/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"
#include	"memory_routine.h"

extern SEM xli_lock;
extern SEM fifo_lock;
extern SEM df_lock;
extern SEM stream_lock;
extern SEM lex_lock;

void
gc_xl_lock()
{
	lock_task(xli_lock);
	lock_task(fifo_lock);
	lock_task(lex_lock);
	if ( df_lock )
		lock_task(df_lock);
	lock_task(stream_lock);
	gc_queue_lock();
}

void
gc_xl_unlock()
{
	gc_queue_unlock();
	unlock_task(stream_lock,"gc_xl_unlock");
	unlock_task(fifo_lock,"gc_xl_unlock");
	unlock_task(lex_lock,"gc_xl_unlock");
	unlock_task(xli_lock,"gc_xl_unlock");
	if ( df_lock )
		unlock_task(df_lock,"gc_xl_unlock");
}


void
gc_lib()
{

	GC_POSITION;

	gc_gblisp();

	GC_POSITION;

	gc_interpreter();

	GC_POSITION;

	gc_gc_stack();

	GC_POSITION;

	gc_unit();

	GC_POSITION;

	gc_queue();
}

void
sp_gc_lib()
{
	sp_gc_gblisp();
	sp_gc_interpreter();
	sp_gc_load();
}

void
after_gc_lib()
{
}

