/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	<stdlib.h>
#include	"memory_debug.h"
#include	"utils.h"

L_CHAR *
seek_ptr(L_CHAR * ptr)
{
	for ( ; *ptr ; ptr ++ );
	return ptr;
}


L_CHAR *
get_url_str2(URL * u)
{
L_CHAR * buf;
L_CHAR * ptr;
char port_buf[20];
	buf = d_alloc(
		((u->proto ? l_strlen(u->proto) : 0) +
		 (u->server ? l_strlen(u->server) : 0) +
		 (u->db ? l_strlen(u->db) : 0) +
		 (u->agent ? l_strlen(u->agent) : 0) +
		 (u->query ? l_strlen(u->query) : 0) +
		 (u->name ? l_strlen(u->name) : 0) +
		 (u->resource ? l_strlen(u->resource) : 0) + 100) *
			sizeof(L_CHAR));
	buf[0] = 0;
	ptr = buf;
	if ( u->proto == 0 )
		goto err;
	l_strcpy(ptr,u->proto);
	ptr = seek_ptr(ptr);
	*ptr ++ = ':';
	*ptr ++ = '/';
	*ptr ++ = '/';
	if ( u->server == 0 )
		goto agent;
	l_strcpy(ptr,u->server);
	ptr = seek_ptr(ptr);
port:
	if ( u->port == get_wkp(u->proto) )
		goto agent;
	sprintf(port_buf,":%i",u->port);
	l_strcpy(ptr,l_string(std_cm,port_buf));
	ptr = seek_ptr(ptr);
agent:
	if ( u->agent == 0 )
		goto db;
	*ptr ++ = '/';
	*ptr ++ = '@';
	l_strcpy(ptr,u->agent);
	ptr = seek_ptr(ptr);
	if ( u->db && u->db[0] != '/' )
		*ptr ++ = '/';
db:
	if ( u->db == 0 ) {
		*ptr ++ = '/';
	}
	else {
		if ( u->db[0] != '/' )
			*ptr ++ = '/';
		l_strcpy(ptr,u->db);
		ptr = seek_ptr(ptr);
	}
	if ( *(ptr-1) != '/' )
		*ptr ++ = '/';
resource:
	if ( u->resource ) {
		l_strcpy(ptr,u->resource);
		ptr = seek_ptr(ptr);
	}
	if ( u->query ) {
		*ptr ++ = '?';
		l_strcpy(ptr,u->query);
		ptr = seek_ptr(ptr);
	}
	if ( u->name ) {
		*ptr ++ = '#';
		l_strcpy(ptr,u->name);
		ptr = seek_ptr(ptr);
	}

	buf = d_re_alloc(buf,(l_strlen(buf)+1)*sizeof(L_CHAR));
	set_buffer(buf);
	return buf;
err:
	d_f_ree(buf);
	return 0;
}
