/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"r64_types.h"

int
_search_ce(R64_FILE * f,int w,int h,int level)
{
R64_CACHE_ENT * ce1;
	for ( ce1 = f->cache[0].next ;
			ce1 != &f->cache[0] ;
			ce1 = ce1->next ) {
		if ( ce1->level != level )
			continue;
		if ( ce1->w_ofs > w )
			continue;
		if ( ce1->h_ofs > h )
			continue;
		if ( ce1->w_ofs + ce1->w_len <= w )
			continue;
		if ( ce1->h_ofs + ce1->h_len <= h )
			continue;
		if ( ce1 == &f->cache[0] )
			return 0;
		ce1->next->prev = ce1->prev;
		ce1->prev->next = ce1->next;
		ce1->prev = &f->cache[0];
		ce1->next = f->cache[0].next;
		ce1->prev->next = ce1;
		ce1->next->prev = ce1;
		return 0;
	}
	return _r64_read(f,w,h,level);
}
