/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"change_endian.h"
#include	"pdb64.h"
#include	"change.h"
void
favt_floating_endian64(FLOATING_INDEX64 * ix,int len)
{
	change_endian_i(ix->fofs);
	change_endian_f(ix->d);
}

void
favt_gb_time_endian64(GB_TIME_INDEX64 * ix,int len)
{
	change_endian_i(ix->fofs);
	change_endian_gb_time(&ix->d);
}


void
favt_string_endian64(STRING_INDEX64 * ix,int len)
{
int i;
	change_endian_i(ix->fofs);
	len = (len - sizeof(ix->fofs))/sizeof(L_CHAR);
	for ( i = 0 ; i < len ; i ++ ) {
		change_endian_i(ix->d[i]);
	}
}

void
favt_timeout_endian64(TIMEOUT_INDEX64 * ix,int len)
{
	change_endian_i(ix->fofs);
	change_endian_i(ix->timeout);
}



void
change_endian_favt_root64(PN_FAVT_ROOT64 * r)
{
	change_endian_header64(&r->h);
	change_endian_i(r->type);
	change_endian_i(r->node);
}

void
change_endian_favt_node64(PN_FAVT_NODE64 * n)
{
	change_endian_header64(&n->h);
	change_endian_i(n->small);
	change_endian_i(n->large);
	change_endian_i(n->level);
}

void (*change_endian_favt_table_to_host64[])() = {
	0,
	change_endian_favt_root64,
	change_endian_favt_node64
};
