/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"machine/include.h"
#include	"memory_debug.h"
#include	"pdb64.h"
#include	"filespace64.h"
#include	"favt64.h"
#include    "../fa64/fa64.h"
#include	"utils.h"



extern void (*change_endian_favt_table_to_host64[])();

typedef struct favt_load_work64 {
	FAVT_HEADER64 * 		ret;
	unsigned int		fofs;
	FAVT_PTR64 *		parent;
} FAVT_LOAD_WORK64;

int favt_load_root64();
int favt_load_node64();

int (*favt_func_table64[])() = {
	0,
	favt_load_root64,
	favt_load_node64,
};

int (**func_table64[])() = {
	0,
	favt_func_table64,
};

FAVT_HEADER64	favt_h;
AVT_NODE *	fr_tree;
int		favt_count;

void
init_favt64()
{
	favt_h.next = favt_h.prev = &favt_h;
	fr_tree = 0;
}

/*
void
check_favt_ring(char * inp)
{
FAVT_HEADER * h;
FAVT_NODE * n;
printf("CFR %s\n",inp);
	for ( h = favt_h.next ; h != &favt_h ; h = h->next )
		switch ( h->type ) {
		case PNT_FAVT_NODE:
			n = (FAVT_NODE*)h;
			if ( n->parent )
				if ( n->parent->ptr != (void*)n )
					er_panic("check_favt_ring");
			break;
		default:
			break;
		}
	for ( h = favt_h.prev ; h != &favt_h ; h = h->prev );
printf("CFR END %s\n",inp);
}
*/

int
cmp_favt64(FAVT_HEADER64 * a,FAVT_HEADER64 * b)
{

	if ( ((int)a->p) < ((int)b->p) )
		return -1;
	if ( ((int)a->p) > ((int)b->p) )
		return 1;
	if ( a->fofs < b->fofs )
		return -1;
	if ( a->fofs > b->fofs )
		return 1;
	return 0;
}

void
insert_favt_tree64(FAVT_HEADER64 * h)
{
AVT_NODE * a,* b;

	a = d_alloc(sizeof(AVT_NODE));
	a->data = h;
	b = avt_insert(&fr_tree,a,cmp_favt64);
	if ( b != a )
		er_panic("insert_favt_tree");
}

void
delete_favt_tree64(PDB64 * p,unsigned int fofs)
{
AVT_NODE * a;
FAVT_HEADER64 h;
	h.fofs = fofs;
	h.p = p;
	a = avt_delete(&fr_tree,&h,cmp_favt64);
	if ( a )
		d_f_ree(a);
}



void
insert_favt_ring64(FAVT_HEADER64 * h)
{

	h->prev = &favt_h;
	h->next = favt_h.next;
	h->prev->next = h;
	h->next->prev = h;
	favt_count ++;
}

void
delete_favt_ring64(FAVT_HEADER64 * h)
{

	h->prev->next = h->next;
	h->next->prev = h->prev;
	favt_count --;
}

void
_touch_ring64(void * h)
{
	delete_favt_ring64((FAVT_HEADER64*)h);
	insert_favt_ring64((FAVT_HEADER64*)h);
}

void
touch_ring64(void * h1,void * h2)
{
	if ( h1 )
		_touch_ring64(h1);
	if ( h2 )
		_touch_ring64(h2);
}

FAVT_PTR64
get_favt_ptr64(unsigned int fofs,int type)
{
FAVT_PTR64 ret;
	ret.fofs = fofs;
	ret.type = type;
	ret.ptr = 0;
	ret.flags = 0;
	return ret;
}

void
get_favt_ptr64_2(FAVT_PTR64 * ptr,FAVT_NODE64 * n)
{
	if ( n == 0 ) {
		ptr->fofs = 0;
		ptr->type = 0;
		ptr->ptr = 0;
	}
	else {
		ptr->fofs = n->h.fofs;
		ptr->type = n->h.type;
		ptr->ptr = n;
		n->parent = ptr;
	}
	ptr->flags |= FAF_DIRTY;
}

void
set_favt_ptr64(FAVT_PTR64 * d,FAVT_PTR64 s)
{
	*d = s;
	if ( d->ptr )
		((FAVT_NODE64 *)d->ptr)->parent = d;
	d->flags |= FAF_DIRTY;
}

FAVT_HEADER64 *
favt_load64(PDB64 * p,FAVT_ROOT64 * rt,unsigned int fofs,FAVT_PTR64 * parent)
{
FAVT_LOAD_WORK64 w;
PN_HEADER64 * h;
int er;
int type,size,len;

	if ( p == 0 )
		p = rt->h.p;
	w.fofs = fofs;
	w.ret = 0;
	w.parent = parent;
	h = d_alloc(sizeof(*h));
	lseek(p->fid,fofs,SEEK_SET);
	er = u_read(p->fid,h,sizeof(*h));
	if ( er < sizeof(*h) ) {
		d_f_ree(h);
		return 0;
	}
	change_endian_header64(h);
	size = h->size;
	type = h->type;
	h = d_re_alloc(h,size);
	change_endian_header64(h);
	er = read(p->fid,h+1,len=size-sizeof(*h));
	if ( er < len ) {
		d_f_ree(h);
		return 0;
	}
	if ( (type&PNT_TYPE_MASK) < 1 ||
			(type&PNT_TYPE_MASK) >= 3 )
{printf("type = %i %i\n",type,h->type);
		er_panic("favt_load");
}
	(*change_endian_favt_table_to_host64[type&PNT_TYPE_MASK])(h);
	(*func_table64[PNT_GET_GROUP(type)][type&PNT_TYPE_MASK])(p,rt,h,&w);
	return w.ret;
}



FAVT_ROOT64 *
get_root64(PDB64 * p,unsigned int fofs,void (*func)())
{
FAVT_ROOT64 * r;
FAVT_HEADER64 h;
AVT_NODE *a;

	h.fofs = fofs;
	h.p = p;
	a = avt_search(fr_tree,&h,cmp_favt64);
	if ( a == 0 ) {
		r = (FAVT_ROOT64*)favt_load64(p,0,fofs,0);
		if ( r == 0 )
			er_panic("get_root");
		if ( r->h.type != PNT_FAVT_ROOT )
			er_panic("get_root2");
		r->endian_func = func;
		insert_favt_tree64((FAVT_HEADER64*)r);
	}
	else	r = a->data;
	touch_ring64(r,0);
	return r;
}

int
favt_write_node64(FAVT_HEADER64 * h)
{
FAVT_NODE64 * nn;
PN_FAVT_NODE64 * n;
int size;
PDB64 * p;
	nn = (FAVT_NODE64*)h;

	p = h->p;
	n = d_alloc(sizeof(PN_FAVT_NODE64)+nn->data_len);
	n->large = nn->large.fofs;
	n->small = nn->small.fofs;
	n->level = nn->level;
	memcpy(n+1,nn->data,nn->data_len);
	(*nn->root->endian_func)(n+1,nn->data_len);
	n->h.type = PNT_FAVT_NODE;
	size = n->h.size = nn->data_len + sizeof(PN_FAVT_NODE64);
	change_endian_favt_node64(n);
	u_lseek(p->fid,h->fofs,SEEK_SET);
	fa_write64(p->fid,n,size);
	d_f_ree(n);
	return 0;
}

int
favt_write_root64(FAVT_HEADER64 * h)
{
FAVT_ROOT64 * rr;
PN_FAVT_ROOT64 r;

	rr = (FAVT_ROOT64*)h;
	r.node = rr->node.fofs;
	r.type = rr->type;
	r.h.type = PNT_FAVT_ROOT;
	r.h.size = sizeof(r);
	change_endian_favt_root64(&r);
	u_lseek(h->p->fid,h->fofs,SEEK_SET);
	fa_write64(h->p->fid,&r,sizeof(r));
	return 0;
}

int
favt_write64(FAVT_HEADER64 * h)
{

	switch ( h->type ) {
	case PNT_FAVT_ROOT:
		return favt_write_root64(h);
	case PNT_FAVT_NODE:
		return favt_write_node64(h);
	}
	return -1;
}

int
check_dirty64(FAVT_HEADER64 * h,unsigned short reset)
{
FAVT_NODE64 * n;
FAVT_ROOT64 * r;
	if ( h->flags & FAF_DIRTY ) {
		h->flags &= ~reset;
		return 1;
	}
	switch ( h->type ) {
	case PNT_FAVT_NODE:
		n = (FAVT_NODE64*)h;
		if ( n->small.flags & FAF_DIRTY ) {
			n->small.flags &= ~reset;
			return 1;
		}
		if ( n->large.flags & FAF_DIRTY ) {
			n->large.flags &= ~reset;
			return 1;
		}
		return 0;
	case PNT_FAVT_ROOT:
		r = (FAVT_ROOT64*)h;
		if ( r->node.flags & FAF_DIRTY ) {
			r->node.flags &= ~reset;
			return 1;
		}
		return 0;
	default:
		er_panic("check_dirty");
	}
	return 0;
}

int
free_favt_cache64(FAVT_HEADER64 * h)
{
FAVT_NODE64 * n;
FAVT_ROOT64 * r;
int i;
char * p;

	switch ( h->type ) {
	case PNT_FAVT_NODE:
		n = (FAVT_NODE64*)h;
		if ( n->small.fofs && n->small.ptr || 
				n->large.fofs && n->large.ptr )
			return -1;
		delete_favt_ring64(h);
		if ( n->parent )
			n->parent->ptr = 0;
		d_f_ree(n->data);
		d_f_ree(n);
		break;
	case PNT_FAVT_ROOT:
		r = (FAVT_ROOT64*)h;
		if ( r->node.fofs && r->node.ptr )
			return -1;
		delete_favt_ring64(h);
		delete_favt_tree64(r->h.p,r->h.fofs);
		d_f_ree(r);
		break;
	}
	return 0;
}

void
clear_cache64()
{
FAVT_NODE64 * n;
FAVT_ROOT64 * r;
FAVT_HEADER64 * h, * h2;
	for ( ; favt_count > FAVT_CACHE_SIZE ; ) {
		for ( h = favt_h.prev ; h != &favt_h ; ) {
			if ( h->flags & FAF_LOCK ) {
				h = h->prev;
				continue;
			}
			switch ( h->type ) {
			case PNT_FAVT_ROOT:
				r = (FAVT_ROOT64*)h;
				if ( r->node.ptr ) {
					h = h->prev;
					continue;
				}
				break;
			case PNT_FAVT_NODE:
				n = (FAVT_NODE64*)h;
				if ( n->small.ptr ) {
					h = h->prev;
					continue;
				}
				if ( n->large.ptr ) {
					h = h->prev;
					continue;
				}
				break;
			default:
				er_panic("clear_cache");
			}
			break;
		}
		if ( h == &favt_h )
			er_panic("clear_cache");
		if ( check_dirty64(h,0) ) {
			for ( h2 = favt_h.next ; h2 != &favt_h ; 
					h2 = h2->next )
				if ( check_dirty64(h2,FAF_DIRTY) )
					favt_write64(h2);
		}
		h2 = h->prev;
		if ( free_favt_cache64(h) < 0 )
			er_panic("clear_cache(2)");
		h = h2;
	}
}

void
flush_favt_cache64(PDB64 * p)
{
FAVT_HEADER64 * h1, * h2;
int f;

	for ( h1 = favt_h.next ; h1 != &favt_h ;) {
		if ( h1->p != p ) {
			h1 = h1->next;
			continue;
		}
		if ( check_dirty64(h1,FAF_DIRTY) )
			favt_write64(h1);
		h1 = h1->next;
	}
retry:
	f = 0;
	for ( h1 = favt_h.next ; h1 != &favt_h ; ) {
		if ( h1->p != p ) {
			h1 = h1->next;
			continue;
		}
		h2 = h1->next;
		if ( free_favt_cache64(h1) < 0 )
			f = 1;
		h1 = h2;
	}
	if ( f )
		goto retry;
}

void
favt_lock64(FAVT_HEADER64 * h)
{
	h->flags |= FAF_LOCK;
}

void
favt_unlock64(FAVT_HEADER64 * h)
{
	h->flags &= ~FAF_LOCK;
}

void
favt_load_header64(PDB64 * p,PN_HEADER64 * f,FAVT_HEADER64 * ret,FAVT_LOAD_WORK64 * w)
{
	ret->type = f->type;
	ret->fofs = w->fofs;
	ret->flags = 0;
	ret->p = p;
	insert_favt_ring64(ret);
	clear_cache64();
}

int
favt_load_root64(PDB64 * p,FAVT_ROOT64 * rt,PN_FAVT_ROOT64 * f,FAVT_LOAD_WORK64 * w)
{
FAVT_ROOT64 * ret;

	ret = d_alloc(sizeof(*ret));
	ret->node = get_favt_ptr64(0,PNT_FAVT_NODE);
	favt_load_header64(p,&f->h,&ret->h,w);
	ret->node = get_favt_ptr64(f->node,PNT_FAVT_NODE);
	ret->type = f->type;
	w->ret = (FAVT_HEADER64*)ret;
	return 0;
}


int
favt_load_node64(PDB64 * p,FAVT_ROOT64 * rt,PN_FAVT_NODE64 * f,FAVT_LOAD_WORK64 * w)
{
FAVT_NODE64 * ret;

	if ( p == 0 )
		p = rt->h.p;
	ret = d_alloc(sizeof(*ret));
	ret->small = get_favt_ptr64(f->small,PNT_FAVT_NODE);
	ret->large = get_favt_ptr64(f->large,PNT_FAVT_NODE);
	ret->parent = w->parent;
	ret->level = f->level;
	ret->root = rt;
	ret->data = d_alloc(f->h.size - sizeof(PN_FAVT_NODE64));
	ret->data_len = f->h.size - sizeof(PN_FAVT_NODE64);
	favt_load_header64(p,&f->h,&ret->h,w);
	memcpy(ret->data,f+1,f->h.size - sizeof(PN_FAVT_NODE64));
	(*rt->endian_func)(ret->data,ret->data_len);
	w->ret = (FAVT_HEADER64*)ret;

	return 0;
}

FAVT_NODE64 *
g_ptr64(FAVT_ROOT64 * rt,FAVT_PTR64 * ptr)
{
	if ( ptr->fofs == 0 )
		return 0;
	if ( ptr->ptr == 0 ) {
		ptr->ptr = favt_load64(0,rt,ptr->fofs,ptr);
		((FAVT_NODE64 *)(ptr->ptr))->parent = ptr;
	}
	return ptr->ptr;
}

FAVT_NODE64 *
small_node64(FAVT_ROOT64 * rt,FAVT_NODE64 * n)
{
FAVT_NODE64 * ret;
	if ( n->small.fofs == 0 )
		return 0;
	if ( n->small.ptr )
		ret = n->small.ptr;
	else {
		ret = n->small.ptr = favt_load64(0,rt,n->small.fofs,&n->small);
		ret->parent = &n->small;
	}
	touch_ring64(ret,0);
	return ret;
}


FAVT_NODE64 *
large_node64(FAVT_ROOT64 * rt,FAVT_NODE64 * n)
{
FAVT_NODE64 * ret;

	if ( n->large.fofs == 0 )
		return 0;
	if ( n->large.ptr )
		ret = n->large.ptr;
	else {
		ret = n->large.ptr = favt_load64(0,rt,n->large.fofs,&n->large);
		ret->parent = &n->large;
	}
	touch_ring64(ret,0);
	return ret;
}

FAVT_NODE64 *
root_node64(FAVT_ROOT64 * r)
{
FAVT_NODE64 * ret;

	if ( r->node.fofs == 0 )
		return 0;
	if ( r->node.ptr )
		ret = r->node.ptr;
	else	ret = r->node.ptr = favt_load64(0,r,r->node.fofs,&r->node);
	touch_ring64(ret,0);
	return ret;
}


void fset_level64(FAVT_ROOT64 * rt,FAVT_NODE64 * avt);
FAVT_NODE64 * _favt_delete_small64(FAVT_ROOT64 * rt,FAVT_PTR64*);
FAVT_NODE64 * _favt_delete_large64(FAVT_ROOT64 * rt,FAVT_PTR64*);

void
fset_level64(FAVT_ROOT64 * p,FAVT_NODE64 * favt)
{
int lev1,lev2;
	touch_ring64(p,favt);
	if ( favt == 0 )
		return;
	if ( favt->large.fofs )
		lev1 = large_node64(p,favt)->level;
	else	lev1 = 0;
	if ( favt->small.fofs )
		lev2 = small_node64(p,favt)->level;
	else	lev2 = 0;
	if ( lev1 > lev2 )
		favt->level = lev1 + 1;
	else	favt->level = lev2 + 1;
	favt->h.flags |= FAF_DIRTY;
}

void
favt_valance64(FAVT_ROOT64 * p,FAVT_PTR64 * favtp)
{
FAVT_NODE64 * b1, * b2, * b3, * b4, * b5;
int lev1,lev2;
FAVT_NODE64 * g;
	if ( favtp->fofs == 0 )
		return;
	if ( (g=g_ptr64(p,favtp))->large.fofs )
		lev1 = large_node64(p,g)->level;
	else	lev1 = 0;
	if ( (g=g_ptr64(p,favtp))->small.fofs )
		lev2 = small_node64(p,g)->level;
	else	lev2 = 0;
	touch_ring64(p,g);
	if ( lev2 + 1 < lev1 ) {
		b1 = g_ptr64(p,favtp);
		b2 = large_node64(p,b1);
		b3 = small_node64(p,b1);
		b4 = large_node64(p,b2);
		b5 = small_node64(p,b2);

		get_favt_ptr64_2(favtp,b2);
		get_favt_ptr64_2(&b2->small,b1);
		get_favt_ptr64_2(&b1->large,b5);

		fset_level64(p,b1);
		fset_level64(p,b2);
	}
	else if ( lev1 + 1 < lev2 ) {
		b1 = g_ptr64(p,favtp);
		b2 = small_node64(p,b1);
		b3 = large_node64(p,b1);
		b4 = small_node64(p,b2);
		b5 = large_node64(p,b2);

		get_favt_ptr64_2(favtp,b2);
		get_favt_ptr64_2(&b2->large,b1);
		get_favt_ptr64_2(&b1->small,b5);

		fset_level64(p,b1);
		fset_level64(p,b2);
	}
}

FAVT_NODE64 *
favt_insert64(FAVT_ROOT64 * p,FAVT_PTR64 * favtp,FAVT_NODE64 * a,int (*cmp)())
{
FAVT_NODE64 * ret;
FAVT_NODE64 * g;
	if ( favtp->fofs == 0 ) {
		if ( a->data == 0 )
			er_panic("avt_insert(1)");
		get_favt_ptr64_2(favtp,a);
		a->large = get_favt_ptr64(0,PNT_FAVT_NODE);
		a->small = get_favt_ptr64(0,PNT_FAVT_NODE);
		a->level = 1;
		a->h.flags |= FAF_DIRTY;
		return a;
	}
	g = g_ptr64(p,favtp);
	favt_lock64(&g->h);
	switch ( (*cmp)(g->data,a->data) ) {
	case -1:
		ret = favt_insert64(p,&g->large,a,cmp);
		break;
	case 0:
		ret = g;
		favt_unlock64(&g->h);
		return ret;
	case 1:
		ret = favt_insert64(p,&g->small,a,cmp);
		break;
	}
	fset_level64(p,g);
	favt_valance64(p,favtp);
	favt_unlock64(&g->h);
	return ret;
}


FAVT_NODE64 *
favt_search64(FAVT_ROOT64 * p,FAVT_NODE64 * a,void * data,int (*cmp)())
{
FAVT_NODE64 * b;
	touch_ring64(p,a);
	if ( a )
		favt_lock64(&a->h);
	for ( ; a ; ) {
		switch ( (*cmp)(a->data,data) ) {
		case -1:
			b = large_node64(p,a);
			if ( b )
				favt_lock64(&b->h);
			favt_unlock64(&a->h);
			a = b;
			break;
		case 0:
			favt_unlock64(&a->h);
			return a;
		case 1:
			b = small_node64(p,a);
			if ( b )
				favt_lock64(&b->h);
			favt_unlock64(&a->h);
			a = b;
			break;
		default:
			er_panic("favt_search(1)");
		}
	}
	return 0;
}


int
favt_trace_from_small64(FAVT_ROOT64 * p,FAVT_NODE64 * a,int (*func)(),void * work)
{
int ret;
	touch_ring64(p,a);
	if ( a == 0 )
		return 0;
	favt_lock64(&a->h);
	if ( a->small.fofs ) {
		ret = favt_trace_from_small64(p,small_node64(p,a),func,work);
		if ( ret ) {
			favt_unlock64(&a->h);
			return ret;
		}
	}
	ret = (*func)(a,work);
	if ( ret ) {
		favt_unlock64(&a->h);
		return ret;
	}
	if ( a->large.fofs ) {
		ret = favt_trace_from_small64(p,large_node64(p,a),func,work);
		if ( ret ) {
			favt_unlock64(&a->h);
			return ret;
		}
	}
	favt_unlock64(&a->h);
	return 0;
}



int
favt_trace_from_large64(FAVT_ROOT64 * p,FAVT_NODE64 * a,int (*func)(),void * work)
{
int ret;

	touch_ring64(p,a);
	if ( a == 0 )
		return 0;
	favt_lock64(&a->h);
	if ( a->large.fofs ) {
		ret = favt_trace_from_large64(p,large_node64(p,a),func,work);
		if ( ret ) {
			favt_unlock64(&a->h);
			return ret;
		}
	}
	ret = (*func)(a,work);
	if ( ret ) {
		favt_unlock64(&a->h);
		return ret;
	}
	if ( a->small.fofs ) {
		ret = favt_trace_from_large64(p,small_node64(p,a),func,work);
		if ( ret ) {
			favt_unlock64(&a->h);
			return ret;
		}
	}
	favt_unlock64(&a->h);
	return 0;
}


typedef struct bound_search_work64 {
	FAVT_ROOT64 * 	p;
	void * 		data_min;
	void * 		data_max;
	int 		(*cmp)();
	BOUND_LIST64 *	lst;
} BOUND_SEARCH_WORK64;


void
insert_lst64(BOUND_SEARCH_WORK64 * w,FAVT_NODE64 * a)
{
BOUND_LIST64 * lst;
	lst = d_alloc(sizeof(*lst));
	lst->data = d_alloc(a->data_len);
	memcpy(lst->data,a->data,a->data_len);
	lst->data_len = a->data_len;
	lst->next = w->lst;
	w->lst = lst;
}

void
_favt_bound_search64(
	BOUND_SEARCH_WORK64 * w,
	FAVT_NODE64 * a)
{
int cmp_max,cmp_min;
	touch_ring64(w->p,a);
	if ( a == 0 )
		return;
	favt_lock64(&a->h);
	cmp_max = (*w->cmp)(a->data,w->data_max);
	cmp_min = (*w->cmp)(a->data,w->data_min);
	if ( cmp_max < 0 )
		_favt_bound_search64(w,large_node64(w->p,a));
	if ( cmp_min > 0 )
		_favt_bound_search64(w,small_node64(w->p,a));
	if ( cmp_max <= 0 && cmp_min >= 0 )
		insert_lst64(w,a);
	favt_unlock64(&a->h);
}

BOUND_LIST64 *
favt_bound_search64(
	FAVT_ROOT64 * p,
	FAVT_NODE64 * a,
	void *	data_min,
	void *	data_max,
	int (*cmp)())
{
BOUND_SEARCH_WORK64 w;
	w.p = p;
	w.data_min = data_min;
	w.data_max = data_max;
	w.lst = 0;
	w.cmp = cmp;
	_favt_bound_search64(&w,a);
	return w.lst;
}

void
free_bound_list64(BOUND_LIST64 * b)
{
BOUND_LIST64 * bb;
	for ( ; b ; ) {
		bb = b->next;
		d_f_ree(b->data);
		d_f_ree(b);
		b = bb;
	}
}

FAVT_NODE64 *
_favt_delete_small64(FAVT_ROOT64 *p,FAVT_PTR64 * ap)
{
FAVT_NODE64 * ret;
FAVT_NODE64 * g;
	g = g_ptr64(p,ap);
	if ( g->small.fofs ) {
		ret = _favt_delete_small64(p,&g->small);
		fset_level64(p,g);
		return ret;
	}
	ret = g;
	set_favt_ptr64(ap,g->large);
	favt_valance64(p,ap);
	return ret;
}

FAVT_NODE64 *
_favt_delete_large64(FAVT_ROOT64 * p,FAVT_PTR64 * ap)
{
FAVT_NODE64 * ret;
FAVT_NODE64 * g;
	g = g_ptr64(p,ap);
	favt_lock64(&g->h);

	if ( g->large.fofs ) {
		ret = _favt_delete_large64(p,&g->large);
		fset_level64(p,g);

		favt_unlock64(&g->h);

		return ret;
	}
	ret = g;
	set_favt_ptr64(ap,g->small);
	favt_valance64(p,ap);

	touch_ring64(0,ret);

	favt_unlock64(&ret->h);

	return ret;
}




FAVT_NODE64 *
favt_delete64(FAVT_ROOT64 * p,FAVT_PTR64 * favtp,void * data,int (*cmp)())
{
FAVT_NODE64 * ret,* a;
FAVT_NODE64 * g;

	if ( favtp->fofs == 0 )
		return 0;
	g = g_ptr64(p,favtp);
	touch_ring64(p,g);

	favt_lock64(&g->h);

	switch ( (*cmp)(g->data,data) ) {
	case -1:
		ret = favt_delete64(p,&g->large,data,cmp);
		fset_level64(p,g);

		favt_unlock64(&g->h);

		return ret;
	case 0:
		break;
	case 1:
		ret = favt_delete64(p,&g->small,data,cmp);
		fset_level64(p,g);

		favt_unlock64(&g->h);

		return ret;
	default:
		er_panic("favt_delete(!)");
	}
	ret = g;
	ret->parent = 0;
	if ( g->large.fofs == 0 )
		set_favt_ptr64(favtp,g->small);
	else if ( g->small.fofs == 0 )
		set_favt_ptr64(favtp,g->large);
	else if ( small_node64(p,g)->level < large_node64(p,g)->level ) {
		a = _favt_delete_small64(p,&g->large);
		set_favt_ptr64(&a->large,g->large);
		set_favt_ptr64(&a->small,g->small);
		get_favt_ptr64_2(favtp,a);
	}
	else {
		a = _favt_delete_large64(p,&g->small);
		set_favt_ptr64(&a->large,g->large);
		set_favt_ptr64(&a->small,g->small);
		get_favt_ptr64_2(favtp,a);
	}
	g = g_ptr64(p,favtp);
	fset_level64(p,g);
	favt_valance64(p,favtp);

	ret->large.ptr = 0;
	ret->small.ptr = 0;

	touch_ring64(0,ret);

	favt_unlock64(&ret->h);

	return ret;
}

typedef struct favt_test64 {
	FAVT_ROOT64 *	p;
	void *		data;
	int 		(*cmp)();
} FAVT_TEST64;

int favt_test_func64(FAVT_NODE64 * a,FAVT_TEST64 * w)
{
int lev1,lev2;

int * ptr;

	ptr = (int*)a->data;
	printf("=%i\n",*ptr);

	if ( w->data == 0 ) {
		if ( w->data )
			d_f_ree(w->data);
		w->data = d_alloc(a->data_len);
		memcpy(w->data,a->data,a->data_len);
		return 0;
	}
	if ( (*w->cmp)(a->data,w->data) < 0 )
		er_panic("favt error 1");
	if ( w->data )
		d_f_ree(w->data);
	w->data = d_alloc(a->data_len);
	memcpy(w->data,a->data,a->data_len);
	if ( a->large.fofs )
		lev1 = large_node64(w->p,a)->level;
	else	lev1 = 0;
	if ( a->small.fofs )
		lev2 = small_node64(w->p,a)->level;
	else lev2 = 0;
	if ( a->level <= lev1 )
		er_panic("favt error 2");
	if ( a->level <= lev2 )
		er_panic("favt error 3");
	if ( lev1+1 != a->level && lev2+1 != a->level )
		er_panic("favt error 4");
	return 0;
}


void
favt_test64(FAVT_ROOT64 * p,FAVT_NODE64 * a,int (*cmp)())
{
FAVT_TEST64 test;
	test.data = 0;
	test.cmp = cmp;
	test.p = p;
	favt_trace_from_small64(p,a,favt_test_func64,&test);
}


void
favt_alloc_header64(PDB64 * p,FAVT_HEADER64 * ret,PN_HEADER64 * h)
{
unsigned int fofs;

	fofs = alloc_filespace64(p,h);

	ret->type = h->type;
	ret->fofs = fofs;
	ret->flags = FAF_DIRTY;
	ret->p = p;
	insert_favt_ring64(ret);
	clear_cache64(p);
}


FAVT_ROOT64 *
favt_alloc_root64(PDB64 * p,int type,void (*func)())
{
FAVT_ROOT64 * ret;
PN_HEADER64 h;
	ret = d_alloc(sizeof(*ret));
	h.type = PNT_FAVT_ROOT;
	h.size = sizeof(PN_FAVT_ROOT64);
	favt_alloc_header64(p,&ret->h,&h);
	ret->type = type;
	ret->endian_func = func;
	ret->node = get_favt_ptr64(0,PNT_FAVT_NODE);
	insert_favt_tree64((FAVT_HEADER64*)ret);
	return ret;
}


FAVT_NODE64 *
favt_alloc_node64(FAVT_ROOT64 * rt,
	void * data,int data_size)
{
FAVT_NODE64 * ret;
PN_HEADER64 h;
PDB64 * p;
	p = rt->h.p;
	ret = d_alloc(sizeof(*ret));
	h.type = PNT_FAVT_NODE;
	h.size = sizeof(PN_FAVT_NODE64)+data_size;
	ret->root = rt;
	ret->small = get_favt_ptr64(0,PNT_FAVT_NODE);
	ret->large = get_favt_ptr64(0,PNT_FAVT_NODE);
	ret->parent = 0;
	ret->level = 0;
	ret->data = d_alloc(data_size);
	memcpy(ret->data,data,data_size);
	ret->data_len = data_size;
	favt_alloc_header64(p,&ret->h,&h);
	return ret;
}


void
favt_free_root64(FAVT_ROOT64 * rt)
{
	if ( rt == 0  )
		return;
	if ( check_dirty64(&rt->h,FAF_DIRTY) )
		favt_write64(&rt->h);
	delete_favt_tree64(rt->h.p,rt->h.fofs);
	delete_favt_ring64(&rt->h);
	free_filespace64(rt->h.p,rt->h.fofs);
}

void
favt_free_node64(FAVT_NODE64 * n)
{
	if ( n == 0 )
		return;
	if ( check_dirty64(&n->h,FAF_DIRTY) )
		favt_write64(&n->h);
	delete_favt_ring64(&n->h);
	free_filespace64(n->h.p,n->h.fofs);
	if ( n->data )
		d_f_ree(n->data);
	d_f_ree(n);
}

void
cc_node64(char * str,FAVT_NODE64 * n)
{
FAVT_NODE64 * n1;
	if ( n->large.ptr ) {
		n1 = n->large.ptr;
		if ( n1->parent != &n->large ) {
			printf("%s\n",str);
			er_panic("cc_node64(1)");
		}
		if ( n->large.fofs != n1->h.fofs ) {
			printf("%s\n",str);
			er_panic("cc_node64(1-1)");
		}
		cc_node64(str,n1);
	}
	if ( n->small.ptr ) {
		n1 = n->small.ptr;
		if ( n1->parent != &n->small ) {
			printf("%s\n",str);
			er_panic("cc_node64(2)");
		}
		if ( n->small.fofs != n1->h.fofs ) {
			printf("%s\n",str);
			er_panic("cc_node64(2-1)");
		}
		cc_node64(str,n1);
	}
	if ( n->parent->ptr != n ) {
		printf("%s\n",str);
		er_panic("cc_node64(3)");
	}
}

void
cc_root64(char * str,FAVT_ROOT64 * r)
{
FAVT_NODE64 * n1;
	if ( r->node.ptr == 0 )
		return;
	n1 = r->node.ptr;
	if ( r->node.fofs != n1->h.fofs ) {
		printf("%s\n",str);
		er_panic("cc_root");
	}
	cc_node64(str,r->node.ptr);
}

void
check_cache64(char * str)
{
FAVT_HEADER64 * h;
int cnt;
	if ( favt_h.next == 0 )
		return;
	cnt = 200;
	for ( h = favt_h.next ; h != &favt_h ; h = h->next , cnt -- ) {
		if ( cnt < 0 )
			er_panic("chec_cache64(2)");
		if ( h->type == PNT_FAVT_ROOT )
			cc_root64(str,(FAVT_ROOT64*)h);
		if ( h->type != PNT_FAVT_ROOT && h->type != PNT_FAVT_NODE )
			er_panic("check_cache64(3)");
		if ( h->next == 0 )
			er_panic("check_cache64(1)");
	}
}
