/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"pdb64.h"
#include	"utils.h"
#include	"fa64.h"

FA_CACHE64 *		cache_list;
FA_RING64			cache_ring;
int			cache_size;

void
init_ring64(FA_RING64 * r)
{
	r->next = r;
	r->prev = r;
}

void
insert_ring64(void * r1,void * r2)
{
FA_RING64 * rr1,*rr2;
	rr1 = r1;
	rr2 = r2;
	rr2->prev = rr1;
	rr2->next = rr1->next;
	rr2->prev->next = rr2;
	rr2->next->prev = rr2;
}

void
delete_ring64(void * r)
{
FA_RING64 * rr;
	rr = r;
	rr->prev->next = rr->next;
	rr->next->prev = rr->prev;
}

void
init_cache64()
{
	init_ring64(&cache_ring);
	cache_size = 0;
}


void
test_ring64()
{
FAC_HEADER64 * h;

	for ( h = (FAC_HEADER64*)cache_ring.next;
			h != (FAC_HEADER64*)&cache_ring;
			h = (FAC_HEADER64*)h->r.next ) {
		if ( h->r.prev->next != (FA_RING64*)h )
			er_panic("test_ring64(0)");
		if ( h->r.next->prev != (FA_RING64*)h )
			er_panic("test_ring64(1)");
		if ( h->file->filename == 0 )
			er_panic("test_ring64(2)");
	}
	for ( h = (FAC_HEADER64*)cache_ring.prev;
			h != (FAC_HEADER64*)&cache_ring;
			h = (FAC_HEADER64*)h->r.prev ) {
		if ( h->r.prev->next != (FA_RING64*)h )
			er_panic("test_ring(0)");
		if ( h->r.next->prev != (FA_RING64*)h )
			er_panic("test_ring64(1)");
		if ( h->file->filename == 0 )
			er_panic("test_ring64(2)");
	}
}


void
delete_fac64(FA_CACHE64 * fac)
{
FA_CACHE64 ** fp;
	for ( fp = &cache_list ; *fp ; fp = &(*fp)->next ) {
		if ( *fp != fac )
			continue;
		*fp = fac->next;
		d_f_ree(fac->filename);
		d_f_ree(fac);
		return;
	}
}

FA_CACHE64 *
new_file64(char *filename)
{
FA_CACHE64 * fac;
	for ( fac = cache_list ; fac ;fac = fac->next ) {
		if ( strcmp(filename,fac->filename) )
			continue;
		fac->ref ++;
		return fac;
	}
	fac = d_alloc(sizeof(*fac));
	fac->filename = copy_str(filename);
	fac->ref = 1;
	fac->records = 0;
	fac->next = cache_list;
	cache_list = fac;
	return fac;
}

void
close_file64(FA_CACHE64 * fac)
{
FA_CACHE64 ** fp;
	if ( fac->ref == 0 )
		er_panic("close_file64(1)");
	for ( fp = &cache_list ; *fp ; fp = &(*fp)->next ) {
		if ( *fp != fac )
			continue;
		if ( fac->ref == 0 )
			return;
		fac->ref --;
		return;
	}
}

int
cmp_fa64(FAC_HEADER64 * h1,FAC_HEADER64 * h2)
{
	if ( h1->offset < h2->offset )
		return -1;
	if ( h1->offset > h2->offset )
		return 1;
	return 0;
}

FAC_HEADER64 * 
search_cache64(FA_CACHE64 * fac,unsigned int ofs)
{
AVT_NODE * a1;
FAC_HEADER64 h;
FAC_HEADER64 * fp;
	if ( fac->ref == 0 )
		er_panic("search_cache64(1)");
	h.offset = ofs;
	a1 = avt_search(fac->records,&h,cmp_fa64);
	if ( a1 == 0 )
		return 0;
	fp = a1->data;
	delete_ring64(&fp->r);
	insert_ring64(&cache_ring,&fp->r);
	return fp;
}

int
insert_cache64(FA_CACHE64 * fac,FAC_HEADER64 * d)
{
AVT_NODE * a1, * a2;
FAC_HEADER64 * d1;
FA_CACHE64 * fa;
	if ( fac->ref == 0 )
		er_panic("insert_cache64(1)");
	d->file = fac;
	a1 = d_alloc(sizeof(*a1));
	a1->data = d;
	a2 = avt_insert(&fac->records,a1,cmp_fa64);
	if ( a2 != a1 ) {
		d_f_ree(a1);
		d_f_ree(d);
		return -1;
	}
	insert_ring64(&cache_ring,d);

	cache_size += d->h.size;
	for ( ; cache_size >= CACHE_MAX ; ) {
		d1 = (FAC_HEADER64*)cache_ring.prev;
		fa = d1->file;
		delete_ring64(cache_ring.prev);
		avt_delete(&fa->records,d1,cmp_fa64);
		cache_size -= d1->h.size;
		d_f_ree(d1);
		if ( fa->records == 0 && fa->ref == 0 )
			delete_fac64(fa);
	}
	return 0;
}
