/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___WIN_FLAME_H___
#define ___WIN_FLAME_H___

#include	"gbview.h"

#define BACKGROUND_COLOR	COL(0x3ff,0x3ff,0x3ff)
#define BACKGROUND_COLOR_MID	COL(0x200,0x200,0x200)


/* win_flame flags */
#define WFF_FREE		0x00000001
#define WFF_SHORT_MH		0x00000002
#define WFF_RUN			0x00000004
#define WFF_ACTIVE		0x00000008
#define WFF_WAIT_BEND		0x00000010
#define WFF_RESIZE		0x00000020

#define WFF_DRAW_REQUEST	0x00000040

#define WFF_DIRTY		0x00000380
#define WFF_LUSTER_DIRTY	0x00000080
#define WFF_POLY_DIRTY		0x00000100
#define WFF_PLOT_DIRTY		0x00000200


#define WFF_LUSTER		0x00000400
#define WFF_POLY		0x00000800
#define WFF_PLOT		0x00001000

/* for drawing */

#define WFF_DRAW		0x10000000

/* win_flame modes */
/*
#define RDM_IDLE		0
#define RDM_SPIRAL		1
#define RDM_SPIRAL_COMPLETE	2
#define RDM_RESIZE		3
*/

#define W_E2D_LUSTER		1
#define W_E2D_POLY		0.3
#define W_E2D_PLOT		0.01

#define W_GLOBE_LUSTER		1.2
#define W_GLOBE_POLY		0.3
#define W_GLOBE_PLOT		0.01

typedef struct win_flame_table {
/*
	int			type;
#define WF_E2D			1
#define WF_E2D_PLOT		2

#define WF_GLOBE		4
#define WF_GLOBE_PLOT		5
*/
	short			geo_type;
		/* equal to GT_T_XX in resource.h */
	short			wf_type;
#define WFT_STD			1
#define WFT_PLOT		2
#define WFT_PART		3
#define WFT_MAX			4


	int (*f_new)

		(	struct win_flame_table * tbl,
			GBVIEW_FLAME *	gf,
			WF_ID *		ret_wfid,
			REAL1		v_reso,
			RESOURCE * 	draw,
			MAP_HISTORY * 	mh,
			GB_POINT	center,
			REAL1		rotate,
			REAL1		resolution);

	int (*f_move)

		(	GBVIEW_FLAME * gf,
			struct win_flame * wf,
			VPOINT from,
			VPOINT to,
			void * ix);
	int (*f_exit)

		(	GBVIEW_FLAME * gf,
			struct win_flame * wf);

	int (*f_change)

		(	struct win_flame_table * tbl,
			GBVIEW_FLAME * gf,
			struct win_flame * wf);

	int (*f_flame_redraw)

		(	GBVIEW_FLAME * gf,
			struct win_flame * 	wf);

	int (*f_dirty)

		(	GBVIEW_FLAME * gf,
			struct win_flame *	wf,
			GB_RECT *		r,
			int			flags,
			int			mode);

	int (*f_overlay)

		(	GBVIEW_FLAME * 		gf,
			struct win_flame *	wf,
			OV_ARG *		a);

	int (*f_zoom)

		(	GBVIEW_FLAME * gf,
			struct win_flame * 	wf,
			int			w,
			int			h,
			int *			index_x,
			int *			index_y);

	int (*f_resize)

		(	GBVIEW_FLAME * gf,
			struct win_flame *	wf);

	int (*f_rotate)

		(	GBVIEW_FLAME * gf,
			struct win_flame *	wf,
			VPOINT *		ix);

} WIN_FLAME_TABLE;

typedef struct wf_lock_list {
	struct wf_lock_list *	next;
	int			tid;
} WF_LOCK_LIST;

typedef struct win_flame {
	struct win_flame *	next;
	WF_ID			id;
	WIN_FLAME_TABLE *	tbl;
	unsigned int		insert_time;

	int			lock;
	WF_LOCK_LIST *		lock_list;
	int			browse;
	int			aboat_count;
	int			flags;
	/* win_flame flags */
	REAL1			v_reso;
	MAP_HISTORY *		mh;
	RESOURCE *		draw;
	unsigned long *		pixels;

	/* set_current parameter */

	unsigned int		in_base_time;
	unsigned int		out_base_time;

	/* movement during redraw */
	int			mov_flag;
	int			mov_x;
	int			mov_y;

	/* win_flame modes */

	int			rd_task;
	SYMBOL_INDICATE *	sym_i;

	int			pri_adj;
} WIN_FLAME;

typedef struct globe_move_t {
	VPOINT *		ix;
	MATRIX3D		rm;
	double			radius;
} GLOBE_MOVE_T;

WIN_FLAME * touch_wf();
int
new_win_flame(
	WF_ID *		ret_wfid,
	GBVIEW_FLAME *	gf,
	REAL1		v_reso,
	RESOURCE * 	draw,
	MAP_HISTORY * 	mh,
	GB_POINT	center,
	REAL1		rotate,
	REAL1		resolution);
int exit_win_flame(GBVIEW_FLAME * gf,WIN_FLAME * wf);
int win_flame_move(GBVIEW_FLAME * Gf,WIN_FLAME * wf,VPOINT from,VPOINT to,void * ix);
int change_win_flame(GBVIEW_FLAME * Gf,WIN_FLAME * wf,int geo_type,int wf_type);
int _change_win_flame(GBVIEW_FLAME * Gf,WIN_FLAME * wf,int geo_type,int wf_type);
int win_flame_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf);
int _win_flame_dirty(GBVIEW_FLAME * gf,WIN_FLAME * wf,GB_RECT * r,int flags,int mode);
int win_flame_dirty(GBVIEW_FLAME * gf,WF_ID wfid,GB_RECT * r,int flags,int mode);
int win_flame_overlay(GBVIEW_FLAME * gf,WIN_FLAME * wf,OV_ARG * a);
int win_flame_zoom(GBVIEW_FLAME * gf,WIN_FLAME * wf,int w,int h,int * ix_x,int * ix_y);
int win_flame_resize(GBVIEW_FLAME * gf,WIN_FLAME * wf);
int win_flame_rotate(GBVIEW_FLAME * gf,WIN_FLAME * wf,VPOINT * ix);

WIN_FLAME * _get_wf_ptr(GBVIEW_FLAME * gf,WF_ID id);

/*
extern WIN_FLAME_TABLE * wf_type_list[];
*/
extern WIN_FLAME_TABLE * wf_geo_type_list[GT_T_MAX][WFT_MAX];

RESOURCE * wf_get_mh(GBVIEW_FLAME * gf,WF_ID id,MAP_HISTORY ** mhp);
RESOURCE * _wf_get_mh(GBVIEW_FLAME * gf,WIN_FLAME * wf,MAP_HISTORY ** mhp);

GBVIEW_FLAME * wf_next_gf(GBVIEW_FLAME*,int);
void
_wf_redraw_si(
	GBVIEW_FLAME * gf,
	WIN_FLAME * wf,int ow,int oh,
	int tl_x,int tl_y,int br_x,int br_y);
int wf_set_current(GBVIEW_FLAME * gf);
int wf_set_current_now(GBVIEW_FLAME * gf,WF_ID);
int wf_set_current_target(GBVIEW_FLAME * gf,WF_ID id);

WF_ID wf_get_current(GBVIEW_FLAME * gf);
int wf_check_last(GBVIEW_FLAME * gf,WF_ID id);
void wf_wait_stable(GBVIEW_FLAME * gf);
GBVIEW_FLAME * wf_new_gf();
int get_next_wfid(GBVIEW_FLAME * gf,int id);
int _get_next_wfid(GBVIEW_FLAME * gf,int id);
int _get_new_wfid(GBVIEW_FLAME *);
void _wakeup_wf(GBVIEW_FLAME * gf,WIN_FLAME * wf);
WIN_FLAME * touch_wf(GBVIEW_FLAME * gf);
int _check_exit_flame(GBVIEW_FLAME * gf);
GBVIEW_FLAME * get_gf_from_sf(XL_SYM_FIELD *);
WIN_FLAME * _get_wf_ptr(GBVIEW_FLAME *,WF_ID);
int _win_lock(GBVIEW_FLAME * gf,WIN_FLAME * wf);
int _win_wlock(GBVIEW_FLAME * gf,WIN_FLAME * wf);
void _win_unlock(GBVIEW_FLAME * gf,WIN_FLAME * wf);
int win_lock(GBVIEW_FLAME * gf,WIN_FLAME * wf);
int win_wlock(GBVIEW_FLAME * gf,WIN_FLAME * wf);
void win_unlock(GBVIEW_FLAME * gf,WIN_FLAME * wf);
void _ex_lock(GBVIEW_FLAME * gf);
void _ex_unlock(GBVIEW_FLAME * gf);
void ex_lock(GBVIEW_FLAME * gf);
void ex_unlock(GBVIEW_FLAME * gf);
unsigned int _wf_insert_time(WIN_FLAME * wf);
unsigned int wf_insert_time(GBVIEW_FLAME * gf,int wfid);
int get_wf_priadj(GBVIEW_FLAME * gf,WF_ID id);
int _get_wf_pri(GBVIEW_FLAME * gf,WIN_FLAME * wf);
void _set_pri_adj(GBVIEW_FLAME * gf,WIN_FLAME * wf,int adj);
void set_pri_adj(GBVIEW_FLAME * gf,int wfid,int adj);
void wf_check_resource(GBVIEW_FLAME * gf);
void wf_wakeup(GBVIEW_FLAME * gf);
void _wf_flame_redraw(GBVIEW_FLAME * gf);
int _wf_set_current(GBVIEW_FLAME * gf,WIN_FLAME * now,WIN_FLAME * target);
void _wf_set_redraw(GBVIEW_FLAME * gf);
void clear_info(GBVIEW_FLAME * gf);
void insert_redraw_gbr(GBVIEW_FLAME * gf,GB_RECT * r);
int wf_move(GBVIEW_FLAME * gf,VPOINT from,VPOINT to);
int new_rotate_and_center(
	GBVIEW_FLAME * gf,
	GB_POINT from,
	GB_POINT to);
int _wf_purge_select(GBVIEW_FLAME * gf);
unsigned long *
_rotate_plane(
	GBVIEW_FLAME * gf,
	unsigned long * plane,
	VPOINT * index);
void indicate_info_card(GBVIEW_FLAME * gf,RESOURCE * r,OBJ * o);
int wf_purge_select(GBVIEW_FLAME * gf);
void wf_get_coordinate_info(GBVIEW_FLAME * gf,L_CHAR ** name,int * rid,GB_POINT * ptr,int ptr_len);

/* table drawing functions */

int
e2d_new(
	WIN_FLAME_TABLE * tbl,
	GBVIEW_FLAME * gf,
	WF_ID *		ret_wfid,
	REAL1		v_reso,
	RESOURCE * 	draw,
	MAP_HISTORY * 	mh,
	GB_POINT	center,
	REAL1		rotate,
	REAL1		resolution);
int e2d_move(	GBVIEW_FLAME * gf,
		struct win_flame * wf,
		VPOINT from,
		VPOINT to,
		void * ix);
int e2d_exit(	GBVIEW_FLAME * gf,
		struct win_flame * wf);
int e2d_change(	struct win_flame_table * tbl,
		GBVIEW_FLAME * gf,
		struct win_flame * wf);
int e2d_redraw(	GBVIEW_FLAME * gf,
		struct win_flame * 	wf);
int e2d_dirty(	GBVIEW_FLAME * gf,
		struct win_flame *	wf,
		GB_RECT *		r,
		int			flags,
		int			mode);
int e2d_overlay(GBVIEW_FLAME * 		gf,
		struct win_flame *	wf,
		OV_ARG *		a);
int e2d_zoom(	GBVIEW_FLAME * gf,
		struct win_flame * 	wf,
		int			w,
		int			h,
		int *			index_x,
		int *			index_y);
int e2d_resize(	GBVIEW_FLAME * gf,
		struct win_flame *	wf);
int e2d_rotate(	GBVIEW_FLAME * gf,
		struct win_flame *	wf,
		VPOINT *		ix);

int e2d_p_move(	GBVIEW_FLAME * gf,
		struct win_flame * wf,
		VPOINT from,
		VPOINT to,
		void * ix);
int e2d_p_exit(	GBVIEW_FLAME * gf,
		struct win_flame * wf);
int e2d_p_change(struct win_flame_table * tbl,
		GBVIEW_FLAME * gf,
		struct win_flame * wf);
int e2d_p_redraw(GBVIEW_FLAME * gf,
		struct win_flame * 	wf);
int e2d_p_dirty(GBVIEW_FLAME * gf,
		struct win_flame *	wf,
		GB_RECT *		r,
		int			flags,
		int			mode);

int globe_move(	GBVIEW_FLAME * gf,
		struct win_flame * wf,
		VPOINT from,
		VPOINT to,
		void * ix);
int globe_move_plot(GBVIEW_FLAME * gf,
		struct win_flame * wf,
		VPOINT from,
		VPOINT to,
		void * ix);

int _e2d_p_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf);

void _xx_free_win_flame(GBVIEW_FLAME * gf,WIN_FLAME*wf,char * __file,int __line);
#define _free_win_flame(gf,wf)	_xx_free_win_flame((gf),(wf),__FILE__,__LINE__)


#endif
