/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___QUEUE_H___
#define ___QUEUE_H___

#include	"long_char.h"
#include	"utils.h"

typedef struct q_header {
	struct q_header *	next;
	L_CHAR *		key;
	struct sys_queue *	ins;
} Q_HEADER;

typedef struct key_list {
	struct key_list *	next;
	L_CHAR *		key;
	int			cnt;
	int			task_asign;
} KEY_LIST;

typedef struct sys_queue {
	SEM *			target_lock;

	int			flags;
#define QFM_DIRECT		0x00000001
#define QF_FIFO			0x00000000
#define QF_STACK		0x00000001
#define QF_HIGH			0x00000010

	void			(*gc_func)();
	void			(*gc_get)();

	void			(*key_func)();

	int			pri;
	int			key_limit;
	int			total_limit;

	Q_HEADER *		head;
	Q_HEADER *		tail;


	KEY_LIST *		keylist;
	int			total_cnt;

	void *			work;

	struct sys_queue *	next;
} SYS_QUEUE;

#define Q_WAIT_NOWAIT		0
#define Q_WAIT_WAIT		1
#define Q_WAIT_FORCE_INSERT	2

void setup_queue(SYS_QUEUE * q);
int insert_queue(SYS_QUEUE * q,void * n,int wait_flag);
void *
delete_queue(SYS_QUEUE * q,int (*cond)(),void * work,int wait_flag);
L_CHAR * touch_qkey(SYS_QUEUE * q);
void release_qkey(SYS_QUEUE * q,L_CHAR * key);
int sq_key_cond(SYS_QUEUE *,void *,void *);
L_CHAR *  xx_get_server_key(URL * u,char *,int);
#define get_server_key(u)	xx_get_server_key((u),__FILE__,__LINE__)
int check_queue(SYS_QUEUE * q,int (*cond)(),void * work);
void * xx_new_queue_node(int,char*,int);
#define new_queue_node(s)	xx_new_queue_node((s),__FILE__,__LINE__)
int get_active_que_thread(SYS_QUEUE*);

#endif

