/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>
#include	<stdlib.h>
#include	<fcntl.h>
#include	"r64.h"

int
cmp_col(unsigned char * c1,unsigned char * c2)
{
int i;
	for ( i = 0 ; i < 3 ; i ++ )
		if ( c1[i] != c2[i] )
			return -1;
	return 0;
}

void
test_start(char * file1,char * file2,int level)
{
R64_FILE * f1,*f2;
int x,y,w,h;
unsigned char col_1[3],col_2[3];

	f1 = r64_open_file(file1,O_RDONLY,0644,'P',0,0);
	if ( f1 == 0 ) {
		fprintf(stderr,"F1 r64 error: %i\n",r64_error);
		perror("system ");
		exit(1);
	}
	f2 = r64_open_file(file2,O_RDONLY,0644,'P',0,0);
	if ( f1 == 0 ) {
		fprintf(stderr,"F2 r64 error: %i\n",r64_error);
		perror("system ");
		exit(1);
	}
	if ( f1->level_w[level] != f2->level_w[level] ) {
		fprintf(stderr,"diferent level width %i = %i\n",
			f1->level_w[level],
			f2->level_w[level]);
		exit(1);
	}
	if ( f1->level_h[level] != f2->level_h[level] ) {
		fprintf(stderr,"diferent level width %i = %i\n",
			f1->level_h[level],
			f2->level_h[level]);
		exit(1);
	}
	w = f1->level_w[level];
	h = f1->level_h[level];
	printf("wh = (%i,%i)\n",w,h);
	for ( x = 0 ; x < w ; x ++ )
		for ( y= 0 ; y < h ; y ++ ) {
			r64_red(col_1,f1,x,y,level);
			r64_red(col_2,f2,x,y,level);
			if ( cmp_col(col_1,col_2) ) {
				printf("(%i,%i)=[%x.%x.%x][%x.%x.%x]\n",
					x,y,
					col_1[0],
					col_1[1],
					col_1[2],
					col_2[0],
					col_2[1],
					col_2[2]);

goto end;

			}

/*
			if ( col_2[0] != 0xa ||
				col_2[1] != 0xb ||
				col_2[2] != 0x1d )
				printf ("(%i %i)\n",x,y);
*/
		}
end:
	r64_close_file(f1);
	r64_close_file(f2);
}

int
main(int argc,char ** argv)
{
	r64_init();
	test_start(argv[1],argv[2],atoi(argv[3]));
	return 0;
}

