/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"
#include	"kyotodb.h"
#include	"favt.h"
#include	"dtree.h"

XL_SEXP * xl_set_point();

void
init_set_point(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"set-point"),
		get_func_prim(xl_set_point,FO_APPLICATIVE,0,3,3));
}

XL_SEXP *
xl_set_point(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * id;
XL_SEXP * plist;
	id = get_el(s,1);
	plist = get_el(s,2);
	if ( get_type(id) != XLT_STRING )
		goto type_missmatch;
	if ( get_type(plist) != XLT_STRING )
		goto type_missmatch;
	insert_point(n_string(std_cm,id->string.data),
		     n_string(std_cm,plist->string.data));
	return 0;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"set-point"),
		0);

}


