/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "zuyou_data.h"
#include <string.h>



int ReadAndChop(FILE *fp, char *szBuff, int nBuffSize){
	if(fgets(szBuff, nBuffSize, fp)==NULL) 
		return 0;
	chop(szBuff);
	return 1;
}

int Zuyou2XML(FILE *fp, ZUYOU_DATA *pData){
	fprintf(fp, "<infomation");
	
	/* Ͽޤο޳ */
	fprintf(fp, " map_square=\"%.1f,%.1f,%.1f,%.1f\"",
				pData->rMap.left, pData->rMap.top,
				pData->rMap.right, pData->rMap.bottom);
	/* Ͽ̾ */
	fprintf(fp, " map_name=\"%s\"", pData->szMapName);
	
	/* ΣĤϿ */
	fprintf(fp, " surrounding_maps=\"%s,%s,%s,%s,%s,%s,%s,%s\"", 
			pData->pszSurroundMapNames[0],
			pData->pszSurroundMapNames[1],
			pData->pszSurroundMapNames[2],
			pData->pszSurroundMapNames[3],
			pData->pszSurroundMapNames[4],
			pData->pszSurroundMapNames[5],
			pData->pszSurroundMapNames[6],
			pData->pszSurroundMapNames[7]);
	
	fprintf(fp, "/>");
	
	return ID_ERR_NOERROR;
}


#define READ_LINE_AND_CHOP(buff) if(!ReadAndChop(fp,buff,sizeof(buff))) return ID_ERR_FILE_FORMAT
int ReadZuyouDataFile(const char *szFileName, ZUYOU_DATA **ppData)
{
	int nBuffSize=2047;
	char szBuff[2048];
	ZUYOU_DATA *pData;
	char *token;
	int i;
	char *p,*p2;
	
	FILE *fp;
	fp = fopen(szFileName,"r");
	if(!fp){
		p = strrchr(szFileName, PATH_DEVIDER);
		if(p){
			*p = '\0';
			p2 = strrchr(szFileName, PATH_DEVIDER);
			*p = PATH_DEVIDER;
			if(p2)
				strtoupper(p2);
			else
				strtoupper(p);
		}
		fp = fopen(szFileName, "r");
	}
	if(!fp){
		return ID_ERR_FILE_OPEN;
	}
	

	pData = (ZUYOU_DATA *)malloc(sizeof(ZUYOU_DATA));
	memset(pData,'\0',sizeof(ZUYOU_DATA));
	*ppData = pData;
	
	/* ֥ǡ */
	READ_LINE_AND_CHOP(pData->szDataFileKind);
	/* ߾ʹ */
	READ_LINE_AND_CHOP(pData->szOrganization);
	/* ǯ */
	READ_LINE_AND_CHOP(pData->szCreatedDate);
	/* ǯ */
	READ_LINE_AND_CHOP(pData->szModifiedDate);
	/* 09lc991 */
	READ_LINE_AND_CHOP(pData->szMapName);

	/* Ͽ޾٥(̼ܤ) */
	if(!ReadAndChop(fp,szBuff,sizeof(szBuff))){
		return ID_ERR_FILE_FORMAT;
	}
	pData->nMapInfoLevel = atoi(szBuff);
	
	/* ɸϤȿޤκȱκɸ */
	READ_LINE_AND_CHOP(szBuff);
	token = strtok(szBuff,",");
	if(token==NULL)
		return ID_ERR_FILE_FORMAT;
	pData->nCoordinate = atoi(token);
	token = strtok(NULL,",");
	if(token==NULL)
		return ID_ERR_FILE_FORMAT;
	pData->rMap.left = atoi(token);
	token = strtok(NULL,",");
	if(token==NULL)
		return ID_ERR_FILE_FORMAT;
	pData->rMap.top = atoi(token);
	token = strtok(NULL,",");
	if(token==NULL)
		return ID_ERR_FILE_FORMAT;
	pData->rMap.right = atoi(token);
	token = strtok(NULL,",");
	if(token==NULL)
		return ID_ERR_FILE_FORMAT;
	pData->rMap.bottom = atoi(token);
	
	/* ñ̡ʥ᡼ȥ */
	READ_LINE_AND_CHOP(pData->szUnit);
	
	/* ܿ̾ */
	READ_LINE_AND_CHOP(szBuff);
	p = szBuff;
	for(i=0;i<8;++i){
/*		token = strtok(szBuff,","); */
		if(!p){
			strcpy(pData->pszSurroundMapNames[i],"");
		}
		p2 = strchr(p, ',');
		if(p2){
			memset(pData->pszSurroundMapNames[i], 0, sizeof(pData->pszSurroundMapNames[i]));
			strncpy(pData->pszSurroundMapNames[i],p,p2-p);
		}
		else{
			strcpy(pData->pszSurroundMapNames[i],p);
			p=0;
		}
	}
	
	/* ѥե̾ */
	i=0;
	while(ReadAndChop(fp, szBuff, sizeof(szBuff))){
		pData->pszUsingFileNames[i] = (char *)malloc(strlen(szBuff)+1);
		strcpy(pData->pszUsingFileNames[i], szBuff);
		++i;
	}
	pData->nFileCount = i;
	fclose(fp);
	return ID_ERR_NOERROR;
}

int ZuyouFile2XML(FILE *fp, const char *szInputFileName)
{
	ZUYOU_DATA *pData;
	int nRetCode = ReadZuyouDataFile(szInputFileName, &pData);
	if(nRetCode != ID_ERR_NOERROR)
		return nRetCode;
	nRetCode = Zuyou2XML(fp, pData);
	free_zuyou_data(pData);
	return nRetCode;
}

void free_zuyou_data(ZUYOU_DATA *pData)
{
	if(pData){
		int i;
		for(i=0;i<pData->nFileCount;++i){
			free(pData->pszUsingFileNames[i]);
		}
		free(pData);
	}
}

