/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"memory_debug.h"
#include	"xl.h"
#include	"gbpmd.h"
#include	"pri_level.h"
#include	"pfc.h"

void set_task();
void set_interval();

PFC pmd_pfc;
int assert_pfc;
unsigned int start_time;

int set_cnt;
int trigger_active;

void
init_set_task()
{
	create_task(set_task,0,PRI_FETCH);
	new_tick(set_interval,10,0);
	trigger_active = 1;
}


void
set_task()
{
L_CHAR * db,* target;
int ses;
XL_INTERPRETER * xli;
unsigned int start;
extern int acc_pfc;
int interval;

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);
	sleep_sec(1);

	init_pfc();
	pfc_checkpoint(&pmd_pfc);


	start_time = get_xltime(); 
	ses = open_session(SEST_OPTIMIZE);
	for ( ; ; ) {

		delete_pmd_que(&db,&target,&interval);
		gc_push(0,0,"set_task");

		if ( assert_pfc ) {
			assert_pfc = 0;
			init_pfc();
			pfc_checkpoint(&pmd_pfc);
		}
		if ( l_strcmp(db,l_string(std_cm,"end")) == 0 ) {
			last_pfc();
			gc_pop(0,0);
			exit(1);
		}
		else {
			init_pfc();
			start = get_xltime();

			set_target(ses,db,target,interval); 

			d_f_ree(db);
			d_f_ree(target);

			set_accumulate(&pmd_pfc,get_xltime() - start + 1);


		}
		gc_pop(0,0);
	}
}

void
set_interval()
{
	assert_pfc = 1;
	if ( check_pmd_que() ) {
		set_cnt = 0;
		return;
	}
	if ( set_cnt == 0 ) {
		set_cnt ++;
		return;
	}
	insert_pmd_que(l_string(std_cm,"end"),l_string(std_cm,"target"));
}
