/*
 * Decompiled with CFR 0.152.
 */
package org.ginkgo.gcov.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class WorkbenchPropertyPage1
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Button check;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.check = new Button(composite, 32);
        this.check.setText("Activate nature");
        IAdaptable element = this.getElement();
        IProject project = (IProject)element.getAdapter(IProject.class);
        try {
            this.check.setSelection(project.hasNature("org.ginkgo.gcov.sampleNature"));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return composite;
    }

    public boolean performOk() {
        try {
            if (this.check.getSelection()) {
                this.addNature();
            } else {
                this.removeNature();
            }
            return true;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void addNature() throws CoreException {
        IAdaptable element = this.getElement();
        IProject project = (IProject)element.getAdapter(IProject.class);
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if ("org.ginkgo.gcov.sampleNature".equals(natures[i])) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "org.ginkgo.gcov.sampleNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    private void removeNature() throws CoreException {
        IAdaptable element = this.getElement();
        IProject project = (IProject)element.getAdapter(IProject.class);
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if ("org.ginkgo.gcov.sampleNature".equals(natures[i])) {
                String[] newNatures = new String[natures.length - 1];
                System.arraycopy(natures, 0, newNatures, 0, i);
                System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }
}

