/*
 * Decompiled with CFR 0.152.
 */
package net.twoch.GikoMail;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CSVTokenizer
implements Enumeration {
    public static final String copyright = "Copyright 1997 TAMURA Kent\nCopyright 1999 ANDOH Tomoharu";
    private String source;
    private int currentPosition;
    private int maxPosition;

    public CSVTokenizer(String string) {
        this.source = string;
        this.currentPosition = 0;
        this.maxPosition = string.length();
    }

    private int nextComma(int n) {
        boolean bl = false;
        while (n < this.maxPosition) {
            char c = this.source.charAt(n);
            if (!bl && c == ',') break;
            if ('\"' == c) {
                bl = !bl;
            }
            ++n;
        }
        return n;
    }

    public int countTokens() {
        int n = 0;
        int n2 = 1;
        while ((n = this.nextComma(n)) < this.maxPosition) {
            ++n;
            ++n2;
        }
        return n2;
    }

    public String nextToken() {
        if (this.currentPosition > this.maxPosition) {
            throw new NoSuchElementException(this.toString() + "#nextToken");
        }
        int n = this.currentPosition;
        this.currentPosition = this.nextComma(this.currentPosition);
        StringBuffer stringBuffer = new StringBuffer();
        while (n < this.currentPosition) {
            char c;
            if ((c = this.source.charAt(n++)) == '\"') {
                if (n >= this.currentPosition || this.source.charAt(n) != '\"') continue;
                stringBuffer.append(c);
                ++n;
                continue;
            }
            stringBuffer.append(c);
        }
        ++this.currentPosition;
        return new String(stringBuffer);
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public boolean hasMoreTokens() {
        return this.nextComma(this.currentPosition) <= this.maxPosition;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public String toString() {
        return "CSVTokenizer(\"" + this.source + "\")";
    }
}

