package matrix;
import java.util.*;

import io.*;


public class findCDS { 
    disrand dis;
    MatrixLoad m; // original mutation matrix
	Jacobi jacobi;
	
	public static void main(String[] args) throws Exception{
		newMatrixLoad m0 = new newMatrixLoad();
        double kappa  = m0.kappa;
        double lambda = m0.lambda;
        
		String[] tmpdata = fileload.loadLine0(args[0]);

        // data input
		String[][] data2 = new String[0][0];
		if(tmpdata[0].charAt(0)=='>'){
			data2 = fastaFormat.translate(tmpdata);
		}else{
			data2 = blastFormat.translate(tmpdata);
		}
		for(int i=0;i<data2[0].length/2;i++){
	        double[][] result = findCDS.areas( m0,data2[1][i*2],data2[1][i*2+1]);
	        for(int j=0;j<result.length;j++){
	    	    double E = E(kappa,lambda,data2[1][i*2].length(), result[j][2] );
	   		    if(E<0.01){
	   		    	System.out.println( (int)result[j][0] + "\t" + (int)result[j][1] + "\t" + E);
	   	    	}
	        }
		}
        /*       
        double[] score = new double[1]; score[0] = 0.0; //to use call-by-pointer

        int size = data2[0].length / 2; // number of sequence pairs
        for(int i=0;i<size;i++){
	        String[][] result = new String[2][];
    	    // max CDS
        	result[1] = maxCDS( m0,data2[1][i*2],data2[1][i*2+1], score );
    	    // title
    	    result[0] = new String[2]; 
    	    double E = E(kappa,lambda,data2[1][i*2].length(), score[0] );
    	    result[0][0] = data2[0][i*2]   + " " + E; 
    	    result[0][1] = data2[0][i*2+1] + " " + E;
	      	fastaFormat.output(result);
        }
        /**/
    }

    public static double E(double kappa, double lambda, int len, double score){
    	return( kappa*len*Math.exp(-score*lambda) );
    }

    public static String[] maxCDS(newMatrixLoad mat, String seq1, String seq2, double[] score){
    	int len = seq1.length()/3;
    	double[][] keisan = scores(mat, seq1, seq2);
        double max = -100;
        int maxX=0;
        int maxY=0;
    	for(int n=0;n<3;n++){
	    	for(int start=0;start<len-1;start++){
    	        double total = keisan[n][start];
    			for(int end=start+1;(end<len);end++){
            	    total+=keisan[n][end];
                	if(max<total){
                		max=total;
	                	maxX=start*3+n;
    	            	maxY=end*3+n;
        	        }
    			}
	    	}
    	}
    	String[] result = new String[3];
    	result[0] = seq1.substring(maxX,maxY);
    	result[1] = seq2.substring(maxX,maxY);
    	score[0] = max;
    	return result;
    }    

    public static double[][] scores(newMatrixLoad mat, String seq1, String seq2){
    	int size = seq1.length()/3;
    	if(seq2.length()<seq1.length()) size = seq2.length()/3;
    	double[][] keisan = new double[3][size];
    	double[][] result = new double[3][size];
    	for(int n=0;n<3;n++){
			for(int i=0;i<size-2;i++){
    			keisan[n][i] = mat.value(seq1.substring(i*3+n,i*3+3+n),seq2.substring(i*3+n,i*3+3+n));
			}
    	}
    	return keisan;
    }    

    public static double[] window5(double[] org){
    	int len = org.length;
		double[] keisan = new double[len];
		keisan[0]=org[0];
		keisan[1]=org[0]+org[1];
    	for(int i=2;i<len-2;i++){
    		keisan[i] = org[i-2]+org[i-1]+org[i]+org[i+1]+org[i+2]; 
    	}
    	return keisan;
    }    

	public static int maxPos(double[] data){
		double max=0.0;
		int result=0;
		for(int i=0;i<data.length;i++){
			if(max<data[i]){
				max=data[i];
				result=i;
			}
		}
		return result;
	}

	public static double[] extend(int center, double[] data){
		int start=center, end=center;
		// extend for minus direction
		double max=0.0, total=0.0;
		for(int i=center;i>=0;i--){
			total+=data[i];
			if(max<total){
				max=total;
				start=i;
			}
		}
		// extend for plus direction
		double max1=max; max=0.0;
		for(int i=center;i<data.length;i++){
			total+=data[i];
			if(max<total){
				max=total;
				end=i;
			}
		}
		double[] result = new double[3]; // start and end;
		result[0]=start;result[1]=end;result[2]=max1+max-data[center];
		return result;
	}

	public static double[][] areas(newMatrixLoad mat, String seq1, String seq2){
       	double[][] tmp = scores( mat,seq1,seq2 );
       	Vector start = new Vector();
       	Vector end   =new Vector();
       	Vector score =new Vector();
       	for(int n=0;n<3;n++){
	       	double highScore=1.0;
       		do{
       			highScore=0.0;
	       		double[] tmp2 = window5(tmp[n]);
	       		int pos = findCDS.maxPos(tmp2);
	       		double[] startend = findCDS.extend(pos,tmp[n]);
	       		for(int j=(int) startend[0];j<=startend[1];j++) tmp[n][j]=0.0;
	       		highScore=startend[2];
	       		if(highScore>0){
	       			start.add( new Double(startend[0]*3+n) );
	       			end.  add( new Double(startend[1]*3+n) );
	       			score.add( new Double(startend[2]) );
	       		}
       		}while(highScore>0);
        }
        int size=start.size();
        double[][] result = new double[size][3];
        for(int i=0;i<size;i++){
        	result[i][0]=( (Double)start.elementAt(i) ).doubleValue();
        	result[i][1]=( (Double)end.elementAt(i) ).doubleValue();
        	result[i][2]=( (Double)score.elementAt(i) ).doubleValue();
        }
        return result;
	}
}
