package matrix;

import java.util.Arrays;
import java.util.Vector;
import java.util.StringTokenizer;
/**
 * @author user
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */

public class Matrix{
	public static double[][] copy(double[][] org){
    	int n=org.length;
    	double[][] result = new double[n][];
    	for(int i=0;i<n;i++){
    		result[i] = new double[org[i].length];
    		for(int j=0;j<org[i].length;j++){
    		 	result[i][j]=org[i][j];
    		}
    	}
    	return result;
    }
 
	
    public static double[][] multiple(double[][] A, double[][] B)   //returns AB 
//        throws ArithmeticException;
    {
        double[][] result = new double[0][0];
        try{
            int m = A.length;
            int n = B[0].length;
            result = new double[m][n];
            for(int i=0;i<m;i++){
                for(int j=0;j<n;j++){
                    result[i][j] = 0.0;
                    int l = A[i].length;
                    for(int k=0;k<l;k++){
                        result[i][j] += A[i][k]*B[k][j];
                    }
                }
            }
        } catch (ArrayIndexOutOfBoundsException e){
//            throw new ArithmeticException("Illegal size");
        }
        return result;
    }
 
    public static double[][] sum(double[][] A, double[][] B)   //returns A+B 
//        throws ArithmeticException;
    {
        double[][] result = new double[0][0];
        try{
            int m = A.length;
            result = new double[m][];
            for(int i=0;i<m;i++){
                int n = A[i].length;
                result[i] = new double[n];
                for(int j=0;j<n;j++){
                    result[i][j] = A[i][j] + B[i][j];
                }
            }
        } catch (ArrayIndexOutOfBoundsException e){
//            throw new ArithmeticException("Illegal size");
        }
        return result;
    }
 
    public static double[][] scalar(double c, double[][] A)   //returns cA 
//        throws ArithmeticException;
    {
        double[][] result = new double[0][0];
        try{
            int m = A.length;
            result = new double[m][];
            for(int i=0;i<m;i++){
                int n = A[i].length;
                result[i] = new double[n];
                for(int j=0;j<n;j++){
                    result[i][j] = c * A[i][j];
                }
            }
        } catch (ArrayIndexOutOfBoundsException e){
//            throw new ArithmeticException("Illegal size");
        }
        return result;
    }

	public static double[][] makeItOne(double[][] org){   //returns cA 
		int i, j;

        int n=org.length;
		double[][] result = new double[n][];
		for (i = 0; i < n; i++) {
			double total=0.0;
            result[i] = new double[org[i].length];
			for (j = 0; j < org[i].length; j++) {
				total+=org[i][j];
			}
			for (j = 0; j <= i; j++) {
                result[i][j]=org[i][j]/total;
			}
		}
		return result;
	}

	public static double[][] log(double[][] org){   //returns cA 
		int i, j;

        int n=org.length;
		double[][] result = new double[n][];
		for (i = 0; i < n; i++) {
			double total=0.0;
            result[i] = new double[org[i].length];
			for (j = 0; j <= i; j++) {
                result[i][j] = Math.log(org[i][j]);
			}
		}
		return result;
	}

 


 
    public static double[][] E(int n)   //returns E 
//        throws ArithmeticException;
    {
        double[][] result = new double[n][n];
        for(int i=0;i<n;i++){
            result[i] = new double[n];
            Arrays.fill(result[i],0.0);
            result[i][i] = 1.0;   // tan-i gyouretsu
        }
        return result;
    }
 
    public static void show(double[][] mat){ 
        int s,t;
        int n = mat.length;
        for (s=0; s<n; s++) {
            int m = mat[s].length;
            for (t=0; t<m; t++) {
                Double SB;
                long tmp = Math.round( mat[s][t] *1000 );
                SB = new Double( (double) tmp/1000 );
/**/                System.out.print( SB );
/*/                System.out.print(mat[s][t]); /**/
                System.out.print(',');
            }
            System.out.println();
        }
    }

    public static void show2(double[][] mat){ 
        int s,t;
        int n = mat.length;
        for (s=0; s<n; s++) {
            int m = mat[s].length;
            for (t=0; t<m; t++) {
                Double SB;
                long tmp = Math.round( mat[s][t] *1000 );
                SB = new Double( (double) tmp/1000 );
/*/                System.out.print( SB );
/*/                System.out.print(mat[s][t]); /**/
                System.out.print(',');
            }
            System.out.println();
        }
    }

    public static double[][] CSVtoMatrix(String[] lines){ 
        double[][] result = new double[lines.length][];
        for(int i=0;i<lines.length;i++){
        	Vector v = new Vector();
        	StringTokenizer ST = new StringTokenizer(lines[i],",");
        	while (ST.hasMoreTokens()){
        		v.addElement(ST.nextToken());
        	}
        	int size=v.size();
        	result[i] = new double[size];
        	for(int j=0;j<size;j++){
        		result[i][j] = ( new Double( (String) v.elementAt(j) )  ).doubleValue();
        	}
        }
        return result;
    }
}
  
