package matrix;
import java.util.Arrays;
import io.fileload;

public class Jacobi {
    double[][] original;
    double[][] diagonal;
    double[][] U; // 
    double[][] invU; // 
	//  invU * original * U = diagonal
	//  original = U * diagonal * invU
    
	double[][] diagonalLog;  // log(diagonal)
	

	public Jacobi(double[][] org) throws Exception{
        double[][] a = sym(org);
        original = Matrix.copy(a);
        int dim = a.length;  // size 
          
        double[][] u = new double[dim][dim];   /* Pʍs */
	    for(int i=0;i<dim;i++){
	    	Arrays.fill(u[i],0.0);
	    	u[i][i] = 1.0;
	    }

	    while(true){
        	double max;
	        max = transform(a,u);       /* ϊ */
        	if(max<EPS) break;       /* AI */
    	}
		diagonal = a; //diagonal matrix
		U = u;
	    inverse I = new inverse();
	    invU = I.Inverse(u);
		diagonalLog = diagonalLog(diagonal);
	}
	
	public double[][] power(double x){  // original ^ x
    	int n = diagonalLog.length;
    	double[][] tmp = new double[n][n];
    	for(int i=0;i<n;i++) Arrays.fill(tmp[i],0.0); // all clear
    	for(int i=0;i<n;i++) tmp[i][i] = Math.exp( x * diagonalLog[i][i] );
		double[][] tmp2 = Matrix.multiple(U,tmp);
		double[][] result = Matrix.multiple(tmp2,invU);
		return result;
	}

	public double[][] V(){  // original ^ x
    	int n = diagonalLog.length;
    	double[][] tmp = new double[n][n];
    	for(int i=0;i<n;i++) Arrays.fill(tmp[i],0.0); // all clear
    	for(int i=0;i<n;i++) tmp[i][i] = diagonalLog[i][i];
		double[][] tmp2 = Matrix.multiple(U,tmp);
		double[][] result = Matrix.multiple(tmp2,invU);
		return result;
	}
	
   	public void test(){
		double[][] tmp2 = Matrix.multiple(original,U);
		tmp2 = Matrix.multiple(invU,tmp2);
	    Matrix.show(tmp2);
	}
			
/*

ASŶ܂Ƃ߁

[1] Ώ̍sA̍őlTAs{bgp,q߂
@@@@
[2] t[R]A[R]߁AŗLl
    U[R]߁AŗLxNgɎ
@@@@
[3] ől[ɂȂieΌ덷EPSȉɂȂj܂
@@菇[1][2]JԂ


 */
 
	static double EPS = 0.000000001;    /* eΌ덷 */

    public static void main(String[] args) throws Exception{
    	
    	String[] lines = fileload.loadLine0(args[0]);
        /* input matrix */
/**/        double[][] org= Matrix.scalar(0.0001,Matrix.CSVtoMatrix(lines));      
/*/        double[][] org= getData();      /**/
//	    System.out.println("original");
//	    Matrix.show(org);
	    
        double[][] a = sym(org);
//   	    System.out.println("sym org");
//	    Matrix.show(a);

        double[][] copya = Matrix.copy(a);
        int dim = a.length;


          
        double[][] u = new double[dim][dim];   /* Pʍs */
	    for(int i=0;i<dim;i++){
	    	Arrays.fill(u[i],0.0);
          u[i][i] = 1.0;
	    }

	    while(true){
        	double max;
	        max = transform(a,u);       /* ϊ */
//	        System.out.println(max);
        	if(max<EPS) break;       /* AI */
    	}
    
/*
	    System.out.println("eigenvalues");
	    Matrix.show(a);
	    System.out.println("eigenvectors");
	    Matrix.show(u);
*/	    

//	    double[][] tmp1 = Matrix.multiple(u,a);
//	    double[][] tmp2 = Matrix.multiple(copya,u);
/*
	    System.out.println("HP");
	    Matrix.show(tmp1);
	    System.out.println("PH");
	    Matrix.show(tmp2);
*/

	    inverse I = new inverse();
	    double[][] invU = I.Inverse(u);

//	    tmp2 = Matrix.multiple(invU,tmp2);
//	    System.out.println("H-1PH");
//	    Matrix.show(tmp2);

	    double[][] logA = diagonalLog(a);
	    double[][] tmp3 = Matrix.multiple(u,logA);
	    double[][] tmp4 = Matrix.multiple(tmp3,invU);	    
	    System.out.println("delta");
	    Matrix.show(tmp4);
	}



	static double transform(double[][] a, double[][] u){   /* ϊ */
		// a is data and u is E.
	    double alpha,beta,gamma;   /* AA */
	    double sine,cosine,w;      /* sin,cos,ꎞl */
	    double wa,wb,wc;           /* ꎞIa_pp,a_pq,a_qqi[ */
	    int i,j;

        /* p,qɃs{bgn */
        int[] maxPos = getMaxPos(a);
        int p=maxPos[0];
        int q=maxPos[1];
        double max = Math.abs(a[p][q]);
	    
	    wa = a[p][p];              /* O߂̓oɊÂ */
	    wb = a[p][q];              /* KvȒl߂ */
	    wc = a[q][q];
    
	    alpha = -wb;
	    beta = (wa-wc)/2;
	    gamma = Math.abs(beta)/Math.sqrt(alpha*alpha+beta*beta);
	    	    
	    sine = Math.sqrt((1.0-gamma)/2);
	    if(alpha*beta < 0) sine = -sine;
	    cosine = Math.sqrt(1.0-sine*sine);
	    
	    int dim = a.length;
	    for(j=0; j<dim; j++){
	        w = a[p][j]*cosine - a[q][j]*sine; /*QȂ̂ŕȂNG*/
	        a[q][j] = a[p][j]*sine + a[q][j]*cosine;
	        a[p][j] = w;
	    }
	    for(j=0; j<dim; j++){
	        a[j][p] = a[p][j];
	        a[j][q] = a[q][j];
	    }
	    
	    w = 2.0*wb*sine*cosine;
	    a[p][p] = wa*cosine*cosine + wc*sine*sine -w;
	    a[q][q] = wa*sine*sine + wc*cosine*cosine +w;
	    a[p][q] = a[q][p] = 0;
    
    
	    /* ŗLxNg̓o */
	    for(i=0; i<dim; i++){
	        w = u[i][p]*cosine - u[i][q]*sine; /*QȂ̂ŕȂNG*/
	        u[i][q] = u[i][p]*sine + u[i][q]*cosine;
	        u[i][p] = w;
	    }
	    
	    return max; // maximum value
	}

	static int[] getMaxPos(double[][] a){ /* ől߈ʒuresult[0],result[1]Ԃ */
	    double max = 0.0;
	    int p=0;int q=0;
        int dim = a.length;  
        	    
	    for(int i=0; i<dim-1; i++){    /* Ίp̂dim-1͖ */
	        for(int j=i+1;j<dim;j++){
	        	double tmp = Math.abs(a[i][j]);
	            if(tmp> max){
	                p=i;
	                q=j;
	                max=tmp;
	            }
	        }
	    }
	    int[] result = new int[2];
        result[0]=p;result[1]=q;
	    return result;
	}
	
	public static double[][] getData() {  // in = size
		int i, j;
        double[][] org ={ { 0.0, 0.3, 1.1,20.0},
                           { 0.4, 0.0,25.8, 1.1},
                           { 1.1,33.8, 0.0, 1.6},
                           {14.1, 0.3, 0.5, 0.0}, };

        int n=org.length;
		double[][] a = new double[n][n];
		double[][] abs = new double[n][n];

		for (i = 0; i < n; i++) {
			for (j = 0; j < i; j++) {
				a[i][j] = a[j][i] = (org[i][j]+org[j][i])*0.5*0.001;
			}
		}
		for (i = 0; i < n; i++) {
			a[i][i]=0.0;
			double sum=0.0;
			for (j = 0; j < n; j++) {
				sum+=a[i][j];
			}
			a[i][i]=1.0-sum; // make sum 1.0;
		}
		for (i = 0; i < n; i++) {
			double sum=0.0;
			for (j = 0; j <= i; j++) {
                abs[i][j]=Math.abs(a[i][j]);
			}
		}
		return a;
	}

	public static double[][] sym(double[][] org) {  // symmetry
		int i, j;

        int n=org.length;
		double[][] a = new double[n][n];
		double[][] abs = new double[n][n];
		for (i = 0; i < n; i++) {
			for (j = 0; j < i; j++) {
				a[i][j] = a[j][i] = (org[i][j]+org[j][i])*0.5;
			}
		}
		for (i = 0; i < n; i++) {
			a[i][i]=0.0;
			double sum=0.0;
			for (j = 0; j < n; j++) {
				sum+=a[i][j];
			}
			a[i][i]=1.0-sum; // make sum 1.0;
		}
		for (i = 0; i < n; i++) {
			double sum=0.0;
			for (j = 0; j <= i; j++) {
                abs[i][j]=Math.abs(a[i][j]);
			}
		}
		return a;
	}


    public static double[][] diagonalLog(double[][] org){
    	int n = org.length;
    	double[][] result = new double[n][n];
    	for(int i=0;i<n;i++) Arrays.fill(result[i],0.0); // all clear
    	for(int i=0;i<n;i++) result[i][i] = Math.log(org[i][i]);
    	return result;
    }    
}

	
/*
	public static void main(String[] args){ 
		Jacobi J = new Jacobi(4);
	}
	
	public Jacobi(int in) {  // in = size
		int i, j;

        // initail value

        double[][] org ={ { 0.0, 0.3, 1.1,20.0},
                           { 0.4, 0.0,25.8, 1.1},
                           { 1.1,33.8, 0.0, 1.6},
                           {14.1, 0.3, 0.5, 0.0}, };

        n=org.length;
		a = new double[n][n];
		abs = new double[n][n];

		for (i = 0; i < n; i++) {
			for (j = 0; j <= i; j++) {
				a[i][j] = org[i][j]*0.01;
			}
		}
		for (i = 0; i < n; i++) {
			a[i][i]=0.0;
			double sum=0.0;
			for (j = 0; j <= i; j++) {
				sum+=a[i][j];
			}
			a[i][i]=1.0-sum; // make sum 1.0;
		}
		for (i = 0; i < n; i++) {
			double sum=0.0;
			for (j = 0; j <= i; j++) {
                abs[i][j]=Math.abs(a[i][j]);
			}
		}
		Max();
	}

	private double Max() {  // get the position of maximum value
		double max;
		p = 1;
		q = 0;
		max = abs[1][0];
		for (int i = 1; i < n; i++) {
			for (int j = 0; j < i; j++) {
				if (abs[i][j] > max) {
					p = i;
					q = j;
					max = abs[i][j];
				}
			}
		}
		return max;
	}

	private void Rotate(int p, int q, double c, double s) {
		double [][] ww;
		double cc, ss, cs;
		cc = c * c;
		ss = s * s;
		cs = c * s;
		ww = abs;
		//Ă񂾂낤IH

		for (int i = 0; i < n; i++) {
			ww[p][i] = ww[i][p] = a[p][i] * c - a[q][i] * s;
		}
		for (int i = 0; i < n; i++) {
			ww[q][i] = ww[i][q] = a[p][i] * s + a[q][i] * c;
		}

		ww[p][p] = a[p][p] * cc - 2 * a[p][q] * cs + a[q][q] * ss;
		ww[q][q] = a[p][p] * ss + 2 * a[p][q] * cs + a[q][q] * cc;
		ww[p][q] = ww[q][p] = (a[p][p] - a[q][q]) * cs + a[p][q] * (cc - ss);

		abs = a;
		a = ww;
	}

	public void Step(int loop) {
		double w, c, s;

		while (loop-- > 0) { 
			w = (a[q][q] - a[p][p]) / (2 * a[p][q]);
			if (w >= 0) {
				w = 1.0 / (w + Math.sqrt(w * w + 1));
			} else {
				w = 1.0 / (w - Math.sqrt(w * w + 1));
			}
			c = 1.0 / Math.sqrt(w * w + 1.0);
			s = w * c;
			Rotate(p, q, c, s);

			for (int i = 0; i < n; i++) {
				for (int j = 0; j <= i; j++) {
					abs[i][j] = abs[j][i] = Math.abs(a[i][j]);
				}
			}
			Max();
		}
	}

	public double SumOffDiag() {
		double sum = 0.0;

		for (int i = 1; i < n; i++) {
			for (int j = 0; j < i; j++) {
				sum += abs[i][j] * abs[i][j];
			}
		}

		return sum;
	}

}
*/


