package geneWaltz;


//class of matrices
import java.io.*;
import java.util.*;
//import sequence.*;
import io.*;

import java.util.Arrays;
import java.util.Vector;
import java.util.StringTokenizer;

public class SmithWaterman{
/*
*     public static void main(String[] args) throws FileNotFoundException,IOException {
     System.out.println(args[0]);
     String[] rawData = fileload.loadLine0(args[0]);
     String[] name = Matrix.name(rawData[0]);
     double[][] s = Matrix.CSVtoDoubleMatrix(rawData);
     double[][] H = Hij(s,1.0,0.333);
     show(H);
	}
*/

 public static void main(String[] args){
     String data1 = "AAUGCCAUUGACGG";
     String data2 = "CAGCCUCGCUUAG";
 	double[][] s = score(data1,data2);
 	show(s);
 	System.out.println();
 	double[][] H = Hij(s,1.0,0.33333);
 	show(H);
 }



 public static double[][] score(String seq1, String seq2){
     int m=seq1.length();    	
     int n=seq2.length();
     double[][] result = new double[m+1][n+1];    	
     for(int i=0;i<m;i++){
         for(int j=0;j<n;j++){
         	char c1=seq1.charAt(i);
         	char c2=seq2.charAt(j);
         	if(c1==c2){
         		result[i+1][j+1] = 1.0;
         	}else{
         		result[i+1][j+1] = -0.3333;
         	}
         }
     }
 	return result;
 }
 
 public double[][] mat;
 SmithWaterman(){
     mat = new double[1][];
     mat[0] = new double[1];
     mat[0][0] = 0.0;
 }
 SmithWaterman(int n){
     mat = new double[n][];
     for(int i=0;i<n;i++){
         mat[i] = new double[n];
         for(int j=0;j<n;j++){
             mat[i][j] = 0.0;
         }
     }
     for(int i=0;i<n;i++) mat[i][i]=1.0;
 }
 SmithWaterman(int m, int n){
     mat = new double[m][];
     for(int i=0;i<m;i++){
         mat[i] = new double[n];
         for(int j=0;j<n;j++){
             mat[i][j] = 0.0;
         }
     }
 }
 SmithWaterman(double[][] mat0){
     int m = mat0.length;
     mat = new double[m][];
     for(int i=0;i<m;i++){
         int n = mat0[i].length;
         mat[i] = new double[n];
         for(int j=0;j<n;j++){
             mat[i][j] = mat0[i][j];
         }
     }
 }

	static double[][] Hij(double[][] s,double openCost, double extendCost){ // SW matrix
     int m = s.length;
     int n = s[0].length;
     double[][] H = new double[m][n];
     // start from 0;
     for(int i=0;i<m;i++) H[i][0]=0;
     for(int j=0;j<n;j++) H[0][j]=0;
     // Smith and Waterman 
     for(int i=1;i<m;i++){
         for(int j=1;j<n;j++){
             double result = 0;
             // first candidate
             double c1 = H[i-1][j-1]+s[i][j];
             if( result<c1 ) result=c1;
             // second candidate
           	double c2 =0;
             for(int k=1;k<i;k++){
                 double tmp2 = H[i-k][j]-openCost-extendCost*k;
             	if(c2< tmp2 ) c2 = tmp2;
             }
             if( result<c2 ) result=c2;
             // third candidate
           	double c3 =0;
             for(int l=1;l<j;l++){
                 double tmp3 = H[i][j-l]-openCost-extendCost*l;
             	if(c3< tmp3 ) c3 = tmp3;
             }
             if( result<c3 ) result=c3;
             //at last
             H[i][j] = result;
         }
     }
     return H;
 }

	static int[][] traceback(double[][] s,double openCost, double extendCost){ // SW matrix
     double[][] H = Hij(s,openCost,extendCost);
     int[] start = max2(H);
     // traceback Smith and Waterman 
     int i=start[0];
     int j=start[1];
     Vector listx = new Vector();
     Vector listy = new Vector();
     int count=0;
     while(H[i][j]>0){
     	int newi, newj;
     	newi=i-1;newj=j-1;
     	if(i<1||j<1) break;
     	if(H[i-1][j-1]+s[i][j]!=H[i][j]){
     		for(int k=1;k<i;k++){
                 double tmp2 = H[i-k][j]-openCost-extendCost*k;
                 if( tmp2==H[i][j] ){
                 	newi=i-k;
                 	newj=j;
                 }
     		}
     		for(int l=1;l<i;l++){
                 double tmp2 = H[i][j-l]-openCost-extendCost*l;
                 if( tmp2==H[i][j] ){
                 	newi=i;
                 	newj=j-l;
                 }
     		}
         }
         listx.add(new Integer(i));
         listy.add(new Integer(j));
         count++;
         i=newi;j=newj;
     }
     int[][] result = new int[count][2];
     for(int n=0;n<count;n++){
     	//reverse order
     	result[count-n-1][0] = ((Integer) listx.elementAt(n)).intValue();
     	result[count-n-1][1] = ((Integer) listy.elementAt(n)).intValue();
     }
     return result;
 }

	public static int[] max2(double[][] mat){ // find maximal value in a matrix
     int[] result = new int[2];
     double max = 0.0;
   	for(int i=0;i<mat.length;i++){
    		for(int j=0;j<mat[i].length;j++){
    			if ( max<mat[i][j] ){
    				 max = mat[i][j];
    				 result[0]=i;
    				 result[1]=j;
    			}
    		}
    	}
     return result;
	}
SmithWaterman(SmithWaterman mat0){
     int m = mat0.mat.length;
     mat = new double[m][];
     for(int i=0;i<m;i++){
         int n = mat0.mat[i].length;
         mat[i] = new double[n];
         for(int j=0;j<n;j++){
             mat[i][j] = mat0.mat[i][j];
         }
     }
 }
 public static void show(double[][] mat){
     int matsize=mat.length;
     for(int i=0;i<matsize;i++){
        int matwidth=mat[i].length;
         for(int j=0;j<matwidth;j++){
             if(Math.abs(mat[i][j])>0.0001) System.out.print(mat[i][j]);
             else System.out.print(0.0);
             System.out.print("\t");
         }
         System.out.println();
     }
 }

 public int height(){return mat.length;}
 public int width(){return mat[0].length;}
 public double value(int x, int y){return mat[x][y];}


 public static String[] name(String line){
     Vector v = new Vector();
     StringTokenizer ST = new StringTokenizer(line,",");
     while (ST.hasMoreTokens()){
     	v.addElement(ST.nextToken());
     }
    	int size=v.size();
     String[] result = new String[size];
    	for(int j=0;j<size;j++){
    		String tmp = ((String) v.elementAt(j)).replace('U','t');
  		result[j] =  tmp.toLowerCase();
    	}
    	return result;
 }

/*    
 public static double[][] CSVtoDoubleMatrix(String[] lines){ 
     double[][] data = new double[lines.length-1][];// first line is name
     for(int i=0;i<lines.length-1;i++){
     	Vector v = new Vector();
     	StringTokenizer ST = new StringTokenizer(lines[i+1],",");
     	while (ST.hasMoreTokens()){
     		v.addElement(ST.nextToken());
     	}
     	int size=v.size();
         data[i] = new double[size-1]; // first line is name
     	for(int j=0;j<size-1;j++){
             String a = (String) v.elementAt(j+1);
             double d = ( new Double(a) ).doubleValue();
     		data[i][j] = d;
     	}
     }
     double max = 0;
   	for(int i=0;i<data.length;i++){
    		for(int j=0;j<data[i].length;j++){
    			if ( (i!=j)&&(max<data[i][j]) ) max = data[i][j];
    		}
    	}
    	double[][] result = new double[data.length][];
    	for(int i=0;i<data.length;i++){
    		result[i] = new double[data[i].length];
    		for(int j=0;j<data[i].length;j++){
    			result[i][j] = max - data[i][j];
    		}
    	}
     return result;
 }
*/
	public static String[][] CSVtoStringMatrix(String[] lines){ 
     String[][] data = new String[lines.length][];// first line is name
     for(int i=0;i<lines.length;i++){
     	Vector v = new Vector();
     	StringTokenizer ST = new StringTokenizer(lines[i],",");
     	while (ST.hasMoreTokens()){
     		v.addElement(ST.nextToken());
     	}
     	int size=v.size();
         data[i] = new String[size]; // first line is name
     	for(int j=0;j<size;j++){
             String a = (String) v.elementAt(j+1);
     		data[i][j] = a;
     	}
     }
     return data;
 }





}


