<?php

###############################################################################
# hellenic.php
# This is the Hellenic language page for GeekLog!
# Revision No: 5 
# Date 21/04/2005
#
# + Compatible with Geeklog 1.3.11 + other corrections
# + Geeklog?s new URL added
# + Formalization of the language completed
# + Language is now more ?Modern Greek Friendly?
# + Removal of the most pre-modern Greek (before 1981) words.
#  
#
# Copyright (C) 2002-2005 Master of Death
# mzozd@ad2u.gr & mzozd@hotmail.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'UTF-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Από τον/την:',
    2 => 'Διαβάστε περισσότερα',
    3 => 'σχόλια',
    4 => 'Επεξεργασία',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => 'Μενού Διαχειριστή:',
    10 => 'Κατατεθέντα άρθρα',
    11 => 'Άρθρα',
    12 => 'Συγκροτήματα',
    13 => 'Θέματα',
    14 => '',
    15 => '',
    16 => '',
    17 => 'Χρήστες',
    18 => 'Εντολή SQL',
    19 => 'Αποσύνδεση',
    20 => 'Πληροφορίες Χρήστη:',
    21 => 'Όνομα χρήστη',
    22 => 'Ταυτότητα Χρήστη',
    23 => 'Επίπεδο ασφαλείας',
    24 => 'Ανώνυμος',
    25 => 'Απάντηση',
    26 => 'Τα ακόλουθα σχόλια ανήκουν στους συγγραφείς τους. Η παρούσα ιστοσελίδα δεν ευθύνεται για το περιεχόμενο τους',
    27 => 'Πιο Πρόσφατη Καταχώρηση',
    28 => 'Διαγραφή',
    29 => 'Κανένα σχόλιο.',
    30 => 'Παλαιότερα άρθρα',
    31 => 'Επιτρεπόμενες εντολές HTML:',
    32 => 'Σφάλμα, άγνωστο όνομα χρήστη',
    33 => 'Σφάλμα, το αρχείο καταγραφής δεν μπορεί να προσπελαστεί.',
    34 => 'Σφάλμα',
    35 => 'Αποσύνδεση',
    36 => 'Ενεργοποιημένο',
    37 => 'Δεν έχει γίνει εισαγωγή άρθρων από τους χρήστες',
    38 => 'Κοινοπραξίες Περιεχομένου',
    39 => 'ανανέωση',
    40 => '',
    41 => 'Επισκέπτες',
    42 => 'Συγγραφέας:',
    43 => 'Απαντήστε σε αυτό',
    44 => 'Συνέταιρος',
    45 => 'Σφάλμα MySQL με αριθμό',
    46 => 'Σφάλμα MySQL με μήνυμα',
    47 => 'Μενού Χρηστών',
    48 => 'Πληροφορίες για τον Λογαριασμό σας',
    49 => 'Προβολή προσωπικών σας προτιμήσεων',
    50 => 'Σφάλμα SQL με δήλωση',
    51 => 'Βοήθεια',
    52 => 'Νέο',
    53 => 'Αρχική Σελίδα Διαχειριστή',
    54 => 'Το αρχείο δεν μπορεί να ανοιχτεί',
    55 => 'Σφάλμα σε',
    56 => 'Ψηφίστε',
    57 => 'Κωδικός Πρόσβασης',
    58 => 'Σύνδεση',
    59 => "Αν δεν είστε κάτοχος λογαριασμού, μπορείτε να αποκτήσετε εδώ <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">Νέος Χρήστης</a>",
    60 => 'Καταθέστε σχόλιο',
    61 => 'Δημιουργία νέου λογαριασμού',
    62 => 'λέξεις',
    63 => 'Προτιμήσεις σχολίων',
    64 => 'Στείλτε αυτό το άρ8ρο με ηλεκτρονικό ταχυδρομείο',
    65 => 'Δείτε το κείμενο προς εκτύπωση',
    66 => '',
    67 => 'Καλωσήρθατε στην σελίδα ',
    68 => 'Κεντρική σελίδα',
    69 => 'επικοινωνία',
    70 => 'αναζήτηση',
    71 => 'υποβολή άρθρων',
    72 => 'σύνδεσμοι',
    73 => '',
    74 => '',
    75 => 'σύνθετη έρευνα',
    76 => 'στατιστικά ιστοσελίδας',
    77 => 'εξωτερικά προγράμματα',
    78 => '',
    79 => 'τελευταίες καταχωρήσεις',
    80 => 'άρθρα τις τελευταίες',
    81 => 'άρθρο τις τελευταίες',
    82 => 'ώρες',
    83 => 'ΣΧΟΛΙΑ',
    84 => '',
    85 => 'τελευταίες 48 ώρες',
    86 => 'Κανένα νέο σχόλιο',
    87 => 'τελευταίες 2 εβδομάδες',
    88 => '',
    89 => '',
    90 => 'Κεντρική Σελίδα',
    91 => 'Η σελίδα αυτή δημιουργήθηκε',
    92 => 'δευτερόλεπτα',
    93 => 'Κατοχύρωση πνευματικής ιδιοκτησίας',
    94 => 'Όλα τα εμπορικά σήματα και οι κατοχυρωμένες πνευματικές ιδιοκτησίες ανήκουν στους αντίστοιχους δικαιούχους',
    95 => 'υποστηρίζετε από την τεχνολογία',
    96 => 'Ομάδες',
    97 => 'Λίστα λέξεων',
    98 => 'Εξωτερικά προγράμματα',
    99 => 'ΑΡθΡΑ',
    100 => 'Δεν υπάρχουν νέα Άρθρα',
    101 => '',
    102 => '',
    103 => 'Αντίγραφα της Βάσης δεδομένων',
    104 => 'από',
    105 => 'Χρήστες ηλεκτρονικού ταχυδρομείου',
    106 => 'Προβολές',
    107 => 'Υποβολή σε δοκιμή των Εκδόσεων GL',
    108 => 'Καθαρισμός Cache',
    109 => 'Αναφορά του παρόντος κειμένου ώς καταχρηστικό',
    110 => 'Αναφορά του παρόντος άρθρου στον Διαχειριστή του συστήματος',
    111 => '',
    112 => 'Καταχωρημένοι Χρήστες',
    113 => 'Τεκμηρίωση',
    114 => 'TRACKBACKS',
    115 => 'No new trackback comments',
    116 => 'Trackback',
    117 => 'Directory',
    118 => 'Please continue reading on the next page:',
    119 => "Lost your <a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\" rel=\"nofollow\">password</a>?",
    120 => 'Permanent link to this comment',
    121 => 'Comments (%d)',
    122 => 'Trackbacks (%d)',
    123 => 'All HTML is allowed',
    124 => 'Click to delete all checked items',
    125 => 'Are you sure you want to Delete all checked items?',
    126 => 'Select or de-select all items',
    127 => 'Permalink',
    128 => 'Login with OpenID:',
    129 => 'Configuration',
    130 => 'Webservices'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Στείλτε το σχόλιο σας',
    2 => 'Κατάσταση Αποστολής',
    3 => 'Αποσύνδεση',
    4 => 'Δημιουργία λογαριασμού',
    5 => 'Όνομα Χρήστη',
    6 => 'Η ιστοσελίδα απαιτεί να έχετε συνδεθεί για να αποστείλετε το σχόλιο σας. Αν δεν διαθέτετε λογαριασμό μπορείτε να δημιουργήσετε χρησιμοποιώντας την παρακάτω φόρμα.',
    7 => 'Το τελευταίο σας σχόλιο ήταν ',
    8 => " δευτερόλεπτα πριν. Η ιστοσελίδα απαιτεί τουλάχιστον να περάσουν τουλάχιστον {$_CONF['commentspeedlimit']} δευτερόλεπτα μεταξύ δύο σχολίων",
    9 => 'Σχόλιο',
    10 => 'Αποστολή αναφοράς',
    11 => 'Καταθέστε το σχόλιο σας',
    12 => 'Παρακαλώ συμπληρώστε τα πεδία: Τίτλος και Σχόλια. Είναι αναγκαία για την αποστολή του σχόλιου σας.',
    13 => 'Η πληροφορίες σας',
    14 => 'Προεπισκόπηση',
    15 => 'Report this post',
    16 => 'Τίτλος',
    17 => 'Σφάλμα',
    18 => 'Σημαντικό',
    19 => 'Παρακαλώ προσπαθήστε το σχόλιο σας να μην ξεφεύγει από το θέμα',
    20 => 'Είναι καλύτερο να απαντάται στα ήδη υπάρχοντα θέματα παρά να δημιουργείτε καινούργια',
    21 => 'Προς αποφυγήν επαναλήψεων, διαβάζετε τα σχόλια των άλλων χρηστών προτού καταθέσετε το δικό σας.',
    22 => 'Χρησιμοποιείστε ένα θέμα που διευκρινίζει το περιεχόμενο του μηνύματος σας',
    23 => 'Η ηλεκτρονική σας διεύθυνση θα παραμείνει απόρρητη',
    24 => 'Ανώνυμος χρήστης',
    25 => 'Είστε σίγουρος(η) ότι επιθυμείτε την αναφορά του παρόντος άρθρου στον Διαχειριστή του συστήματος;',
    26 => '%s ανέφερε το ακόλουθο καταχρηστικό σχόλιο:',
    27 => 'Αναφορά Καταχρηστικών Κειμένων',
    28 => 'Preview Changes',
    29 => 'Submit Changes',
    30 => 'Edited on',
    31 => 'by',
    32 => 'Editing a Comment',
    33 => 'Editing a Comment Submission',
    34 => 'Preview Submission Changes',
    35 => 'Save Changes to Queue',
    36 => 'Notify me of new replies',
    37 => 'New Comment Reply',
    38 => 'A reply has been made to your comment \'%s\'.',
    39 => 'You may view the comment thread at the following address:',
    40 => 'If you wish to receive no further notifications of replies, visit the following link:',
    41 => 'Hello %s,',
    42 => 'Unsubscribe',
    43 => 'Unsubscribe from reply notifications',
    44 => 'Your Name'
);

###############################################################################
# users.php

$LANG04 = array(
    1 => 'Προφίλ χρήστη',
    2 => 'Όνομα Χρήστη',
    3 => 'Πλήρες Όνομα',
    4 => 'Κωδικός',
    5 => 'Διεύθυνση ηλεκτρονικού ταχυδρομείου',
    6 => 'Ιστοσελίδα',
    7 => 'Βιογραφικό',
    8 => 'Κλειδί PGP',
    9 => 'Αποθήκευση πληροφοριών',
    10 => 'Τελευταία 10 σχόλια από τον/την',
    11 => 'Δεν υπάρχουν σχόλια από τον/την ',
    12 => 'Προτιμήσεις χρήστη για',
    13 => 'Αποστολή ηλεκτρονικού ταχυδρομείου νυχτερινής ανασκόπησης',
    14 => 'Ο κωδικός αυτός είναι τυχαίος και προσωρινός. Συνιστούμε την άμεση αντικατάσταση του. Συνδεθείτε και επιλέξτε από το μενού την επιλογή Πληροφορίες λογαριασμού.',
    15 => "Ο λογαριασμός σας στην ιστοσελίδα {$_CONF['site_name']} δημιουργήθηκε με επιτυχία. Συνδεθείτε χρησιμοποιώντας τα στοιχεία παρακάτω. Παρακαλούμε κρατήστε αυτό το μήνυμα.",
    16 => 'Πληροφορίες για τον λογαριασμό σας',
    17 => 'Ο Λογαριασμός δεν υπάρχει',
    18 => 'Η διεύθυνση ηλεκτρονικού ταχυδρομείου που υποβάλατε δεν είναι σωστή',
    19 => 'Το όνομα χρήστη ή ο κωδικός πρόσβασης είναι ήδη σε χρήση',
    20 => 'Η διεύθυνση ηλεκτρονικού ταχυδρομείου που υποβάλατε δεν είναι σωστή',
    21 => 'Σφάλμα',
    22 => "Εγγραφή στο {$_CONF['site_name']}!",
    23 => "Με την δημιουργία ενός λογαριασμού χρήστη θα απολαμβάνετε τα προνόμια του εγγεγραμμένου χρήστη στο {$_CONF['site_name']} και θα μπορείτε να καταθέσετε σχόλια. Αν δεν θέλετε να εγγραφτείτε, θα έχετε μόνο την δυνατότητα να καταθέσετε ανώνυμα σχόλια. Η ηλεκτρονική σας διεύθυνση <b><i>δεν πρόκειται</i></b> να δημοσιευτεί ποτέ σε αυτήν την ιστοσελίδα.",
    24 => 'Ο κωδικός σας θα αποσταλεί στην ηλεκτρονική διεύθυνση που μας υποβάλατε.',
    25 => 'Ξεχάσατε τον κωδικό σας;',
    26 => 'Συμπληρώστε το όνομα χρήστη και πατήστε την Αποστολή κωδικού μέσω Ηλεκτρονικού ταχυδρομείου. Ο νέος σας κωδικός θα αποσταλεί άμεσα στην ηλεκτρονική διεύθυνση του λογαριασμού σας.',
    27 => 'Άμεση εγγραφή',
    28 => 'Αποστολή κωδικού με ηλεκτρονικό ταχυδρομείο',
    29 => 'Αποσυνδεθήκατε από',
    30 => 'Συνδεθήκατε από',
    31 => 'Η επιλογή αυτή, απαιτεί την σύνδεση σας',
    32 => 'Υπογραφή',
    33 => 'Χωρίς δημόσια προβολή',
    34 => 'Αυτό είναι το πραγματικό σας όνομα',
    35 => 'Πληκτρολογήστε νέο κωδικό',
    36 => 'Αρχίζει με http://',
    37 => 'Επισυνάπτεται στα σχόλια σας',
    38 => 'Έχει σχέση με εσάς, είναι προσπελάσιμο από όλους τους χρήστες',
    39 => 'Το δημόσιο PGP κλειδί σας',
    40 => 'Δεν υπάρχουν εικονίδια για το θέμα',
    41 => 'Πρόθυμος/η να επιβλέπω',
    42 => 'Διαμόρφωση ημερομηνίας',
    43 => 'Μέγιστος αριθμός άρθρων',
    44 => 'Δεν υπάρχουν κουτιά',
    45 => 'Προβολή προτιμήσεων για τον/την',
    46 => 'Μη συμπεριλαμβανόμενα στοιχεία για τον/την',
    47 => 'Ρύθμιση ομάδας ειδήσεων για τον/την',
    48 => 'Θέματα',
    49 => 'Δεν υπάρχουν εικονίδια για τα Άρθρα',
    50 => 'Αν δεν σας ενδιαφέρει ακυρώστε την επιλογή του',
    51 => 'Μόνο τα Άρθρα ειδήσεων',
    52 => 'Το προεπιλεγμένο είναι',
    53 => 'Λήψη των ημερήσιων άρθρων κάθε βράδυ',
    54 => 'Επιλέξτε τα κουτιά με τα θέματα και τους συγγραφείς που δεν επιθυμείτε να παρακολουθείτε.',
    55 => 'Εφόσον αφήνετε όλα τα κουτιά χωρίς επιλογή, η προεπιλεγμένη επιλογή θα ισχύσει. Στην επιλογή των κουτιών, μην παραλείψετε κάποιο που θέλετε επειδή η προεπιλεγμένες επιλογές θα αγνοηθούν. Οι προεπιλεγμένες επιλογές παρουσιάζονται με έντονο τόνο.',
    56 => 'Συγγραφείς',
    57 => 'Κατάσταση προβολής',
    58 => 'Σειρά ταξινόμησης',
    59 => 'Όριο σχολίων',
    60 => 'Πώς θέλετε να προβάλλονται τα σχόλια;',
    61 => 'Το νεότερο η το παλαιότερο κατά σειρά;',
    62 => 'Η προεπιλογή είναι 100',
    63 => "Ο Κωδικός πρόσβασης για τον λογαριασμό σας έχει ήδη αποσταλεί. Παρακαλώ ακολουθήστε τις οδηγίες που συμπεριλαμβάνονται στο μήνυμα και σας ευχαριστούμε που χρησιμοποιείτε {$_CONF['site_name']}",
    64 => 'Προτιμήσεις σχολίων για',
    65 => 'Παρακαλώ προσπαθήστε να συνδεθείτε ξανά',
    66 => "Πιθανόν να πληκτρολογήσατε λανθασμένα τα στοιχεία του λογαριασμού σας. Παρακαλώ προσπαθήστε ξανά παρακάτω. Είστε <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">νέος χρήστης</a>;",
    67 => 'Μέλος από',
    68 => 'Παραμονή στο σύστημα για',
    69 => 'Η χρονική διάρκεια που το σύστημα θα θεωρεί ενεργή την παραμονή σας μετά από την σύνδεση σας',
    70 => "Επιλέξτε τη δική σας διάταξη κειμένου και περιεχομένου για την ιστοσελίδα {$_CONF['site_name']}",
    71 => "Ένα από τα χαρακτηριστικά του {$_CONF['site_name']} είναι η δυνατότητα των χρηστών να διαμορφώνουν κατά βούληση το περιεχόμενο και το παρουσιαστικό της ιστοσελίδας. Για να επωφεληθείτε από αυτές τις δυνατότητες πρέπει πρώτα να <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">εγγραφείτε</a> στο {$_CONF['site_name']}.  Αν είστε ήδη μέλος, μπορείτε να πληκτρολογήσετε τα στοιχεία σας στην φόρμα αριστερά",
    72 => 'Θέμα',
    73 => 'Γλώσσα',
    74 => 'Αλλάξτε την εμφάνιση της ιστοσελίδας',
    75 => 'Τα αποστελλόμενα με ηλεκτρονικό ταχυδρομείο θέματα για τον/την',
    76 => 'Αν επιλέξετε ένα θέμα από τα παρακάτω, θα λαμβάνετε και τα νέα Άρθρα που δημοσιεύτηκαν στο θέμα αυτό με το τέλος της κάθε ημέρας. Διαλέξτε μόνο τα θέματα που σας ενδιαφέρουν!',
    77 => 'Φωτογραφία',
    78 => 'Προσθέστε την φωτογραφία σας',
    79 => 'Πατήστε εδώ για την διαγραφή της φωτογραφίας σας',
    80 => 'Σύνδεση',
    81 => 'Αποστολή ηλεκτρονικού ταχυδρομείου',
    82 => 'Τελευταία 10 Άρθρα από τον/την χρήστη',
    83 => 'Στατιστικά συγγραφής από τον χρήστη',
    84 => 'Αριθμός άρθρων:',
    85 => 'Αριθμός σχολίων:',
    86 => 'Αναζητήστε όλα τα σχετικά θέματα με',
    87 => 'Το όνομα του λογαριασμού σας',
    88 => "Κάποιος, (πιθανόν εσείς), ζήτησε την δημιουργία ενός νέου κωδικού για τον λογαριασμό χρήστη \"%s\" στην ιστοσελίδα {$_CONF['site_name']}, <{$_CONF['site_url']}>.\n\n Αν πραγματικά επιθυμείτε την αλλαγή του κωδικού πρόσβασης επιλέξτε τον ακόλουθο σύνδεσμο:\n\n",
    89 => "Εάν δεν επιθυμείτε την αλλαγή του κωδικού αγνοήστε το παρόν ηλεκτρονικό μήνυμα και η αίτηση αλλαγής του κωδικού θα απορριφθεί (ο κωδικός πρόσβασης για τον λογαριασμό σας θα παραμείνει ο ίδιος).\n\n",
    90 => 'Μπορείτε να εισάγετε τον νέο κωδικό για τον λογαριασμό σας παρακάτω. Σας επισημαίνεται ότι ο παλαιός κωδικός σας θα είναι ενεργός μέχρι την αποστολή της φόρμας.',
    91 => 'Αντικατάσταση Κωδικού Πρόσβασης',
    92 => 'Εισάγετε τον νεό κωδικό',
    93 => 'Η τελευταία αίτηση σας για αλλαγή κωδικού πραγματοποιήθηκε πρίν %d δευτερόλεπτα. Στην παρούσα ιστοσελίδα πρέπει να περιμένετε τουλάχιστον %d δευτερόλεπτα μεταξύ δύο αιτήσεων για αλλαγή κωδικού.',
    94 => 'Διαγραφή λογαριασμού "%s"',
    95 => 'Επιλέξτε την "Διαφραφή λογαριασμού" παρακάτω για να αφαιρέσετε τον λογαριασμό σας απο την βάση δεδομένων. Τυχόν ιστορίες και σχόλια του λογαριασμού σας <strong>ΔΕΝ</strong> θα αφαιρεθούν αλλά ο αποστολέας τους θα αντικαταστάθει απο τον χρήστη "Anonymous".',
    96 => 'Διαφραφή Λογαριασμού',
    97 => 'Επιβεβαίωση διαγραφής λογαριασμού',
    98 => 'Είστε σίγουρος(η) οτι επιθυμείτε την διαγραφή του λογαριασμού σας; Αν συνεχίσετε θα χάσετε την δυνατότητα εισόδου στην παρούσα ιστοσελίδα με την ταυτότητας σας. Αν είστε σίγουρος(η) επιλέξτε την "Διαγραφή Λογαριασμού" ξανά στην παρακάτω φόρμα.',
    99 => 'Επιλογές Ιδιωτικών Ρυθμίσεων',
    100 => 'Ηλεκτρονικά μήνυματα απο τον Διαχειριστή',
    101 => 'Αποδοχή Ηλεκτρονικών μηνυμάτων απο τους Διαχειριστές',
    102 => 'Αποδοχή Ηλεκτρονικών μηνυμάτων απο χρήστες',
    103 => 'Αποδοχή Ηλεκτρονικών μηνυμάτων απο λοιπούς',
    104 => 'Εμφάνιση Ενεργής Κατάστασης του Χρήστη',
    105 => 'Εμφάνιση στο τμήμα του "Ποιοί είναι Ενεργοί στην Ιστοσελίδα',
    106 => 'Τοποθεσία',
    107 => 'Εμφάνιση στο δημόσιο προφίλ σας',
    108 => 'Confirm new password',
    109 => 'Enter the New password again here',
    110 => 'Current Password',
    111 => 'Please enter your Current password',
    112 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    113 => 'Login Attempt Failed',
    114 => 'Account Disabled',
    115 => 'Your account has been disabled, you may not login. Please contact an Administrator.',
    116 => 'Account Awaiting Activation',
    117 => 'Your account is currently awaiting activation by an administrator. You will not be able to login until your account has been approved.',
    118 => "Your {$_CONF['site_name']} account has now been activated by an administrator. You may now login to the site at the url below using your username (<username>) and password as previously emailed to you.",
    119 => 'If you have forgotten your password, you may request a new one at this url:',
    120 => 'Account Activated',
    121 => 'Service',
    122 => 'Sorry, new user registration is disabled',
    123 => "Are you a <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\">new user</a>?",
    124 => 'Confirm Email',
    125 => 'You have to enter the same email address in both fields!',
    126 => 'Please repeat for confirmation',
    127 => 'To change any of these settings, you will have to enter your current password.',
    128 => 'Your Name',
    129 => 'Password &amp; Email',
    130 => 'About You',
    131 => 'Daily Digest Options',
    132 => 'Daily Digest Feature',
    133 => 'Comment Display',
    134 => 'Comment Options',
    135 => '<li>Default mode for how comments will be displayed</li><li>Default order to display comments</li><li>Set maximum number of comments to show - default is 100</li>',
    136 => 'Exclude Topics and Authors',
    137 => 'Filter Story Content',
    138 => 'Misc Settings',
    139 => 'Layout and Language',
    140 => '<li>No Topic Icons if checked will not display the story topic icons</li><li>No boxes if checked will only show the Admin Menu, User Menu and Topics</li><li>Set the maximum number of stories to show per page</li><li>Set your theme, timezone and preferred date format</li>',
    141 => 'Privacy Settings',
    142 => 'The default setting is to allow users & admins to email fellow site members and show your status as online. Un-check these options to protect your privacy.',
    143 => 'Filter Block Content',
    144 => 'Show & hide boxes',
    145 => 'Your Public Profile',
    146 => 'Password and email',
    147 => 'Edit your account password, email and autologin feature. You will need to enter the same password or email address twice as a confirmation.',
    148 => 'User Information',
    149 => 'Modify your user information that will be shown to other users.<li>The signature will be added to any comments or forum posts you made</li><li>The BIO is a brief summary of yourself to share</li><li>Share your PGP Key</li>',
    150 => 'Warning: Javascript recommended for enhanced functionality',
    156 => 'Delete Account',
    157 => 'Delete Option',
    158 => 'Time Zone',
    159 => 'This email was generated automatically. Please do not reply to this email.',
    160 => '(max. %d x %d pixels, %d bytes; %s)',
    161 => 'will be scaled down',
    162 => 'will not be scaled',
    163 => 'Re-Authentication Failed',
    164 => 'You have exceeded the number of allowed attempts for re-authentication. The operation has been aborted and your recent changes were lost, sorry.',
    165 => 'Use Advanced Editor'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Preview',
    'pe_namepass' => 'Username &amp; Password',
    'pe_userinfo' => 'About You',
    'pe_layout' => 'Layout &amp; Language',
    'pe_content' => 'Content',
    'pe_privacy' => 'Privacy'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Δεν υπάρχουν νέα',
    2 => 'Δεν υπάρχουν νέα άρθρα. Δεν υπάρχουν νέα για αυτό το θέμα ή οι ρυθμίσεις σας είναι πολύ αυστηρές.',
    3 => ' για το θέμα %s',
    4 => 'Ενδιαφέρον άρθρο',
    5 => 'Επόμενο',
    6 => 'Προηγούμενο',
    7 => 'Πρώτο',
    8 => 'Τελευταίο'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'Σφάλμα στην αποστολή του μηνύματος, παρακαλώ προσπαθήστε ξανά.',
    2 => 'Το μήνυμα στάλθηκε με επιτυχία.',
    3 => 'Παρακαλώ, βεβαιωθείτε ότι έχετε πληκτρολογήσει μία ενεργή διεύθυνση ταχυδρομείου στο πεδίο Απάντηση.',
    4 => 'Παρακαλώ, πληκτρολογήστε τα πεδία Όνομα, Απάντηση στην διεύθυνση, θέμα και μήνυμα.',
    5 => 'Σφάλμα: Δεν υπάρχει ο χρήστης.',
    6 => 'Υπήρξε σφάλμα.',
    7 => 'Προφίλ χρήστη για',
    8 => 'Όνομα χρήστη',
    9 => 'URL χρήστη',
    10 => 'Αποστολή ηλεκτρονικής αλληλογραφίας στον/στην',
    11 => 'Όνομα:',
    12 => 'Απάντηση στην διεύθυνση:',
    13 => 'Θέμα:',
    14 => 'Μήνυμα:',
    15 => 'Η γλώσσα HTML θα μεταφραστεί.',
    16 => 'Αποστολή μηνύματος',
    17 => 'Αποστείλετε το άρθρο με ηλεκτρονικό ταχυδρομείο σε έναν φίλο/φίλη',
    18 => 'Όνομα παραλήπτη',
    19 => 'Ηλεκτρονική διεύθυνση παραλήπτη',
    20 => 'Όνομα αποστολέα',
    21 => 'Ηλεκτρονική διεύθυνση αποστολέα',
    22 => 'Απαιτούνται όλοι οι φίλοι',
    23 => "Το παρόν μήνυμα στάλθηκε σε εσάς από τον/την %s με ηλεκτρονική διεύθυνση %s επειδή θεώρησε ότι θα σας ενδιέφερε το άρθρο που βρίσκετε στην ιστοσελίδα {$_CONF['site_url']}. Το παρόν μήνυμα δεν είναι διαφημιστικό, και η διεύθυνση του ηλεκτρονικού ταχυδρομείου σας δεν αποθηκεύτηκε από το σύστημά μας.",
    24 => 'Σχόλιο του άρθρου αυτού στο',
    25 => 'Πρέπει να συνδεθείτε για να χρησιμοποιήσετε αυτήν την υπηρεσία. Έτσι μας βοηθάτε να αποφύγουμε την κακή χρήση του συστήματος',
    26 => 'Η παρούσα φόρμα θα σας επιτρέψει να στείλετε ένα μήνυμα ηλεκτρονικού ταχυδρομείου στον επιλεγμένο χρήστη. Όλα τα πεδία είναι αναγκαία.',
    27 => 'Σύντομο μήνυμα',
    28 => 'Ο %s έγραψε: ',
    29 => "Η παρούσα καθημερινή ανασκόπηση από το {$_CONF['site_name']} για ",
    30 => 'Καθημερινή ειδησιογραφία από ',
    31 => 'Τίτλος',
    32 => 'Ημερομηνία',
    33 => 'Διαβάστε το πλήρες άρθρο',
    34 => 'Τέλος μηνύματος',
    35 => 'Λυπούμαστε, ο χρήστης έχει απενεργοποιήσει την λήψη ηλεκτρονικών μηνυμάτων.',
    36 => 'Copy:',
    37 => 'Send me a copy of this email',
    38 => "This is a copy of the email that you sent to %s from <{$_CONF['site_url']}>:",
    39 => 'Your last message was ',
    40 => " seconds ago.  This site requires at least {$_CONF['speedlimit']} seconds between sending messages"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Σύνθετη έρευνα',
    2 => 'Λέξεις κλειδιά',
    3 => 'Θέμα',
    4 => 'Όλα',
    5 => 'Τύπος',
    6 => 'Άρθρα',
    7 => 'Σχόλια',
    8 => 'Συγγραφείς',
    9 => 'Όλα',
    10 => 'Έρευνα',
    11 => 'Αποτελέσματα έρευνας',
    12 => 'Αποτελέσματα',
    13 => 'Αποτελέσματα έρευνας: Δεν βρέθηκαν αποτελέσματα',
    14 => 'Δεν υπάρχουν αποτελέσματα που να ταιριάζουν σε ',
    15 => 'Παρακαλώ, προσπαθήστε ξανά.',
    16 => 'Τίτλος',
    17 => 'Ημερομηνία',
    18 => 'Συγγραφέας',
    19 => "Αναζήτηση στην βάση πρόσφατων και παλαιών ιστοριών του {$_CONF['site_name']}",
    20 => 'Ημερομηνία',
    21 => 'Προς',
    22 => '(Διαμόρφωση ημερομηνίας ΧΧΧΧ-ΜΜ-ΜΜ)',
    23 => 'Επισκέψεις',
    24 => 'Βρέθηκε',
    25 => 'Αποτελέσματα για',
    26 => 'στοιχείο σε',
    27 => 'δευτερόλεπτα',
    28 => 'Τα κριτήρια της έρευνας που θέσατε δεν ικανοποιούνται από κανένα άρθρο ή σχόλιο.',
    29 => 'Αποτελέσματα άρθρων και σχολίων',
    30 => '',
    31 => 'Τα κριτήρια της έρευνας που θέσατε δεν ικανοποιούνται από κανένα εξωτερικά προγράμματα. ',
    32 => '',
    33 => 'URL',
    34 => 'Περιοχή',
    35 => 'Συνεχώς',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Η αναζήτηση σας πρέπει να περιέχει τουλάχιστον τρείς(3) χαρακτήρες.',
    42 => 'Παρακαλούμαι, εισάγετε την ημερομηνία σαν YYYY-MM-DD (Έτος-Μήνας-Μέρα).',
    43 => 'ακριβής φράση',
    44 => 'όλες τις λέξεις',
    45 => 'οποιαδήποτε απο τις λέξεις',
    46 => 'Επόμενο',
    47 => 'Προηγούμενο',
    48 => 'Συγγραφέας',
    49 => 'Ημερομηνία',
    50 => 'Επισκέψεις',
    51 => '',
    52 => 'Τοποθεσία',
    53 => 'Αποτελέσματα άρθρων',
    54 => 'Αποτελέσματα σχολίων',
    55 => 'η φράση',
    56 => 'ΚΑΙ',
    57 => 'Ή',
    58 => 'More results &gt;&gt;',
    59 => 'Results',
    60 => 'per page',
    61 => 'Refine search',
    62 => '#',
    63 => 'Description',
    64 => 'Showing %1$d - %2$d of %3$d results',
    65 => 'Story',
    66 => 'Comment',
    67 => 'Show %d Results',
    68 => 'Sort By',
    69 => 'Titles Only',
    70 => 'Not available ...',
    71 => 'asc',
    72 => 'desc'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Στατιστικά ιστοσελίδας',
    2 => 'Συνολικές επισκέψεις στο σύστημα',
    3 => 'Άρθρα(Σχόλια) στο σύστημα',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Τα 10 περισσότερο δημοφιλή Άρθρα.',
    8 => 'Τίτλος Άρθρου',
    9 => 'Επισκέψεις',
    10 => 'Δεν υπάρχουν Άρθρα σε αυτή την ιστοσελίδα ή κανείς δεν τα έχει επισκεφτεί.',
    11 => 'Τα 10 περισσότερο σχολιασμένα Άρθρα',
    12 => 'Σχόλια',
    13 => 'Δεν υπάρχουν Άρθρα σε αυτή την ιστοσελίδα ή κανείς δεν έχει καταθέσει σχόλια.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'Τα 10 Άρθρα που προωθήθηκαν περισσότερο με το ηλεκτρονικό ταχυδρομείο',
    23 => 'Ηλεκτρονική αλληλογραφία',
    24 => 'Δεν έχουν σταλεί άρθρα μέσω ηλεκτρονικού ταχυδρομείου από αυτήν την ιστοσελίδα.',
    25 => 'Top Ten Trackback Commented Stories',
    26 => 'No trackback comments found.',
    27 => 'Number of active users',
    28 => '',
    29 => '',
    30 => 'Hits',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Τι είναι σχετικό;',
    2 => 'Στείλτε το άρθρο σε έναν φίλο/φίλη μέσω ηλεκτρονικού ταχυδρομίου',
    3 => 'Διαμόρφωση άρθρου για εκτύπωση',
    4 => 'Μενού επιλογών άρθρου',
    5 => '',
    6 => 'Subscribe to \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'Για να αποστείλετε %s πρέπει πρώτα να έχετε συνδεθεί.',
    2 => 'Σύνδεση',
    3 => 'Νέος χρήστης',
    4 => '',
    5 => '',
    6 => 'Στείλτε ένα άρθρο',
    7 => 'Η σύνδεση είναι απαραίτητη',
    8 => 'Αποστολή',
    9 => 'Όταν αποστέλλετε πληροφορίες για χρήση στην ιστοσελίδα, προτείνουμε να ακολουθήσετε αυτούς τους κανόνες... <ul><li>Συμπληρώστε όλα τα πεδία, τίποτα δεν είναι προαιρετικό<li>Δώστε πλήρη και ακριβή στοιχεία<li>Επιβεβαιώστε τους συνδέσμους URL</ul>',
    10 => 'Τίτλος',
    11 => '',
    12 => 'Ημερομηνία έναρξης',
    13 => 'Ημερομηνία λήξης',
    14 => 'Περιοχή',
    15 => 'Περιγραφή',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Διαβάστε πρώτα',
    20 => '',
    21 => '',
    22 => 'Σφάλμα: Πεδία μη διαθέσιμα',
    23 => 'Παρακαλώ συμπληρώστε όλα τα πεδία της φόρμας. Κανένα δεν είναι προαιρετικό.',
    24 => 'Η αποστολή αποθηκεύτηκε ',
    25 => 'Η αποστολή σας (%s) αποθηκεύτηκε επιτυχώς',
    26 => 'Όριο ταχύτητας',
    27 => 'Όνομα χρήστη',
    28 => 'Θέμα',
    29 => 'Άρθρο',
    30 => 'Η τελευταία σας αποστολή έγινε ',
    31 => " δευτερόλεπτα πριν.  Περιμένετε τουλάχιστον {$_CONF['speedlimit']} δευτερόλεπτα για άλλη αποστολή",
    32 => 'Προεπισκόπηση',
    33 => 'Προεπισκόπηση Άρθρου',
    34 => 'Αποσύνδεση',
    35 => 'Η γλώσσα HTML ΔΕΝ επιτρέπεται',
    36 => 'Κατάσταση αποστολής',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Διεύθυνση γραμμή 1',
    45 => 'Διεύθυνση γραμμή 2',
    46 => 'Πόλη / Κοινότητα',
    47 => 'Πολιτεία (Για Ηνωμένες Πολιτείες μόνο)',
    48 => 'Ταχυδρομικός κωδικός',
    49 => '',
    50 => '',
    51 => 'Περιοχή',
    52 => 'Διαγραφή',
    53 => 'Δημιουργία λογαριασμού',
    54 => 'Story Introduction',
    55 => 'Story Body'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Η πιστοποίηση είναι αναγκαία',
    2 => 'Το αίτημα πρόσβασης απορρίφθηκε, τα στοιχεία πρόσβασης δέν ειναι σωστά',
    3 => 'Λάθος κωδικός πρόσβασης χρήστη',
    4 => 'Όνομα χρήστη:',
    5 => 'Κωδικός πρόσβασης:',
    6 => 'Η πρόσβαση σε επίπεδο διαχειριστή για αυτήν την ιστοσελίδα είναι ελεγχόμενη και καταγραφόμενη. <br' . XHTML . '> Η παρούσα ιστοσελίδα είναι για χρήση πιστοποιημένου προσωπικού',
    7 => 'σύνδεση'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Ανεπαρκή δικαιώματα διαχειριστή ',
    2 => 'Δεν διαθέτετε τα απαραίτητα δικαιώματα διαχειριστή για να επεξεργαστείτε αυτήν την ομάδα',
    3 => 'Επεξεργαστής διαζωμάτων ',
    4 => 'Υπήρξε κάποιο πρόβλημα κατα την ανάγνωση των δεδομένων (δείτε το αρχείο error.log για λεπτομέριες).',
    5 => '',
    6 => '',
    7 => 'Όλα',
    8 => 'Επίπεδο ασφαλείας ομάδας ',
    9 => 'Σειρά ομάδας ',
    10 => '',
    11 => 'Ομάδα πύλης',
    12 => 'Κανονική ομάδα',
    13 => 'Επιλογές ομάδας πύλης ',
    14 => 'RDF URL',
    15 => 'Τελευταία αναβάθμιση RDF',
    16 => 'Επιλογές κανονικής ομάδας',
    17 => 'Περιεχόμενο ομάδας',
    18 => 'Παρακαλώ, συμπληρώστε τα πεδία Τίτλος, επίπεδο ασφαλείας και περιεχόμενο',
    19 => 'Διαχειριστής ομάδας ',
    20 => '',
    21 => 'Επίπεδο ασφαλείας ομάδας',
    22 => '',
    23 => 'Σειρά ομάδας',
    24 => '',
    25 => 'Για να μετατρέψετε η να διαγράψετε μία ομάδα, επιλέξτε την ομάδα οπό τις παρακάτω. Για να δημιουργήσετε μία ομάδα επιλέξτε την επιλογή Νέα ομάδα ',
    26 => 'Διάταξη ομάδας',
    27 => 'Ομάδα PHP',
    28 => 'Επιλογές Ομάδας PHP',
    29 => 'Λειτουργίες ομάδας ',
    30 => 'Αν επιθυμείτε κάποια από τις ομάδες να συμπεριλαμβάνει κώδικα στην γλώσσα PHP, εισάγετε το όνομα της ρουτίνας στο παραπάνω κουτί. Η ρουτίνα σας πρέπει να αρχίζει με το πρόθεμα "phpblock " ( για παράδειγμα phpblock_getweather). Εάν το πρόθεμα αυτό παραλειφθεί, η ρουτίνα σας δεν θα εκτελεστεί. Προτείνετε να τοποθετήσετε τον κωδικά σας στον ακόλουθο κατάλογο /διαδρομή/για/το/geeklog/system/lib-custom.php.',
    31 => 'Σφάλμα στην ομάδα PHP.  Η ρουτίνα %s, είναι ανύπαρκτη.',
    32 => 'Σφάλμα, λείπουν πεδίο(α)',
    33 => 'Πρέπει να πληκτρολογήσετε το URL για το .rdf αρχείο των ομάδων πύλης ',
    34 => ' Πρέπει να πληκτρολογήσετε τον τίτλο και την ρουτίνα για την ομάδα PHP.',
    35 => ' Πρέπει να πληκτρολογήσετε τον τίτλο και το περιεχόμενο για τα την κανονική ομάδα ',
    36 => ' Πρέπει να πληκτρολογήσετε το περιεχόμενο για την διάταξη της ομάδας',
    37 => 'Το όνομα της ομάδας PHP είναι λάθος',
    38 => 'Οι ρουτίνες για τις ομάδες PHP πρέπει να έχουν το πρόθεμα \'phpblock_\' (για παράδειγμα phpblock_getweather). Λόγοι ασφαλείας απαιτούν να το τηρήσετε.',
    39 => 'Διάταξη',
    40 => 'Αριστερά',
    41 => 'Δεξιά',
    42 => 'Πρέπει να ορίσετε την σειρά και το επίπεδο ασφαλείας για τις κοινές ομάδες του GeekLog',
    43 => 'Αρχική σελίδα μόνο',
    44 => '',
    45 => "Τα δικαιώματα σας δεν αρκούν για να προσπελάσετε αυτήν την ομάδα\nΗ απόπειρα έχει καταχωρηθεί. Παρακαλώ, <a ref=\"{$_CONF['site_admin_url']}/block.php\"> πηγαίνετε πίσω στην σελίδα διαχείρησης</a>.",
    46 => 'Νέα ομάδα',
    47 => '',
    48 => 'Όνομα ομάδας',
    49 => ' (χωρίς κενά and το όνομα πρέπει να είναι μοναδικό)',
    50 => 'The Block Name can not be empty',
    51 => 'συμπεριλαμβανόμενο http://',
    52 => 'Αν αφήσετε αυτό εδώ κενό, δεν θα εμφανιστεί εικονίδιο βοηθείας για αυτήν την ομάδα. ',
    53 => 'Ενεργό',
    54 => 'αποθήκευση',
    55 => 'ακύρωση',
    56 => 'διαγραφή',
    57 => 'Μετάθεση ομάδας προς τα κάτω',
    58 => 'Μετάθεση ομάδας προς τα πάνω',
    59 => 'Μετάθεση ομάδας προς τα δεξιά',
    60 => 'Μετάθεση ομάδας προς τα αριστερά',
    61 => 'No Title',
    62 => 'Article Limit',
    63 => 'Bad Block Title',
    64 => 'Your Title must not be empty and cannot contain HTML!',
    65 => 'Order',
    66 => 'Autotags',
    67 => 'Check to allow autotags',
    68 => 'The feed for this portal block is too long to display. Please set a maximum number of articles to import for the block in the block setup screen, or a global maximum in Geeklog Configuration.'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => 'Παλαιότερα Άρθρα',
    2 => 'Επόμενα Άρθρα',
    3 => 'Κατάσταση',
    4 => 'Κατάσταση Αποστολής ',
    5 => 'Επεξεργαστής Άρθρων',
    6 => 'Δεν υπάρχουν Άρθρα στο σύστημα',
    7 => 'Συγγραφέας',
    8 => 'αποθήκευση',
    9 => 'προεπισκόπηση',
    10 => 'ακύρωση',
    11 => 'διαγραφή',
    12 => 'Α/Α',
    13 => '',
    14 => '',
    15 => 'Ημερομηνία',
    16 => 'Κείμενο εισαγωγής',
    17 => 'Κυρίως κείμενο',
    18 => 'Επισκέψεις',
    19 => 'Σχόλια',
    20 => 'Ping',
    21 => 'Send Ping',
    22 => 'Λίστα άρθρων',
    23 => 'Για να μετατρέψετε η να διαγράψετε ένα άρθρο διαλέξτε το απο την παρακάτω λίστα. Για να δημιουργήσετε ένα άρθρο διαλέξτε την επιλογή Νέο άρθρο παραπάνω',
    24 => 'Ο α/α που επελέξατε για το άρθρο χρησιμοποιείται ήδη. Παρακαλώ, διαλέξτε ένα άλλο α/α.',
    25 => 'Error when saving story',
    26 => 'Προεπισκόπηση άρθρου',
    27 => 'If you use [unscaledX] instead of [imageX], the image will be inserted at its original dimensions.',
    28 => '<p><b>PREVIEWING</b>: Previewing a story with images attached is best done by saving the article as a draft INSTEAD OF hitting the preview button.  Use the preview button only when images are not attached.',
    29 => 'Trackbacks',
    30 => 'Η σύνηψη αρχείων έγινε με σφάλματα',
    31 => 'Τα πεδία Συγγραφέας, Τίτλος και Κείμενο εισαγωγής είναι αναγκαία. ',
    32 => 'Ενδιαφέρον',
    33 => 'Ένα κείμενο μπορεί να είναι ενδιαφέρον κάθε φορά.',
    34 => 'Πρόχειρο',
    35 => 'Ναι',
    36 => 'Όχι',
    37 => 'Περισσότερα άρθρα από τον/την',
    38 => 'Περισσότερα άρθρα του',
    39 => 'Ηλεκτρονικές διευθύνσεις',
    40 => '',
    41 => "Τα δικαιώματα σας δεν αρκούν για να προσπελάσετε αυτό το άρθρο. Η απόπειρα έχει καταχωρηθεί. Παρακαλώ, <a ref=\"{$_CONF['site_admin_url']}/story.php\"> πηγαίνετε πίσω στην σελίδα διαχείρισης</a>.",
    42 => "Τα δικαιώματα σας δεν αρκούν για να προσπελάσετε αυτό το άρθρο. Η απόπειρα έχει καταχωρηθεί. Παρακαλώ, <a ref=\"{$_CONF['site_admin_url']}/story.php\"> πηγαίνετε πίσω στην σελίδα διαχείρισης</a>.",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>ΣΗΜΕΙΩΣΗ:</b> Εάν θέσετε μία ημερομηνία στο μέλλον, το παρόν άρθρο θα δημοσιευτεί την ημερομηνία που έχετε ορίσει. Το άρθρο δεν συμπεριλαμβάνετε στις επικεφαλίδες RDF καθώς και θα αγνοείτε στην αναζήτηση και στην έκδοση στατιστικών',
    47 => 'Εικόνες',
    48 => 'Εικόνα',
    49 => 'Δεξιά',
    50 => 'Αριστερά',
    51 => 'Για να προσθέσετε σε αυτό το άρθρο μία οπό τις εικόνες που επισυνάπτετε χρειάζεται να προσθέσετε ειδικά διαμορφωμένο κείμενο. Το ειδικά διαμορφωμένο κείμενο είναι [imageX], [imageX_right] or [imageX_left] όπου Χ είναι ο αριθμός της επισυναπτόμενης εικόνας. ΣΗΜΕΙΩΣΗ: Πρέπει να χρησιμοποιήσετε τις εικόνες που επισυνάψατε. Αν δεν το κάνετε, δεν θα μπορέσετε να αποθηκεύσετε το άρθρο σας. <BR><P><B>Προεπισκόπηση</B>: Η προεπισκόπηση ενός άρθρου με επισυνημμένες εικόνες γίνετε καλύτερα όταν έχετε προσωρινά αποθηκεύσει το άρθρο σας σαν πρόχειρο και όχι όταν επιλέξετε την επιλογή προεπισκόπηση. Η επιλογή προεπισκόπηση χρησιμοποιείτε μόνο όταν ΔΕΝ υπάρχουν επισυνημμένες εικόνες',
    52 => '',
    53 => 'Δεν χρησιμοποιείτε.  Πρέπει να συμπεριλάβετε την εικόνα στην εισαγωγή η το κυρίως κείμενο πριν αποθηκεύσετε τις αλλαγές σας.',
    54 => 'Οι επισυνημμένες εικόνες δεν χρησιμοποιούνται',
    55 => 'Τα ακόλουθα σφάλματα έγιναν στην προσπάθεια να αποθηκευτεί το άρθρο σας. Διορθώστε τα και ξαναπροσπαθήσετε.',
    56 => 'Προβολή εικονιδίου θέματος',
    57 => 'Προβολή εικόνας άνευ κλίμακας',
    58 => 'Διαχείριση Άρθρων',
    59 => 'Επιλογή',
    60 => '',
    61 => 'Αυτόματη αρχειοθέτηση',
    62 => 'Αυτόματη διαγραφή',
    63 => 'Disable Comments',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Expand the Content Edit Area size',
    68 => 'Reduce the Content Edit Area size',
    69 => 'Publish Story Date',
    70 => 'Toolbar Selection',
    71 => 'Basic Toolbar',
    72 => 'Common Toolbar',
    73 => 'Advanced Toolbar',
    74 => 'Advanced II Toolbar',
    75 => 'Full Featured',
    76 => 'Publish Options',
    77 => 'Javascript needs to be enabled for Advanced Editor. Option can be disabled in the main site config.php',
    78 => 'Click <a href="%s/story.php?mode=edit&amp;sid=%s&amp;editopt=default">here</a> to use default editor',
    79 => 'Preview',
    80 => 'Editor',
    81 => 'Publish Options',
    82 => 'Images',
    83 => 'Archive Options',
    84 => 'Permissions',
    85 => 'Show All',
    86 => 'Advanced Editor',
    87 => 'Story Stats',
    88 => 'Wiki-style format',
    89 => 'Meta Description',
    90 => 'Meta Keywords',
    91 => 'You can always hit "Preview" to extend the expiry time.'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Επεξεργαστής θέματος',
    2 => 'α/α θέματος',
    3 => 'Όνομα θέματος',
    4 => 'Εικόνα θέματος',
    5 => '(μην πληκτρολογείτε κενά)',
    6 => 'Η διαγραφή ενός θέματος διαγράφει και όλες τις Άρθρα και ομάδες που σχετίζονται με αυτό. ',
    7 => 'Τα πεδία α/α and Όνομα θέματος πρέπει να συμπληρωθούν',
    8 => 'Διαχειριστής θέματος',
    9 => 'Για να μετατρέψετε η να διαγράψετε ένα θέμα διαλέξτε το από την παρακάτω λίστα. Για να δημιουργήσετε ένα θέμα διαλέξτε την επιλογή Νέο θέμα παραπάνω',
    10 => 'Σειρά ταξινόμησης',
    11 => 'Άρθρα/Σελίδα',
    12 => 'Η πρόσβαση απορρίφθηκε',
    13 => "Τα δικαιώματα σας δεν αρκούν για να προσπελάσετε αυτό το θέμα. Η απόπειρα έχει καταχωρηθεί. Παρακαλώ, <a ref=\"{$_CONF['site_admin_url']}/topic.php\"> πηγαίνετε πίσω στην σελίδα διαχείρισης</a>.",
    14 => 'Τύπος ταξινόμησης',
    15 => 'Αλφαβητικός',
    16 => 'η προεπιλογή είναι',
    17 => 'Νέο θέμα',
    18 => 'Σελίδα διαχείρισης',
    19 => 'αποθήκευση',
    20 => 'ακύρωση',
    21 => 'διαγραφή',
    22 => 'Προεπιλογή',
    23 => 'επιλογή προεπιλεγμένης κατηγορίας για την δημιουργία νέων άρθρων',
    24 => '(*)',
    25 => 'Αρχειοθέτηση Κατηγορίας',
    26 => 'επιλογή προεπιλεγμένης κατηγορίας για τα αρχειοθετημένα άρθρα.',
    27 => 'Or Upload Topic Icon',
    28 => 'Maximum',
    29 => 'File Upload Errors',
    30 => 'Stories in Topic'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'Επεξεργαστής χρηστών',
    2 => 'Ταυτότητα χρήστη',
    3 => 'Όνομα χρήστη',
    4 => 'Πλήρες όνομα',
    5 => 'Κωδικός πρόσβασης',
    6 => 'Επίπεδο ασφαλείας',
    7 => 'Ηλεκτρονική διεύθυνση',
    8 => 'Ιστοσελίδα',
    9 => '(μη πληκτρολογείτε κενά)',
    10 => 'Τα πεδία Όνομα χρήστη, Πλήρες όνομα, επίπεδο ασφαλείας και Ηλεκτρονική διεύθυνση είναι υποχρεωτικά',
    11 => 'Διαχειριστής χρηστών',
    12 => ' Για να μετατρέψετε η να διαγράψετε έναν χρήστη διαλέξτε τον από την παρακάτω λίστα. Για να δημιουργήσετε έναν χρήστη επιλέξτε Νέος χρήστης από το μενού αριστερά.  Μπορείτε να αναζητήσετε ένα μέρος από ονόματα χρηστών, ηλεκτρονικών διευθύνσεων ή τα πλήρη τους ονόματα ( για παράδειγμα *υιός* ή *.gr) στην φόρμα παρακάτω ',
    13 => 'Επίπεδο ασφαλείας',
    14 => 'Ημερομηνία εγγραφής.',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'αποθήκευση',
    21 => 'Το όνομα χρήστη υπάρχει ήδη',
    22 => 'Σφάλμα',
    23 => 'Πρόσθεση συνόλου',
    24 => 'Εισαγωγή συνόλου χρηστών',
    25 => "Υπάρχει η δυνατότητα να προσθέσετε χρήστες στο Geeklog. Το αρχείο εισαγωγής χρηστών πρέπει να είναι διαμορφωμένο ακολούθως: πλήρες όνομα, όνομα χρήστη, ηλεκτρονική διεύθυνση. Κάθε χρήστης που θα εισάγεται θα λαμβάνει ένα μήνυμα με τον τυχαίο κωδικού του. Πρέπει να έχετε έναν χρήστης σε κάθε γραμμή. \nΟποιαδήποτε παρατυπία, ίσως οδηγήσει σε προβλήματα, όπότε ελέγξτε δύο φορές τις γραμμές εισαγωγής σας.",
    26 => '',
    27 => '',
    28 => 'Πατήστε εδώ να διαγράψετε την φωτογραφία',
    29 => 'Διαδρομή',
    30 => 'Εισαγωγή',
    31 => 'Νέοι χρήστες',
    32 => 'Η επεξεργασία τελείωσε. Εισαγωγές %d και %d αποτυχίες',
    33 => 'Υποβολή',
    34 => 'Σφάλμα: Πρέπει να ορίσετε το αρχείο για επαναφόρτωση.',
    35 => 'Τευλευταία εισαγωγή στο σύστημα',
    36 => '(ποτέ)',
    37 => 'UID',
    38 => 'Group Listing',
    39 => 'Password (again)',
    40 => 'Registration Date',
    41 => 'Last login Date',
    42 => 'Banned',
    43 => 'Awaiting Activation',
    44 => 'Awaiting Authorization',
    45 => 'Active',
    46 => 'User Status',
    47 => 'Edit',
    48 => 'Show Admin Groups',
    49 => 'Admin Group',
    50 => 'Check to allow filtering this group as an Admin Use Group',
    51 => 'Online Days',
    52 => '<br' . XHTML . '>Note: "Online Days" is the number of days between the first registration and the last login.',
    53 => 'registered',
    54 => 'Batch Delete',
    55 => 'This only works if you have <code>$_CONF[\'lastlogin\'] = true;</code> in your config.php',
    56 => 'Please choose the type of user you want to delete and press "Update List". Then, uncheck those from the list you do not want to delete and press "Delete". Please note that you will only delete those that are currently visible in case the list spans over several pages.',
    57 => 'Phantom users',
    58 => 'Short-Time Users',
    59 => 'Old Users',
    60 => 'Users that registered more than ',
    61 => ' months ago, but never logged in.',
    62 => 'Users that registered more than ',
    63 => ' months ago, then logged in within 24 hours, but since then never came back to your site.',
    64 => 'Normal users, who simply did not visit your site since ',
    65 => ' months.',
    66 => 'Update List',
    67 => 'Months since registration',
    68 => 'Online Hours',
    69 => 'Offline Months',
    70 => 'could not be deleted',
    71 => 'sucessfully deleted',
    72 => 'No User selected for deletion',
    73 => 'Are You sure you want to permanently delete ALL selected users?',
    74 => 'Recent Users',
    75 => 'Users that registered in the last ',
    76 => ' months',
    77 => 'Email site login reminder to selected users',
    78 => 'Send Reminder',
    79 => 'No User selected for reminders',
    80 => 'Successfully sent Reminders',
    81 => 'Reminder to verify account for %s',
    82 => "Your account on {$_CONF['site_name']} has not been accesssed since %s and will be disabled if not accessed in the 30 days.",
    83 => "Your account on {$_CONF['site_name']} has not been used since it was created and will deleted soon if not accessed.",
    84 => "Your login name is: %s  for our site: {$_CONF['site_url']}",
    85 => 'If you have forgotten the password use the following link: %s',
    86 => 'Include',
    87 => 'Reminders',
    88 => 'Default Group',
    89 => 'Check to make this a default group for new users',
    90 => 'Apply "Default Group" change to existing user accounts'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => 'Έγκριση',
    2 => 'Διαγραφή',
    3 => 'Επεξεργασία',
    4 => 'Προφίλ',
    10 => 'Τίτλος',
    11 => 'Ημερομηνία έναρξης',
    12 => 'URL',
    13 => 'Κατηγορία',
    14 => 'Ημερομηνία',
    15 => 'Θέμα',
    16 => 'Όνομα χρήστη',
    17 => 'Πλήρες Όνομα',
    18 => 'Ηλεκτρονική διεύθυνση',
    34 => 'Εντολές και Έλεγχος',
    35 => 'Υποβολή άρθρων',
    36 => 'Parent or Comment',
    37 => '',
    38 => 'Υποβολή',
    39 => 'Δέν υπάρχουν υποβολές προς επιθεώρηση την παρούσα στιγμή',
    40 => 'Υποβολές χρηστών',
    41 => 'Comment Submissions',
    42 => 'Username',
    43 => 'Auto-publish Comments?'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "{$_CONF['site_name']} Υπηρεσία ηλεκτρονικού ταχυδρομείου",
    2 => 'Από',
    3 => 'Απάντηση-σε',
    4 => 'Θέμα',
    5 => 'Κείμενο',
    6 => 'Παραλήπτης:',
    7 => 'Όλοι οι χρήστες',
    8 => 'Διαχειριστής',
    9 => 'Επιλογές',
    10 => 'HTML',
    11 => 'Επείγον μήνυμα!',
    12 => 'Αποστολή',
    13 => 'Ρύθμιση εκ νέου',
    14 => 'Αγνόησε επιλογές χρήστη',
    15 => 'Σφάλμα κατά την αποστολή στον: ',
    16 => 'Μήνυμα εστάλη επιτυχώς: ',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>Στείλτε άλλο μήνυμα</a>",
    18 => 'Στον',
    19 => 'ΣΗΜΕΙΩΣΗ: Εάν επιθυμείτε να αποστείλετε ένα μήνυμα σε όλους τους εγγεγραμμένους χρήστες επιλέξτε το σύνολο των χρηστών εν ενεργεία από το κυλιόμενο μενού επιλογής',
    20 => "Επιτυχής αποστολή <successcount> μηνυμάτων και ανεπιτυχής αποστολή  <failcount> μηνυμάτων. Αν τα χρειάζεστε, αναλυτικές πληροφορίες για κάθε μία απόπειρα βρίσκονται παρακάτω. Αλλιώς, μπορείτε να <a href=\"{$_CONF['site_admin_url']}/mail.php\">Στείλετε νέο μήνυμα</a> ή να  <a href=\"{$_CONF['site_admin_url']}/moderation.php\">επιστρέψετε στην σελίδα διαχείρισης</a>.",
    21 => 'Αποτυχίες',
    22 => 'Επιτυχίες',
    23 => 'Καμιά αποτυχία',
    24 => 'Καμιά επιτυχία',
    25 => '-- Επιλέξτε σύνολο --',
    26 => 'Παρακαλώ, συμπληρώστε όλα τα πεδία. Κανένα δεν είναι προαιρετικό.'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'Η εγκατάσταση των εξωτερικών προγραμμάτων θα μπορούσε να προκαλέσει ζημιά στην εγκατάσταση του Geeklog και πιθανόν στο σύστημα σας. Είναι σημαντικό να σιγουρευτείτε ότι τα εξωτερικά προγράμματα προέρχονται από την ιστοσελίδα <a href="http://www.geeklog.net" target="_blank">Geeklog Homepage</a> επειδή στην σελίδα μας τα εξωτερικά προγράμματα είναι ελεγχόμενα. Είναι επίσης σημαντικό να καταλάβετε ότι η εγκατάσταση ενός εξωτερικού προγράμματος απαιτεί την εκτέλεση μερικών εντολών του συστήματος αρχείων που θα μπορούσε να επιφέρει προβλήματα ασφαλείας ειδικά αν προέρχεται το εξωτερικό πρόγραμμα από τρίτο κατασκευαστή. Ακόμα και με την παρούσα προειδοποίηση δεν εγγυόμαστε ότι η εγκατάσταση των  εξωτερικών προγραμμάτων θα είναι επιτυχής ούτε αποδεχόμαστε ευθύνη για τυχόν ζημιές από την εγκατάσταση. Η εγκατάσταση είναι δικό σας ρίσκο. Οδηγίες για την εγκατάσταση εξωτερικών προγραμμάτων μπορούν να βρεθούν σε κάθενα απο αυτά. ',
    2 => 'Αποποίηση ευθυνών εγκατάστασης εξωτερικών προγραμμάτων',
    3 => 'Φόρμα εγκατάστασης εξωτερικών προγραμμάτων',
    4 => 'Αρχείο εξωτερικών προγραμμάτων',
    5 => 'Λίστα εξωτερικών προγραμμάτων',
    6 => 'ΠΡΟΕΙΔΟΠΟΙΗΣΗ: Το εξωτερικό πρόγραμμα είναι ήδη εγκατεστημένο',
    7 => 'Το εξωτερικό πρόγραμμα που προσπαθείτε να εγκαταστήσετε είναι ήδη εγκατεστημένο. Παρακαλώ, σβήστε το και ξαναπροσπαθήστε.',
    8 => 'H εξέταση συμβατότητας για εξωτερικό πρόγραμμα απέτυχε',
    9 => 'Αυτό το εξωτερικό πρόγραμμα απαιτεί νεότερη έκδοση του Geeklog. Η αναβαθμίστε την έκδοση σας του <a href="http://www.geeklog.net">Geeklog</a> η βρείτε μία νεότερη έκδοση του.',
    10 => '<br' . XHTML . '><b>Δεν υπάρχουν εγκατεστημένα εξωτερικά προγράμματα.</b><br' . XHTML . '><br' . XHTML . '>',
    11 => 'Για να επεξεργαστείτε η να διαγράψετε ένα εξωτερικό πρόγραμμα, επιλέξτε το παρακάτω με βάση την αριθμό του. Για να μάθετε περισσότερα για ένα συγκεκριμένο εξωτερικό πρόγραμμα, επιλέξτε το όνομα του και θα οδηγηθείτε στην ιστοσελίδα του. Για να to αναβαθμίσετε  συμβουλευτείτε το εγχειρίδιο χρήσης. ',
    12 => 'Δεν δόθηκε το όνομα του εξωτερικού προγράμμaτος στον plugineditor()',
    13 => 'Επεξεργαστής εξωτερικών προγραμμάτων',
    14 => 'Νέο εξωτερικό πρόγραμμα',
    15 => 'Σελίδα διαχείρισης',
    16 => 'Όνομα εξωτερικού προγράμματος',
    17 => 'Έκδοση εξωτερικού προγράμματος',
    18 => 'Έκδοση Geeklog',
    19 => 'Ενεργό',
    20 => 'Ναι',
    21 => 'Όχι',
    22 => 'Εγκατάσταση',
    23 => 'Αποθήκευση',
    24 => 'Ακύρωση',
    25 => 'Διαγραφή',
    26 => 'Όνομα εξωτερικού προγράμματος',
    27 => 'Ιστοσελίδα εξωτερικού προγράμματος',
    28 => 'Έκδοση εξωτερικού προγράμματος',
    29 => 'Έκδοση Geeklog',
    30 => 'Διαγραφή εξωτερικού προγράμματος;',
    31 => 'Είστε σίγουρος/η ότι επιθυμείτε να διαγράψετε αυτό το εξωτερικό πρόγραμμα; Αν το διαγράψετε όλα τα αρχεία, τα δεδομένα και οι δομές δεδομένων που χρησιμοποιεί θα διαγραφούν επίσης. Εάν είστε σίγουρος/η επιλέξτε την επιλογή διαγραφή οπό την παρακάτω φόρμα.',
    32 => '<p><b>Σφάλμα, η διαμόρφωση του "AutoLink tag" δεν είναι σωστή</b></p>',
    33 => 'Έκδοση κώδικα',
    34 => 'Αναβάθμιση',
    35 => 'Edit',
    36 => 'Code',
    37 => 'Data',
    38 => 'Update!',
    39 => 'Upload a plugin',
    40 => 'You can upload a plugin archive (.tar.gz, .tgz, .zip) directly here:',
    41 => 'Upload',
    42 => 'Click to update',
    99 => 'An unknown error occured',
    100 => 'Ok.',
    101 => 'The uploaded file exceeds the upload_max_filesize directive in php.ini.',
    102 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form.',
    103 => 'The uploaded file was only partially uploaded.',
    104 => 'No file was uploaded.',
    105 => '(undefined error)',
    106 => 'Missing a temporary folder.',
    107 => 'Failed to write file to disk.',
    108 => 'File upload stopped by extension.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'Δημιουργία ροής δεδομένων',
    2 => 'Αποθήκευση',
    3 => 'Διαγραφή',
    4 => 'Ακύρωση',
    10 => 'Κοινοπραξία Περιεχομένων',
    11 => 'Νέα ροή δεδομένων',
    12 => 'Σελίδα Διαχειριστή',
    13 => 'Για να τροποποιήσετε την ροή δεδομένων επιλέξτε τον τίτλο της ροής παρακάτω. Για να δημιουργήσετε μια νέα ροή δεδομένων επιλέξτε Νέα Ροή παραπάνω.',
    14 => 'Τίτλος',
    15 => 'Τύπος',
    16 => 'Όνομα Αρχείου',
    17 => 'Διαμόρφωση',
    18 => 'Τελευταία Ανανέωση',
    19 => 'Ενεργοποιήμένο',
    20 => 'Ναί',
    21 => 'Όχι',
    22 => '<i>(Δεν υπάρχει ροή δεδομένων)</i>',
    23 => 'όλες οι ιστορίες',
    24 => 'Συντάκτης ροής δεδομένων',
    25 => 'Τίτλος Ροής δεδομένων',
    26 => 'Όριο',
    27 => 'Εύρος στοιχείων',
    28 => '(0 = κενό κείμενο, 1 = πλήρες κείμενο, άλλο = περιορισμός στο μήκος των χαρακτήρων.)',
    29 => 'Περιγραφή',
    30 => 'Τελευταία ανανέωση',
    31 => 'Σύνολο χαρακτήρων',
    32 => 'Γλώσσα',
    33 => 'Περιέχομενα',
    34 => 'Εισαγωγές',
    35 => 'Ώρες',
    36 => 'Επιλέξτε τύπο ροής',
    37 => '',
    38 => 'Σφάλμα: Κάποια πεδία δεν έχουν συμπληρωθεί',
    39 => 'Παρακαλώ, συμπληρώστε τα πεδία Τίτλος Ροής, Περιγραφή και Όνομα αρχείου.',
    40 => 'Παρακαλώ, εισάγετε τον αριθμό των εγγραφών η τον αριθμό των ωρών.',
    41 => 'Σύνδεσμοι',
    42 => '',
    43 => 'All',
    44 => 'None',
    45 => 'Header-link in topic',
    46 => 'Limit Results',
    47 => 'Search',
    48 => 'Edit',
    49 => 'Feed Logo',
    50 => "Relative to site url ({$_CONF['site_url']})",
    51 => 'The filename you have chosen is already used by another feed. Please choose a different one.',
    52 => 'Error: existing Filename',
    53 => 'All Frontpage Stories',
    54 => 'Please select the type of feed to create.',
    55 => 'Articles'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Ο κωδικός πρόσβασης σας έχει αποσταλεί με μήνυμα ηλεκτρονικού ταχυδρομείου. Παρακαλούμε, ακολουθήστε τις οδηγίες και σας ευχαριστούμε που χρησιμοποιείται{$_CONF['site_name']}",
    2 => "Ευχαριστούμε για την υποβολή του άρθρου σας στο {$_CONF['site_name']}.  Η υποβολή σας θα πρέπει να περάσει από την έγκριση των διαχειριστών. Αν εγκριθεί θα είναι διαθέσιμη για όλους τους χρήστες στην ιστοσελίδα",
    3 => '',
    4 => '',
    5 => 'Η πληροφορίες του λογαριασμού σας αποθηκεύτηκαν επιτυχώς.',
    6 => 'Οι προτιμήσεις προβολής σας αποθηκεύτηκαν επιτυχώς.',
    7 => 'Οι προτιμήσεις σχολίων σας αποθηκεύτηκαν επιτυχώς.',
    8 => 'Έχετε επιτυχώς αποσυνδεθεί.',
    9 => 'Το άρθρο σας αποθηκεύτηκε επιτυχώς.',
    10 => 'Το άρθρο διαγράφηκε επιτυχώς.',
    11 => 'Η ομάδα σας αποθηκεύτηκε επιτυχώς.',
    12 => 'Η ομάδα διαγράφτηκε επιτυχώς.',
    13 => 'Το θέμα σας αποθηκεύτηκε επιτυχώς.',
    14 => 'Το θέμα και όλες οι Άρθρα και ομάδες του διαγράφηκαν επιτυχώς.',
    15 => 'Your comment has been submitted for review and will be published when approved by a moderator.',
    16 => 'You have been unsubscribed. You will no longer be notified of new replies.',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Ο νέος χρήστης αποθηκεύτηκε επιτυχώς.',
    22 => 'Ο χρήστης διαγράφτηκε επιτυχώς.',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'Το μήνυμα στάλθηκε επιτυχώς.',
    28 => 'Το εξωτερικό πρόγραμμα αποθηκεύτηκε επιτυχώς',
    29 => 'Sorry, you do not have access to this administration page.  Please note that all attempts to access unauthorized features are logged',
    30 => 'Η πρόσβαση απορρίφτηκε',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'Μήνυμα συστήματος',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Το εξωτερικό πρόγραμμα εγκαταστάθηκε με επιτυχία!',
    45 => 'Το εξωτερικό πρόγραμμα διαγράφτηκε με επιτυχία!',
    46 => '',
    47 => '',
    48 => "Σας ευχαριστούμε για το ενδιαφέρον σας να γίνετε μέλος του {$_CONF['site_name']}. Η ομάδα μας θα αξιολογήσει την αίτηση σας. Αν εγκριθεί ο κωδικός σας θα αποσταλεί με μήνυμα ηλεκτρονικού ταχυδρομείου στην διεύθυνση που υποδηλώσατε.",
    49 => 'Το σύνολο σας αποθηκεύτηκε επιτυχώς.',
    50 => 'Το σύνολο διαγράφηκε επιτυχώς.',
    51 => 'Το όνομα χρήστη που επιλέξατε είναι ήδη σε χρήση απο κάποιο άλλο μέλος. Παρακαλώ, επιλέξτε κάποιο άλλο όνομα.',
    52 => 'Η ηλεκτρονική διεύθυνση που δηλώσατε δεν είναι σωστή.',
    53 => 'Ο Νέος σας κωδικός έχει γίνει δεκτός. Παρακαλώ, χρησιμοποιήστε τον νέο σας κωδικό απο εδώ και πέρα.',
    54 => 'Η αίτηση σας για την έκδοση νέου κωδικού πρόσβασης έχει εκπνεύσει. Παρακαλώ, προσπαθήστε ξανά.',
    55 => 'Σας έχει αποσταλεί ένα ηλεκτρονικό μήνυμα και σύντομα θα το λάβετε. Παρακαλώ, ακολουθήστε τις οδηγίες στο ηλεκτρονικό μήνυμα για να αντικαταστήσετε τον κωδικό πρόσβασης για τον λογαριασμό σας.',
    56 => 'Η Ηλεκτρονική διεύθυνση που δηλώσατε είναι σε ήδη σε χρήση απο ένα άλλο λογαριασμό στο σύστημα.',
    57 => 'Ο λογαριασμός σας διαγράφτηκε επιτυχώς',
    58 => 'Η ροή δεδομένων αποθηκεύτικε επιτυχώς',
    59 => 'Η ροή δεδομένων διαγράφτηκε επιτυχώς',
    60 => 'Το εξωτερικό πρόγραμμα αναβαθμίστηκε επιτυχώς',
    61 => 'Εξωτερικό Πρόγραμμα %s: Άγνωστoς παραλήπτης μηνύματος',
    62 => 'The trackback comment has been deleted.',
    63 => 'An error occurred when deleting the trackback comment.',
    64 => 'Your trackback comment has been successfully sent.',
    65 => 'Weblog directory service successfully saved.',
    66 => 'The weblog directory service has been deleted.',
    67 => 'The new password does not match the confirmation password!',
    68 => 'You have to enter the correct current password.',
    69 => 'Your account has been blocked!',
    70 => 'Your account is awaiting administrator approval.',
    71 => 'Your account has now been confirmed and is awaiting administrator approval.',
    72 => 'An error occured while attempting to install the plugin. See error.log for details.',
    73 => 'An error occured while attempting to uninstall the plugin. See error.log for details.',
    74 => 'The pingback has been successfully sent.',
    75 => 'Trackbacks must be sent using a POST request.',
    76 => 'Do you really want to delete this item?',
    77 => 'WARNING:<br' . XHTML . '>You have set your default encoding to UTF-8. However, your server does not support multibyte encodings. Please install mbstring functions for PHP or choose a different character set/language.',
    78 => 'Please make sure that the email address and the confirmation email address are the same.',
    79 => 'The page you have been trying to open refers to a function that no longer exists on this site.',
    80 => 'The plugin that created this feed is currently disabled. You will not be able to edit this feed until you re-enable the parent plugin.',
    81 => 'You may have mistyped your login credentials.  Please try logging in again below.',
    82 => 'You have exceeded the number of allowed login attempts.  Please try again later.',
    83 => 'To change your password, email address, or for how long to remember you, please enter your current password.',
    84 => 'To delete your account, please enter your current password.',
    85 => 'There was a problem sending the email.',
    86 => 'The OpenID server invalidated your login attempt.',
    87 => 'OpenID login operation cancelled by user.',
    88 => 'The OpenID server returned an error.',
    89 => 'Unable to find an OpenID server for the given identity URL.',
    90 => 'OpenID identification cancelled.',
    91 => 'You specified an invalid identity URL.',
    92 => "Please <a href=\"{$_CONF['site_admin_url']}/sectest.php\">check the security of your site</a> before using it!",
    93 => 'Database back up was successful.',
    94 => 'Backup Failed: Filesize less than 1kb',
    95 => 'There was an error.',
    96 => '',
    97 => '',
    98 => 'The plugin was successfully uploaded.',
    99 => 'The plugin already exists.',
    100 => 'The plugin file you uploaded was not a GZip or Zip compressed archive.',
    101 => 'There are no topics (that you have access to). You need at least one topic to be able to submit stories.',
    400 => 'Not all required fields have been passed validation',
    401 => 'Please enter Fullname'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Πρόσβαση',
    'ownerroot' => 'Δικαιούχος/Root',
    'group' => 'Σύνολο',
    'readonly' => 'Μόνο ανάγνωση',
    'accessrights' => 'Δικαιώματα πρόσβασης',
    'owner' => 'Δικαιούχος',
    'grantgrouplabel' => 'Παραχώρησε Παραπάνω Σύνολο Επεξεργασία Δικαιώματα',
    'permmsg' => 'ΣΗΜΕΙΩΣΗ: τα μέλη είναι συνδεμένα σαν μέλη και σαν ανώνυμοι χρήστες όσοι απλά βλέπουν την σελίδα.',
    'securitygroups' => 'Σύνολα ασφαλείας',
    'editrootmsg' => "Ακόμα και αν είστε διαχειριστής χρηστών, δεν μπορείτε να επεξεργαστείτε τον λογαριασμό του υπέρ χρήστη χωρίς να είστε εσείς ένας υπέρ χρήστης. Μπορείτε να επεξεργαστείτε όλους τους λογαριασμούς εκτός από αυτούς που είναι συνδεμένοι. Όλες οι προσπάθειες για παράνομη επεξεργασία του λογαριασμού του υπέρ χρήστη καταγράφονται. Παρακαλώ γυρίστε πίσω στην <a href=\"{$_CONF['site_admin_url']}/user.php\">σελίδα διαχείρισης</a>.",
    'securitygroupsmsg' => 'Διαλέξτε τα κουτιά με τα σύνολα που θέλετε ο χρήστης να ανήκει. ',
    'groupeditor' => 'Επεξεργαστής σύνολων',
    'description' => 'Περιγραφή',
    'name' => 'Όνομα',
    'rights' => 'Δικαιώματα',
    'missingfields' => 'Ελλιπή πεδία',
    'missingfieldsmsg' => 'Πρέπει να δώσετε μια περιγραφή για το σύνολο',
    'groupmanager' => 'Διαχειριστής σύνολων',
    'newgroupmsg' => 'Για να μετατρέψετε η να διαγράψετε ένα σύνολο επιλέξτε το σύνολο παρακάτω. Για να δημιουργήσετε ένα νέο σύνολο επιλέξτε Νέο σύνολο παραπάνω. Τα καίρια σύνολα δεν μπορούν να διαγραφτούν.',
    'groupname' => 'Όνομα σύνολου',
    'coregroup' => 'Καίριο σύνολο',
    'yes' => 'Ναι',
    'no' => 'Όχι',
    'corerightsdescr' => "Αυτό το σύνολο είναι καίριο για το {$_CONF['site_name']}.  Τα δικαιώματα για αυτό το σύνολο δεν μπορούν να επεξεργαστούν. Παρακάτω βρίσκετε η λίστα με τα μόνο-ανάγνωσης δικαιώματα που έχει πρόσβαση αυτό το σύνολο.",
    'groupmsg' => 'Τα σύνολα ασφάλειας σε αυτήν την ιστοσελίδα είναι ιεραρχικά. Η πρόσθεση ενός συνόλου σε άλλα σύνολα παρακάτω δίνει την δυνατότητα σε αυτό το σύνολο να μοιράζεται τα δικαιώματα με τα άλλα σύνολα. Όπου είναι εφικτό, είναι καλό να παραχωρείτε τέτοιου είδους δικαιώματα. Εάν χρειάζεστε ένα σύνολο να έχει διαφορετικά δικαιώματα μπορείτε να τα επιλέξετε στο τμήμα Δικαιώματα. Για να προσθέσετε το σύνολο σε οποιοδήποτε άλλο παρακάτω απλά επιλέξτε το κουτί δίπλα από το σύνολο που επιθυμείτε.',
    'coregroupmsg' => "Το σύνολο {$_CONF['site_name']} είναι καίριο.  Τα σύνολα που συμπεριλαμβάνουν το σύνολο αυτό δεν μπορούν να υποστούν επεξεργασία. Παρακάτω είναι μία λίστα με τα μόνο-ανάγνωσης σύνολα που συμπεριλαμβάνουν το παρόν σύνολο.",
    'rightsdescr' => 'Η πρόσβαση ενός συνόλου σε συγκεκριμένα δικαιώματα μπορεί να πραγματοποιηθεί απευθείας στο σύνολο Ή σε ένα διαφορετικό σύνολο που το παρόν σύνολο είναι μέλος. Τα σύνολα παρακάτω χωρίς κουτιά επιλογής είναι τα δικαιώματα που δόθηκαν σε αυτό το σύνολο επειδή ανήκει σε άλλο σύνολο που έχει αυτά τα δικαιώματα. Τα δικαιώματα με κουτιά επιλογής είναι δικαιώματα που μπορούν να δοθούν απευθείας στο σύνολο',
    'lock' => 'Κλείδωμα',
    'members' => 'Μέλη',
    'anonymous' => 'Ανώνυμο',
    'permissions' => 'Άδειες',
    'permissionskey' => 'R = ανάγνωση, E = επεξεργασία, η δυνατότητα επεξεργασίας και ανάγνωσης προϋποθέτει',
    'edit' => 'Επεξεργασία',
    'none' => 'Κανένα',
    'accessdenied' => 'Η πρόσβαση απορρίπτεται',
    'storydenialmsg' => "Δεν έχετε πρόσβαση να δείτε αυτό το άρθρο.  Αυτό ίσως έγινε επειδή δεν είστε μέλος {$_CONF['site_name']}.  Σας παρακαλούμε <a href=\"{$_CONF['site_url']}/users.php?mode=new\" rel=\"nofollow\"> να γίνετε μέλος</a> of {$_CONF['site_name']} για να έχετε ολοκληρωμένη πρόσβαση ως μέλος!",
    'nogroupsforcoregroup' => 'Αυτό το σύνολο δεν ανήκει σε κανένα από τα άλλα σύνολα',
    'grouphasnorights' => 'Αυτό το σύνολο δεν έχει πρόσβαση σε καμία από τις ρουτίνες διαχείρησης αυτής της ιστοσελίδας',
    'newgroup' => 'νέο σύνολο',
    'adminhome' => 'σελίδα διαχείρισης',
    'save' => 'αποθήκευση',
    'cancel' => 'ακύρωση',
    'delete' => 'διαγραφή',
    'canteditroot' => 'Προσπαθήσατε να επεξεργαστείτε το κεντρικό σύνολο αλλά δεν είστε στο σύνολο των διαχειριστών οπότε η πρόσβασή σας απορρίπτεται.  Σας παρακαλούμε επικοινωνήστε με τον διαχειριστή του συστήματος αν νομίζετε ότι πρόκειται περί λάθους.',
    'listusers' => 'Λίστα Χρηστών',
    'listthem' => 'Λίστα',
    'usersingroup' => 'Χρήστε στην ομάδα  "%s"',
    'usergroupadmin' => 'Ομάδα διαχείρισης χρηστών',
    'add' => 'Πρόσθεση',
    'remove' => 'Αφαίρεση',
    'availmembers' => 'Διαθέσιμα μέλη',
    'groupmembers' => 'Μέλη Ομάδας',
    'canteditgroup' => 'Για να επεξεργαστήτε την παρούσα ομάδα πρέπει να είστε μέλος της. Παρακαλούμαι επικοινωνήστε με τους διαχειριστές του συστήματος αν νομίζετε οτι πρόκειται περι σφάλματος.',
    'cantlistgroup' => 'Για να δείτε τα μέλη της ομάδας πρέπει να είστε μέλος της ομάδας και εσείς. Παρακαλούμαι επικοινωνήστε με τους διαχειριστές του συστήματος αν νομίζετε οτι πρόκειται περι σφάλματος.',
    'editgroupmsg' => 'To modify the group membership, click on the member names(s) and use the add or remove buttons. If the member is a member of the group, their name will appear on the right side only. Once you are complete - press <b>Save</b> to update the group and return to the main group admin page.',
    'listgroupmsg' => 'Listing of all current members in the group: <b>%s</b>',
    'search' => 'Search',
    'submit' => 'Submit',
    'limitresults' => 'Limit Results',
    'group_id' => 'Group ID',
    'plugin_access_denied_msg' => 'You are illegally trying access a plugin administration page.  Please note that all attempts to illegally access this page are logged.',
    'groupexists' => 'Group name already exists',
    'groupexistsmsg' => 'There is already a group with this name. Group names must be unique.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => 'Τελευταία 10 αντίγραφα ασφαλείας',
    'do_backup' => 'Δημιουργία αντιγράφων ασφαλείας',
    'backup_successful' => 'Τα αντίγραφα ασφαλείας της βάσης δεδομένων ήταν επιτυχημένα',
    'db_explanation' => 'Για να δημιουργήσετε ένα νέο αντίγραφο ασφάλειας του συστήματος Geeklog, πατήστε το παρακάτω κουμπί',
    'not_found' => "Λάθος διαδρομή ή το πρόγραμμα mysqldump δεν είναι εκτελέσημο. <br" . XHTML . ">Check <strong>\$_DB_mysqldump_path</strong> definition in config.php.<br" . XHTML . ">Η μεταβλητή ορίζεται ως: <var>{$_DB_mysqldump_path}</var>",
    'zero_size' => 'Η αποθήκευση αντιγράφων απέτυχε: Το μέγεθος του αρχείου ήταν 0 bytes',
    'path_not_found' => "{$_CONF['backup_path']} δεν υπάρχει ή δεν είναι κατάλογος",
    'no_access' => "Σφάλμα: Ο κατάλογος {$_CONF['backup_path']} δεν είναι προσβάσημος.",
    'backup_file' => 'Αρχείο αντιγράφου ασφαλείας',
    'size' => 'Μέγεθος',
    'bytes' => 'Βytes',
    'total_number' => 'Συγκεντρωτικός αριθμός αντιγράφων ασφαλείας: %d',
    'download' => 'Click to download this file',
    'new_backup' => 'New Backup',
    'delete_failure' => 'One or more backup files could not be deleted.',
    'delete_success' => 'Backup file(s) successfully deleted.',
    'convert_menu' => 'Convert to InnoDB',
    'convert_title' => 'Convert to InnoDB tables',
    'convert_button' => 'Convert',
    'sorry_no_innodb' => 'Sorry, your version of MySQL does not support InnoDB tables.',
    'innodb_explain' => 'InnoDB tables provide better performance on <em>really</em> large databases but make the backup process more complicated. Please <a href="http://dev.mysql.com/doc/mysql/en/innodb.html">read up</a> on the pros and cons of InnoDB tables before you perform this operation.',
    'already_converted' => 'Note: It appears that all of the tables have already been converted to InnoDB.',
    'conversion_patience' => 'Note: Conversion may take some time - please be patient.',
    'innodb_success' => 'Successfully converted tables to InnoDB.',
    'table_issues' => 'There may have been problems with some tables, though. Please check error.log for details.',
    'optimize_menu' => 'Optimize Tables',
    'optimize_title' => 'Optimize Tables',
    'optimize_button' => 'Optimize',
    'optimize_explain' => 'Optimizing tables may help to improve the performance of your site. The actual impact depends on the table usage and some tables may benefit from it more than others. Do no expect to see a huge difference in performance. The <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQL manual</a> states: <q>it is not likely that you need to do this more than once a week or month</q>.',
    'last_optimization' => 'Last optimization',
    'optimization_patience' => 'Note: Optimization may take some time - please be patient.',
    'optimize_success' => 'Successfully optimized database tables.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Κεντρική σελίδα',
    2 => 'Επικοινωνία',
    3 => 'Υποβολή άρθρων',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Στατιστικά ιστοσελίδας',
    8 => 'Εξατομίκευση',
    9 => 'Αναζήτηση',
    10 => 'Σύνθετη αναζήτηση',
    11 => 'Directory'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => '404 Error',
    2 => 'Η έρευνα πραγματοποιήθηκε σε όλα τα πιθανά σημεία χωρίς αποτέλεσμα  <b>%s</b>.',
    3 => "<p>Λυπάμαι, αλλά το αρχείο που έχετε ζητήσει δεν υπάρχει. Μπορείτε να ελέγξετε την <a href=\"{$_CONF['site_url']}\">κεντρική σελίδα</a> or the <a href=\"{$_CONF['site_url']}/search.php\">σελίδα αναζήτησης</a> για να δείτε αν μπορείτε να βρείτε ό,τι χάσατε."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Η σύνδεσή σας είναι απαραίτητη',
    2 => 'Για να προσπελάσετε αυτήν την περιοχή πρέπει να συνδεθείτε σαν χρήστης.',
    3 => 'Σύνδεση',
    4 => 'Νέος χρήστης '
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'from',
    'tracked_on' => 'Tracked on',
    'read_more' => '[read more]',
    'intro_text' => 'Here\'s what others have to say about \'%s\':',
    'no_comments' => 'No trackback comments for this entry.',
    'this_trackback_url' => 'Trackback URL for this entry:',
    'num_comments' => '%d trackback comments',
    'send_trackback' => 'Send Pings',
    'preview' => 'Preview',
    'editor_title' => 'Send trackback comment',
    'trackback_url' => 'Trackback URL',
    'entry_url' => 'Entry URL',
    'entry_title' => 'Entry Title',
    'blog_name' => 'Site Name',
    'excerpt' => 'Excerpt',
    'truncate_warning' => 'Note: The receiving site may truncate your excerpt',
    'button_send' => 'Send',
    'button_preview' => 'Preview',
    'send_error' => 'Error',
    'send_error_details' => 'Error when sending trackback comment:',
    'url_missing' => 'No Entry URL',
    'url_required' => 'Please enter at least a URL for the entry.',
    'target_missing' => 'No Trackback URL',
    'target_required' => 'Please enter a trackback URL',
    'error_socket' => 'Could not open socket.',
    'error_response' => 'Response not understood.',
    'error_unspecified' => 'Unspecified error.',
    'select_url' => 'Select Trackback URL',
    'not_found' => 'Trackback URL not found',
    'autodetect_failed' => 'Geeklog could not detect the Trackback URL for the post you want to send your comment to. Please enter it manually below.',
    'trackback_explain' => 'From the links below, please select the URL you want to send your Trackback comment to. Geeklog will then try to determine the correct Trackback URL for that post. Or you can <a href="%s">enter it manually</a> if you know it already.',
    'no_links_trackback' => 'No links found. You can not send a Trackback comment for this entry.',
    'pingback' => 'Pingback',
    'pingback_results' => 'Pingback results',
    'send_pings' => 'Send Pings',
    'send_pings_for' => 'Send Pings for "%s"',
    'no_links_pingback' => 'No links found. No Pingbacks were sent for this entry.',
    'pingback_success' => 'Pingback sent.',
    'no_pingback_url' => 'No pingback URL found.',
    'resend' => 'Resend',
    'ping_all_explain' => 'You can now notify the sites you linked to (<a href="http://en.wikipedia.org/wiki/Pingback">Pingback</a>), advertise that your site has been updated by pinging weblog directory services, or send a <a href="http://en.wikipedia.org/wiki/Trackback">Trackback</a> comment in case you wrote about a post on someone else\'s site.',
    'pingback_button' => 'Send Pingback',
    'pingback_short' => 'Send Pingbacks to all sites linked from this entry.',
    'pingback_disabled' => '(Pingback disabled)',
    'ping_button' => 'Send Ping',
    'ping_short' => 'Ping weblog directory services.',
    'ping_disabled' => '(Ping disabled)',
    'trackback_button' => 'Send Trackback',
    'trackback_short' => 'Send a Trackback comment.',
    'trackback_disabled' => '(Trackback disabled)',
    'may_take_a_while' => 'Please note that sending Pingbacks and Pings may take a while.',
    'ping_results' => 'Ping results',
    'unknown_method' => 'Unknown ping method',
    'ping_success' => 'Ping sent.',
    'error_site_name' => 'Please enter the site\'s name.',
    'error_site_url' => 'Please enter the site\'s URL.',
    'error_ping_url' => 'Please enter a valid Ping URL.',
    'no_services' => 'No weblog directory services configured.',
    'services_headline' => 'Weblog Directory Services',
    'service_explain' => 'To modify or delete a weblog directory service, click on the edit icon of that service below. To add a new weblog directory service, click on "Create New" above.',
    'service' => 'Service',
    'ping_method' => 'Ping method',
    'service_website' => 'Website',
    'service_ping_url' => 'URL to ping',
    'ping_standard' => 'Standard Ping',
    'ping_extended' => 'Extended Ping',
    'ping_unknown' => '(unknown method)',
    'edit_service' => 'Edit Weblog Directory Service',
    'trackbacks' => 'Trackbacks',
    'editor_intro' => 'Prepare your trackback comment for <a href="%s">%s</a>.',
    'editor_intro_none' => 'Prepare your trackback comment.',
    'trackback_note' => 'To send a trackback comment for a story, go to the list of stories and click on "Send Ping" for the story. To send a trackback that is not related to a story, <a href="%s">click here</a>.',
    'pingback_explain' => 'Enter a URL to send the Pingback to. The pingback will point to your site\'s homepage.',
    'pingback_url' => 'Pingback URL',
    'site_url' => 'This site\'s URL',
    'pingback_note' => 'To send a pingback for a story, go to the list of stories and click on "Send Ping" for the story. To send a pingback that is not related to a story, <a href="%s">click here</a>.',
    'pbtarget_missing' => 'No Pingback URL',
    'pbtarget_required' => 'Please enter a pingback URL',
    'pb_error_details' => 'Error when sending the pingback:',
    'delete_trackback' => 'To delete this Trackback click: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Article Directory',
    'title_year' => 'Article Directory for %d',
    'title_month_year' => 'Article Directory for %s %d',
    'nav_top' => 'Back to Article Directory',
    'no_articles' => 'No articles.'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklog Security Check',
    'results' => 'Results of the Security Check',
    'okay' => 'Everything seems to be in order.',
    'please_fix' => 'Please fix the above issues before using your site!',
    'please_note' => 'Please note that no site is ever 100% secure. This script can only test for obvious security issues.',
    'stay_informed' => 'To stay informed about new Geeklog releases and possible security issues, we suggest that you subscribe to the (low-traffic) %s mailing list and/or use the %s option in your Admin menu from time to time to check for available updates.',
    'public_html' => '"public_html" should never be part of your site\'s URL.  Please read the part about public_html in the %s again and change your setup accordingly before you proceed.',
    'installation' => 'installation instructions',
    'directory' => 'directory',
    'failed_tmp' => 'Failed to create a temporary file in your %s directory. Check your directory permissions!',
    'fix_it' => 'This is a security risk and should be fixed!',
    'reachable' => 'Your %s is reachable from the web.',
    'not_reachable' => 'Good! Your %s is not reachable from the web.',
    'not_sure' => 'Got an HTTP result code %s when trying to test your %s. Not sure what to make of it ...',
    'remove_inst' => 'You should really remove the install directory %s once you have your site up and running without any errors.',
    'remove_inst2' => 'Keeping it around would allow malicious users the ability to destroy your current install, take over your site, or retrieve sensitive information.',
    'inst_removed' => 'Good! You seem to have removed the install directory already.',
    'fix_password' => 'You still have not changed the <strong>default password</strong> from "password" on %s Root user account(s).',
    'password_okay' => 'Good! You seem to have changed the default account password already.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n new %i in the last %t %s',
    'new_last' => 'last %t %s',
    'minutes' => 'minutes',
    'hours' => 'hours',
    'days' => 'days',
    'weeks' => 'weeks',
    'months' => 'months',
    'years' => 'years',
    'minute' => 'minute',
    'hour' => 'hour',
    'day' => 'day',
    'week' => 'week',
    'month' => 'month',
    'year' => 'year'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Ιανουάριος',
    2 => 'Φεβρουάριος',
    3 => 'Μάρτιος',
    4 => 'Απρίλιος',
    5 => 'Μάιος',
    6 => 'Ιούνιος',
    7 => 'Ιούλιος',
    8 => 'Αύγουστος',
    9 => 'Σεπτέμβριος',
    10 => 'Οκτώβριος',
    11 => 'Νοέμβριος',
    12 => 'Δεκέμβριος'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Κυριακή',
    2 => 'Δευτέρα',
    3 => 'Τρίτη',
    4 => 'Τετάρτη',
    5 => 'Πέμπτη',
    6 => 'Παρασκευή',
    7 => 'Σάββατο'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Search',
    'limit_results' => 'Limit Results',
    'submit' => 'Submit',
    'edit' => 'Edit',
    'edit_adv' => 'Adv. Edit',
    'admin_home' => 'Admin Home',
    'create_new' => 'Create New',
    'create_new_adv' => 'Create New (Adv.)',
    'enabled' => 'Enabled',
    'title' => 'Title',
    'page_title' => 'Page Title',
    'type' => 'Type',
    'topic' => 'Topic',
    'help_url' => 'Help File URL',
    'save' => 'Save',
    'cancel' => 'Cancel',
    'delete' => 'Delete',
    'delete_sel' => 'Delete selected',
    'copy' => 'Copy',
    'no_results' => '- No entries found -',
    'data_error' => 'There was an error processing the subscription data. Please check the data source.',
    'preview' => 'Preview',
    'records_found' => 'Records found',
    'addchild' => 'Add child',
    'list' => 'list',
    'list_all' => 'List all',
    'meta_description' => 'Meta Description',
    'meta_keywords' => 'Meta Keywords',
    'na' => 'N/A',
    'token_expiry' => 'You have until %s to make changes. After that time, the security token embedded into this page will expire and you will lose your changes.',
    'token_expired' => 'The security token for this operation has expired. Please authenticate again to continue.',
    'reauth_msg' => 'The security token for this operation has expired. If you want to continue with this operation, then please authenticate again below. This will ensure that the changes you just made will not be lost.',
    'authenticate' => 'Authenticate'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'Comments Enabled',
    -1 => 'Comments Disabled',
    1 => 'Comments Closed'
);

$LANG_commentmodes = array(
    'flat' => 'Flat',
    'nested' => 'Nested',
    'threaded' => 'Threaded',
    'nocomment' => 'No Comments'
);

$LANG_cookiecodes = array(
    0 => '(don\'t)',
    3600 => '1 Hour',
    7200 => '2 Hours',
    10800 => '3 Hours',
    28800 => '8 Hours',
    86400 => '1 Day',
    604800 => '1 Week',
    2678400 => '1 Month'
);

$LANG_dateformats = array(
    0 => 'System Default'
);

$LANG_featurecodes = array(
    0 => 'Not Featured',
    1 => 'Featured'
);

$LANG_frontpagecodes = array(
    0 => 'Show Only in Topic',
    1 => 'Show on Front Page'
);

$LANG_postmodes = array(
    'plaintext' => 'Plain Old Text',
    'html' => 'HTML Formatted'
);

$LANG_sortcodes = array(
    'ASC' => 'Oldest First',
    'DESC' => 'Newest First'
);

$LANG_trackbackcodes = array(
    0 => 'Trackback Enabled',
    -1 => 'Trackback Disabled'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Home',
    'admin_home' => 'Site Administration',
    'sections' => 'Configuration Sections',
    'restore' => 'Restore',
    'add_element' => 'Add Element',
    'save_changes' => 'Save Changes',
    'reset_form' => 'Reset Form',
    'changes_made' => 'Changes were successfully made to',
    'title' => 'Configuration Manager',
    'disable' => 'Click to disable this option',
    'enable' => 'Enable'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklog Configuration'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTML Path',
    'site_url' => 'Site URL',
    'site_admin_url' => 'Admin URL',
    'site_mail' => 'Site E-Mail',
    'noreply_mail' => 'No-Reply E-Mail',
    'site_name' => 'Site Name',
    'site_slogan' => 'Slogan',
    'microsummary_short' => 'Microsummary',
    'path_log' => 'Log',
    'path_language' => 'Language',
    'backup_path' => 'Backup',
    'path_data' => 'Data',
    'path_images' => 'Images',
    'path_pear' => 'Path Pear',
    'have_pear' => 'Have Pear?',
    'mail_settings' => 'Mail Settings',
    'allow_mysqldump' => 'Allow MySQL Dump',
    'mysqldump_path' => 'Path of Executable',
    'mysqldump_options' => 'MySQL Dump Options',
    'mysqldump_filename_mask' => 'Backup File Name Mask',
    'theme' => 'Theme',
    'doctype' => 'DOCTYPE Declaration',
    'menu_elements' => 'Menu Elements',
    'path_themes' => 'Themes Path',
    'disable_new_user_registration' => 'Disable New Registrations',
    'allow_user_themes' => 'Allow User Themes',
    'allow_user_language' => 'Allow User Language',
    'allow_user_photo' => 'Allow User Photo',
    'allow_username_change' => 'Allow Username Changes',
    'allow_account_delete' => 'Allow Account Deletion',
    'hide_author_exclusion' => 'Allow Hide Author',
    'show_fullname' => 'Show Fullname',
    'show_servicename' => 'Show Service Name',
    'custom_registration' => 'Enable Custom Registration',
    'user_login_method' => 'User Login Method',
    'spamx' => 'Spam-X Actions',
    'sort_admin' => 'Sort Links',
    'language' => 'Language',
    'locale' => 'Locale',
    'date' => 'Date Format',
    'daytime' => 'Daytime Format',
    'shortdate' => 'Short Date Format',
    'dateonly' => 'Date Only Format',
    'timeonly' => 'Time Only Format',
    'week_start' => 'Week Start',
    'hour_mode' => 'Hour Mode',
    'thousand_separator' => 'Thousands Separator',
    'decimal_separator' => 'Decimal Separator',
    'decimal_count' => 'Decimal Count',
    'language_files' => 'Language Files',
    'languages' => 'Languages',
    'timezone' => 'Timezone',
    'site_disabled_msg' => 'Site Disabled Message or URL',
    'rootdebug' => 'Root Debugging',
    'cookie_session' => 'Session Cookie Name',
    'cookie_name' => 'Permanent Cookie Name',
    'cookie_password' => 'Password Cookie Name',
    'cookie_theme' => 'Theme Cookie Name',
    'cookie_language' => 'Language Cookie Name',
    'cookie_tzid' => 'Timezone Cookie Name',
    'cookie_anon_name' => 'Anon. Username Cookie Name',
    'cookie_ip' => 'Cookies embed IP?',
    'default_perm_cookie_timeout' => 'Permanent Timeout',
    'session_cookie_timeout' => 'Session Timeout',
    'cookie_path' => 'Cookie Path',
    'cookiedomain' => 'Cookie Domain',
    'cookiesecure' => 'Cookie Secure',
    'lastlogin' => 'Record Last Login?',
    'num_search_results' => 'Number of Search Results',
    'loginrequired' => 'Login Required?',
    'submitloginrequired' => 'Submit Login Required?',
    'commentsloginrequired' => 'Comment Login Required?',
    'statsloginrequired' => 'Stats Login Required?',
    'searchloginrequired' => 'Search Login Required?',
    'profileloginrequired' => 'Profile Login Required?',
    'emailuserloginrequired' => 'E-Mail User Login Required?',
    'emailstoryloginrequired' => 'E-Mail Story Login Required?',
    'directoryloginrequired' => 'Directory Login Required?',
    'storysubmission' => 'Story Submission Queue?',
    'usersubmission' => 'User Submission Queue?',
    'listdraftstories' => 'List Draft Stories?',
    'notification' => 'Notifications',
    'postmode' => 'Default Post Mode',
    'speedlimit' => 'Post Speed Limit',
    'skip_preview' => 'Skip Preview in Posts',
    'advanced_editor' => 'Advanced Editor?',
    'wikitext_editor' => 'Wikitext Editor?',
    'cron_schedule_interval' => 'Cron Schedule Interval',
    'sortmethod' => 'Sort Topics',
    'showstorycount' => 'Show Story Count?',
    'showsubmissioncount' => 'Show Submission Count?',
    'hide_home_link' => 'Hide Home Link?',
    'whosonline_threshold' => 'Session Threshold',
    'whosonline_anonymous' => 'Hide Names from Guests?',
    'emailstories' => 'Daily Digest Enabled?',
    'emailstorieslength' => 'Length of Stories',
    'emailstoriesperdefault' => 'Enable for New Users?',
    'allow_domains' => 'Automatic Allow Domains',
    'disallow_domains' => 'Automatic Disallow Domains',
    'newstoriesinterval' => 'New Stories Interval',
    'newcommentsinterval' => 'New Comments Interval',
    'newtrackbackinterval' => 'New Trackbacks Interval',
    'hidenewstories' => 'Hide New Stories',
    'hidenewcomments' => 'Hide New Comments',
    'hidenewtrackbacks' => 'Hide New Trackbacks',
    'hidenewplugins' => 'Hide New Plugin Entries',
    'title_trim_length' => 'Title Trim Length',
    'trackback_enabled' => 'Trackback Enabled?',
    'pingback_enabled' => 'Pingback Enabled?',
    'ping_enabled' => 'Ping Enabled?',
    'trackback_code' => 'Trackback Default',
    'multiple_trackbacks' => 'Multiple Trackbacks',
    'trackbackspeedlimit' => 'Trackback Speed Limit',
    'check_trackback_link' => 'Check Trackbacks',
    'pingback_self' => 'Pingback Self?',
    'pingback_excerpt' => 'Create Pingback Excerpt?',
    'link_documentation' => 'Link to Documentation?',
    'link_versionchecker' => 'Link to Version Checker?',
    'maximagesperarticle' => 'Max Images per Article',
    'limitnews' => 'Stories per Page',
    'minnews' => 'Min. Stories per Page',
    'contributedbyline' => 'Show "Contributed By"?"',
    'hideviewscount' => 'Hide Views Count?',
    'hideemailicon' => 'Hide E-Mail Icon?',
    'hideprintericon' => 'Hide Print Icon?',
    'allow_page_breaks' => 'Allow Page Breaks?',
    'page_break_comments' => 'Comments on Multi-Page Articles',
    'article_image_align' => 'Topic Icon Alignment',
    'show_topic_icon' => 'Show Topic Icon?',
    'draft_flag' => 'Draft Flag Default',
    'frontpage' => 'Frontpage Default',
    'hide_no_news_msg' => 'Hide "No News" Message?',
    'hide_main_page_navigation' => 'Hide Main Page Navigation?',
    'onlyrootfeatures' => 'Only Root can Feature?',
    'aftersave_story' => 'After Saving Story',
    'aftersave_user' => 'After Saving User',
    'show_right_blocks' => 'Always Show Right Blocks?',
    'showfirstasfeatured' => 'Show First Story as Featured?',
    'backend' => 'Enable Feeds?',
    'rdf_file' => 'Syndication Output Folder',
    'rdf_limit' => 'Feed Limit',
    'rdf_storytext' => 'Length of Stories in Feed',
    'rdf_language' => 'Feed Language',
    'syndication_max_headlines' => 'Max. Number of Headlines (portal blocks)',
    'copyrightyear' => 'Copyright Year',
    'image_lib' => 'Image Library',
    'path_to_mogrify' => 'Path to Mogrify',
    'path_to_netpbm' => 'Path to Netpbm',
    'debug_image_upload' => 'Debug Image Uploading?',
    'keep_unscaled_image' => 'Keep Unscaled Image?',
    'allow_user_scaling' => 'Allow User Scaling?',
    'jpeg_quality' => 'JPEG Quality?',
    'max_image_width' => 'Max Image Width?',
    'max_image_height' => 'Max Image Height?',
    'max_image_size' => 'Max Image Size?',
    'max_topicicon_width' => 'Max Topic Icon Width?',
    'max_topicicon_height' => 'Max Topic Icon Height?',
    'max_topicicon_size' => 'Max Topic Icon Size?',
    'max_photo_width' => 'Max Photo Width?',
    'max_photo_height' => 'Max Photo Height?',
    'max_photo_size' => 'Max Photo Size?',
    'use_gravatar' => 'Use Gravatar?',
    'gravatar_rating' => 'Gravatar Rating',
    'force_photo_width' => 'Force Photo Width',
    'default_photo' => 'Default Photo',
    'commentspeedlimit' => 'Comment Speed Limit',
    'comment_limit' => 'Comment Limit',
    'comment_mode' => 'Comment Mode',
    'comment_code' => 'Comment Default',
    'comment_edit' => 'Allow Comment Edit?',
    'comment_edittime' => 'Comment Edit Time (seconds)',
    'commentsubmission' => 'Queue Comment Submissions',
    'passwordspeedlimit' => 'Password Speed Limit',
    'login_attempts' => 'Max. Login Attempts',
    'login_speedlimit' => 'Login Speed Limit',
    'user_html' => 'User HTML',
    'admin_html' => 'Admin HTML',
    'advanced_html' => 'Additional HTML for Adv. Editor',
    'skip_html_filter_for_root' => 'Skip HTML Filter for Root?',
    'allowed_protocols' => 'Allowed Protocols',
    'disable_autolinks' => 'Disable Autotags?',
    'clickable_links' => 'Make URLs clickable?',
    'compressed_output' => 'Send compressed output?',
    'frame_options' => 'Protection against "clickjacking"',
    'censormode' => 'Censor Mode?',
    'censorreplace' => 'Censor Replace Text',
    'censorlist' => 'Censor List',
    'ip_lookup' => 'IP Lookup',
    'url_rewrite' => 'Enable URL Rewrite',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'Default Meta Description',
    'meta_keywords' => 'Default Meta Keywords',
    'default_permissions_block' => 'Block Default Permissions',
    'default_permissions_story' => 'Story Default Permissions',
    'default_permissions_topic' => 'Topic Default Permissions',
    'atom_max_stories' => 'Max. Stories in Webservices Feed',
    'disable_webservices' => 'Disable Webservices?',
    'restrict_webservices' => 'Restrict Webservices?',
    'article_comment_close_enabled' => 'Automatically close comments (default)',
    'article_comment_close_days' => 'Days to close comments (default)',
    'comment_close_rec_stories' => 'Number of most recent stories enabled for comments',
    'allow_reply_notifications' => 'Allow comment reply notifications?',
    'search_style' => 'Results List Style',
    'search_limits' => 'Page Limits',
    'search_show_num' => 'Show Result Number?',
    'search_show_type' => 'Show Result Type?',
    'search_show_sort' => 'Allow User to Sort Results?',
    'search_show_limit' => 'Show Page Limits?',
    'search_separator' => 'Group Separator',
    'search_def_keytype' => 'Default Search Method',
    'search_def_sort' => 'Default Sort Order'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Site',
    'sg_stories' => 'Stories and Trackback',
    'sg_theme' => 'Theme',
    'sg_blocks' => 'Blocks',
    'sg_users' => 'Users and Submissions',
    'sg_images' => 'Images',
    'sg_locale' => 'Languages and Locale',
    'sg_misc' => 'Miscellaneous'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Site',
    'fs_paths' => 'Paths',
    'fs_theme' => 'Theme',
    'fs_mail' => 'Mail',
    'fs_pear' => 'Pear',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'Users',
    'fs_misc' => 'Miscellaneous',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Block',
    'fs_locale' => 'Locale',
    'fs_language' => 'Language',
    'fs_debug' => 'Debug',
    'fs_cookies' => 'Cookies',
    'fs_login' => 'Login Settings',
    'fs_search' => 'Search',
    'fs_user_submission' => 'User Submission',
    'fs_submission' => 'Submission Settings',
    'fs_topics_block' => 'Topics Block',
    'fs_whosonline_block' => 'Who\'s Online Block',
    'fs_daily_digest' => 'Daily Digest',
    'fs_whatsnew_block' => 'What\'s New Block',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Story',
    'fs_theme_advanced' => 'Advanced Settings',
    'fs_syndication' => 'Syndication',
    'fs_imagelib' => 'Image Library',
    'fs_upload' => 'Upload',
    'fs_articleimg' => 'Images in Articles',
    'fs_topicicon' => 'Topic Icons',
    'fs_userphoto' => 'Photos',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Comments',
    'fs_htmlfilter' => 'HTML Filtering',
    'fs_censoring' => 'Censoring',
    'fs_iplookup' => 'IP Lookup',
    'fs_perm_story' => 'Story Default Permission',
    'fs_perm_topic' => 'Topic Default Permission',
    'fs_perm_block' => 'Block Default Permission',
    'fs_webservices' => 'Webservices'
);

$LANG_configselects['Core'] = array(
    0 => array('True' => 1, 'False' => 0),
    1 => array('True' => true, 'False' => false),
    2 => array('Reject' => 0, 'Only Keep Latest' => 1, 'Allow Multiple Posts' => 2),
    3 => array('Trackback Enabled' => 0, 'Trackback Disabled' => -1),
    4 => array('Don\'t Check Anything' => 0, 'Check against Site URL' => 1, 'Check full URL' => 2, 'Check against Site URL and full URL' => 3, 'Check IP against Site IP' => 4, 'Check IP and Site URL' => 5, 'Check IP and Full URL' => 6, 'Check IP, Full URL, and Site URL' => 7),
    5 => array('Plain Old Text' => 'plaintext', 'HTML Formatted' => 'html'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Last Page' => 'last', 'First Page' => 'first', 'Every Page' => 'all'),
    8 => array('Right' => 'right', 'Left' => 'left'),
    9 => array('Forward to page' => 'item', 'Display List' => 'list', 'Display Home' => 'home', 'Display Admin' => 'admin'),
    10 => array('None' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('Flat' => 'flat', 'Nested' => 'nested', 'Threaded' => 'threaded', 'No Comments' => 'nocomment'),
    12 => array('No access' => 0, 'Read-Only' => 2, 'Read-Write' => 3),
    13 => array('Skip' => 0, 'Allow, with speedlimit' => 1, 'Allow, no speedlimit' => 2),
    14 => array('Sunday' => 'Sun', 'Monday' => 'Mon'),
    15 => array('By Number' => 'sortnum', 'Alphabetically' => 'alpha'),
    16 => array('No Login required' => 0, 'Advanced Search only' => 1, 'Simple + Advanced Search' => 2),
    17 => array('Comments Enabled' => 0, 'Comments Disabled' => -1),
    18 => array('Disabled' => 0, 'Enabled (Exact Match)' => 1, 'Enabled (Word Beginning)' => 2, 'Enabled (Word Fragment)' => 3),
    19 => array('Google' => 'google', 'Table' => 'table'),
    20 => array('Exact Phrase' => 'phrase', 'All of The Words' => 'all', 'Any of The Words' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict'),
    22 => array('Strict' => 'DENY', 'Same Origin' => 'SAMEORIGIN', '(disabled)' => ''),
    23 => array('Disabled' => 0, 'Enabled' => 1, 'Enabled (Default for Homepage only)' => 2),
    24 => array('Contribute' => 'contribute', 'Home' => 'home', 'Advanced Search' => 'search', 'Directory' => 'directory', 'My Account' => 'prefs', 'Plugin Entries' => 'plugins', 'Custom Entries' => 'custom', 'Site Statistics' => 'stats'),
    25 => array('New Stories' => 'story', 'New Comments' => 'comment', 'New Trackbacks' => 'trackback', 'New Pingbacks' => 'pingback', 'New Users' => 'user'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Hits (asc)' => 'hits|asc', 'Hits (desc)' => 'hits|desc', 'Date (asc)' => 'date|asc', 'Date (desc)' => 'date|desc', 'Title (asc)' => 'title|asc', 'Title (desc)' => 'title|desc', 'Author (asc)' => 'uid|asc', 'Author (desc)' => 'uid|desc')
);

?>
