<?php

###############################################################################
# estonian_utf-8.php
# This is the Estonian language file for Geeklog!
#
# Copyright (C) 2000 Jason Whittenburg
# jwhitten@securitygeeks.com
#
# Estonian translation by Artur Räpp <rtr AT planet DOT ee>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

$LANG_CHARSET = 'utf-8';

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

###############################################################################
# USER PHRASES - These are file phrases used in end user scripts
###############################################################################

###############################################################################
# lib-common.php

$LANG01 = array(
    1 => 'Postitajaks:',
    2 => 'loe lisaks',
    3 => 'kommentaari',
    4 => 'Toimeta',
    5 => '',
    6 => '',
    7 => '',
    8 => '',
    9 => 'Admini funktsioonid:',
    10 => 'Sisestused',
    11 => 'Lugu',
    12 => 'Plokid',
    13 => 'Rubriigid',
    14 => '',
    15 => '',
    16 => '',
    17 => 'Kasutajad',
    18 => 'SQL päring',
    19 => 'Logi välja',
    20 => 'Kasutaja info',
    21 => 'Kasutajanimi',
    22 => 'Kasutaja ID',
    23 => 'Turvatase',
    24 => 'Anonüümne',
    25 => 'Vasta',
    26 => 'Järgnevate kommentaaride omanikuks on need, kes iganes need postitas. See leht ei vastuta nende poolt öeldu eest.',
    27 => 'Värskeim postitus',
    28 => 'Kustuta',
    29 => 'Pole kommentaare.',
    30 => 'Vanemad lood',
    31 => 'Lubatud HTML sildid:',
    32 => 'Viga, sobimatu kasutajanimi',
    33 => 'Viga, ei saanud kirjutada logifaili',
    34 => 'Viga',
    35 => 'Logi välja',
    36 => 'Aeg',
    37 => 'Pole kasutaja lugusid',
    38 => 'Sisu jagamine',
    39 => 'Värskenda',
    40 => '',
    41 => 'Külaliskasutajaid',
    42 => 'Autoriks:',
    43 => 'Vasta sellele',
    44 => 'Tase kõrgemal',
    45 => 'MySQL vea number',
    46 => 'MySQL veateade',
    47 => 'Lehe kasutajale',
    48 => 'Konto info',
    49 => 'eelistused',
    50 => 'Viga SQL lauses',
    51 => 'abi',
    52 => 'Uus',
    53 => 'Admin avaleht',
    54 => 'Ei saanud avada faili.',
    55 => 'Viga: koht',
    56 => 'Hääleta',
    57 => 'Salasõna',
    58 => 'Logi sisse',
    59 => "Pole veel kontot? Logi sisse <a href=\"{$_CONF['site_url']}/users.php?mode=new\">uue kasutajana</a>",
    60 => 'Postita kommentaar',
    61 => 'Loo uus kasutajakonto',
    62 => 'sõna',
    63 => 'Kommentaaride eelistused',
    64 => 'Saada artikkel sõbrale E-postiga',
    65 => 'Näita printversiooni',
    66 => '',
    67 => 'Tere siia - ',
    68 => 'Avaleht',
    69 => 'Kontakt',
    70 => 'Otsi',
    71 => 'Lisa lehele lugu',
    72 => 'Veebikohad',
    73 => '',
    74 => '',
    75 => 'Otsing',
    76 => 'Lehe statistika',
    77 => 'Pluginad',
    78 => '',
    79 => 'Mida uut',
    80 => 'viimased lood',
    81 => 'viimane lugu',
    82 => 'tundi',
    83 => 'KOMMENTAARE',
    84 => '',
    85 => 'viimased 48 t',
    86 => 'Pole uusi kommentaare',
    87 => 'viimased 2 n',
    88 => '',
    89 => '',
    90 => 'Avaleht',
    91 => 'Leht valmis',
    92 => 'sekundiga',
    93 => '(C)',
    94 => 'Kõik sellel lehel olevad kaubamärgid ja autorikaitsega materjalid kuuluvad nende õigustatud omanikele.',
    95 => 'Mootoriks on',
    96 => 'Grupid',
    97 => 'Sõnade loetelu',
    98 => 'Pluginad',
    99 => 'LOOD',
    100 => 'Pole uusi lugusid',
    101 => '',
    102 => '',
    103 => 'DB Backupid',
    104 => 'by',
    105 => 'E-post kasutajatele',
    106 => 'Vaatamisi',
    107 => 'GL versiooni test',
    108 => 'Tühjenda puhvermälu',
    109 => 'Teata kuritahtlikkusest',
    110 => 'Teata sellest postitusest lehe administraatorile',
    111 => '',
    112 => 'Registreeritud kasutajaid',
    113 => 'Dokumentatsioon',
    114 => 'TRACKBACKID',
    115 => 'Pole uusi trackback kommentaare',
    116 => 'Trackback',
    117 => 'Lood ajalises järjestuses',
    118 => 'Palun jätka lugemist järgmisel lehel:',
    119 => "Kaotasid oma <a href=\"{$_CONF['site_url']}/users.php?mode=getpassword\">salasõna?</a>",
    120 => 'Püsilink sellele kommentaarile',
    121 => 'Kommentaare (%d)',
    122 => 'Trackbacke (%d)',
    123 => 'Kogu HTML on lubatud',
    124 => 'Klõpsa kõigi märgitute kustutamiseks',
    125 => 'Kas oled kindel, et soovid kõiki neid kustutada?',
    126 => 'Märgi/eemalda märge kõigilt',
    127 => 'Püsilink',
    128 => 'Logi sisse OpenID abiga:',
    129 => 'Seadistus',
    130 => 'Veebiteenused'
);

###############################################################################
# comment.php

$LANG03 = array(
    1 => 'Postita kommentaar',
    2 => 'Postituse viis',
    3 => 'Logi välja',
    4 => 'Tee konto',
    5 => 'Kasutajanimi',
    6 => 'Sellel lehel pead kommentaaride postitamiseks eelnevalt sisse logima. Kui sul ei ole veel kasutajakontot, võid alloleva vormi abiga endale konto luua.',
    7 => 'Sinu viimane kommentaar oli ',
    8 => " sekundit tagasi.  Sellel lehel  peab kommentaaride vahe olema vähemalt {$_CONF['commentspeedlimit']} sekundit",
    9 => 'kommentaar',
    10 => 'Saada raport',
    11 => 'Saada kommentaar',
    12 => 'Palun täida tiitli ja kommentaari väljad. Need on kommentaari postitamisel kohustuslikud.',
    13 => 'Info sinu kohta',
    14 => 'Eelvaade',
    15 => 'Teata sellest postitusest',
    16 => 'Tiitel',
    17 => 'Viga',
    18 => 'Oluline',
    19 => 'Hoia sõnum vastavuses teemaga.',
    20 => 'Proovi uue teema algatamise asemel pigem vastata teiste postitustele',
    21 => 'Loe enne postitamist teiste poolt öeldut, vältides nii juba öeldu kordamist.',
    22 => 'Kasuta sinu sõnumit selgelt kirjeldavat tiitlit.',
    23 => 'Sinu E-postiaadressi ei tehta avalikuks.',
    24 => 'Anonüümne kasutaja',
    25 => 'Kas oled kindel, et soovid teatada sellest postitusest lehe administraatorile?',
    26 => '%s teatas järgmisest kuritahtlikust postitusest:',
    27 => 'Kuritahtlikkusest teatamine',
    28 => 'Muudatuste eelvaade',
    29 => 'Sisesta muutused',
    30 => 'Muudetud',
    31 => 'muutja',
    32 => 'Kommentaari toimetamine',
    33 => 'Sisestatud kommentaari muutmine',
    34 => 'Sisestuste muutuste eelvaade',
    35 => 'Salvesta muutused puhvrisse',
    36 => 'Teavita mind vastustest',
    37 => 'Uus vastus kommentaarile',
    38 => 'Sinu kommentaarile on vastatud \'%s\'.',
    39 => 'Sa võid vaadata kommentaari lõime järgneval aadressil:',
    40 => 'Kui sa ei soovi enam saada  teaviusi vastuste kohta, külasta järgnevat aadressit:',
    41 => 'Tere %s,',
    42 => 'Loobu tellimisest',
    43 => 'Loobu vastuste teavitustest.',
    44 => 'Sinu nimi'
);

###############################################################################
# users.php

$LANG04 = array(
    1 => 'Kasutaja profiil, omanik',
    2 => 'Kasutajanimi',
    3 => 'Täisnimi',
    4 => 'Salasõna',
    5 => 'E-postiaadress',
    6 => 'Koduleht',
    7 => 'Bio',
    8 => 'PGP võti',
    9 => 'Salvesta info',
    10 => 'Viimased 10 kommentaari, kommenteerijaks',
    11 => 'Pole kasutaja kommentaare',
    12 => 'Kasutaja eelistused, kasutaja -',
    13 => 'Saada öösiti kokkuvõtted',
    14 => 'See salasõna on genereeritud juhusliku sümbolite kombinatsioonina. On soovitav, et sa vahetad koheselt salasõna. Salasõna muutmiseks logi oma kasutajanime ja salasõna abil sisse ja ava "Lehe kasutajale" alt "Konto info".',
    15 => "Sinu {$_CONF['site_name']} konto on edukalt loodud. Selle kasutamiseks pead sa allpool oleva info abil sisse logima. Palun salvesta see kiri edaspidiseks kasutamiseks.",
    16 => 'Sinu kasutajakonto info',
    17 => 'Kontot ei ole',
    18 => 'Sisestatud E-postiaadress tundub olevat ebakorrektne E-postiaadress',
    19 => 'Kasutajanimi või E-postiaadress on juba olemas',
    20 => 'Sisestatud E-postiaadress tundub olevat ebakorrektne E-postiaadress',
    21 => 'Viga',
    22 => "Registreeri {$_CONF['site_name']} lehel!",
    23 => "Kasutajakonto loomine annab sulle kõik {$_CONF['site_name']} lehe poolt kasutajale pakutavad võimalused. Sa võid postitada oma nimega  kommentaare ja uusi lugusid. Kui sul ei ole kontot, ei saa sa neid postitada. Sinu E-postiaadressi <i><b>ei näidata </b></i> sellel lehel avalikult.",
    24 => 'Sinu salasõna saadetakse siin sisestatud E-postiaadressil.',
    25 => 'Kas unustasid oma salasõna?',
    26 => 'Sisesta <em>kas</em> oma kasutajanimi <em> või </em> registreerimisel antud E-postiaadress ning klõpsa Saada salasõna. Antud E-postiaadressile saadetakse juhendid, kuidas määrata uus salasõna.',
    27 => 'Registreeri nüüd!',
    28 => 'Saada salasõna',
    29 => 'välja logitud',
    30 => 'logitud sisse lehelt',
    31 => 'Sinu valitud käsk vajab, et oleksid sisse logitud',
    32 => 'Allkiri',
    33 => 'Ei näidata kunagi avalikel lehtedel',
    34 => 'See on sinu tegelik nimi',
    35 => 'Sisesta uus salasõna',
    36 => 'Koos http://',
    37 => 'Rakendatakse sinu kommentaaridele',
    38 => 'See on kõik sinu kohta! Kõik saavad seda lugeda',
    39 => 'Sinu avalik/public PGP võti levitamiseks',
    40 => 'Pole rubriikide ikoone',
    41 => 'Soovid modereerida',
    42 => 'Kuupäeva formaat',
    43 => 'Lugude maksimum',
    44 => 'pole kaste',
    45 => 'Näita eelistusi - kasutaja',
    46 => 'Väljaarvatud asjad - kasutaja',
    47 => 'Uudistekasti häälestus - kasutaja',
    48 => 'Rubriigid',
    49 => 'Lugudes pole ikoone',
    50 => 'Eemalda märge, kui pole huvitatud',
    51 => 'Ainult uudislood',
    52 => 'Vaikimisi on',
    53 => 'Saada igal öösel päeval postitatud lood .',
    54 => 'Märgi (rubriigid/autorid), mida sa ei soovi näha',
    55 => 'Kui sa jätad kõik märkimata, siis rakendatakse süsteemi vaikimisi häälestust. Kui aga alustad märkimist, siis märgi kindlasti kõik soovitud, sest süsteemi vaikeseadistust sinule ei rakendata. Süsteemi vaikevalikud on rasvases kirjas.',
    56 => 'Autorid',
    57 => 'Näitamise viis',
    58 => 'Sorteerimisjärjekord',
    59 => 'Kommentaaride limiit',
    60 => 'Kuidas soovid, et kommentaare näidatakse?',
    61 => 'Uuemad või vanemad enne',
    62 => 'Vaikimisi on 100',
    63 => "Sinu salasõna saadeti sulle E-postiga ja peaks kohe kohale jõudma. Palun järgi sõnumis olevaid juhendeid. Me täname sind {$_CONF['site_name']} kasutamise eest.",
    64 => 'Kommentaaride eelistused - kasutaja',
    65 => 'Proovi uuesti sisse logida',
    66 => "Võib-olla kirjutasid kasutajatunnuse või salasõna valesti. Palun proovi alloleva vormi abil uuesti. Või oled <a href=\"{$_CONF['site_url']}/users.php?mode=new\">uus kasutaja?</a>",
    67 => 'Liige alates',
    68 => 'Mäleta mind',
    69 => 'Kui kaua peale sisselogimist peaksin sind mäletama?',
    70 => "Kohanda {$_CONF['site_name']} sisu ja välimust",
    71 => "{$_CONF['site_name']} lehe üks headest omadustest on see, et sa võid määrata, millist sisu sulle näidatakse ja sa saad muuta lehe üldist välimust. Selle kasutamiseks pead sa kõigepealt <a href=\"{$_CONF['site_url']}/users.php?mode=new\">registreeruma</a> {$_CONF['site_name']} lehel.   Kui sa oled juba registreerinud, siis logi palun sisse.",
    72 => 'Teema',
    73 => 'Keel',
    74 => 'Saidi välimus',
    75 => 'Rubriigid E-postiga kasutajale',
    76 => 'Kui valid allpool olevast loetelust rubriigi, saadetakse päeva lõpus sulle kõik antud teemas postitatud lood. Vali ainult sind huvitavad teemad!',
    77 => 'Foto',
    78 => 'Lisa pilt endast!',
    79 => 'tee märge selle pilti kustutamiseks',
    80 => 'Logi sisse',
    81 => 'Saada E-kiri',
    82 => 'Viimased 10 lugu, postitajaks',
    83 => 'Postituste statistika, autor',
    84 => 'Artiklite koguarv:',
    85 => 'Kommentaaride koguarv:',
    86 => 'Leia kõik postitused - autoriks',
    87 => 'Sinu kasutajanimi',
    88 => "Keegi, võimalik, et sa ise, tellis {$_CONF['site_name']} lehel aadressiga {$_CONF['site_url']}\n\n asuva kasutajakonto \"%s\" jaoks uue salasõna. Kui sa soovid seda tõesti teha, siis kliki alloleval lingil või ava see leht oma veebilehitsejas:\n\n",
    89 => "Kui sa ei soovi salasõna vahetada, siis ignoreeri seda E-kirja ning salasõna vahetuse tellimus tühistatakse (sinu salasõna jääb muutmata)\n\n",
    90 => 'Sa võid allpool sisestada oma konto jaoks uue salasõna. Pane tähele, et vana salasõna on kehtiv kuni oled selle vormi täitnud ja uus salasõna on serveri poolt kinnitatud.',
    91 => 'Kinnita uus salasõna',
    92 => 'Sisesta uus salasõna',
    93 => 'Sinu viimane uue salasõna tellimine toimus %d sekundit tagasi. Sellel lehel peab aga salasõna tellimiste vahe olema vähemalt %d sekundit.',
    94 => 'Kustuta konto "%s"',
    95 => 'Oma kasutajakonto kustutamiseks klõpsa allpool nupul Kustuta konto. Pane tähele, et koos sellega ei kustutata selle kasutajakonto alt postitatud kommentaare ega jutte. Neid näidatakse edaspidi kui anonüümse kasutaja poolt postitatuid.',
    96 => 'kustuta konto',
    97 => 'Kinnita kasutajakonto kustutamine',
    98 => 'Kas oled kindel, et soovid oma kasutajakonto kustutada? Pärast kustutamist ei saa sa enam sellel lehel kasutajana sisse logida (kuni sa pole uut kasutajakontot loonud). Kui oled kindel, klõpsa uuesti allpool olevat nuppu "Kustuta konto"',
    99 => 'Privaatsusvalikud - kasutaja',
    100 => 'E-kiri administraatorilt',
    101 => 'Luba lehe administraatoritelt E-kirju',
    102 => 'E-kirjad kasutajatelt',
    103 => 'Luba teistelt kasutajatelt E-kirju',
    104 => 'Näita online staatust',
    105 => 'Näita "Kes on online" plokis',
    106 => 'Asukoht',
    107 => 'Näidatakse sinu avalikus profiilis',
    108 => 'Kontrolliks uus salasõna uuesti',
    109 => 'Kirjuta siia uuesti oma uus salasõna',
    110 => 'Praegune salasõna',
    111 => 'Palun sisesta oma praegune salasõna',
    112 => 'Liiga mitu järjestikust ebaõnnestunud sisselogimist. Palun proovi hiljem uuesti.',
    113 => 'Ebaõnnestunud sisselogimine',
    114 => 'Kontole on ligipääs tõkestatud',
    115 => 'Ligipääs sinu kasutajakontole on tõkestatud. Palun kontakteeru administraatoriga.',
    116 => 'Konto ootab aktiveerimist',
    117 => 'Sinu konto ootab hetkel administraatoripoolt aktiveerimist. Sa ei saa enne konto aktiveerimist sisse logida.',
    118 => "Sinu {$_CONF['site_name']} lehe konto on nüüd administraatori poolt aktiveeritud. Sa saad nüüd alloleval aadressil oma kasutajanime <username>) ja eelnevalt saadetud salasõnaga sisse logida.",
    119 => 'Kui sa unustasid oma salasõna võid tellida uue salasõna URL-ilt',
    120 => 'Konto on aktiveeritud',
    121 => 'Teenus',
    122 => 'Kahjuks on uute kasutajate registreerimine suletud',
    123 => "Kas sa oled <a href=\"{$_CONF['site_url']}/users.php?mode=new\">uus kasutaja?</a>",
    124 => 'Kinnita E-postiaadress',
    125 => 'Sa pead sisestama sama E-postiaadressi mõlemale väljale!',
    126 => 'Palun korda vigade vältimiseks',
    127 => 'Neist seadistustest ükskõik millise muutmiseks pead sa sisestama oma kehtiva salasõna.',
    128 => 'Sinu nimi',
    129 => 'Salasõna ja E-post',
    130 => 'Sinust',
    131 => 'Päeva kokkuvõttekirjade valikud',
    132 => 'Päeva kokkuvõttekirjade võimalused',
    133 => 'Kommentaaride näitamine',
    134 => 'Kommentaaride valikud',
    135 => '<li>Vaikimisi seatud kommentaaride näitamisviis</li><li>Kommentaaride sorteerimise vaikejärjekord</li><li>Sea kommentaaride maksimumarv, vaikimisi on 100</li>',
    136 => 'Arva välja rubriigid ja autorid',
    137 => 'Filtreeri lugusid',
    138 => 'Mitmesugused valikud',
    139 => 'Välimus ja keel',
    140 => '<li>Pole ikoone, Kui märgitud, ei näidata rubriikide ikoone</li><li>Pole kaste, kui märgitud näidatakse ainult Kasutaja valikuid, rubriike ja administraatoritele administraatori valikuid</li><li>Määra ühel lehel maksimaalselt näidatavate lugude arv</li><li>Määra kasutatava välimuse teema ja kuupäeva formaat</li>',
    141 => 'Privaatsusseadistused',
    142 => 'Vaikimisi on määratud, et kasutajad ja administraatorid võivad saata "lehekaaslastele" E-kirju ja lehel näidatakse kui sa oled online. Eemalda märked, et kaitsta oma privaatsust.',
    143 => 'Filtreeri kaste',
    144 => 'Näita/peida kaste',
    145 => 'Sinu avalik profiil',
    146 => 'Salasõna ja E-post',
    147 => 'Muuda oma salasõna, E-postiaadressi või autologimist. Salasõna ja E-postiaadressi muutmisel pead sa vigade vältimiseks sisestama need topelt.',
    148 => 'Kasutaja info',
    149 => "Muuda teistele kasutajatele nähtavat kasutaja infot. \n    <li>Allkiri lisatakse sinu kommentaaridele</li>\n    <li>Bio on lühike sinu kirjeldus teistele</li>\n    <li>Jaga oma PGP võtit</li>",
    150 => 'Märkus: mugavamaks kasutamiseks on soovitav JavaScript.',
    156 => 'Kustuta konto',
    157 => 'Kustutamisvalik',
    158 => 'Ajavöönd',
    159 => 'See E-kiri on automaatselt genereeritud . Palun ära vasta  sellele.',
    160 => '(maks. %d x %d pikslit, %d baiti; %s)',
    161 => 'Vähendatakse',
    162 => 'Ei vähendata',
    163 => 'Taasautoriseerimine ebaõnnestus',
    164 => 'Ületasid lubatud taasautoriseerimiste arvu. Tegevus on katkestatud ja viimati tehtud muutused läksid kahjuks kaduma.',
    165 => 'Kasuta keerukamat toimetajat'
);

###############################################################################
# Customize if need to modify the Tabbed navbar MyAccount panels used.
# Array index key matches preference div id

$LANG_MYACCOUNT = array(
    'pe_preview' => 'Eelvaade',
    'pe_namepass' => 'Kasutajanimi &amp; salasõna',
    'pe_userinfo' => 'Info sinust',
    'pe_layout' => 'Välimus &amp; keel',
    'pe_content' => 'Sisu',
    'pe_privacy' => 'Privaatsus'
);

###############################################################################
# index.php

$LANG05 = array(
    1 => 'Pole midagi näidata',
    2 => 'Pole midagi näidata. Võimalik, et selles rubriigis pole ühtegi lugu, mida näidata või on sinu kasutajaeelistused liiga kitsendavad, et näidata neid',
    3 => ' rubriigis %s',
    4 => 'Tänane peaartikkel',
    5 => 'Järgmine',
    6 => 'Eelmine',
    7 => 'Esimene',
    8 => 'Viimane'
);

###############################################################################
# profiles.php

$LANG08 = array(
    1 => 'Sinu kirja saatmisel tekkis viga. Palun proovi uuesti.',
    2 => 'Sõnum on edukalt saadetud.',
    3 => 'Palun veendu, et saatja E-postiaadressiks oleks toimiv E-postiaadress.',
    4 => 'Palun täida "Sinu nimi", "Sinu E-postiaadress", "Teema" ja sõnumi väljad.',
    5 => 'Viga: pole sellist kasutajat.',
    6 => 'Oli viga..',
    7 => 'Kasutajaprofiil, omanik ',
    8 => 'Kasutaja nimi',
    9 => 'Kasutaja URL',
    10 => 'Saada E-post, kirja saajaks',
    11 => 'Sinu nimi:',
    12 => 'Sinu E-postiaadress:',
    13 => 'Teema:',
    14 => 'Sõnum:',
    15 => 'HTML-i ei transleerita .',
    16 => 'Valmis',
    17 => 'Saada lugu sõbrale',
    18 => 'Saaja nimi',
    19 => 'E-postiaadress',
    20 => 'Saatja nimi',
    21 => 'Saatja E-postiaadress',
    22 => 'Kõik väljad on kohustuslikud',
    23 => "See E-kiri saadeti sulle %s %s poolt, sest ta arvas, et sa oled huvitatud artiklist {$_CONF['site_url']} lehel.  See ei ole rämpskiri. Antud kirjaga seotud E-postiaadresseid ei säilitata hilisemaks kasutamiseks!",
    24 => 'Kommenteeri seda lugu aadressil',
    25 => 'Selle võimaluse kasutamiseks pead sa lehele sisse logima. See nõue aitab meil kaitsta lehte väärkasutuste eest.',
    26 => 'Selle vormi abil saad saata E-kirja valitud inimesele. Kõik väljad on kohustuslikud.',
    27 => 'Lühike sõnum',
    28 => '%s kirjutas: ',
    29 => "See on päevane kokkuvõte {$_CONF['site_name']} lehelt kasutajale.",
    30 => 'Igapäevane uudiskiri kasutajale  ',
    31 => 'Tiitel',
    32 => 'Päev',
    33 => 'Loe kogu artiklit aadressil',
    34 => 'Sõnumi lõpp',
    35 => 'Kahjuks ei soovi see kasutaja kirju saada.',
    36 => 'Koopia:',
    37 => 'Saada mulle selle kirja koopia',
    38 => "See on koopia kirjast, mille saatsid %s-le lehelt aadressiga <{$_CONF['site_url']}>:"
);

###############################################################################
# search.php

$LANG09 = array(
    1 => 'Otsing',
    2 => 'Märksõnad',
    3 => 'Rubriik',
    4 => 'Kõik',
    5 => 'Tüüp',
    6 => 'Lood',
    7 => 'Kommentaarid',
    8 => 'Autorid',
    9 => 'Kõik',
    10 => 'Otsi',
    11 => 'Otsingu tulemused',
    12 => 'Sobivaid',
    13 => 'Otsingu tulemused: ei leitud sobivaid',
    14 => 'Ei leitud sobivat otsitavale',
    15 => 'Palun proovi uuesti.',
    16 => 'Tiitel',
    17 => 'päev',
    18 => 'Postitaja',
    19 => "Otsi kõigist {$_CONF['site_name']} praegustest ja eelmistest lugudest",
    20 => 'kuupäev',
    21 => 'kuni',
    22 => '(kuupäeva formaat AAAA-KK-PP)',
    23 => 'Vaatamisi',
    24 => 'Leidsin %d sobivat',
    25 => 'Otsiti',
    26 => 'asja ',
    27 => 'sekundit',
    28 => 'Ükski lugu ega kommentaar ei sobinud otsitavaga',
    29 => 'Lugude ja kommentaaride tulemus',
    30 => '',
    31 => 'See plugin ei leidnud sobivaid',
    32 => '',
    33 => 'URL',
    34 => 'Asukoht',
    35 => 'Kogu päev',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => 'Otsitav peab olema vähemalt 3 märki pikk',
    42 => 'Palun kasuta kuupäeva kujul AAAA-KK-PP(aasta-kuu-päev)',
    43 => 'täpne fraas',
    44 => 'Kõik need sõnad',
    45 => 'vähemalt üks neist sõnadest',
    46 => 'Järgmine',
    47 => 'Eelmine',
    48 => 'Autor',
    49 => 'Päev',
    50 => 'Klikke',
    51 => '',
    52 => 'Asukoht',
    53 => 'Lugude tulemus',
    54 => 'Kommentaaride tulemus',
    55 => 'fraasi',
    56 => 'JA',
    57 => 'VÕI',
    58 => 'Rohkem tulemusi &gt;&gt;',
    59 => 'Tulemused',
    60 => 'lehel',
    61 => ' täpsusta otsingut',
    62 => '#',
    63 => 'Kirjeldus',
    64 => 'Näitan %1$d - %2$d, kokku %3$d leitust',
    65 => 'Lugu',
    66 => 'Kommentaar',
    67 => 'Näita %d tulemust',
    68 => 'Sorteerimisalus',
    69 => 'Ainult pealkirjad',
    70 => 'Pole saadaval ...',
    71 => 'Kasv.',
    72 => 'kahan.'
);

###############################################################################
# stats.php

$LANG10 = array(
    1 => 'Lehe statistika',
    2 => 'Klikkide koguarv lehtedel',
    3 => 'Lugusid (kommentaare lehtedel',
    4 => '',
    5 => '',
    6 => '',
    7 => '10 enim vaadatud lugu',
    8 => 'Loo tiitel',
    9 => 'Vaatamisi',
    10 => 'Näib, et saidil pole ühtegi lugu või mitte keegi pole neid vaadanud.',
    11 => '10 enim kommenteeritud lugu',
    12 => 'Kommentaare',
    13 => 'Näib, et saidil pole ühtegi lugu või mitte keegi pole neile postitanud ühtegi kommentaari.',
    14 => '',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => '',
    22 => 'Top 10 E-postiga saadetud lugu',
    23 => 'E-kirju',
    24 => 'Näib, et mitte keegi pole saidil saatnud ühtegi lugu E-postiga.',
    25 => 'Top 10 trackback abil kommenteeritud lugu',
    26 => 'Ei leidnud trackback kommentaare.',
    27 => 'Aktiivseid kasutajaid',
    28 => '',
    29 => '',
    30 => 'Klikke',
    31 => ''
);

###############################################################################
# article.php

$LANG11 = array(
    1 => 'Seotud',
    2 => 'Saada lugu sõbrale',
    3 => 'Lugu prinditaval kujul',
    4 => 'Loo valikud',
    5 => '',
    6 => 'Telli \'%s\''
);

###############################################################################
# submit.php

$LANG12 = array(
    1 => 'Selleks et lisada %s pead sa kasutajana sisse logima.',
    2 => 'Logi sisse',
    3 => 'Uus kasutaja',
    4 => '',
    5 => '',
    6 => 'Lisa lugu',
    7 => 'Nõutav on sisselogimine',
    8 => 'Sisesta',
    9 => "Kui lisad meie saidile uut infot, palume järgida järgmisi soovitusi . . .\n    <ul><li>Täida kõik väljad, mis on kohustuslikud</li>\n    <li>Anna täielik ja täpne info</li>\n    <li>Kontrolli hoolikalt kirjutatud URL-id (veebiaadressid)</li></ul>",
    10 => 'Tiitel',
    11 => '',
    12 => 'Alguskuupäev',
    13 => 'Lõpukuupäev',
    14 => 'Asukoht',
    15 => 'Kirjeldus',
    16 => '',
    17 => '',
    18 => '',
    19 => 'Loe enne',
    20 => '',
    21 => '',
    22 => 'Viga: puuduvad väljad',
    23 => 'Palun täida kõik vormi väljad. Kõik väljad on kohustuslikud.',
    24 => 'Sisestus on salvestatud',
    25 => 'Sinu sisestatud %s on edukalt salvestatud.',
    26 => 'Kiiruse piirang',
    27 => 'Kasutajanimi',
    28 => 'Rubriik',
    29 => 'Lugu',
    30 => 'Sinu viimane postitus oli',
    31 => " sekundit tagasi.  Sellel lehel   peab sisestuste vahe olema vähemalt {$_CONF['speedlimit']} sekundit.",
    32 => 'Eelvaade',
    33 => 'Loo eelvaade',
    34 => 'Logi välja',
    35 => 'HTML sildid pole lubatud',
    36 => 'Postituse tüüp',
    37 => '',
    38 => '',
    39 => '',
    40 => '',
    41 => '',
    42 => '',
    43 => '',
    44 => 'aadressrida 1',
    45 => 'aadressrida 2',
    46 => 'linn',
    47 => 'Piirkond',
    48 => 'postiindeks',
    49 => '',
    50 => '',
    51 => 'Asukoht',
    52 => 'Kustuta',
    53 => 'Tee konto',
    54 => 'Loo kokkuvõte',
    55 => 'Loo sisu'
);

###############################################################################
# ADMIN PHRASES - These are file phrases used in admin scripts
###############################################################################

###############################################################################
# admin/auth.inc.php

$LANG20 = array(
    1 => 'Nõutav on autoriseerimine',
    2 => 'Tõkestatud! Ebakorrektne info logimisel',
    3 => 'vigane salasõna, kasutajanimi',
    4 => 'Kasutajanimi:',
    5 => 'Salasõna:',
    6 => 'Kõik katsed pääseda ligi selle lehe administreerimisosadele logitakse ja vaadatakse läbi. <br >See leht on mõeldud ainult autoriseeritud kasutajatele.',
    7 => 'logi sisse'
);

###############################################################################
# admin/block.php

$LANG21 = array(
    1 => 'Ebapiisavalt administreerimisõiguseid',
    2 => 'Sul ei ole piisavalt õigusi selle ploki toimetamiseks.',
    3 => 'Ploki toimetaja',
    4 => 'Tekkis probleem selle lõime lugemisel. Täpsemalt loe error.log failist.',
    5 => '',
    6 => '',
    7 => 'Kõik',
    8 => 'Ploki turvatase',
    9 => 'Ploki järjekord',
    10 => '',
    11 => 'Portaalplokk',
    12 => 'Normaalplokk',
    13 => 'Portaalploki valikud',
    14 => 'RSS URL',
    15 => 'Viimane RSS uuendus',
    16 => 'Normaalploki valikud',
    17 => 'Ploki sisu',
    18 => 'Palun täida ploki tiitli ja sisu väljad',
    19 => 'Ploki haldur',
    20 => '',
    21 => 'Ploki turva..',
    22 => '',
    23 => 'Ploki järjekord',
    24 => '',
    25 => 'Ploki toimetamiseks või kustutamiseks klõpsa allpool selle tiitlil. Uue ploki loomiseks klõpsa Tee uus ülal.',
    26 => 'Kujundusplokk',
    27 => 'PHP plokk',
    28 => 'PHP ploki valikud',
    29 => 'Ploki funktsioon',
    30 => 'Kui sa soovid oma plokis kasutada PHP käske, sisesta allolevasse kasti PHP funktsiooni nimi. See peab algama eesliitega "phpblock_" (n. phpblock_getweather). Ilma selle eesliiteta funktsiooni ei käivitata. Me oleme lisanud selle kitsenduse kaitsmaks sinu saiti juhuks, kui keegi on sellele sisse häkkinud ja lisanud lehe koodi kontrollimata käske. Jälgi, et sa ei lisaks funktsiooni nime lõppu sulge "()". On soovitav panna oma PHP plokkide jaoks mõeldud funktsioonid faili /path/to/geeklog/system/lib-custom.php. See lubab säilitada lisatud PHP blockide funktsioonid ka Geeklogi uuendamisel.',
    31 => 'Viga PHP plokis.  Funktsiooni %s pole olemas.',
    32 => 'Viga: puuduvad väljad',
    33 => 'Sa pead portaalploki jaoks sisestama RSS faili URL-i.',
    34 => 'Sa pead sisestama PHP ploki tiitli ja funktsiooni',
    35 => 'Sa pead normaalploki jaoks sisestama tiitli ja sisu',
    36 => 'Sa pead kujundusplokkide jaoks sisestama ploki sisu',
    37 => 'Sobimatu PHP ploki funktsiooni nimi',
    38 => 'PHP plokkide jaoks mõeldud funktsioonid peavad algama \'phpblock_\' (n. phpblock_getweather).  \'phpblock_\' algus on kasutuses turvakaalutlustel, takistamaks kontrollimata koodi käivitamist',
    39 => 'Külg',
    40 => 'Vasak',
    41 => 'Parem',
    42 => 'Sa pead Geeklogi vaikeplokkide jaoks sisestama ploki tiitli ja järjekorra.',
    43 => 'Ainult avaleht',
    44 => '',
    45 => "Sa üritasid ligi pääseda plokile, milleks polnud sul õigust. See katse logiti. Palun <a href=\"{$_CONF['site_admin_url']}/block.php\">mine tagasi plokkide administreerimislehele. </a>",
    46 => 'Uus plokk',
    47 => '',
    48 => 'Ploki nimi',
    49 => ' (ilma tühikuteta ja erinev teistest)',
    50 => 'Ploki nimi ei tohi olla tühi',
    51 => 'koos http://',
    52 => 'Kui sa jätad selle välja tühjaks, siis selle ploki jaoks ei näidata abiikooni.',
    53 => 'kasutuses',
    54 => 'salvesta',
    55 => 'tühista',
    56 => 'kustuta',
    57 => 'vii allapoole',
    58 => 'Vii ülespoole',
    59 => 'Vii plokk paremale',
    60 => 'Vii plokk vasakule',
    61 => 'Pole tiitlit',
    62 => 'Artikli limiit',
    63 => 'Sobimatu ploki tiitel',
    64 => 'Tiitel peab olema ja ei tohi sisaldada HTML-i!',
    65 => 'Järjekord',
    66 => 'Autosildid',
    67 => 'Autosiltide lubamiseks tee märge',
    68 => 'See lõim on antud portaalplokis näitamiseks liiga pikk.  Palun määra plokihalduslehel imporditavate  artiklite maksimum kas antud portaalploki jaoks või  siis üldine Geeklogi maksimum.'
);

###############################################################################
# admin/story.php

$LANG24 = array(
    1 => 'Eelmised lood',
    2 => 'Järgmised lood',
    3 => 'laad',
    4 => 'Postituse viis',
    5 => 'Lugude toimetaja',
    6 => 'Süsteemis pole lugusid',
    7 => 'Autor',
    8 => 'Salvesta',
    9 => 'eelvaade',
    10 => 'tühista',
    11 => 'kustuta',
    12 => 'ID',
    13 => '',
    14 => '',
    15 => 'Päev',
    16 => 'Tutvustustekst',
    17 => 'Sisutekst',
    18 => 'Klikke',
    19 => 'Kommentaare',
    20 => 'Ping',
    21 => 'Saada Ping',
    22 => 'Lugude nimekiri',
    23 => 'Loo toimetamiseks või kustutamiseks klõpsa allpool loo numbril. Loo vaatamiseks klõpsa selle tiitlil. Uue loo tegemiseks klõpsa Tee uus ülal.',
    24 => 'Loo jaoks valitud ID on juba kasutuses. Palun vali loo jaoks teine ID.',
    25 => 'Viga loo salvestamisel',
    26 => 'Loo eelvaade',
    27 => '<p>Kui sa kasutad [unscaledX] [imageX] asemel, lisatakse pilt originaalmõõtmetes.</p>',
    28 => '<p><b>EELVAADE</b>: Pilte sisaldava loo eelvaateks on parem eelvaate nupu klõpsamise asemel  salvestada see mustandina.  Kasuta eelvaate nuppu ainult  siis kui pilte pole lisatud.</p>',
    29 => 'Trackbackid',
    30 => 'Faili üleslaadimise vead',
    31 => 'Palun täida loo tiitli ja tutvustusteksti väljad',
    32 => 'Pealugu',
    33 => 'Korraga saab olla vaid üks pealugu',
    34 => 'Mustand',
    35 => 'Ja',
    36 => 'Ei',
    37 => 'Rohkem postitajalt',
    38 => 'Rohkem rubriigis',
    39 => 'E-kirju',
    40 => '',
    41 => "Sa proovisid ligi pääseda loole, millele pole sul õigust. See katse on logitud. Sa võid vaadata seda artiklit allpool ainult loetaval kujul. Palun <a href=\"{$_CONF['site_admin_url']}/story.php\">mine pärast lugemist tagasi lugude administreerimislehele. </a>",
    42 => "Sa proovisid ligi pääseda loole, millele pole sul õigust. See katse on logitud. Palun <a href=\"{$_CONF['site_admin_url']}/story.php\">mine tagasi lugude administreerimislehele. </a>",
    43 => '',
    44 => '',
    45 => '',
    46 => '<b>MÄRKUS:</b> Kui sa määrad selle kuupäeva tulevikku, siis seda artiklit ei avaldata enne seda päeva. See tähendab ka seda, et seda artiklit ei lisata varem sinu RSS voogu ja seda ignoreeritakse otsingu ja statistika lehtede poolt.',
    47 => 'Pildid',
    48 => 'pilt',
    49 => 'parem',
    50 => 'vasak',
    51 => 'Loosse lisatud piltide lehel nähtavaks tegemiseks pead sa teksti kirjutama spetsiaalsed tähistused. Need tähistused on kujul: [imageX], [imageX_right] või [imageX_left], kus tähe X asemele tuleb panna lisatava pildi järjenumber. Märkus: sa pead iga lisatud pildi jaoks kirjutama vastava tähistuse. Kui sa ei määra laetud piltidele asukohta, ei saa sa lugu salvestada. <p><b>Eelvaade</b>: Piltidega loo puhul on Eelvaate nupul klõpsamise asemel parem lugu salvestada mustandina. Kasuta eelvaate nuppu vaid siis, kui loos pole pilte.',
    52 => '',
    53 => 'pole kasutuses. Sa pead enne muudatuste salvestamist lisama selle pildi kas tutvustusteksti või sisu teksti.',
    54 => 'Lisatud pildid pole kasutuses',
    55 => 'Loo salvestamisel tekkisid järgmised vead. Palun paranda need enne loo salvestamist',
    56 => 'Näita rubriigi ikooni',
    57 => 'Vaata originaalsuuruses pilti',
    58 => 'Lugude haldamine',
    59 => 'Valik',
    60 => '',
    61 => 'Autoarhiiv',
    62 => 'Autokustuta',
    63 => 'Keela kommentaarid',
    64 => '',
    65 => '',
    66 => '',
    67 => 'Laienda sisu toimetamise ala suurust',
    68 => 'Vähenda sisu toimetamise ala suurust',
    69 => 'Loo avaldamise aeg',
    70 => 'Tööriistariba valik',
    71 => 'Lihtne tööriistariba',
    72 => 'Harilik tööriistariba',
    73 => 'Suur tööriistariba',
    74 => 'Suur II tööriistariba',
    75 => 'Täis põhilugu',
    76 => 'Avaldamise valikud',
    77 => 'Keerukama toimetaja jaoks peab lubatud olema JavaScript. Valiku saab välja lülitada saidi seadistuslehel.',
    78 => '<a href="%s/story.php?mode=edit&sid=%s&editopt=default">vaiketoimetaja kasutamiseks klõpsa siia</a>',
    79 => 'Eelvaade',
    80 => 'Toimetaja',
    81 => 'Avaldamisvalikud',
    82 => 'Pildid',
    83 => 'Arhiveerimisvalikud',
    84 => 'Õigused',
    85 => 'Näita kõik',
    86 => 'Keerukam toimetaja',
    87 => 'Lugude statistika',
    88 => 'Wiki-laadne formaat',
    89 => 'Meta kirjeldus',
    90 => 'Meta märksõnad',
    91 => 'Sa võid alati klõpsata "Eelvaade", et aegumisaega pikendada.'
);

###############################################################################
# admin/topic.php

$LANG27 = array(
    1 => 'Rubriikide toimetaja',
    2 => 'Rubriigi ID',
    3 => 'Rubriigi nimi',
    4 => 'Rubriigi pilt',
    5 => '(ära kasuta tühikuid)',
    6 => 'Kustutades rubriigi, kustutatakse ka kõik sellega seotud lood ja plokid.',
    7 => 'Palun täida rubriigi ID ja kirjelduse väljad',
    8 => 'Rubriikide haldaja',
    9 => 'Rubriigi toimetamiseks või kustutamiseks klõpsa selle nimel. Uue rubriigi lisamiseks klõpsa Tee uus ülal. Sa näed iga rubriigi kõrval sulgudes antud rubriigi jaoks oma ligipääsuõiguseid. Tärn (*) märgib vaikimisi valitud rubriiki.',
    10 => 'Sorteerimise järjekord',
    11 => 'Lugusid lehel',
    12 => 'Ligipääs tõkestatud',
    13 => "Sa proovisid pääseda ligi rubriigile, milleks polnud sul õigust. See ligipääsukatse on logitud. Palun <a href=\"{$_CONF['site_admin_url']}/topic.php\">mine tagasi rubriikide administreerimislehele. </a>",
    14 => 'Sorteerimismeetod',
    15 => 'tähestikuline',
    16 => 'vaikimisi',
    17 => 'Uus rubriik',
    18 => 'Admin avaleht',
    19 => 'salvesta',
    20 => 'tühista',
    21 => 'kustuta',
    22 => 'Vaikimisi',
    23 => 'Määra see uute lugude jaoks vaikerubriigiks',
    24 => '(*)',
    25 => 'Arhiivi rubriik',
    26 => 'määra see rubriik arhiveeritud lugude  jaoks vaikerubriigiks. Ainult üks rubriik on lubatud.',
    27 => 'või lae rubriigi ikoon',
    28 => 'Maksimum',
    29 => 'Vead faili üleslaadimisel',
    30 => 'Lood rubriikides'
);

###############################################################################
# admin/user.php

$LANG28 = array(
    1 => 'Kasutajate toimetaja',
    2 => 'Kasutaja ID',
    3 => 'kasutaja nimi',
    4 => 'Täisnimi',
    5 => 'Salasõna',
    6 => 'Turvatase',
    7 => 'E-postiaadress',
    8 => 'Koduleht',
    9 => '(ära kasuta tühikuid)',
    10 => 'Palun täida kasutajanime ja E-postiaadressi väljad',
    11 => 'Kasutajate haldur',
    12 => 'Kasutaja andmete toimetamiseks või konto kustutamiseks klõpsa allpool soovitud kasutajal. Uue kasutajakonto loomiseks klõpsa ülal Tee uus. Võid teha kasutajate lihtotsingut sisestades otsingukasti osa nende kasutajanimest, E-postiaadressist või täisnimest (näiteks: mart* või *.com).',
    13 => 'Turva..',
    14 => 'Reg. aeg',
    15 => '',
    16 => '',
    17 => '',
    18 => '',
    19 => '',
    20 => 'salvesta',
    21 => 'See kasutajanimi on juba olemas',
    22 => 'Viga',
    23 => 'Masslisamine',
    24 => 'Mass kasutajate importimine',
    25 => 'Sa võid Geeklogi importida korraga mitu kasutajat. Imporditavas tekstifailis peab väljade eraldajaks olema tabulaator ja selles peavad väljad olema järgmises järjekorras: täisnimi, kasutajanimi, E-postiaadress. Igale imporditud kasutajale saadetakse E-postiga salasõnageneraatoriga genereeritud juhuslik salasõna. Ühel real tohib olla vaid täpselt üks kasutaja. Selle reegli rikkumine toob kaasa probleeme, mille kõrvaldamine nõuab lehe käsitsi häälestamist, nii et kontrolli hoolikalt ja mitu korda imporditava faili sissekandeid!',
    26 => '',
    27 => '',
    28 => 'Pildi kustutamiseks märgi see',
    29 => 'tee',
    30 => 'Import',
    31 => 'Uued kasutajad',
    32 => 'Töötlus lõpetatud. Imporditi %d ja oli %d tõrget',
    33 => 'sisesta',
    34 => 'Viga: pead määrama laetava faili.',
    35 => 'Viimati logitud',
    36 => '(pole)',
    37 => 'UID',
    38 => 'Gruppide nimekiri',
    39 => 'salasõna (uuesti)',
    40 => 'Registreerimise aeg',
    41 => 'Viimane sisenemisaeg',
    42 => 'Blokeeritud',
    43 => 'Ootab aktiveerimist',
    44 => 'Ootab autoriseerimist',
    45 => 'Aktiivne',
    46 => 'Kasutaja staatus',
    47 => 'Toimeta',
    48 => 'Näita administreerimisgruppe',
    49 => 'Administreerimisgrupp',
    50 => 'Märgi, et seda gruppi filtreeritaks administreerimisgrupina',
    51 => 'Online päevad',
    52 => '<brMärkus: Online päevad on päevade arv  registreerimisest viimase sisselogimiseni.',
    53 => 'registreeritud',
    54 => 'Masskustutamine',
    55 => 'See töötab vaid siis kui sul on config.php failis <code>$_CONF[\'lastlogin\'] = true;</code>',
    56 => 'Palun vali kasutajate rühm, mida soovid kustutada ja klõpsa seejärel "Uuenda loetelu". Avanenud lehel  eemalda märge nende kasutajate eest, keda sa ei soovi kustutada ning vajuta "Kustuta". Pane tähele, et kui kasutajate loetelu on jaotatud mitmele lehele, kustutad sa ainult neid kasutajaid, mis on antud lehel nähtaval.',
    57 => 'Fantoomkasutajad',
    58 => 'Lühiaegsed kasutajad',
    59 => 'Vanad kasutajad',
    60 => 'Kasutajad, kes on registreerunud rohkem kui',
    61 => ' kuud tagasi kuid pole kunagi sisse loginud.',
    62 => 'Kasutajad, kes on registreerunud rohkem kui ',
    63 => ' kuud tagasi, seejärel loginud sisse 24 tunni jooksul kuid pole pärast seda enam kordagi sinu lehele naasnud.',
    64 => 'Tavalised kasutajad, kes lihtsalt pole sinu lehele tulnud juba ',
    65 => ' kuud.',
    66 => 'Uuenda loetelu',
    67 => 'Kuud registreerimisest',
    68 => 'Online tunde',
    69 => 'Offline kuud',
    70 => 'Ei kustutatud',
    71 => 'Edukalt kustutatud',
    72 => 'Kustutamiseks pole ühtegi kasutajat valitud',
    73 => 'Kas sa oled kindel, et soovid lõplikult kustutada kõik valitud kasutajad?',
    74 => 'Viimased registreerunud',
    75 => 'Kasutajad, kes on viimati registreerunud ',
    76 => ' kuud',
    77 => 'Saada valitud kasutajatele E-kiri lehele logimise meeldetuletusega',
    78 => 'Saada meeldetuletus',
    79 => 'Meeldetuletuste jaoks pole valitud kasutajaid',
    80 => 'Meeldetuletused edukalt saadetud',
    81 => 'Meeldetuletus konto %s kontrollimiseks',
    82 => "Sinu kontot {$_CONF['site_name']}  lehel pole kasutatud %s alates ning see suletakse , kui seda ei kasutata ka järgmise 30 päeva jooksul.",
    83 => "Sinu kontot {$_CONF['site_name']} lehel pole selle tegemisest alates kasutatud ja see kustutatakse peatselt, kui seda kohe ei kasutata.",
    84 => "Meie lehel: {$_CONF['site_url']} on sinu kasutajanimi  : %s",
    85 => 'Kui unustasid oma salasõna, kasuta järgmist linki: %s',
    86 => 'Lisa',
    87 => 'Meeldetuletused',
    88 => 'Vaikegrupp',
    89 => 'Märgi, et teha sellest uute kasutajate jaoks vaikegrupp',
    90 => 'Rakenda muutunud "Vaikegrupp" olemasolevatele kasutajakontodele'
);

###############################################################################
# admin/moderation.php

$LANG29 = array(
    1 => 'Kinnita',
    2 => 'Kustuta',
    3 => 'Toimeta',
    4 => 'Profiil',
    10 => 'Tiitel',
    11 => 'Alguspäev',
    12 => 'URL',
    13 => 'Kategooria',
    14 => 'Päev',
    15 => 'Rubriik',
    16 => 'Kasutajanimi',
    17 => 'Täisnimi',
    18 => 'E-post',
    34 => 'Kontrolli ja otsusta',
    35 => 'Sisestatud lood',
    36 => 'Parent or Comment', /* tõlgi */
    37 => '',
    38 => 'Sisesta',
    39 => 'Hetkel pole ülevaatamist (modereerimist) vajavaid sisestusi.',
    40 => 'Kasutajate sisestused',
    41 => 'Kommentaaride sisestused',
    42 => 'Kasutaja nimi',
    43 => 'Auto-publitseeri kommentaarid?'
);

###############################################################################
# admin/mail.php

$LANG31 = array(
    1 => "{$_CONF['site_name']} E-posti tööriist",
    2 => 'Kellelt',
    3 => 'Vasta',
    4 => 'Teema',
    5 => 'Sisu',
    6 => 'Saada :',
    7 => 'Kõik kasutajad',
    8 => 'Administraator',
    9 => 'Valikud',
    10 => 'HTML',
    11 => 'Oluline teade!',
    12 => 'Saada',
    13 => 'Puhasta',
    14 => 'Ignoreeri kasutaja seadistusi',
    15 => 'Viga saatmisel: ',
    16 => 'Edukalt saadetud: ',
    17 => "<a href={$_CONF['site_admin_url']}/mail.php>Saada järgmine kiri</a>",
    18 => 'Kellele',
    19 => 'Kui soovid saata kirja kõigile registreeritud kasutajatele, vali valikukastist Logged-in kasutajagrupp.',
    20 => "Edukalt saadetud <successcount> sõnumit ja ebaõnnestus saata <failcount> sõnumit.  Kui sa vajad iga sõnumi kohta detailset infot, siis leiad selle info allpool. Kuid sa võid <a href=\"{$_CONF['site_admin_url']}/mail.php\">saata järgmise sõnumi</a> või võid <a href=\"{$_CONF['site_admin_url']}/moderation.php\">mine tagasi administreerimislehele. </a>",
    21 => 'Tõrked',
    22 => 'Edukalt',
    23 => 'Polnud tõrkeid',
    24 => 'Polnud õnnestunuid',
    25 => '-- Vali grupp --',
    26 => 'Palun täida kõik väljad ja vali valikukastist kasutajate grupp.'
);

###############################################################################
# admin/plugins.php

$LANG32 = array(
    1 => 'Pluginate installeerimine võib kahjustada sinu Geeklogi installatsiooni ja lisaks kahjustada ka sinu süsteemi. On oluline, et sa installeeriksid vaid <a href="http://www.geeklog.net">Geeklogi kodulehelt</a> laetud pluginaid, sest me kontrollime hoolikalt meie lehele laetud pluginaid erinevates operatsioonisüsteemides. On oluline mõista, et plugina installeerimine nõuab mitmete süsteemikäskude kasutamist, mis võib kaasa tuua turvalisusprobleeme, eriti siis, kui sa kasutad kolmandatelt lehtedelt laetud pluginaid. Sellest hoiatusest hoolimata ei taga me plugina installeerimise edukust ega vastuta selle installeerimise tagajärjena põhjustatud kahju eest. Teiste sõnadega - installeeri oma vastutusel. Lisaks on iga plugina paketi juures juhend, kuidas installeerida plugin käsitsi.',
    2 => 'Plug-ina installeerimise disklaimer',
    3 => 'Plugina installeerimisvorm',
    4 => 'Plugina fail',
    5 => 'Pluginate loetelu',
    6 => 'Hoiatus, plugin on juba installeeritud!',
    7 => 'Plugin, mida sa soovid installeerida, on juba installeeritud. Palun kustuta see plugin enne taasinstalleerimist.',
    8 => 'Plugina sobivuse kontroll  ebaõnnestus',
    9 => 'See plugin vajab uuemat Geeklogi versiooni. Kas uuenda <a href="http://www.geeklog.net">Geeklog</a> või hangi plugina sobiv versioon.',
    10 => "<br" . XHTML . "><b>Hetkel pole installeeritud ühtegi pluginat.</b>\n    <br" . XHTML . "><br" . XHTML . ">",
    11 => 'Plugina muutmiseks või kustutamiseks klõpsa allpool selle nimel. Sulle näidatakse plugina kohta täpsemat infot koos autori veebilehe aadressiga. Näidatakse nii installeeritud versiooni numbrit kui ka plugina koodist saadud plugina versioon. Selle põhjal saad otsustada, kas plugin vajab uuendamist või mitte. Plugina installeerimise või uuendamise kohta loe täpsemalt plugina dokumentatsioonist.',
    12 => 'pluginitor () ei saanud plugina nime',
    13 => 'Plugina toimetaja',
    14 => 'Uus plugin',
    15 => 'Admin avaleht',
    16 => 'Plugina nimi',
    17 => 'Plugina versioon',
    18 => 'Geeklogi versioon',
    19 => 'Kasutuses',
    20 => 'Ja',
    21 => 'Ei',
    22 => 'Installeeri',
    23 => 'Salvesta',
    24 => 'Tühista',
    25 => 'Kustuta',
    26 => 'Plugina nimi',
    27 => 'Plugina koduleht',
    28 => 'Installeeritud versioonid',
    29 => 'Geeklogi versioon',
    30 => 'Kustuta plugin?',
    31 => 'Kas sa oled kindel, et soovid  kustutada  selle plugina?  Jätkates kustutad sa ka kõik selle pluginaga seotud andmed ja andmestruktuurid. Kui sa oled kindel, siis klõpsa uuesti allpool "kustuta" nuppu.',
    32 => '<p><b>Viga: AutoLink silt on ebakorrektse formaadiga</b></p>',
    33 => 'Koodi versioon',
    34 => 'Uuenda',
    35 => 'Toimeta',
    36 => 'Kood',
    37 => 'andmed',
    38 => 'Uuenda!',
    39 => 'Lae plugin',
    40 => 'Sa võid otse siin laadida plugina arhiivi (.tar.gz, .tgz, .zip):',
    41 => 'Lae ülesse',
    42 => 'Kliki uuendamiseks',
    99 => 'Oli tundmatu viga',
    100 => 'OK.',
    101 => 'Ülesse laetud faili suurus ületab php.ini failis oleva upload_max_filesize direktiivi.',
    102 => 'Ülesse laetud faili suurus ületab HTML vormis määratud MAX_FILE_SIZE direktiivi.',
    103 => 'Ülesse laetud fail laeti ülesse vaid osaliselt.',
    104 => 'Faili ei laetud ülesse.',
    105 => '(defineerimata viga)',
    106 => 'Puudub temp kaust.',
    107 => 'Faili kettale kirjutamine ebaõnnestus.',
    108 => 'Faili üleslaadimine peatatud laienduse poolt.'
);

###############################################################################
# admin/syndication.php

$LANG33 = array(
    1 => 'loo lõim',
    2 => 'salvesta',
    3 => 'kustuta',
    4 => 'tühista',
    10 => 'Sisu jagamine',
    11 => 'Uus lõim',
    12 => 'Admin avaleht',
    13 => 'Lõime toimetamiseks või kustutamiseks klõpsa allpool selle nimel. Uue lõime loomiseks klõpsa Tee uus ülalpool.',
    14 => 'Tiitel',
    15 => 'Tüüp',
    16 => 'Faili nimi',
    17 => 'Formaat',
    18 => 'viimati uuendatud',
    19 => 'Kasutuses',
    20 => 'Ja',
    21 => 'Ei',
    22 => '<i>(pole lõimi)</i>',
    23 => 'kõik lood',
    24 => 'Lõime toimetaja',
    25 => 'Lõime tiitel',
    26 => 'Limiit',
    27 => 'Kannete pikkus',
    28 => '(0 = pole  teksti, 1 = täistekst, muu = piira antud märkide arvuni.)',
    29 => 'Kirjeldus',
    30 => 'Viimane uuendus',
    31 => 'kooditabel',
    32 => 'Keel',
    33 => 'Sisu',
    34 => 'Kanded',
    35 => 'tundi',
    36 => 'Vali lõime tüüp',
    37 => '',
    38 => 'Viga: puuduvad väljad',
    39 => 'Palun täida lõime tiitli, kirjelduse ja faili nime väljad.',
    40 => 'Palun sisesta lugude  või tundide arv.',
    41 => 'Sisesta',
    42 => '',
    43 => 'Igas rubriigis.',
    44 => 'Mitte üheski.',
    45 => 'Rubriigi lehepäises on link?',
    46 => 'Piira tulemused',
    47 => 'Otsi',
    48 => 'Toimeta',
    49 => 'Lõime logo',
    50 => "Suhteline saidi urli suhtes ({$_CONF['site_url']})",
    51 => 'Sinu valitud lõimefailinimi on juba teise lõime kasutuses. Palun vali teine nimi.',
    52 => 'Viga: failinimi on juba kasutusel',
    53 => 'Kõik avalehe lood',
    54 => 'Valige loodava lõime tüüp.',
    55 => 'Artiklid'
);

###############################################################################
# confirmation and error messages

$MESSAGE = array(
    1 => "Sinu salasõna saadeti sulle E-postiga ja peaks kohe kohale jõudma. Palun järgi kirjas olevaid juhiseid. Me täname sind {$_CONF['site_name']} lehe kasutamise eest",
    2 => "Täname sind {$_CONF['site_name']} lehele loo sisestamise eest. See saadeti meie meeskonnale kinnitamiseks. Pärast meie lehe meeskonna poolset kinnitamist saavad kõik seda meie lehel lugeda.",
    3 => '',
    4 => '',
    5 => 'Sinu konto info on edukalt salvestatud.',
    6 => 'Sinu eelistused on edukalt salvestatud.',
    7 => 'Sinu kommentaaride eelistused on edukalt salvestatud.',
    8 => 'Sa oled edukalt välja logitud.',
    9 => 'Sinu lugu on edukalt salvestatud.',
    10 => 'Lugu on edukalt kustutatud.',
    11 => 'Sinu plokk on edukalt salvestatud.',
    12 => 'Plokk on edukalt kustutatud.',
    13 => 'Rubriik on edukalt salvestatud.',
    14 => 'Rubriik ja kõik sellega seotud lood ja plokid on edukalt kustutatud.',
    15 => 'Sinu kommentaar saadeti läbivaatamiseks. See avaldatakse lehel peale moderaatoripoolset kinnitamist.',
    16 => 'Sinu tellimus lõpetati. Sind ei teavitata enam uutest vastustest.',
    17 => '',
    18 => '',
    19 => '',
    20 => '',
    21 => 'Kasutaja on edukalt salvestatud.',
    22 => 'Kasutaja on edukalt kustutatud.',
    23 => '',
    24 => '',
    25 => '',
    26 => '',
    27 => 'Sõnum on edukalt saadetud.',
    28 => 'plugin on edukalt salvestatud',
    29 => 'Sul ei ole sellele administreerimislehele ligipääsu.  Pane tähele, et kõik katsed pääseda autoriseerimata ligi administreerimislehtedele, logitakse',
    30 => 'Ligipääs tõkestatud',
    31 => '',
    32 => '',
    33 => '',
    34 => '',
    35 => '',
    36 => '',
    37 => '',
    38 => '',
    39 => '',
    40 => 'Süsteemi teade',
    41 => '',
    42 => '',
    43 => '',
    44 => 'Plugin on edukalt installeeritud!',
    45 => 'Plugin on edukalt kustutatud.',
    46 => '',
    47 => '',
    48 => "Täname sind oma liikmelisuse kinnitamise eest {$_CONF['site_name']} lehel. Meie meeskond vaatab sinu taotluse läbi. Kui see kinnitatakse, saadetakse sinu poolt sisestatud E-postiaadressile sinu salasõna.",
    49 => 'Grupp on edukalt salvestatud.',
    50 => 'Grupp on edukalt kustutatud.',
    51 => 'See kasutajanimi on juba kasutuses. Palun vali mõni teine.',
    52 => 'Sisestatud E-postiaadress tundub olevat ebakorrektne.',
    53 => 'Sinu uus salasõna on aktsepteeritud. Palun logi uut salasõna kasutades allpool oleva vormi kaudu sisse.',
    54 => 'Sinu tellimus uue salasõna saamiseks on aegunud. Palun proovi alloleva vormi abil uuesti.',
    55 => 'Sulle saadeti E-kiri, mis peaks kohe sinu postkasti jõudma. Uue salasõna määramiseks järgi selles olevaid juhiseid.',
    56 => 'Sisestatud E-postiaadress on juba kasutuses teises kasutajakontos.',
    57 => 'Sinu kasutajakonto on edukalt kustutatud.',
    58 => 'Lõim on edukalt salvestatud.',
    59 => 'Lõim on edukalt kustutatud.',
    60 => 'Plugin on edukalt uuendatud.',
    61 => 'Plugin %s: Tundmatu teate järjenumber',
    62 => 'Trackback kommentaar on kustutatud.',
    63 => 'Trackback kommentaari kustutamisel tekkis viga.',
    64 => 'Sinu trackback kommentaar on edukalt saadetud.',
    65 => 'Veebilogi kataloogi teenus on edukalt salvestatud.',
    66 => 'See Veebilogi kataloogi teenus on kustutatud.',
    67 => 'Uus salasõna ei kattu kontrolliks sisestatud teise salasõnaga!',
    68 => 'Sa pead sisestama praeguse kehtiva salasõna.',
    69 => 'Sinu kasutajakonto on blokeeritud!',
    70 => 'Sinu konto ootab administraatori kinnitust.',
    71 => 'Sinu kasutajakonto loomise soov on nüüd kinnitatud ja ootab administraatoripoolset kinnitamist.',
    72 => 'Plugina installeerimisel tekkis viga. Täpsemalt vaata error.log failist.',
    73 => 'Plugina eemaldamisel tekkis viga. Täpsemalt vaata error.log failist.',
    74 => 'Pingback on edukalt saadetud.',
    75 => 'Trackbackid tuleb saata post meetodiga.',
    76 => 'Kas sa tõesti soovid selle kustutada?',
    77 => 'Hoiatus: <br' . XHTML . '>sa määrasid vaikekooditabeliks UTF-8, kuid sinu server ei toeta mitmebaidilist kooditabelit. Palun installeeri PHP jaoks mbstring funktsioonid või vali mõni teine kooditabel/keel.',
    78 => 'Palun kontrolli, et E-postiaadress ja kontrolliks sisestatud E-postiaadress oleksid samad.',
    79 => 'Leht, mida soovid avada, vajab tööks funktsiooni, mida kahjuks sellel saidil enam kasutuses ei ole.',
    80 => 'Selle lõime teinud plugina töö on hetkel välja lülitatud. Sa ei saa seda lõime toimetada enne kui oled antud plugina uuesti tööle lülitanud.',
    81 => 'Võimalik, et sa kirjutasid oma sisselogimisinfo valesti. Palun proovi alloleva vormi abil  uuesti sisse logida.',
    82 => 'Sa oled ületanud lubatud sisselogimiskatsete limiidi. Palun proovi hiljem uuesti.',
    83 => 'Et muuta oma salasõna, E-postiaadressi või seda kui kaua peaks sait sind mäletama, pead sa sisestama oma kehtiva salasõna.',
    84 => 'Oma konto kustutamiseks sisesta oma kehtiv salasõna.',
    85 => 'E-kirja saatmisel oli tõrge.',
    86 => 'OpenID server lükkas teie sisselogimiskatse tagasi.',
    87 => 'OpenID sisselogimine tühistati kasutaja poolt.',
    88 => 'OpenID server  andis veateate.',
    89 => 'Ei suuda leida antud identiteedi URL-i OpenID serverit.',
    90 => 'OpenID tuvastamine tühistatud.',
    91 => 'Sa määrasid vigase identiteedi URL-i.',
    92 => "Palun <a href=\"{$_CONF['site_admin_url']}/sectest.php\">kontrolli enne oma lehe kasutama hakkamist selle turvalisust!</a>",
    93 => 'Andmebaasi varundamine oli edukas.',
    94 => 'Varundamine ebaõnnestus: faili suurus on alla 1kb',
    95 => 'Oli viga.',
    96 => '',
    97 => '',
    98 => 'Plugina ülesse laadimine oli edukas.',
    99 => 'Plugin on juba olemas.',
    100 => 'Laetud plugina fail pole GZip või Zip formaadis tihendatud arhiiv.',
    101 => 'Pole ühtegi rubriiki, millele sul oleks ligipääsu. Sul peab olema vähemalt üks rubriik, et saaksid lugusid sisestada.',
    400 => 'Kõik väljad ei läbinud kontrolli',
    401 => 'Palun sisesta täisnimi'
);

###############################################################################

$LANG_ACCESS = array(
    'access' => 'Ligipääs',
    'ownerroot' => 'omanik (root)',
    'group' => 'Grupp',
    'readonly' => 'Ainult loetav',
    'accessrights' => 'Ligipääsuõigused',
    'owner' => 'Omanik',
    'grantgrouplabel' => 'Taga ülagrupi toimetamisõigused',
    'permmsg' => 'Märkus: liikmed on kõik lehele sisse loginud lehe kasutajad ja anonüümsed on kõik lehel olevad ja mitte sisse loginud lehe lugejad.',
    'securitygroups' => 'Turvalisusgrupid',
    'editrootmsg' => "Kuigi sa oled kasutajate administraator, ei saa sa muuta root kasutajate andmeid, kui sa ei ole ise root kasutaja. Sa võid toimetada kõiki teisi kasutajaid, välja arvatud root kasutajaid. Pane tähele, et kõik õigustamata katsed muuta root kasutajate andmeid logitakse.  Palun mine tagasi <a href=\"{$_CONF['site_admin_url']}/user.php\">Kasutajate administreerimislehele. </a>",
    'securitygroupsmsg' => 'Märgi grupid, millesse soovid, et see kasutaja kuuluks.',
    'groupeditor' => 'Grupi toimetaja',
    'description' => 'Kirjeldus',
    'name' => 'Nimi',
    'rights' => 'Õigused',
    'missingfields' => 'Puuduvad väljad',
    'missingfieldsmsg' => 'Sa pead grupi jaoks sisestama grupi nime ja kirjelduse',
    'groupmanager' => 'Grupi haldur',
    'newgroupmsg' => 'Grupi toimetamiseks või kustutamiseks klõpsa selle nimel allpool. Uue grupi loomiseks klõpsa Tee uus ülal. Pane tähele, et põhigruppe (core group) ei saa kustutada, sest need on süsteemis kasutusel.',
    'groupname' => 'Grupi nimi',
    'coregroup' => 'Põhigrupp',
    'yes' => 'Ja',
    'no' => 'Ei',
    'corerightsdescr' => "See grupp on {$_CONF['site_name']} põhigrupp (Core Group).  Seetõttu selle grupi õigusi ei saa muuta. Allpool on ainult loetaval kujul loetelu antud grupi õigustest.",
    'groupmsg' => 'Sellel lehel on turvalisusgrupid hierarhilised.  Lisades antud grupi mõnda alloleva grupi koosseisu, annad sa antud grupile samad õigused kui neilgi gruppidel. On eelistatavam kasutada allolevaid gruppe antud grupile õiguste määramisel.  Kui vajad kohandatud õigustega gruppi, siis saad sa selle lehe "Õigused" osas määrata mitmeid õigusi. Õiguste määramiseks märgi lihtsalt vastava grupi või õiguse juures olev märkeruut.',
    'coregroupmsg' => "See grupp on {$_CONF['site_name']} põhigrupp (Core Group).  Seetõttu ei saa selle grupi kuulumist teistesse gruppidesse muuta. Allpool on ainult loetaval kujul loetelu gruppidest, kuhu see grupp kuulub.",
    'rightsdescr' => 'Grupile võib määrata õigusi otse, määrates neid just antud grupile,  või andes vastavad õigused mõnele neist gruppidest, kuhu antud grupp kuulub. Need õigused, mis on ilma märkeruuduta, on antud grupile juba määratud nende gruppide kaudu, kuhu see hetkel kuulub. Neid õigusi, mille kõrval on märkeruut, võib määrata otse antud grupile.',
    'lock' => 'Lukk',
    'members' => 'Liikmed',
    'anonymous' => 'Anonüümne',
    'permissions' => 'Lubatud',
    'permissionskey' => 'R =lugemis-, E = toimetamis-, toimetamisõigus annab ka  lugemisõiguse',
    'edit' => 'Toimeta',
    'none' => 'Mitte midagi',
    'accessdenied' => 'Ligipääs tõkestatud',
    'storydenialmsg' => "Sul ei ole õigust seda lugu vaadata. Selle põhjuseks võib olla, et sa ei ole {$_CONF['site_name']} lehel registreerunud kasutaja.  Palun <a href=\"users.php?mode=new\"> registreeru {$_CONF['site_name']} lehe kasutajaks </a>, et saada kõiki registreerunud kasutaja õigusi",
    'nogroupsforcoregroup' => 'See grupp ei kuulu ühtegi teise gruppi',
    'grouphasnorights' => 'Sellel grupil pole antud saidil ligipääsu ühelegi administreerimisfunktsioonile',
    'newgroup' => 'Uus grupp',
    'adminhome' => 'Admin avaleht',
    'save' => 'salvesta',
    'cancel' => 'tühista',
    'delete' => 'kustuta',
    'canteditroot' => 'Sa üritasid toimetada root gruppi, kuid sa pole ise root grupi liige. Selletõttu tõkestati sinu ligipääs antud grupile. Kui sa arvad, et tegu on veaga, siis palun kontakteeru lehe administraatoriga.',
    'listusers' => 'Näita kasutajad',
    'listthem' => 'loetelu',
    'usersingroup' => 'Kasutajad grupis "%s"',
    'usergroupadmin' => 'Kasutajagrupi administreerimine',
    'add' => 'Lisa',
    'remove' => 'Eemalda',
    'availmembers' => 'Võimalikud liikmed',
    'groupmembers' => 'Grupi liikmed',
    'canteditgroup' => 'Grupi toimetamiseks pead sa ise olema selle grupi liige. Kui arvad, et tegu on veaga, siis palun kontakteeru lehe administraatoriga.',
    'cantlistgroup' => 'Grupi liikmete nägemiseks pead sa ise olema selle grupi liige. Kui sa arvad, et tegu on veaga, palun kontakteeru lehe administraatoriga.',
    'editgroupmsg' => 'Grupi liikmeskonna muutmiseks klõpsa kasutaja nimel ja kasuta kas Lisa või Eemalda nuppu. Kui kasutaja on grupi liige, on tema nimi ainult parempoolses loetelus. Kui oled lõpetanud, klõpsa grupi koosseisu uuendamiseks ja gruppide haldamise pealehele jõudmiseks <b>Salvesta</b> nuppu.',
    'listgroupmsg' => 'Loetelu kõigist grupi <b>%s</b> hetke liikmetest:',
    'search' => 'Otsi',
    'submit' => 'Sisesta',
    'limitresults' => 'Piira tulemused',
    'group_id' => 'Grupi ID',
    'plugin_access_denied_msg' => 'Sa üritasid ligi pääseda pluginate administreerimislehele, milleks polnud sul õigust. Pane tähele, et kõik õigustamata katsed sellele lehele ligi pääseda logitakse.',
    'groupexists' => 'Grupi nimi on juba olemas',
    'groupexistsmsg' => 'Sama nimega grupp on juba olemas. Grupi nimed peavad olema üksteisest erinevad.'
);

###############################################################################
# admin/database.php

$LANG_DB_BACKUP = array(
    'last_ten_backups' => 'Viimased 10 varundamist',
    'do_backup' => 'Varunda',
    'backup_successful' => 'Andmebaasi varundamine oli edukas.',
    'db_explanation' => 'Sinu Geeklogist uue varukoopia tegemiseks klõpsa allolevat nuppu',
    'not_found' => "Ebakorrektne tee programmini, kasutusel turvapiirang  või mysqldump pole käivitatav.<br" . XHTML . ">\n    Kontrolli seadistuses <strong>mysqldump_path</strong> definitsiooni.<br" . XHTML . ">\n    Kontrolli <a href=\"http://www.php.net/manual/en/features.safe-mode.php#ini.open-basedir\">open_basedir</a>\nPHP seadistust.<br" . XHTML . ">  \n    Hetkel on muutuja väärtuseks: <var>{$_DB_mysqldump_path}</var>",
    'zero_size' => 'Varundamine ebaõnnestus, faili suurus on 0 baiti',
    'path_not_found' => "{$_CONF['backup_path']} pole olemas või pole kataloog.",
    'no_access' => "Viga: varunduskataloog, {$_CONF['backup_path']}, pole ligipääsetav.",
    'backup_file' => 'Varundusfail',
    'size' => 'suurus',
    'bytes' => 'baiti',
    'total_number' => 'Varunduste üldarv: %d',
    'download' => 'Klõpsa selle faili allalaadimiseks',
    'new_backup' => 'Uus varundamine',
    'delete_failure' => 'Ühe või enama backupfaili kustutamine ebaõnnestus.',
    'delete_success' => 'Backupfail(id) on edukalt kustutatud.',
    'convert_menu' => 'Konverteeri InnoDB formaati',
    'convert_title' => 'Konverteeri InnoDB tabeliteks',
    'convert_button' => 'Konverteeri',
    'sorry_no_innodb' => 'Kahjuks sinu MySQL-i versioon ei toeta  InnoDB tabeleid.',
    'innodb_explain' => 'InnoDB tabelid pakuvad suuremat jõudlust, kui tegu on <em>tõesti</em> suure andmebaasiga, kuid teeb varundamise protsessi keerulisemaks. Palun <a href="http://dev.mysql.com/doc/mysql/en/innodb.html">loe rohkem </a> InnoDB tabelite kohta käivate poolt ja vastuargumente, enne kui teostad selle operatsiooni.',
    'already_converted' => 'Märkus: Näib, et kõik tabelid on juba konverteeritud InnoDB tabeliteks.',
    'conversion_patience' => 'Märkus: Konverteerimine võib võtta aega. Palun kannatust.',
    'innodb_success' => 'Tabelid on edukalt konverteeritud InnoDB formaati.',
    'table_issues' => 'Mõnede tabelitega võis olla probleeme. Vaata täpsemat infot error.log failist. .',
    'optimize_menu' => 'Optimeeri tabeleid',
    'optimize_title' => 'Optimeeri tabeleid',
    'optimize_button' => 'Optimeeri',
    'optimize_explain' => 'Tabelite optimeerimine võib parandada saidi jõudlust. Tegelik kasu sõltub iga tabeli kasutusest ja mõnede tabelite puhul annab see rohkem kasu kui teiste puhul. Ära oota tõeliselt suurt jõudluse tõusu. <a href="http://dev.mysql.com/doc/mysql/en/optimize-table.html">MySQL manuaal </a> ütleb: <q>Ei ole tõenäoline, et sa peaksid seda tegema sagedamini kui korra kuus või nädalas</q>.',
    'last_optimization' => 'Viimane optimeerimine',
    'optimization_patience' => 'Märkus: Optimeerimine võib võtta aega. Palun kannatust.',
    'optimize_success' => 'Andmebaasi tabelite optimeerimine oli edukas.'
);

###############################################################################

$LANG_BUTTONS = array(
    1 => 'Avaleht',
    2 => 'Kontakt',
    3 => 'Avalda',
    4 => '',
    5 => '',
    6 => '',
    7 => 'Lehe statistika',
    8 => 'Kohanda',
    9 => 'Otsi',
    10 => 'täpsem otsing',
    11 => 'Artiklid'
);

###############################################################################
# 404.php

$LANG_404 = array(
    1 => 'Viga/Error 404',
    2 => 'Ma otsisin igalt poolt, kuid ei leidnud otsitud lehte: <b>%s</b>.',
    3 => "<p>Mul on kahju, kuid soovitud  faili ei ole. Palun vaata kindlasti <a href=\"{$_CONF['site_url']}\">pealehele </a> või <a href=\"{$_CONF['site_url']}/search.php\">otsimislehele,</a> et otsitavat leida."
);

###############################################################################
# login form

$LANG_LOGIN = array(
    1 => 'Nõutav sisselogimine',
    2 => 'Selle lehe osa vaatamiseks pead kasutajana sisse logima.',
    3 => 'Logi sisse',
    4 => 'Uus kasutaja'
);

###############################################################################
# trackback.php

$LANG_TRB = array(
    'trackback' => 'Trackback',
    'from' => 'kust',
    'tracked_on' => 'Kommenteeritud',
    'read_more' => '[loe lisaks]',
    'intro_text' => 'Siin on see, mida teised ütlevad "%s" kohta:',
    'no_comments' => 'Selle sisestuse kohta pole trackbackkommentaare.',
    'this_trackback_url' => 'Selle sisestuse trackback URL:',
    'num_comments' => '%d trackbackkommentaari',
    'send_trackback' => 'Saada Ping',
    'preview' => 'Eelvaade',
    'editor_title' => 'Saada trackbackkommentaar',
    'trackback_url' => 'Trackbacki URL',
    'entry_url' => 'Sisestuse URL',
    'entry_title' => 'Sisestuse tiitel',
    'blog_name' => 'Saidi nimi',
    'excerpt' => 'katkend',
    'truncate_warning' => 'Märkus: vastuvõttev leht võib sinu katkendit lühendada.',
    'button_send' => 'Saada',
    'button_preview' => 'Eelvaade',
    'send_error' => 'Viga',
    'send_error_details' => 'Viga trackbackkommentaari saatmisel:',
    'url_missing' => 'Puudub sisestuse URL',
    'url_required' => 'Palun kirjuta sisestuse jaoks vähemalt URL.',
    'target_missing' => 'Pole Trackback URL-i',
    'target_required' => 'Palun kirjuta trackbacki URL',
    'error_socket' => 'Ei saanud avada väratit.',
    'error_response' => 'Serveri vastus oli arusaamatu.',
    'error_unspecified' => 'Määratlemata viga.',
    'select_url' => 'Vali trackbacki URL',
    'not_found' => 'Ei leidnud trackback URL-i',
    'autodetect_failed' => 'Geeklog ei suutnud tuvastada saadetava kommentaari jaoks trackback URL-i. Palun kirjuta see käsitsi allolevasse vormi.',
    'trackback_explain' => 'Vali allolevast loetelust link, kuhu soovid oma trackback kommentaari saata. Pärast seda üritab Geeklog tuvastada trackback kommentaari jaoks õige URL-i. Kui sa tead õiget URL-i, võid sa <a href="%s">sisestada selle käsitsi. </a>',
    'no_links_trackback' => 'Ei leidnud linke. Sa ei saa selle sisestuse kohta saata trackback kommentaari.',
    'pingback' => 'Pingback',
    'pingback_results' => 'Pingback tulemused',
    'send_pings' => 'Saada Ping-id',
    'send_pings_for' => 'Saada Ping-id "%s"',
    'no_links_pingback' => 'Ei leidnud linke. Selle sisestuse kohta ei saadetud  pingbacke.',
    'pingback_success' => 'Pingback on saadetud.',
    'no_pingback_url' => 'Ei leidnud pingback URL-i.',
    'resend' => 'Saada uuesti',
    'ping_all_explain' => 'Sa võid teavitada lehti, millele sinu leht viitab saates (<a href="http://en.wikipedia.org/wiki/Pingback"> Pingbacki</a>), teavitada lehe uuendamisest saates pingi veebi logikataloogidesse (weblog directory) või saata <a href="http://en.wikipedia.org/wiki/Trackback"> Trackbackkommentaari,</a> viimast juhul, kui oled oma lehel kommenteerinud mõnel teisel saidil olnud kellegi teise kirjutist.',
    'pingback_button' => 'Saada Pingback',
    'pingback_short' => 'Saada pingback kõigile käesolevalt  lehelt lingitud lehtedele.',
    'pingback_disabled' => '(Pingback on välja lülitatud)',
    'ping_button' => 'Saada Ping',
    'ping_short' => 'Pingi veebi logikatalooge',
    'ping_disabled' => '(Ping on välja lülitatud)',
    'trackback_button' => 'Saada Trackback',
    'trackback_short' => 'Saada trackbackkommentaar.',
    'trackback_disabled' => '(Trackback on välja lülitatud)',
    'may_take_a_while' => 'Pane tähele, et pingi ja pingbacki saatmine võib võtta aega.',
    'ping_results' => 'Ping tulemused',
    'unknown_method' => 'Tundmatu ping meetod',
    'ping_success' => 'Ping on saadetud.',
    'error_site_name' => 'Palun kirjuta saidi nimi.',
    'error_site_url' => 'Palun sisesta lehe URL.',
    'error_ping_url' => 'Palun kirjuta toimiv ping URL.',
    'no_services' => 'Pole häälestatud veebi logikataloogide kasutamine (weblog directory services).',
    'services_headline' => 'Veebi logikataloogide teenused',
    'service_explain' => 'Veebi logikataloogi teenusepakkuja andmete toimetamiseks klõpsa allpool vastavat nuppu logikataloogi nime kõrval. Uue logikataloogi lisamiseks klõpsa Tee uus ülal.',
    'service' => 'Teenus',
    'ping_method' => 'Ping meetod',
    'service_website' => 'Veebileht',
    'service_ping_url' => 'Pingi URL',
    'ping_standard' => 'Standard Ping',
    'ping_extended' => 'Laiendatud ping',
    'ping_unknown' => '(tundmatu meetod)',
    'edit_service' => 'Toimeta veebi logikataloogi andmeid',
    'trackbacks' => 'Trackbackid',
    'editor_intro' => 'Valmista oma trackbackkommentaar  <a href="%s">%s jaoks ette</a>.',
    'editor_intro_none' => 'Valmista trackback kommentaar ette.',
    'trackback_note' => 'Trackbackkommentaari saatmiseks mine lugude loetelusse ja klõpsa loo juures "". Klõpsa järgmisel lingil, et <a href="%s"> saata lugudega sidumata trackbackkommentaari.</a>',
    'pingback_explain' => 'Kirjuta URL, kuhu pingback saata. Pingback viitab tagasi sinu saidi pealehele.',
    'pingback_url' => 'Pingbacki URL',
    'site_url' => 'Antud saidi URL',
    'pingback_note' => 'Pingbacki saatmiseks mine lugude loetelusse ja klõpsa loo juures "". Klõpsa järgmisel lingil, et <a href="%s"> saata lugudega sidumata pingbacki.</a>',
    'pbtarget_missing' => 'Pole pingbacki URL-i',
    'pbtarget_required' => 'Palun kirjuta pingbacki URL',
    'pb_error_details' => 'Pingbacki saatmisel tekkis viga:',
    'delete_trackback' => 'Selle trackbacki kustutamiseks klõpsa: '
);

###############################################################################
# directory.php

$LANG_DIR = array(
    'title' => 'Artiklite kataloog',
    'title_year' => '%d artiklid',
    'title_month_year' => '%s %d artiklid',
    'nav_top' => 'Tagasi peakataloogi',
    'no_articles' => 'Pole artikleid'
);

###############################################################################
# admin/sectest.php

$LANG_SECTEST = array(
    'sectest' => 'Geeklogi turvalisuse kontroll',
    'results' => 'Turvalisuse kontrolli tulemused',
    'okay' => 'Kõik näib korras olevat.',
    'please_fix' => 'Palun paranda ülal toodud probleemid, enne kui võtad oma saidi kasutusele!',
    'please_note' => 'Palun pane tähele, et sait ei ole kunagi 100 protsenti turvaline. See skript testib ainult ilmseid turvaprobleeme.',
    'stay_informed' => 'Et olla informeeritud Geeklogi uutest versioonidest ja võimalikest turvaprobleemidest, soovitame me  et sa liituksid (väikese liiklusega) %s meililistiga ja/või kasutad %s, mis asub lehe Admin menüüs, et aeg-ajalt kontrollida uue versiooni olemasolu.',
    'public_html' => '"public_html" ei tohiks kunagi olla osa  sinu saidi URList.  Palun loe public_html kohta käivat osa %s uuesti ja muuda enne jätkamist vastavalt lehe seadistust.',
    'installation' => 'Installeerimisjuhised',
    'directory' => 'Kaust',
    'failed_tmp' => 'Ebaõnnestus luua ajutine fail kaustas %s. Kontrolli kaustaõiguseid!',
    'fix_it' => 'See on turvarisk ja see tuleb parandada!',
    'reachable' => 'Sinu %s on veebist kättesaadav.',
    'not_reachable' => 'Hea! Sinu %s pole veebist kättesaadav.',
    'not_sure' => 'Sain HTTP vastuskoodi %s, kui proovisin testida %s. Ma ei tea, mida sellega teha ...',
    'remove_inst' => 'Sa peaksid tõesti eemaldama pärast lehe veavabalt töölesaamist installkausta %s.',
    'remove_inst2' => 'Selle alles jätmine jätab pahatahtlikel kasutajatel võimaluse hävitada sinu praegune install, võtta sinu leht üle või hankida tundlikku infot.',
    'inst_removed' => 'Hea! Näib,  et oled juba install kausta eemaldanud.',
    'fix_password' => 'Sa ei ole veel muutnud <strong>vaike salasõna</strong> "password" %s root kontol r (del).',
    'password_okay' => 'Hea! Näib, et sa oled juba muutnud Root konto vaikesalasõna.'
);

###############################################################################
# "What's New" Time Strings
# 
# For the first two strings, you can use the following placeholders.
# Order them so it makes sense in your language:
# %i    item, "Stories"
# %n    amount, "2", "20" etc.
# %t    time, "2" (weeks)
# %s    scale, "hrs", "weeks"

$LANG_WHATSNEW = array(
    'new_string' => '%n uut %i viimase %t %s jooksul',
    'new_last' => ' viimase %t %s jooksul',
    'minutes' => 'minuti',
    'hours' => 'tunni',
    'days' => 'päeva',
    'weeks' => 'nädala',
    'months' => 'kuu',
    'minute' => 'minut',
    'hour' => 'tund',
    'day' => 'päeva',
    'week' => 'nädala',
    'month' => 'kuu'
);

###############################################################################
# Month names

$LANG_MONTH = array(
    1 => 'Jaanuar',
    2 => 'Veebruar',
    3 => 'Märts',
    4 => 'Aprill',
    5 => 'Mai',
    6 => 'Juuni',
    7 => 'Juuli',
    8 => 'August',
    9 => 'September',
    10 => 'Oktoober',
    11 => 'November',
    12 => 'Detsember'
);

###############################################################################
# Weekdays

$LANG_WEEK = array(
    1 => 'Pühapäev',
    2 => 'Esmaspäev',
    3 => 'Teisipäev',
    4 => 'Kolmapäev',
    5 => 'Neljapäev',
    6 => 'Reede',
    7 => 'Laupäev'
);

###############################################################################
# Admin - Strings
# 
# These are some standard strings used by core functions as well as plugins to
# display administration lists and edit pages

$LANG_ADMIN = array(
    'search' => 'Otsi',
    'limit_results' => 'Piira tulemused',
    'submit' => 'Valmis',
    'edit' => 'Toimeta',
    'edit_adv' => 'Toimeta lisa',
    'admin_home' => 'Admin avaleht',
    'create_new' => 'Tee uus',
    'create_new_adv' => 'Tee uus (lisa)',
    'enabled' => 'Kasutuses',
    'title' => 'Tiitel',
    'page_title' => 'Lehe tiitel',
    'type' => 'Tüüp',
    'topic' => 'Rubriik',
    'help_url' => 'Abifaili URL',
    'save' => 'Salvesta',
    'cancel' => 'Tühista',
    'delete' => 'Kustuta',
    'delete_sel' => 'Kustuta valitud',
    'copy' => 'Koopia',
    'no_results' => '- Ei leidnud midagi -',
    'data_error' => 'Liitumiste andmetega tekkis viga. Palun kontrolli algandmeid.',
    'preview' => 'Eelvaade',
    'records_found' => 'Leitud kirjed',
    'addchild' => 'Lisa alamdetail',
    'list' => 'Loetelu',
    'list_all' => 'Loetle kõik',
    'meta_description' => 'Meta kirjeldus',
    'meta_keywords' => 'Meta märksõnad',
    'na' => 'N/A',
    'token_expiry' => 'Sul on aega kuni %s, et teha muutusi. Pärast seda aegub lehele lisatud turvalisuskood ja tehtud muutused lähevad kaotsi.',
    'token_expired' => 'Selle tegevuse turvakood on aegunud. Jätkamiseks palun autoriseeri ennast uuesti.',
    'reauth_msg' => 'Selle tegevuse turvakood on aegunud. Kui sa soovid selle tegevusega jätkata, siis autoriseeri allpool ennast uuesti. See tagab, et sinu poolt tehtud muutused ei läheks kaotsi.',
    'authenticate' => 'Autoriseeri'
);

# Localisation of the texts for the various drop-down menus that are actually
# stored in the database. If these exist, they override the texts from the
# database.

$LANG_commentcodes = array(
    0 => 'On kommentaarid',
    -1 => 'Pole kommentaare',
    1 => 'Kommenteerimine suletud'
);

$LANG_commentmodes = array(
    'flat' => 'lihtne',
    'nested' => 'Üksteise sees',
    'threaded' => 'Lõimedena',
    'nocomment' => 'pole kommentaare'
);

$LANG_cookiecodes = array(
    0 => 'ära mäleta',
    3600 => '1 tund',
    7200 => '2 tundi',
    10800 => '3 tundi',
    28800 => '8 tundi',
    86400 => '1 päev',
    604800 => '1 nädal',
    2678400 => '1 kuu'
);

$LANG_dateformats = array(
    0 => 'Süsteemi seadistus'
);

$LANG_featurecodes = array(
    0 => 'Pole pealugu',
    1 => 'Pealugu'
);

$LANG_frontpagecodes = array(
    0 => 'Ainult rubriigis',
    1 => 'Avalehel ja rubriigis'
);

$LANG_postmodes = array(
    'plaintext' => 'Puhas tekst',
    'html' => 'HTML kujundusega'
);

$LANG_sortcodes = array(
    'ASC' => 'Vanemad enne',
    'DESC' => 'Uuemad enne'
);

$LANG_trackbackcodes = array(
    0 => 'Trackback lubatud',
    -1 => 'Trackback keelatud'
);

###############################################################################
# Localization of the Admin Configuration UI

$LANG_CONFIG = array(
    'home' => 'Avaleht',
    'admin_home' => 'Admin avaleht',
    'sections' => 'Seadistuse alajaotused',
    'restore' => 'Taasta',
    'add_element' => 'Lisa element',
    'save_changes' => 'Salvesta muudatused',
    'reset_form' => 'Reseti vorm',
    'changes_made' => 'Muudatused tehti edukalt',
    'title' => 'Seadistuste haldaja',
    'disable' => 'Klõpsa antud valiku keelamiseks',
    'enable' => 'Luba'
);

$LANG_configsections['Core'] = array(
    'label' => 'Geeklog',
    'title' => 'Geeklog seadistus'
);

$LANG_confignames['Core'] = array(
    'path_html' => 'HTML asukoht',
    'site_url' => 'Lehe URL',
    'site_admin_url' => 'Administreerimise URL',
    'site_mail' => 'Lehe E-post',
    'noreply_mail' => 'mitte-vastatav E-post',
    'site_name' => 'Lehe Nimi',
    'site_slogan' => 'Deviis',
    'microsummary_short' => 'Mikrokokkuvõtte',
    'path_log' => 'Logi',
    'path_language' => 'Keel',
    'backup_path' => 'Varundus',
    'path_data' => 'Andmed',
    'path_images' => 'Pildid',
    'path_pear' => 'Pear asukoht',
    'have_pear' => 'Pear olemas?',
    'mail_settings' => 'E-posti häälestus',
    'allow_mysqldump' => 'Luba MySQL Dump',
    'mysqldump_path' => 'programmi asukoht',
    'mysqldump_options' => 'MySQL Dump valikud',
    'mysqldump_filename_mask' => 'Bakkup faili nime mall',
    'theme' => 'Skeem',
    'doctype' => 'DOCTYPE Deklaratsioon',
    'menu_elements' => 'Menüü elemendid',
    'path_themes' => 'Skeemide asukoht',
    'disable_new_user_registration' => 'Keela uue kasutaja registreerimine',
    'allow_user_themes' => 'Luba kasutaja skeem',
    'allow_user_language' => 'Luba kasutaja keel',
    'allow_user_photo' => 'Luba kasutaja foto',
    'allow_username_change' => 'Luba kasutajanime muutmine',
    'allow_account_delete' => 'Luba konto kustutamine',
    'hide_author_exclusion' => 'Luba autori peitmine',
    'show_fullname' => 'Näita täisnime',
    'show_servicename' => 'Näita teenusenime',
    'custom_registration' => 'Luba kohandatud registreerimine',
    'user_login_method' => 'Kasutaja sisselogimise meetod',
    'spamx' => 'Spam-X tegevused',
    'sort_admin' => 'Sordi lingid',
    'language' => 'Keel',
    'locale' => 'Asukoht',
    'date' => 'Kuupäevaformaat',
    'daytime' => 'Kellaaja formaat',
    'shortdate' => 'Lühike kuupäevaformaat',
    'dateonly' => 'Ainult kuupäeva formaat',
    'timeonly' => 'Ainult aja formaat',
    'week_start' => 'Nädal algab',
    'hour_mode' => 'Tundide näitamine',
    'thousand_separator' => 'Tuhande eraldaja',
    'decimal_separator' => 'Kümnendkoha eraldaja',
    'decimal_count' => 'Kümnendkohti',
    'language_files' => 'Keelefailid',
    'languages' => 'Keeled',
    'timezone' => 'Ajavöönd',
    'site_disabled_msg' => 'Leht suletud, teade või URL',
    'rootdebug' => 'Root Debugimine',
    'cookie_session' => 'Sessiooniküpsise nimi ',
    'cookie_name' => 'Püsiküpsise nimi',
    'cookie_password' => 'Salasõnaküpsise nimi',
    'cookie_theme' => 'Skeemiküpsise nimi',
    'cookie_language' => 'Keeleküpsise nimi',
    'cookie_tzid' => 'Ajavööndiküpsise nimi',
    'cookie_anon_name' => 'Anon. kasutajanime küpsise nimi',
    'cookie_ip' => 'Küpsistes on IP?',
    'default_perm_cookie_timeout' => 'Püsiv kehtivusaeg',
    'session_cookie_timeout' => 'Sessiooni kehtivusaeg',
    'cookie_path' => 'Küpsise tee',
    'cookiedomain' => 'Küpsise domeen',
    'cookiesecure' => 'Turvaühenduse küpsis',
    'lastlogin' => 'Salvestan viimatise logimise aja?',
    'num_search_results' => 'Otsingutulemuste arv',
    'loginrequired' => 'Vajab sisselogimist?',
    'submitloginrequired' => 'Sisestamine vajab sisselogimist?',
    'commentsloginrequired' => 'Kommenteerimine vajab sisselogimist?',
    'statsloginrequired' => 'Statistika vajab sisselogimist?',
    'searchloginrequired' => 'Otsimine vajab sisselogimist?',
    'profileloginrequired' => 'Profiil vajab sisselogimist?',
    'emailuserloginrequired' => 'Kasutajale kirjutamine vajab sisselogimist?',
    'emailstoryloginrequired' => 'Loo saatmine vajab sisselogimist?',
    'directoryloginrequired' => 'Artiklikaust vajab sisselogimist?',
    'storysubmission' => 'Loo sisestuste puhver?',
    'usersubmission' => 'Kasutajate sisestuste puhver?',
    'listdraftstories' => 'Loetle mustandlugusi?',
    'notification' => 'Teavitamine',
    'postmode' => 'Vaikimisi postitusviis',
    'speedlimit' => 'Postituse kiiruspiir',
    'skip_preview' => 'Jäta postitamisel eelvaade vahele',
    'advanced_editor' => 'Keerukam toimetaja?',
    'wikitext_editor' => 'Wikitekst toimetaja?',
    'cron_schedule_interval' => 'Cron ajaplaani intervall',
    'sortmethod' => 'Sorteeri rubriike',
    'showstorycount' => 'Näitan lugude arvu?',
    'showsubmissioncount' => 'Näitan sisestuste arvu?',
    'hide_home_link' => 'Avalehe link peidetud?',
    'whosonline_threshold' => 'Sessiooni pikkus',
    'whosonline_anonymous' => 'Anonüümsed ei näe nimesid?',
    'emailstories' => 'Päevased kokkuvõtted lubatud?',
    'emailstorieslength' => 'Lugude pikkus',
    'emailstoriesperdefault' => 'Lubatud uute kasutajate jaoks?',
    'allow_domains' => 'Automaatselt luba domeenid',
    'disallow_domains' => 'Automaatselt keela domeenid',
    'newstoriesinterval' => 'Uute lugude intervall',
    'newcommentsinterval' => 'Uute kommentaaride intervall',
    'newtrackbackinterval' => 'Uute trackbackide intervall',
    'hidenewstories' => 'Peida uued lood',
    'hidenewcomments' => 'Peida uued kommentaarid',
    'hidenewtrackbacks' => 'Peida uued trackbackid',
    'hidenewplugins' => 'Peida pluginate uued kanded',
    'title_trim_length' => 'Pealkirjade maksimaalne pikkus',
    'trackback_enabled' => 'Trackback lubatud?',
    'pingback_enabled' => 'Pingback lubatud?',
    'ping_enabled' => 'Ping lubatud?',
    'trackback_code' => 'Vaikimisi Trackback',
    'multiple_trackbacks' => 'Multi-Trackback',
    'trackbackspeedlimit' => 'Trackbacki kiirusepiirang',
    'check_trackback_link' => 'Kontrolli Trackbacke',
    'pingback_self' => 'Pingbacki ennast?',
    'pingback_excerpt' => 'Loo Pingbacki väljavõte?',
    'link_documentation' => 'Link dokumentatsioonile?',
    'link_versionchecker' => 'Link versioonikontrollijale?',
    'maximagesperarticle' => 'Piltide maksimum loo kohta',
    'limitnews' => 'Lugusid lehel',
    'minnews' => 'Min. lugusid lehel',
    'contributedbyline' => '"Näita postitajat?"',
    'hideviewscount' => 'Peida vaatamiste arv',
    'hideemailicon' => 'Peida link E-post?',
    'hideprintericon' => 'Peida link prindi?',
    'allow_page_breaks' => 'Luba leheküljevahetused?',
    'page_break_comments' => 'Kommentaarid mitmelehelistes lugudes',
    'article_image_align' => 'Rubriigi ikooni joondus',
    'show_topic_icon' => 'Näita rubriigi ikooni?',
    'draft_flag' => 'Vaikimisi mustandilipp',
    'frontpage' => 'Vaikimisi avalehel',
    'hide_no_news_msg' => 'Peida teade "Pole uudiseid"?',
    'hide_main_page_navigation' => 'Peida Main Page Navigation?',
    'onlyrootfeatures' => 'Ainult root saab pealugu määrata?',
    'aftersave_story' => 'Pärast loo salvestamist',
    'aftersave_user' => 'Pärast kasutaja salvestamist',
    'show_right_blocks' => 'Näita alati paremplokki?',
    'showfirstasfeatured' => 'Näita esimest lugu pealoona?',
    'backend' => 'Luba lõimed?',
    'rdf_file' => 'Lõimede väljundkaust',
    'rdf_limit' => 'Lõimede limiit',
    'rdf_storytext' => 'Lugude pikkus lõimedes',
    'rdf_language' => 'Lõime keel',
    'syndication_max_headlines' => 'Maks. pealkirju lõimedes (portaalplokid)',
    'copyrightyear' => 'autorikaitse aasta',
    'image_lib' => 'pilditeek',
    'path_to_mogrify' => 'Mogrify asukoht',
    'path_to_netpbm' => 'Netpbm asukoht',
    'debug_image_upload' => 'Debugi piltide üleslaadimist?',
    'keep_unscaled_image' => 'Säilita originaalsuuruses pilt?',
    'allow_user_scaling' => 'Luba kasutajal suurendamine?',
    'jpeg_quality' => 'JPEG kvaliteet?',
    'max_image_width' => 'maks. pildi laius?',
    'max_image_height' => 'Maks. pildi kõrgus?',
    'max_image_size' => 'Maks. pildi suurus?',
    'max_topicicon_width' => 'Maks. rubriigi ikooni laius?',
    'max_topicicon_height' => 'Maks. rubriigi ikooni kõrgus?',
    'max_topicicon_size' => 'Maks. rubriigi ikooni suurus?',
    'max_photo_width' => 'Maks. foto laius?',
    'max_photo_height' => 'Maks foto kõrgus?',
    'max_photo_size' => 'Maks. foto suurus?',
    'use_gravatar' => 'Kasuta Gravatar?',
    'gravatar_rating' => 'Luba Gravatari hindamine',
    'force_photo_width' => 'Määra Photo laius',
    'default_photo' => 'Vaikimisi Photo',
    'commentspeedlimit' => 'Kommenteerimise kiirusepiirang',
    'comment_limit' => 'Kommentaaride piir',
    'comment_mode' => 'Kommentaaride viis',
    'comment_code' => 'Vaikimisi kommenteerimine',
    'comment_edit' => 'Luba kommentaaride muutmine?',
    'comment_edittime' => 'Kommentaaride muutmise aeg (sekundid)',
    'commentsubmission' => 'Puhverda kommentaaride sisestamine',
    'passwordspeedlimit' => 'Salasõna kiirusepiirang',
    'login_attempts' => 'Maks. sisselogimiskatseid',
    'login_speedlimit' => 'sisselogimise kiirusepiirang',
    'user_html' => 'Kasutaja HTML',
    'admin_html' => 'Admini HTML',
    'advanced_html' => 'lisa HTML keer. toimetaja jaoks',
    'skip_html_filter_for_root' => 'Jäta HTML filter root jaoks vahele?',
    'allowed_protocols' => 'Lubatud protokollid',
    'disable_autolinks' => 'Keela autolingid?',
    'clickable_links' => 'Tee URL-id klikitavaks?',
    'compressed_output' => 'Saada väljund tihendatult?',
    'frame_options' => 'Kaitse "clickjacking" vastu',
    'censormode' => 'Tsensuurireþiim?',
    'censorreplace' => 'Tsensuuri asendustekst',
    'censorlist' => 'Tsenseerimisloetelu',
    'ip_lookup' => 'IP otsing',
    'url_rewrite' => 'Luba URL-i ülekirjutamine',
    'meta_tags' => 'Meta Tags',
    'meta_description' => 'vaikimisi Meta kirjeldus',
    'meta_keywords' => 'Vaikimisi Meta märksõnad',
    'default_permissions_block' => 'Ploki vaikimisi õigused',
    'default_permissions_story' => 'Lugude vaikimisi õigused',
    'default_permissions_topic' => 'Rubriigi vaikimisi õigused',
    'atom_max_stories' => 'Maks. lugusid veebiteenuste lõimedes',
    'disable_webservices' => 'Keela veebiteenused?',
    'restrict_webservices' => 'Piira veebiteenused?',
    'article_comment_close_enabled' => 'Sulge automaatselt kommentaarid (vaikimisi)',
    'article_comment_close_days' => 'Sulge kommenteerimine päevaga (vaikimisi)',
    'comment_close_rec_stories' => 'Uusimate lugude arv, mida on lubatud kommenteerida',
    'allow_reply_notifications' => 'Luba kommentaarile vastamisest teavitamine?',
    'search_style' => 'Tulemuste loetelu stiil',
    'search_limits' => 'Lehe limiit',
    'search_show_num' => 'Näitatulemuste arvu?',
    'search_show_type' => 'Näita tulemuse tüüpi?',
    'search_show_sort' => 'Luba kasutajal tulemusi sorteerida?',
    'search_show_limit' => 'Näita lehe limiiti?',
    'search_separator' => 'Grupi eraldaja',
    'search_def_keytype' => 'Vaikimisi otsimisviis',
    'search_def_sort' => 'vaikimisi sorteerimisjärjestus'
);

$LANG_configsubgroups['Core'] = array(
    'sg_site' => 'Leht',
    'sg_stories' => 'Lood ja Trackback',
    'sg_theme' => 'Skeem',
    'sg_blocks' => 'Plokid',
    'sg_users' => 'Kasutajad ja sisestused',
    'sg_images' => 'Pildid',
    'sg_locale' => 'Keel ja asukoht',
    'sg_misc' => 'Mitmesugust'
);

$LANG_fs['Core'] = array(
    'fs_site' => 'Leht',
    'fs_paths' => 'Asukohad',
    'fs_theme' => 'Skeem',
    'fs_mail' => 'E-post',
    'fs_pear' => 'Pear',
    'fs_mysql' => 'MySQL',
    'fs_users' => 'Kasutajad',
    'fs_misc' => 'Mitmesugust',
    'fs_spamx' => 'Spam-X',
    'fs_admin_block' => 'Admin Plokk',
    'fs_locale' => 'Asukoht',
    'fs_language' => 'Keel',
    'fs_debug' => 'Silumine',
    'fs_cookies' => 'Küpsised',
    'fs_login' => 'Sisselogimise häälestus',
    'fs_search' => 'Otsing',
    'fs_user_submission' => 'Kasutaja sisestused',
    'fs_submission' => 'Sisestuse häälestused',
    'fs_topics_block' => 'Rubriigi plokk',
    'fs_whosonline_block' => 'Kes on  Online Plokk',
    'fs_daily_digest' => 'Päevased kokkuvõtted',
    'fs_whatsnew_block' => 'Mida uut Plokk',
    'fs_trackback' => 'Trackback',
    'fs_pingback' => 'Pingback',
    'fs_story' => 'Lugu',
    'fs_theme_advanced' => 'Keerukamad häälestused',
    'fs_syndication' => 'Lõimed',
    'fs_imagelib' => 'Pilditeek',
    'fs_upload' => 'Üleslaadimine',
    'fs_articleimg' => 'Pildid lugudes',
    'fs_topicicon' => 'Rubriigi ikoonid',
    'fs_userphoto' => 'Fotod',
    'fs_gravatar' => 'Gravatar',
    'fs_comments' => 'Kommentaarid',
    'fs_htmlfilter' => 'HTML filtreerimine',
    'fs_censoring' => 'Tsenseerimine',
    'fs_iplookup' => 'IP otsing',
    'fs_perm_story' => 'Loo vaikimisi õigused',
    'fs_perm_topic' => 'Rubriigi vaikimisi õigused',
    'fs_perm_block' => 'Ploki vaikimisi õigused',
    'fs_webservices' => 'Veebiteenused'
);

$LANG_configselects['Core'] = array(
    0 => array('Jah' => 1, 'Ei' => 0),
    1 => array('Jah' => true, 'Ei' => false),
    2 => array('Lükka tagasi' => 0, 'Jäta ainult viimane' => 1, 'Luba mitut postitust' => 2),
    3 => array('Trackback lubatud' => 0, 'Trackback keelatud' => -1),
    4 => array('Ei kontrolli midagi' => 0, 'Kontrolli saidi URL-i' => 1, 'Kontrolli Täis URL-i' => 2, 'Kontrolli saidi URL-i ja täis URL-i' => 3, 'Võrdle IP saidi IP-ga' => 4, 'Kontrolli IP ja saidi URL-i' => 5, 'Kontrolli IP ja täis URL-i' => 6, 'Kontrolli IP, täis URL-i, ja saidi URL-i' => 7),
    5 => array('Puhas tekst' => 'plaintext', 'HTML kujundusega' => 'html'),
    6 => array('12' => 12, '24' => 24),
    7 => array('Viimane leht' => 'last', 'Esimene leht' => 'first', 'Iga leht' => 'all'),
    8 => array('Parem' => 'right', 'Vasak' => 'left'),
    9 => array('Suuna edasi lehele' => 'item', 'Näita loetelu' => 'list', 'Näita avalehte' => 'home', 'Näita admini lehte' => 'admin'),
    10 => array('Mitte midagi' => '', 'Netpbm' => 'netpbm', 'ImageMagick' => 'imagemagick', 'gdLib' => 'gdlib'),
    11 => array('lihtne' => 'flat', 'Üksteise sees' => 'nested', 'Lõimedena' => 'threaded', 'pole kommentaare' => 'nocomment'),
    12 => array('Pole ligipääsu' => 0, 'Ainult loetav' => 2, 'Loetav ja muudetav' => 3),
    13 => array('Jäta vahele' => 0, 'Luba kiiruspiiranguga' => 1, 'Luba ilma kiiruspiiranguta' => 2),
    14 => array('Pühapäev' => 'Sun', 'Esmaspäev' => 'Mon'),
    15 => array('Arvuliselt' => 'sortnum', 'Tähestikuliselt' => 'alpha'),
    16 => array('Sisselogimine pole tarvilik' => 0, 'Täpsem otsing' => 1, 'Lihtne ja täpsem otsing' => 2),
    17 => array('Kommenteerimine lubatud' => 0, 'Kommenteerimine keelatud' => -1),
    18 => array('Keelatud' => 0, 'Lubatud (täpne kattumine)' => 1, 'Lubatud (sõna algus)' => 2, 'Lubatud (sõna osa)' => 3),
    19 => array('Google' => 'google', 'Tabel' => 'table'),
    20 => array('Täpne fraas' => 'phrase', 'Kõik sõnad' => 'all', 'Mõni sõnadest' => 'any'),
    21 => array('HTML 4.01 Transitional' => 'html401transitional', 'HTML 4.01 Strict' => 'html401strict', 'XHTML 1.0 Transitional' => 'xhtml10transitional', 'XHTML 1.0 Strict' => 'xhtml10strict'),
    22 => array('Range' => 'DENY', 'Sama allikas' => 'SAMEORIGIN', '(väljas)' => ''),
    23 => array('Keelatud' => 0, 'Lubatud' => 1, 'Lubatud (vaikimisi ainult avalehel)' => 2),
    24 => array('Avlda' => 'contribute', 'Avaleht' => 'home', 'Täpsem otsing' => 'search', 'Artiklid' => 'directory', 'Minu konto' => 'prefs', 'Pluginate kanded' => 'plugins', 'Kohandatud kanded' => 'custom', 'Lehe statistika' => 'stats'),
    25 => array('Uued lood' => 'story', 'Uued kommentaarid' => 'comment', 'Uued Trackbackid' => 'trackback', 'Uued Pingbackid' => 'pingback', 'Uued kasutajad' => 'user'),
    26 => array('G (General Audiences)' => 'G', 'PG (Parental Guidance)' => 'PG', 'R (Restricted)' => 'R', 'X (Explicit)' => 'X'),
    27 => array('Klikke (ksv.)' => 'hits|asc', 'Klikke (kahan.)' => 'hits|desc', 'Aeg (ksv.)' => 'date|asc', 'Aeg (kahan.)' => 'date|desc', 'Title (asc)' => 'title|asc', 'Title (desc)' => 'title|desc', 'Author (asc)' => 'uid|asc', 'Author (desc)' => 'uid|desc')
);

?>
