<?php

###############################################################################
# estonian.php
# This is the Estonian language file for the Geeklog Link plugin
#
# Copyright (C) 2001 Tony Bibbs
# tony@tonybibbs.com
# Copyright (C) 2005 Trinity Bays
# trinity93@gmail.com
#
# Estonian translation by Artur Rpp <rtr AT planet DOT ee>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
###############################################################################

global $LANG32;

###############################################################################
# Array Format:
# $LANGXX[YY]:  $LANG - variable name
#               XX    - file id number
#               YY    - phrase id number
###############################################################################

$LANG_LINKS = array(
    10 => 'Sisestatud',
    14 => 'Linke',
    84 => 'LINKE',
    88 => 'Pole uusi linke',
    114 => 'Linke',
    116 => 'Lisa link',
    117 => 'Teata mittettavast lingist',
    118 => 'Mittettavast lingist teatamine',
    119 => 'Jrgmisest lingist on teatatud kui mittettavast: ',
    120 => 'Lingi toimetamiseks kliki siin: ',
    121 => 'Mittettavast lingist teatas: ',
    122 => 'Tname mittettavast lingist teatamise eest. Administraator parandab lingi nii ruttu kui vimalik.',
    123 => 'Tname sind',
    124 => 'Mine',
    125 => 'Kategooriad',
    126 => 'Oled siin:',
    'root' => 'Pea'
);

###############################################################################
# for stats

$LANG_LINKS_STATS = array(
    'links' => 'Linke (klikke) lehtedel',
    'stats_headline' => 'Top 10 linki',
    'stats_page_title' => 'Lingid',
    'stats_hits' => 'Klikke',
    'stats_no_hits' => 'Nib, et lehel pole linke vi keegi pole neil klpsanud.'
);

###############################################################################
# for the search

$LANG_LINKS_SEARCH = array(
    'results' => 'Linkide tulemus',
    'title' => 'Tiitel',
    'date' => 'Lisamisaeg',
    'author' => 'Lisaja',
    'hits' => 'Klikke'
);

###############################################################################
# for the submission form

$LANG_LINKS_SUBMIT = array(
    1 => 'Saada link',
    2 => 'Link',
    3 => 'Kategooria',
    4 => 'Muu',
    5 => 'Kui muu, siis mratle',
    6 => 'Viga: puudub kategooria',
    7 => 'Kui valid "Muu", mratle ka kategooria nimi',
    8 => 'Tiitel',
    9 => 'URL',
    10 => 'Kategooria',
    11 => 'Sisestatud lingid'
);

###############################################################################
# Messages for COM_showMessage the submission form

$PLG_links_MESSAGE1 = "Tname sind {$_CONF['site_name']} lehele lingi sisestamise eest. See on saadetud meie meeskonnale kinnitamiseks. Kui meeskond kinnitab selle lingi, ilmub see <a href=\"{$_CONF['site_url']}/links/\">Linkide osas.</a>";
$PLG_links_MESSAGE2 = 'Sinu link on edukalt salvestatud.';
$PLG_links_MESSAGE3 = 'Link on edukalt kustutatud';
$PLG_links_MESSAGE4 = "Tname sind {$_CONF['site_name']}  lehele lingi lisamise eest. Sa vid seda linki juba nha <a href=\"{$_CONF['site_url']}/links/\">linkide osas.</a>";
$PLG_links_MESSAGE5 = 'Sul pole piisavalt ligipsuigusi selle kategooria vaatamiseks.';
$PLG_links_MESSAGE6 = 'Sul pole piisavalt igusi selle kategooria toimetamiseks.';
$PLG_links_MESSAGE7 = 'Palun sisesta kategooria nimi ja kirjeldus.';
$PLG_links_MESSAGE10 = 'Sinu kategooria on edukalt salvestatud.';
$PLG_links_MESSAGE11 = 'Sa ei saa kategooria ID-ks mrata "site" vi "user" - need on reserveeritud sisemiseks kasutamiseks.';
$PLG_links_MESSAGE12 = 'Sa proovid teha vanemkategooriast selle kategooria alamkategooria alamkategooriat. Nii tekiks orbkategooria. Palun vii enne alamkategooriad krgemale tasemele.';
$PLG_links_MESSAGE13 = 'Kategooria on edukalt kustutatud.';
$PLG_links_MESSAGE14 = 'Kategooria sisaldab linke vi alamkategooriaid. Eemalda need enne.';
$PLG_links_MESSAGE15 = 'Sul pole piisavalt igusi, et seda kategooriat kustutada.';
$PLG_links_MESSAGE16 = 'Pole sellist kategooriat.';
$PLG_links_MESSAGE17 = 'See kategooria-ID on juba kasutuses.';

// Messages for the plugin upgrade
$PLG_links_MESSAGE3001 = 'Plugina uuendamine pole toetatud.';
$PLG_links_MESSAGE3002 = $LANG32[9];

###############################################################################
# admin/plugins/links/index.php

$LANG_LINKS_ADMIN = array(
    1 => 'Lingi toimetaja',
    2 => 'Lingi ID',
    3 => 'Lingi tiitel',
    4 => 'Lingi URL',
    5 => 'Kategooria',
    6 => '(koos http://)',
    7 => 'Muu',
    8 => 'Klikke lingil',
    9 => 'Lingi kirjeldus',
    10 => 'Sa pead mrama lingi URL-i, tiitli ja kirjelduse.',
    11 => 'Lingi haldur',
    12 => 'Lingi toimetamiseks vi kustutamiseks klpsa allpool vastava lingi juures oleval toimetamisikoonil. Uue lingi loomiseks klpsa "Tee uus" lal.',
    14 => 'Lingi kategooria',
    16 => 'Ligips tkestatud',
    17 => "Sa proovisid ligi pseda lingile, milleks pole sul igust. See katse on logitud. Palun <a href=\"{$_CONF['site_admin_url']}/plugins/links/\"> mine tagasi linkide administreerimislehele.</a>",
    20 => 'Kui muu, siis mratle',
    21 => 'salvesta',
    22 => 'thista',
    23 => 'kustuta',
    24 => 'Ei leidnud linki',
    25 => 'Ei leidnud seda linki, mille valisid toimetamiseks.',
    26 => 'Kontrolli linke',
    27 => 'HTML Staatus',
    28 => 'Toimeta kategooriat',
    29 => 'Sisesta allpool kategooria detaile vi toimeta neid.',
    30 => 'Kategooria',
    31 => 'Kirjeldus',
    32 => 'Kategooria ID',
    33 => 'Rubriik',
    34 => 'lemine',
    35 => 'Kik',
    40 => 'Toimeta kategooriat',
    41 => 'Loo alamkategooria',
    42 => 'Kustuta see kategooria',
    43 => 'Lehe kategooriad',
    44 => 'Lisa&nbsp;alam',
    46 => 'Kasutaja %s pdis kustutada kategooriat, mille jaoks polnud tal ligipsuigusi',
    50 => 'Loetle kategooriaid',
    51 => 'Uus link',
    52 => 'Uus kategooria',
    53 => 'Loetle linke',
    54 => 'Kategooriahaldur',
    55 => 'Toimeta allpool olevaid kategooriaid. Pane thele, et sa ei saa kustutada kategooriaid, milles on alamkategooriaid vi linke. Kustuta need eelnevalt vi vii need mnda teise kategooriasse.',
    56 => 'Kategooriatoimetaja',
    57 => 'Veel kontrollimata',
    58 => 'Kontrolli nd',
    59 => '<p>Kigi nhtaval olevate linkide kontrollimiseks, klpsa palun allpool oleval lingil "Kontrolli nd". Pane thele, et kontrollimine vib sltuvalt nhtaval olevate linkide arvust vtta veidi aega.</p>',
    60 => 'Kasutaja %s proovis igustamatult  muuta kategooriat: %s.'
);


$LANG_LINKS_STATUS = array(
    100 => 'Jtka',
    101 => 'Vahetan protokolli',
    200 => 'OK',
    201 => 'Loodud',
    202 => 'Kinnitatud',
    203 => 'Ebausaldusvrne info',
    204 => 'Pole sisu',
    205 => 'Reseti sisu',
    206 => 'Osaline sisu',
    300 => 'Mitu valikut',
    301 => 'Psivalt teises kohas',
    302 => 'Leitud',
    303 => 'Vaata muud',
    304 => 'Pole muudetud',
    305 => 'Kasuta Proxyt',
    307 => 'Ajutine mbersuunamine',
    400 => 'Halb pring',
    401 => 'Pole autoriseeritud',
    402 => 'Tasuline teenus',
    403 => 'Keelatud',
    404 => 'Ei leidnud',
    405 => 'Meetod pole lubatud',
    406 => 'Pole vastuvetav',
    407 => 'Nutav Proxy kaudu autoriseerimine',
    408 => 'Pringu ajapiir',
    409 => 'Konflikt',
    410 => 'Linud',
    411 => 'Pikkus nutav',
    412 => 'Eeltingimused ebannestusid',
    413 => 'Pringu sisu liiga suur',
    414 => 'Pringu URI liiga pikk',
    415 => 'Toetamata meedia Tp',
    416 => 'Nutud piirkond pole rahuldatav',
    417 => 'Expectation Failed',
    500 => 'Sisemine serveri viga',
    501 => 'Pole implementeeritud',
    502 => 'Halb Gateway',
    503 => 'Teenus pole saadaval',
    504 => 'Gateway ajapiir',
    505 => 'HTTP Versioon pole toetatud',
    999 => 'henduse ajapiir'
);

// Localization of the Admin Configuration UI
$LANG_configsections['links'] = array(
    'label' => 'Lingid',
    'title' => 'Linkide haldur'
);

$LANG_confignames['links'] = array(
    'linksloginrequired' => 'Lingid vajavad sisselogimist?',
    'linksubmission' => 'Luba linkide puhver?',
    'newlinksinterval' => 'Uute linkide intervall',
    'hidenewlinks' => 'Peida uued lingid',
    'hidelinksmenu' => 'Peida linkide menpunkt',
    'linkcols' => 'Kategooriaid veerus',
    'linksperpage' => 'Linke lehel',
    'show_top10' => 'Nita top 10 linki?',
    'notification' => 'Teavituskiri?',
    'delete_links' => 'Kustuta lingid, omanikuks?',
    'aftersave' => 'Prast linkide salvestamist',
    'show_category_descriptions' => 'Nita kategooriate kirjeldust?',
    'root' => 'Peakategooria ID',
    'default_permissions' => 'Linkide vaikimisi igused'
);

$LANG_configsubgroups['links'] = array(
    'sg_main' => 'Peahlestused'
);

$LANG_fs['links'] = array(
    'fs_public' => 'Avalike linkide loetelu hlestused',
    'fs_admin' => 'Linkide Admin hlestused',
    'fs_permissions' => 'Vaikimisi igused'
);

// Note: entries 0, 1, and 12 are the same as in $LANG_configselects['Core']
$LANG_configselects['links'] = array(
    0 => array('Jah' => 1, 'Ei' => 0),
    1 => array('Jah' => true, 'Ei' => false),
    9 => array('Suuna edasi lingitud lehele' => 'item', 'Nita administreerimisloetelu' => 'list', 'Nita avalikku loetelu' => 'plugin', 'Nita avalehte' => 'home', 'Nita Admini lehte' => 'admin'),
    12 => array('Pole ligipsu' => 0, 'Ainult loetav' => 2, 'Loetav ja muudetav' => 3)
);

?>
