// TilesDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "GBEmu.h"
#include "TilesDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define R_BGP	0xFF47
extern DWORD dwSize;
LPBITMAPINFO tiles_info = (LPBITMAPINFO)new char[dwSize];

CDC* pTDC;						// rfIr[p̃foCXReLXg
extern bool fTileDlg;
extern unsigned char MEM[0x10000];
extern unsigned char Colours[4];

/////////////////////////////////////////////////////////////////////////////
// CTilesDlg _CAO


CTilesDlg::CTilesDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTilesDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTilesDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CTilesDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTilesDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTilesDlg, CDialog)
	//{{AFX_MSG_MAP(CTilesDlg)
	ON_WM_PAINT()
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTilesDlg bZ[W nh

BOOL CTilesDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// LCDpɉʂ̃foCXReLXg擾
	pTDC = this->GetDC();

	RECT	DlgSize;
	SetRect(&DlgSize, 0, 0,295, 135);
	AdjustWindowRect(&DlgSize, WS_OVERLAPPEDWINDOW, TRUE);
	CDialog::SetWindowPos(&wndTop, 0, 0, DlgSize.right - DlgSize.left,
							DlgSize.bottom - DlgSize.top, SWP_NOMOVE);
	::SetWindowPos(::GetDlgItem(m_hWnd, IDC_GROUP_BGP), 0, 235, 5, 50, 145, SWP_NOACTIVATE|SWP_NOZORDER);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CTilesDlg::OnPaint() 
{
	CPaintDC dc(this); // `p̃foCX ReLXg
	
	ShowTiles();

	// `pbZ[WƂ CDialog::OnPaint() ĂяoĂ͂܂
}

void CTilesDlg::OnClose() 
{	// tO߂ă_CAO
	fTileDlg=false;	
	CDialog::OnClose();
}

void CTilesDlg::ShowTiles()
{
	unsigned short tdpx, tdpy, tmpx, tmpy;
	unsigned char TDD, TDS, tilebit;
	unsigned short TDA=0x8000;
	unsigned char TilesBuffer[216*144];
	unsigned int FBA;
	DWORD SysBGPalette;

	for(tmpy=0; tmpy<144; tmpy++){
		for(tmpx=0; tmpx<216; tmpx++){
			TilesBuffer[tmpx+tmpy*216]=4;
		}
	}

	for(tmpy=0; tmpy<144; tmpy+=9){		// }bvf[^
		for(tmpx=0; tmpx<216; tmpx+=9){
			for(tdpy=0; tdpy<8; tdpy++){	// ^Cf[^
				for(tdpx=0; tdpx<8; tdpx+=8){
					TDD = MEM[TDA];		// 1oCgڂ̃^Cf[^
					TDS = MEM[TDA+1];	// 2oCgڂ̃^Cf[^
					FBA=tdpx+tdpy*216+tmpx+tmpy*216;
					for(tilebit=0x80; tilebit; tilebit/=2,FBA++){
						if((~(TDD&tilebit))&(~(TDS&tilebit)))TilesBuffer[FBA]=0;
						if((TDD&tilebit)&(~(TDS&tilebit)))TilesBuffer[FBA]=1;
						if((~(TDD&tilebit))&(TDS&tilebit))TilesBuffer[FBA]=2;
						if((TDD&tilebit)&(TDS&tilebit))TilesBuffer[FBA]=3;
					}
					TDA+=2; //QoCgɈړ
				}
			}
		}
	}

	memset(tiles_info, 0, sizeof(BITMAPINFOHEADER));
	tiles_info->bmiHeader.biSize	= sizeof(BITMAPINFOHEADER);
	tiles_info->bmiHeader.biWidth	= 216;
	tiles_info->bmiHeader.biHeight	= -144;
	tiles_info->bmiHeader.biPlanes	= 1;
	tiles_info->bmiHeader.biBitCount= 8;

	// BGPWX^pbgϊ
	tiles_info->bmiColors[0].rgbBlue = \
	tiles_info->bmiColors[0].rgbGreen = \
	tiles_info->bmiColors[0].rgbRed = Colours[(MEM[R_BGP]&0x03)];
	tiles_info->bmiColors[0].rgbReserved = 0;
	tiles_info->bmiColors[1].rgbBlue = \
	tiles_info->bmiColors[1].rgbGreen = \
	tiles_info->bmiColors[1].rgbRed = Colours[(MEM[R_BGP]>>2&0x03)];
	tiles_info->bmiColors[1].rgbReserved = 0;
	tiles_info->bmiColors[2].rgbBlue = \
	tiles_info->bmiColors[2].rgbGreen = \
	tiles_info->bmiColors[2].rgbRed = Colours[(MEM[R_BGP]>>4&0x03)];
	tiles_info->bmiColors[2].rgbReserved = 0;
	tiles_info->bmiColors[3].rgbBlue = \
	tiles_info->bmiColors[3].rgbGreen = \
	tiles_info->bmiColors[3].rgbRed = Colours[(MEM[R_BGP]>>6&0x03)];
	tiles_info->bmiColors[3].rgbReserved = 0;
	SysBGPalette=GetSysColor(COLOR_3DLIGHT);
	tiles_info->bmiColors[4].rgbBlue = (unsigned char)(SysBGPalette>>16);
	tiles_info->bmiColors[4].rgbGreen = (unsigned char)(SysBGPalette>>8);
	tiles_info->bmiColors[4].rgbRed = (unsigned char)(SysBGPalette);
	tiles_info->bmiColors[4].rgbReserved = 0;
	HDC	hMemDC	= ::CreateCompatibleDC(pTDC->m_hDC);
	HBITMAP	hBitmap	= ::CreateDIBitmap(pTDC->m_hDC, &tiles_info->bmiHeader, CBM_INIT, TilesBuffer, tiles_info, DIB_RGB_COLORS);
	HBITMAP	hOldmap	= (HBITMAP)::SelectObject(hMemDC, hBitmap);

	::BitBlt(pTDC->m_hDC, 5, 5, 215, 143, hMemDC, 0, 0, SRCCOPY);
	::DeleteObject(hBitmap);
}