
typedef unsigned char  byte;
typedef unsigned short hword;
typedef unsigned long  word;

typedef unsigned char  u8;
typedef unsigned short u16;
typedef unsigned long  u32;

typedef signed char  s8;
typedef signed short s16;
typedef signed long  s32;

typedef struct ARM7TDMI{
	u32 reg[16];
}ARM7TDMI;

#define	R0		(u32)(arm.reg[0])
#define	R1		(u32)(arm.reg[1])
#define	R2		(u32)(arm.reg[2])
#define	R3		(u32)(arm.reg[3])
#define	R4		(u32)(arm.reg[4])
#define	R5		(u32)(arm.reg[5])
#define	R6		(u32)(arm.reg[6])
#define	R7		(u32)(arm.reg[7])
#define	R8		(u32)(arm.reg[8])
#define	R9		(u32)(arm.reg[9])
#define	R10		(u32)(arm.reg[10])
#define	R11		(u32)(arm.reg[11])
#define	R12		(u32)(arm.reg[12])
#define	R13		(u32)(arm.reg[13])
#define	R14		(u32)(arm.reg[14])
#define	R15		(u32)(arm.reg[15])
#define	R16		(u32)(arm.reg[16])
#define	SR		(u32)(arm.reg[13])
#define	LR		(u32)(arm.reg[14])
#define	PC		(u32)(arm.reg[15])
#define	CPSR	(u32)(arm.reg[16])
//#define	CPUIsRunning	(u32)(arm.running)

#define	N_	0x80000000	/* Negative/Less Than*/
#define	Z_	0x40000000	/* Zero/Equal*/
#define	C_	0x20000000	/* Carry/Borrow/Extend*/
#define	V_	0x10000000	/* Overflow*/
#define	I_	0x00000080	/* IRQ Disable*/
#define	F_	0x00000040	/* FIQ Disable*/
#define	T_	0x00000020	/* THUMB State*/
#define	M4_	0x00000010	/* Mode 4-0*/
#define	M3_	0x00000008
#define	M2_	0x00000004
#define	M1_	0x00000002
#define	M0_	0x00000001

#define	SF(_flag)	(u32)(arm.reg[16])|=_flag
#define	RF(_flag)	(u32)(arm.reg[16])&=~_flag

#define	FN	((0x80000000>>31)&0x01)
#define	FZ	((0x40000000>>30)&0x01)
#define	FC	((0x20000000>>29)&0x01)
#define	FV	((0x10000000>>28)&0x01)

#define	LCD_X	240
#define	LCD_Y	160

#define	OPCODE	RMem32(PC)

#define	MSG(__msg)	GBAEmu.MessageBox(__msg, NULL, 0);
#define	MNI(__mni)	GBAEmu.ShowMnimonic(__mni)

#ifndef	_GBAEMU_
extern ARM7TDMI arm;
extern bool CPUIsRunning;
#endif

