/*
 * Galatea Dialog Manager:
 * (c)2004 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: AMBuffer.java,v 1.3 2006/11/17 02:31:20 nishi Exp $
 */
package galatea.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class AMBuffer
{
	private BufferedWriter writer_;
	private BufferedReader reader_;
	private Charset cs_;
	
	public AMBuffer(Charset cs) {
		cs_ = cs; // Charset.forName("EUC-JP");
		writer_ = new BufferedWriter(new OutputStreamWriter(System.out, cs_));
		reader_ = new BufferedReader(new InputStreamReader(System.in, cs_));
	}
	
	// In
	public void send(String str) {
		try {
			writer_.write(str);
			writer_.newLine();
			writer_.flush();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	// Out
	public String receive() {
		try {
			if ( reader_.ready() ) {
				String str = reader_.readLine();
				if ( str != null && str.length() > 0 ) {
					return str;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "";
	}
	
}
