/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlSubdialog</b> is generated from vxml20.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="subdialog">
 *       <optional>
 *         <attribute name="name">
 *           <data type="NMTOKEN"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="cond">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="expr">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <attribute name="src">
 *         <text/>
 *       </attribute>
 *       <optional>
 *         <attribute name="fetchhint">
 *           <choice>
 *             <value type="NMTOKEN">prefetch</value>
 *             <value type="NMTOKEN">safe</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="fetchtimeout">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="maxage">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="maxstale">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="fetchaudio">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="method">
 *           <choice>
 *             <value type="NMTOKEN">get</value>
 *             <value type="NMTOKEN">post</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="enctype">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="namelist">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <mixed>
 *         <zeroOrMore>
 *           <choice>
 *             <ref name="audio"/>
 *             <ref name="prompt"/>
 *             <ref name="param"/>
 *             <ref name="catch"/>
 *             <ref name="help"/>
 *             <ref name="noinput"/>
 *             <ref name="error"/>
 *             <ref name="filled"/>
 *             <ref name="nomatch"/>
 *             <ref name="property"/>
 *             <ref name="enumerate"/>
 *             <ref name="value"/>
 *           </choice>
 *         </zeroOrMore>
 *       </mixed>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="subdialog"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="name"&gt;
 *           &lt;data type="NMTOKEN"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="cond"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="expr"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;attribute name="src"&gt;
 *         &lt;text/&gt;
 *       &lt;/attribute&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="fetchhint"&gt;
 *           &lt;choice&gt;
 *             &lt;value type="NMTOKEN"&gt;prefetch&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;safe&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="fetchtimeout"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="maxage"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="maxstale"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="fetchaudio"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="method"&gt;
 *           &lt;choice&gt;
 *             &lt;value type="NMTOKEN"&gt;get&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;post&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="enctype"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="namelist"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;mixed&gt;
 *         &lt;zeroOrMore&gt;
 *           &lt;choice&gt;
 *             &lt;ref name="audio"/&gt;
 *             &lt;ref name="prompt"/&gt;
 *             &lt;ref name="param"/&gt;
 *             &lt;ref name="catch"/&gt;
 *             &lt;ref name="help"/&gt;
 *             &lt;ref name="noinput"/&gt;
 *             &lt;ref name="error"/&gt;
 *             &lt;ref name="filled"/&gt;
 *             &lt;ref name="nomatch"/&gt;
 *             &lt;ref name="property"/&gt;
 *             &lt;ref name="enumerate"/&gt;
 *             &lt;ref name="value"/&gt;
 *           &lt;/choice&gt;
 *         &lt;/zeroOrMore&gt;
 *       &lt;/mixed&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version vxml20.rng (Wed Jul 07 07:19:11 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlSubdialog implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlFormChoice {
    public static final String FETCHHINT_PREFETCH = "prefetch";
    public static final String FETCHHINT_SAFE = "safe";
    public static final String METHOD_GET = "get";
    public static final String METHOD_POST = "post";

    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String name_;
    private String cond_;
    private String expr_;
    private String src_;
    private String fetchhint_;
    private String fetchtimeout_;
    private String maxage_;
    private String maxstale_;
    private String fetchaudio_;
    private String method_;
    private String enctype_;
    private String namelist_;
    // List<IVxmlSubdialogMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlSubdialog</code>.
     *
     */
    public VxmlSubdialog() {
        src_ = "";
    }

    /**
     * Creates a <code>VxmlSubdialog</code>.
     *
     * @param source
     */
    public VxmlSubdialog(VxmlSubdialog source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlSubdialog</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlSubdialog(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlSubdialog</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlSubdialog(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlSubdialog</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlSubdialog(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlSubdialog</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlSubdialog(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlSubdialog</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlSubdialog(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlSubdialog</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlSubdialog(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlSubdialog</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlSubdialog(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlSubdialog</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlSubdialog(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlSubdialog</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlSubdialog(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlSubdialog</code> by the VxmlSubdialog <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlSubdialog source) {
        int size;
        name_ = source.name_;
        cond_ = source.cond_;
        expr_ = source.expr_;
        src_ = source.src_;
        fetchhint_ = source.fetchhint_;
        fetchtimeout_ = source.fetchtimeout_;
        maxage_ = source.maxage_;
        maxstale_ = source.maxstale_;
        fetchaudio_ = source.fetchaudio_;
        method_ = source.method_;
        enctype_ = source.enctype_;
        namelist_ = source.namelist_;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlSubdialogMixed)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlSubdialog</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlSubdialog</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlSubdialog</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        cond_ = URelaxer.getAttributePropertyAsString(element, "cond");
        expr_ = URelaxer.getAttributePropertyAsString(element, "expr");
        src_ = URelaxer.getAttributePropertyAsString(element, "src");
        fetchhint_ = URelaxer.getAttributePropertyAsString(element, "fetchhint");
        fetchtimeout_ = URelaxer.getAttributePropertyAsString(element, "fetchtimeout");
        maxage_ = URelaxer.getAttributePropertyAsString(element, "maxage");
        maxstale_ = URelaxer.getAttributePropertyAsString(element, "maxstale");
        fetchaudio_ = URelaxer.getAttributePropertyAsString(element, "fetchaudio");
        method_ = URelaxer.getAttributePropertyAsString(element, "method");
        enctype_ = URelaxer.getAttributePropertyAsString(element, "enctype");
        namelist_ = URelaxer.getAttributePropertyAsString(element, "namelist");
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (VxmlAudio.isMatch(stack)) {
                addContent(new VxmlAudio(stack));
            } else if (VxmlPrompt.isMatch(stack)) {
                addContent(new VxmlPrompt(stack));
            } else if (VxmlParam.isMatch(stack)) {
                addContent(new VxmlParam(stack));
            } else if (VxmlCatch.isMatch(stack)) {
                addContent(new VxmlCatch(stack));
            } else if (VxmlHelp.isMatch(stack)) {
                addContent(new VxmlHelp(stack));
            } else if (VxmlError.isMatch(stack)) {
                addContent(new VxmlError(stack));
            } else if (VxmlNomatch.isMatch(stack)) {
                addContent(new VxmlNomatch(stack));
            } else if (VxmlNoinput.isMatch(stack)) {
                addContent(new VxmlNoinput(stack));
            } else if (VxmlFilled.isMatch(stack)) {
                addContent(new VxmlFilled(stack));
            } else if (VxmlProperty.isMatch(stack)) {
                addContent(new VxmlProperty(stack));
            } else if (VxmlValue.isMatch(stack)) {
                addContent(new VxmlValue(stack));
            } else if (VxmlEnumerate.isMatch(stack)) {
                addContent(new VxmlEnumerate(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlSubdialog((VxmlSubdialog)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "subdialog");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.cond_ != null) {
            URelaxer.setAttributePropertyByString(element, "cond", this.cond_);
        }
        if (this.expr_ != null) {
            URelaxer.setAttributePropertyByString(element, "expr", this.expr_);
        }
        if (this.src_ != null) {
            URelaxer.setAttributePropertyByString(element, "src", this.src_);
        }
        if (this.fetchhint_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchhint", this.fetchhint_);
        }
        if (this.fetchtimeout_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchtimeout", this.fetchtimeout_);
        }
        if (this.maxage_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxage", this.maxage_);
        }
        if (this.maxstale_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxstale", this.maxstale_);
        }
        if (this.fetchaudio_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchaudio", this.fetchaudio_);
        }
        if (this.method_ != null) {
            URelaxer.setAttributePropertyByString(element, "method", this.method_);
        }
        if (this.enctype_ != null) {
            URelaxer.setAttributePropertyByString(element, "enctype", this.enctype_);
        }
        if (this.namelist_ != null) {
            URelaxer.setAttributePropertyByString(element, "namelist", this.namelist_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlSubdialogMixed value = (IVxmlSubdialogMixed)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlSubdialog</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlSubdialog</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlSubdialog</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlSubdialog</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlSubdialog</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlSubdialog</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContent(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContent(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContentByString(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContentByString(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void setContent(org.w3c.dom.Node value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void addContent(org.w3c.dom.Node value) {
        addContent(new RString(value));
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>cond</b>.
     *
     * @return String
     */
    public String getCond() {
        return (cond_);
    }

    /**
     * Sets the String property <b>cond</b>.
     *
     * @param cond
     */
    public void setCond(String cond) {
        this.cond_ = cond;
    }

    /**
     * Gets the String property <b>expr</b>.
     *
     * @return String
     */
    public String getExpr() {
        return (expr_);
    }

    /**
     * Sets the String property <b>expr</b>.
     *
     * @param expr
     */
    public void setExpr(String expr) {
        this.expr_ = expr;
    }

    /**
     * Gets the String property <b>src</b>.
     *
     * @return String
     */
    public String getSrc() {
        return (src_);
    }

    /**
     * Sets the String property <b>src</b>.
     *
     * @param src
     */
    public void setSrc(String src) {
        this.src_ = src;
    }

    /**
     * Gets the String property <b>fetchhint</b>.
     *
     * @return String
     */
    public String getFetchhint() {
        return (fetchhint_);
    }

    /**
     * Sets the String property <b>fetchhint</b>.
     *
     * @param fetchhint
     */
    public void setFetchhint(String fetchhint) {
        this.fetchhint_ = fetchhint;
    }

    /**
     * Gets the String property <b>fetchtimeout</b>.
     *
     * @return String
     */
    public String getFetchtimeout() {
        return (fetchtimeout_);
    }

    /**
     * Sets the String property <b>fetchtimeout</b>.
     *
     * @param fetchtimeout
     */
    public void setFetchtimeout(String fetchtimeout) {
        this.fetchtimeout_ = fetchtimeout;
    }

    /**
     * Gets the String property <b>maxage</b>.
     *
     * @return String
     */
    public String getMaxage() {
        return (maxage_);
    }

    /**
     * Sets the String property <b>maxage</b>.
     *
     * @param maxage
     */
    public void setMaxage(String maxage) {
        this.maxage_ = maxage;
    }

    /**
     * Gets the String property <b>maxstale</b>.
     *
     * @return String
     */
    public String getMaxstale() {
        return (maxstale_);
    }

    /**
     * Sets the String property <b>maxstale</b>.
     *
     * @param maxstale
     */
    public void setMaxstale(String maxstale) {
        this.maxstale_ = maxstale;
    }

    /**
     * Gets the String property <b>fetchaudio</b>.
     *
     * @return String
     */
    public String getFetchaudio() {
        return (fetchaudio_);
    }

    /**
     * Sets the String property <b>fetchaudio</b>.
     *
     * @param fetchaudio
     */
    public void setFetchaudio(String fetchaudio) {
        this.fetchaudio_ = fetchaudio;
    }

    /**
     * Gets the String property <b>method</b>.
     *
     * @return String
     */
    public String getMethod() {
        return (method_);
    }

    /**
     * Sets the String property <b>method</b>.
     *
     * @param method
     */
    public void setMethod(String method) {
        this.method_ = method;
    }

    /**
     * Gets the String property <b>enctype</b>.
     *
     * @return String
     */
    public String getEnctype() {
        return (enctype_);
    }

    /**
     * Sets the String property <b>enctype</b>.
     *
     * @param enctype
     */
    public void setEnctype(String enctype) {
        this.enctype_ = enctype;
    }

    /**
     * Gets the String property <b>namelist</b>.
     *
     * @return String
     */
    public String getNamelist() {
        return (namelist_);
    }

    /**
     * Sets the String property <b>namelist</b>.
     *
     * @param namelist
     */
    public void setNamelist(String namelist) {
        this.namelist_ = namelist;
    }

    /**
     * Gets the IVxmlSubdialogMixed property <b>content</b>.
     *
     * @return IVxmlSubdialogMixed[]
     */
    public IVxmlSubdialogMixed[] getContent() {
        IVxmlSubdialogMixed[] array = new IVxmlSubdialogMixed[content_.size()];
        return ((IVxmlSubdialogMixed[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlSubdialogMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlSubdialogMixed[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlSubdialogMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlSubdialogMixed content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlSubdialogMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlSubdialogMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlSubdialogMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlSubdialogMixed[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlSubdialogMixed property <b>content</b>.
     *
     * @return int
     */
    public int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlSubdialogMixed property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlSubdialogMixed
     */
    public IVxmlSubdialogMixed getContent(int index) {
        return ((IVxmlSubdialogMixed)content_.get(index));
    }

    /**
     * Sets the IVxmlSubdialogMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void setContent(int index, IVxmlSubdialogMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlSubdialogMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void addContent(int index, IVxmlSubdialogMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlSubdialogMixed property <b>content</b> by index.
     *
     * @param index
     */
    public void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlSubdialogMixed property <b>content</b> by object.
     *
     * @param content
     */
    public void removeContent(IVxmlSubdialogMixed content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlSubdialogMixed property <b>content</b>.
     *
     */
    public void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "subdialog", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.append(" ");
            buffer.append("name");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.append("\"");
        }
        if (cond_ != null) {
            buffer.append(" ");
            buffer.append("cond");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.append("\"");
        }
        if (expr_ != null) {
            buffer.append(" ");
            buffer.append("expr");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.append("\"");
        }
        if (src_ != null) {
            buffer.append(" ");
            buffer.append("src");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getSrc())));
            buffer.append("\"");
        }
        if (fetchhint_ != null) {
            buffer.append(" ");
            buffer.append("fetchhint");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.append("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.append(" ");
            buffer.append("fetchtimeout");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.append("\"");
        }
        if (maxage_ != null) {
            buffer.append(" ");
            buffer.append("maxage");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.append("\"");
        }
        if (maxstale_ != null) {
            buffer.append(" ");
            buffer.append("maxstale");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.append("\"");
        }
        if (fetchaudio_ != null) {
            buffer.append(" ");
            buffer.append("fetchaudio");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchaudio())));
            buffer.append("\"");
        }
        if (method_ != null) {
            buffer.append(" ");
            buffer.append("method");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMethod())));
            buffer.append("\"");
        }
        if (enctype_ != null) {
            buffer.append(" ");
            buffer.append("enctype");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getEnctype())));
            buffer.append("\"");
        }
        if (namelist_ != null) {
            buffer.append(" ");
            buffer.append("namelist");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getNamelist())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlSubdialogMixed value = (IVxmlSubdialogMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlSubdialogMixed value = (IVxmlSubdialogMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "subdialog", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "subdialog", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.write(" ");
            buffer.write("name");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.write("\"");
        }
        if (cond_ != null) {
            buffer.write(" ");
            buffer.write("cond");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.write("\"");
        }
        if (expr_ != null) {
            buffer.write(" ");
            buffer.write("expr");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.write("\"");
        }
        if (src_ != null) {
            buffer.write(" ");
            buffer.write("src");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getSrc())));
            buffer.write("\"");
        }
        if (fetchhint_ != null) {
            buffer.write(" ");
            buffer.write("fetchhint");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.write("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.write(" ");
            buffer.write("fetchtimeout");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.write("\"");
        }
        if (maxage_ != null) {
            buffer.write(" ");
            buffer.write("maxage");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.write("\"");
        }
        if (maxstale_ != null) {
            buffer.write(" ");
            buffer.write("maxstale");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.write("\"");
        }
        if (fetchaudio_ != null) {
            buffer.write(" ");
            buffer.write("fetchaudio");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchaudio())));
            buffer.write("\"");
        }
        if (method_ != null) {
            buffer.write(" ");
            buffer.write("method");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMethod())));
            buffer.write("\"");
        }
        if (enctype_ != null) {
            buffer.write(" ");
            buffer.write("enctype");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getEnctype())));
            buffer.write("\"");
        }
        if (namelist_ != null) {
            buffer.write(" ");
            buffer.write("namelist");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getNamelist())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlSubdialogMixed value = (IVxmlSubdialogMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlSubdialogMixed value = (IVxmlSubdialogMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "subdialog", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "subdialog", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.print(" ");
            buffer.print("name");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.print("\"");
        }
        if (cond_ != null) {
            buffer.print(" ");
            buffer.print("cond");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.print("\"");
        }
        if (expr_ != null) {
            buffer.print(" ");
            buffer.print("expr");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.print("\"");
        }
        if (src_ != null) {
            buffer.print(" ");
            buffer.print("src");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getSrc())));
            buffer.print("\"");
        }
        if (fetchhint_ != null) {
            buffer.print(" ");
            buffer.print("fetchhint");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.print("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.print(" ");
            buffer.print("fetchtimeout");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.print("\"");
        }
        if (maxage_ != null) {
            buffer.print(" ");
            buffer.print("maxage");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.print("\"");
        }
        if (maxstale_ != null) {
            buffer.print(" ");
            buffer.print("maxstale");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.print("\"");
        }
        if (fetchaudio_ != null) {
            buffer.print(" ");
            buffer.print("fetchaudio");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchaudio())));
            buffer.print("\"");
        }
        if (method_ != null) {
            buffer.print(" ");
            buffer.print("method");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMethod())));
            buffer.print("\"");
        }
        if (enctype_ != null) {
            buffer.print(" ");
            buffer.print("enctype");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getEnctype())));
            buffer.print("\"");
        }
        if (namelist_ != null) {
            buffer.print(" ");
            buffer.print("namelist");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getNamelist())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlSubdialogMixed value = (IVxmlSubdialogMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlSubdialogMixed value = (IVxmlSubdialogMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "subdialog", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCondAsString() {
        return (URelaxer.getString(getCond()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getExprAsString() {
        return (URelaxer.getString(getExpr()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getSrcAsString() {
        return (URelaxer.getString(getSrc()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchhintAsString() {
        return (URelaxer.getString(getFetchhint()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchtimeoutAsString() {
        return (URelaxer.getString(getFetchtimeout()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaxageAsString() {
        return (URelaxer.getString(getMaxage()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaxstaleAsString() {
        return (URelaxer.getString(getMaxstale()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchaudioAsString() {
        return (URelaxer.getString(getFetchaudio()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMethodAsString() {
        return (URelaxer.getString(getMethod()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getEnctypeAsString() {
        return (URelaxer.getString(getEnctype()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNamelistAsString() {
        return (URelaxer.getString(getNamelist()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCondByString(String string) {
        setCond(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setExprByString(String string) {
        setExpr(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setSrcByString(String string) {
        setSrc(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchhintByString(String string) {
        setFetchhint(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchtimeoutByString(String string) {
        setFetchtimeout(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaxageByString(String string) {
        setMaxage(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaxstaleByString(String string) {
        setMaxstale(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchaudioByString(String string) {
        setFetchaudio(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMethodByString(String string) {
        setMethod(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setEnctypeByString(String string) {
        setEnctype(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNamelistByString(String string) {
        setNamelist(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlSubdialog</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "subdialog")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "src")) {
            return (false);
        }
        $match$ = true;
        if (RString.isMatch(target)) {
            $match$ = true;
        }
        while (true) {
            if (VxmlAudio.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPrompt.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlParam.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlCatch.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlHelp.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlError.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNomatch.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNoinput.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlFilled.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlProperty.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEnumerate.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlSubdialog</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlSubdialog</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
