/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.*;

/**
 * <b>VxmlMediaMixed</b> is generated from vxml20.rng by Relaxer.
 *
 * @version vxml20.rng (Wed Jul 07 07:19:11 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlMediaMixed implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlMediaChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    // List<IVxmlMediaMixedMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlMediaMixed</code>.
     *
     */
    public VxmlMediaMixed() {
    }

    /**
     * Creates a <code>VxmlMediaMixed</code>.
     *
     * @param source
     */
    public VxmlMediaMixed(VxmlMediaMixed source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlMediaMixed</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlMediaMixed(RStack stack) {
        setup(stack);
    }

    /**
     * Initializes the <code>VxmlMediaMixed</code> by the VxmlMediaMixed <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlMediaMixed source) {
        int size;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlMediaMixedMixed)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlMediaMixed</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        Element element = stack.getContextElement();
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (VxmlProsody.isMatch(stack)) {
                addContent(new VxmlProsody(stack));
            } else if (VxmlAudio.isMatch(stack)) {
                addContent(new VxmlAudio(stack));
            } else if (VxmlVoice.isMatch(stack)) {
                addContent(new VxmlVoice(stack));
            } else if (VxmlEmotion.isMatch(stack)) {
                addContent(new VxmlEmotion(stack));
            } else if (VxmlREGWORD.isMatch(stack)) {
                addContent(new VxmlREGWORD(stack));
            } else if (VxmlCONTEXT.isMatch(stack)) {
                addContent(new VxmlCONTEXT(stack));
            } else if (VxmlJVOICE.isMatch(stack)) {
                addContent(new VxmlJVOICE(stack));
            } else if (VxmlPITCH.isMatch(stack)) {
                addContent(new VxmlPITCH(stack));
            } else if (VxmlBreak.isMatch(stack)) {
                addContent(new VxmlBreak(stack));
            } else if (VxmlPhoneme.isMatch(stack)) {
                addContent(new VxmlPhoneme(stack));
            } else if (VxmlSayAs.isMatch(stack)) {
                addContent(new VxmlSayAs(stack));
            } else if (VxmlParagraph.isMatch(stack)) {
                addContent(new VxmlParagraph(stack));
            } else if (VxmlP.isMatch(stack)) {
                addContent(new VxmlP(stack));
            } else if (VxmlSentence.isMatch(stack)) {
                addContent(new VxmlSentence(stack));
            } else if (VxmlPARTOFSP.isMatch(stack)) {
                addContent(new VxmlPARTOFSP(stack));
            } else if (VxmlPRON.isMatch(stack)) {
                addContent(new VxmlPRON(stack));
            } else if (VxmlVOLUME.isMatch(stack)) {
                addContent(new VxmlVOLUME(stack));
            } else if (VxmlS.isMatch(stack)) {
                addContent(new VxmlS(stack));
            } else if (VxmlLANG.isMatch(stack)) {
                addContent(new VxmlLANG(stack));
            } else if (VxmlRATE.isMatch(stack)) {
                addContent(new VxmlRATE(stack));
            } else if (VxmlValue.isMatch(stack)) {
                addContent(new VxmlValue(stack));
            } else if (VxmlEmphasis.isMatch(stack)) {
                addContent(new VxmlEmphasis(stack));
            } else if (VxmlMark.isMatch(stack)) {
                addContent(new VxmlMark(stack));
            } else if (VxmlBOOKMARK.isMatch(stack)) {
                addContent(new VxmlBOOKMARK(stack));
            } else if (VxmlSPELL.isMatch(stack)) {
                addContent(new VxmlSPELL(stack));
            } else if (VxmlSILENCE.isMatch(stack)) {
                addContent(new VxmlSILENCE(stack));
            } else if (VxmlEnumerate.isMatch(stack)) {
                addContent(new VxmlEnumerate(stack));
            } else if (VxmlEMPH.isMatch(stack)) {
                addContent(new VxmlEMPH(stack));
            } else if (VxmlSPEECH.isMatch(stack)) {
                addContent(new VxmlSPEECH(stack));
            } else if (VxmlRESET.isMatch(stack)) {
                addContent(new VxmlRESET(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlMediaMixed((VxmlMediaMixed)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc = parent.getOwnerDocument();
        Element element = (Element)parent;
        int size;
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlMediaMixedMixed value = (IVxmlMediaMixedMixed)this.content_.get(i);
            value.makeElement(element);
        }
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContent(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContent(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContentByString(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContentByString(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void setContent(org.w3c.dom.Node value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void addContent(org.w3c.dom.Node value) {
        addContent(new RString(value));
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the IVxmlMediaMixedMixed property <b>content</b>.
     *
     * @return IVxmlMediaMixedMixed[]
     */
    public IVxmlMediaMixedMixed[] getContent() {
        IVxmlMediaMixedMixed[] array = new IVxmlMediaMixedMixed[content_.size()];
        return ((IVxmlMediaMixedMixed[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlMediaMixedMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlMediaMixedMixed[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlMediaMixedMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlMediaMixedMixed content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlMediaMixedMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlMediaMixedMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlMediaMixedMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlMediaMixedMixed[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlMediaMixedMixed property <b>content</b>.
     *
     * @return int
     */
    public int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlMediaMixedMixed property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlMediaMixedMixed
     */
    public IVxmlMediaMixedMixed getContent(int index) {
        return ((IVxmlMediaMixedMixed)content_.get(index));
    }

    /**
     * Sets the IVxmlMediaMixedMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void setContent(int index, IVxmlMediaMixedMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlMediaMixedMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void addContent(int index, IVxmlMediaMixedMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlMediaMixedMixed property <b>content</b> by index.
     *
     * @param index
     */
    public void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlMediaMixedMixed property <b>content</b> by object.
     *
     * @param content
     */
    public void removeContent(IVxmlMediaMixedMixed content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlMediaMixedMixed property <b>content</b>.
     *
     */
    public void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlMediaMixedMixed value = (IVxmlMediaMixedMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlMediaMixedMixed value = (IVxmlMediaMixedMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlMediaMixedMixed value = (IVxmlMediaMixedMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
        int size;
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlMediaMixedMixed value = (IVxmlMediaMixedMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
        int size;
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlMediaMixedMixed value = (IVxmlMediaMixedMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
        int size;
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlMediaMixedMixed value = (IVxmlMediaMixedMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlMediaMixed</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        return (isMatchHungry(stack.makeClone()));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlMediaMixed</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        RStack target = stack;
        boolean $match$ = false;
        Element element = stack.peekElement();
        Element child;
        if (RString.isMatch(target)) {
            $match$ = true;
        }
        while (true) {
            if (VxmlProsody.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlAudio.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmotion.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlREGWORD.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlCONTEXT.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlJVOICE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPITCH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBreak.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPhoneme.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSayAs.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlParagraph.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSentence.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPARTOFSP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPRON.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVOLUME.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlS.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlLANG.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRATE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmphasis.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlMark.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBOOKMARK.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPELL.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSILENCE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEnumerate.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEMPH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPEECH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRESET.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        return ($match$);
    }
}
