/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.pdoc;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PdocCatch</b> is generated from pdoc.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="catch">
 *       <optional>
 *         <attribute name="event">
 *           <data type="token"/>
 *         </attribute>
 *       </optional>
 *       <attribute name="next">
 *         <data type="token"/>
 *       </attribute>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="catch"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="event"&gt;
 *           &lt;data type="token"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;attribute name="next"&gt;
 *         &lt;data type="token"/&gt;
 *       &lt;/attribute&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version pdoc.rng (Tue Nov 30 11:23:39 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class PdocCatch implements java.io.Serializable, Cloneable {
    private String event_;
    private String next_;

    /**
     * Creates a <code>PdocCatch</code>.
     *
     */
    public PdocCatch() {
        next_ = "";
    }

    /**
     * Creates a <code>PdocCatch</code>.
     *
     * @param source
     */
    public PdocCatch(PdocCatch source) {
        setup(source);
    }

    /**
     * Creates a <code>PdocCatch</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PdocCatch(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PdocCatch</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PdocCatch(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PdocCatch</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PdocCatch(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PdocCatch</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCatch(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PdocCatch</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCatch(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PdocCatch</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCatch(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PdocCatch</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCatch(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PdocCatch</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCatch(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PdocCatch</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCatch(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PdocCatch</code> by the PdocCatch <code>source</code>.
     *
     * @param source
     */
    public void setup(PdocCatch source) {
        int size;
        event_ = source.event_;
        next_ = source.next_;
    }

    /**
     * Initializes the <code>PdocCatch</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PdocCatch</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PdocCatch</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        event_ = URelaxer.getAttributePropertyAsString(element, "event");
        next_ = URelaxer.getAttributePropertyAsString(element, "next");
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new PdocCatch((PdocCatch)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("catch");
        int size;
        if (this.event_ != null) {
            URelaxer.setAttributePropertyByString(element, "event", this.event_);
        }
        if (this.next_ != null) {
            URelaxer.setAttributePropertyByString(element, "next", this.next_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PdocCatch</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PdocCatch</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocCatch</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocCatch</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocCatch</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocCatch</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>event</b>.
     *
     * @return String
     */
    public String getEvent() {
        return (event_);
    }

    /**
     * Sets the String property <b>event</b>.
     *
     * @param event
     */
    public void setEvent(String event) {
        this.event_ = event;
    }

    /**
     * Gets the String property <b>next</b>.
     *
     * @return String
     */
    public String getNext() {
        return (next_);
    }

    /**
     * Sets the String property <b>next</b>.
     *
     * @param next
     */
    public void setNext(String next) {
        this.next_ = next;
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<catch");
        if (event_ != null) {
            buffer.append(" event=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.append("\"");
        }
        if (next_ != null) {
            buffer.append(" next=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getNext())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</catch>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<catch");
        if (event_ != null) {
            buffer.write(" event=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.write("\"");
        }
        if (next_ != null) {
            buffer.write(" next=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getNext())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</catch>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<catch");
        if (event_ != null) {
            buffer.print(" event=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.print("\"");
        }
        if (next_ != null) {
            buffer.print(" next=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getNext())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</catch>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getEventAsString() {
        return (URelaxer.getString(getEvent()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNextAsString() {
        return (URelaxer.getString(getNext()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setEventByString(String string) {
        setEvent(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNextByString(String string) {
        setNext(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PdocCatch</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "catch")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "next")) {
            return (false);
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocCatch</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocCatch</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
