/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.pdoc;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PdocBody</b> is generated from pdoc.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="body">
 *       <attribute name="start">
 *         <data type="token"/>
 *       </attribute>
 *       <oneOrMore>
 *         <ref name="state"/>
 *       </oneOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="body"&gt;
 *       &lt;attribute name="start"&gt;
 *         &lt;data type="token"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;oneOrMore&gt;
 *         &lt;ref name="state"/&gt;
 *       &lt;/oneOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version pdoc.rng (Tue Nov 30 11:23:39 JST 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class PdocBody implements java.io.Serializable, Cloneable {
    private String start_;
    // List<PdocState>
    private java.util.List state_ = new java.util.ArrayList();

    /**
     * Creates a <code>PdocBody</code>.
     *
     */
    public PdocBody() {
        start_ = "";
    }

    /**
     * Creates a <code>PdocBody</code>.
     *
     * @param source
     */
    public PdocBody(PdocBody source) {
        setup(source);
    }

    /**
     * Creates a <code>PdocBody</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PdocBody(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PdocBody</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PdocBody(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PdocBody</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PdocBody(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PdocBody</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocBody(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PdocBody</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocBody(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PdocBody</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocBody(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PdocBody</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocBody(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PdocBody</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocBody(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PdocBody</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocBody(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PdocBody</code> by the PdocBody <code>source</code>.
     *
     * @param source
     */
    public void setup(PdocBody source) {
        int size;
        start_ = source.start_;
        this.state_.clear();
        size = source.state_.size();
        for (int i = 0;i < size;i++) {
            addState((PdocState)source.getState(i).clone());
        }
    }

    /**
     * Initializes the <code>PdocBody</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PdocBody</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PdocBody</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        start_ = URelaxer.getAttributePropertyAsString(element, "start");
        state_.clear();
        while (true) {
            if (PdocState.isMatch(stack)) {
                addState(new PdocState(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new PdocBody((PdocBody)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("body");
        int size;
        if (this.start_ != null) {
            URelaxer.setAttributePropertyByString(element, "start", this.start_);
        }
        size = this.state_.size();
        for (int i = 0;i < size;i++) {
            PdocState value = (PdocState)this.state_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PdocBody</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PdocBody</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocBody</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocBody</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocBody</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocBody</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>start</b>.
     *
     * @return String
     */
    public String getStart() {
        return (start_);
    }

    /**
     * Sets the String property <b>start</b>.
     *
     * @param start
     */
    public void setStart(String start) {
        this.start_ = start;
    }

    /**
     * Gets the PdocState property <b>state</b>.
     *
     * @return PdocState[]
     */
    public PdocState[] getState() {
        PdocState[] array = new PdocState[state_.size()];
        return ((PdocState[])state_.toArray(array));
    }

    /**
     * Sets the PdocState property <b>state</b>.
     *
     * @param state
     */
    public void setState(PdocState[] state) {
        this.state_.clear();
        for (int i = 0;i < state.length;i++) {
            addState(state[i]);
        }
    }

    /**
     * Sets the PdocState property <b>state</b>.
     *
     * @param state
     */
    public void setState(PdocState state) {
        this.state_.clear();
        addState(state);
    }

    /**
     * Adds the PdocState property <b>state</b>.
     *
     * @param state
     */
    public void addState(PdocState state) {
        this.state_.add(state);
    }

    /**
     * Adds the PdocState property <b>state</b>.
     *
     * @param state
     */
    public void addState(PdocState[] state) {
        for (int i = 0;i < state.length;i++) {
            addState(state[i]);
        }
    }

    /**
     * Gets number of the PdocState property <b>state</b>.
     *
     * @return int
     */
    public int sizeState() {
        return (state_.size());
    }

    /**
     * Gets the PdocState property <b>state</b> by index.
     *
     * @param index
     * @return PdocState
     */
    public PdocState getState(int index) {
        return ((PdocState)state_.get(index));
    }

    /**
     * Sets the PdocState property <b>state</b> by index.
     *
     * @param index
     * @param state
     */
    public void setState(int index, PdocState state) {
        this.state_.set(index, state);
    }

    /**
     * Adds the PdocState property <b>state</b> by index.
     *
     * @param index
     * @param state
     */
    public void addState(int index, PdocState state) {
        this.state_.add(index, state);
    }

    /**
     * Remove the PdocState property <b>state</b> by index.
     *
     * @param index
     */
    public void removeState(int index) {
        this.state_.remove(index);
    }

    /**
     * Remove the PdocState property <b>state</b> by object.
     *
     * @param state
     */
    public void removeState(PdocState state) {
        this.state_.remove(state);
    }

    /**
     * Clear the PdocState property <b>state</b>.
     *
     */
    public void clearState() {
        this.state_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<body");
        if (start_ != null) {
            buffer.append(" start=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getStart())));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.state_.size();
        for (int i = 0;i < size;i++) {
            PdocState value = (PdocState)this.state_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</body>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<body");
        if (start_ != null) {
            buffer.write(" start=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getStart())));
            buffer.write("\"");
        }
        buffer.write(">");
        size = this.state_.size();
        for (int i = 0;i < size;i++) {
            PdocState value = (PdocState)this.state_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</body>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<body");
        if (start_ != null) {
            buffer.print(" start=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getStart())));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.state_.size();
        for (int i = 0;i < size;i++) {
            PdocState value = (PdocState)this.state_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</body>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getStartAsString() {
        return (URelaxer.getString(getStart()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setStartByString(String string) {
        setStart(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PdocBody</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "body")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "start")) {
            return (false);
        }
        $match$ = true;
        if (!PdocState.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (!PdocState.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocBody</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocBody</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
