/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: Logger.java,v 1.1 2008/02/14 02:00:07 nishi Exp $
 */

package galatea.logger;

import galatea.util.Property;

import java.util.ArrayList;

public class Logger
{
	private int debuglevel;
	static private int count_ = 0;
	private String name_ = "DM";
	
	private static ArrayList<ILoggerListener> 
		listeners = new ArrayList<ILoggerListener>();

	public static void addListener(ILoggerListener ls) {
		listeners.add(ls);
	}

	public Logger(String name, int defaultLevel) {
		this.debuglevel = Property.getAsInt("Logger." + name, defaultLevel);
//		if (s == null) {
//			this.debuglevel = defaultLevel;
//		} else {
//			this.debuglevel = Integer.parseInt(s);
//		}
		name_ = name;
	}
	
	public Logger(String name) {
		this.debuglevel = Property.getAsInt("Logger." + name, 0);
//		String s = System.getProperty("Logger." + name);
//		if (s == null) {
//			this.debuglevel = 0;
//		} else {
//			this.debuglevel = Integer.parseInt(s);
//		}
		name_ = name;
	}
	
	public Logger() {
		this.debuglevel = 0;
	}
	
	public void setLevel(int level) {
		this.debuglevel = level;
	}
	
	public int getLevel() {
		return(this.debuglevel);
	}
	
	public static void doPrint(String msg, String name) {
		String str = "[" + (++count_) + " " + name + " " 
				+ Thread.currentThread().getName() 
				+ "] " + msg;
		// System.err.println(str);
    	for (ILoggerListener l : listeners) {
    		l.addLoggerEvent(str);
    	}
	}
		
	public void print(String msg) {
		if(this.debuglevel != 0)
			Logger.doPrint(msg, name_);
	}
	
	// level 0: most important
	public void print(String msg, int level) {
		if(this.debuglevel >= level)
			Logger.doPrint(msg, name_);
	}
	
	public void err(String msg) {
		if(this.debuglevel != 0)
			System.err.println(msg);
	}
	
	public void err(String msg, int level) {
		if(this.debuglevel >= level)
			System.err.println(msg);
	}
	
	public void DIE(Exception e) {
		if(this.debuglevel != 0) {
			/*
			 System.out.println("to @MON set SysLogText = " 
			 + "DIE:");
			 e.printStackTrace();
			 */
			System.err.println("DIE");
			System.exit(1);
		}
	}
	
	public void DIE(String msg) {
		if(this.debuglevel != 0) {
			/*
			 System.out.println("to @MON set SysLogText = " 
			 + "DIE: "+msg);
			 */
			System.err.println("DIE: "+msg);
			System.exit(1);
		}
	}
	
	public void ASSERT(boolean bool, String msg) {
		if(this.debuglevel != 0) {
			if (bool == false) {
				/*
				 System.out.println("to @MON set SysLogText = " 
				 + "ASSERTION FAILED: " + msg);
				 */
				System.err.println("ASSERTION FAILED: "+msg);
				System.exit(1);
			}
		}
	}
	
	public void ASSERT(boolean bool, String msg, int level) {
		if(this.debuglevel >= level) {
			if (bool == false) {
				/*
				 System.out.println("to @MON set SysLogText = " 
				 + "ASSERTION FAILED: " + msg);
				 */
				System.err.println("ASSERTION FAILED: "+msg);
				System.exit(1);
			}
		}
	}
	
	
	//
	// 1: this is shown.
	// 2: this is shown.
	// ASSERTION FAILED: 5: this is shown.
	//
	public static void main(String args[]) throws Exception
	{
		Logger dbg = new Logger("DM", 5);
		
		dbg.print("1: this is shown.", 4);
		dbg.print("2: this is shown.", 5);
		dbg.print("3: not shown.", 6);
		
		int a = 1;
		int b = 2;
		dbg.ASSERT( a == a, "4: not shown." );
		dbg.ASSERT( a == b, "5: this is shown.", 4 );
		dbg.ASSERT( a == b, "6: not shown.", 5 ); // not executed
		dbg.ASSERT( a == b, "7: not shown.", 6);  // not executed
	}
}
