/*
 * Galatea Dialog Manager:
 * (c)2004 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 * $Id: InterpretedEventQueueManager.java,v 1.3 2008/02/14 02:00:07 nishi Exp $
 */
package galatea.dialog;


import galatea.logger.Logger;

import java.util.ArrayList;

public class InterpretedEventQueueManager {
	private Logger dbg = new Logger("InterpretedEventQueueManager", 0);
	private ArrayList<InterpretedEvent> queue_; // ArrayList<InterpretedEvent>
	
	public InterpretedEventQueueManager() {
		queue_ = new ArrayList<InterpretedEvent>();
	}
	
	public synchronized void discard() {
		queue_.clear();
	}
	
	public synchronized void enqueue(InterpretedEvent o) {
		queue_.add(o);
		dbg.print("EQM: added " + o.getClass().getName() 
				+ ", total:" + queue_.size() );
	}
	
	public synchronized InterpretedEvent dequeue() {
		InterpretedEvent ret;
		if (queue_.isEmpty()) {
			return null;
		} else {
			ret = (InterpretedEvent)queue_.remove(0);
			dbg.print("EQM: removed " + ret.getClass().getName() 
					+ ", total:" + queue_.size() );
			return ret;
		}
	}
	
}
