/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: GotoCommand.java,v 1.2 2006/11/20 01:13:35 nishi Exp $
 */

package galatea.command;

import galatea.dialog.RuntimeError;

//import galatea.main.*;

public class GotoCommand extends Command
{
//	private Debug dbg = new Debug(1);
	
	private String next_;
	
	public GotoCommand(String next)
	{
		next_ = next;
	}
	
	public GotoCommand(String next, String cond)
	{
		next_ = next;
		setCondition(cond);
	}
	
	public String getNext()
	{
		return(next_);
	}
	
	
	public String toString()
	{
		String s = "  <goto";
		if ( hasCondition() ) {
			s += " cond=\"" + getConditionAsEncodedString() + "\"";
		}
		s += ">";
		s += next_ + "</goto>";
		return s;
	}
	
	
	public void execute() throws RuntimeError
	{
		String state = ecmascript_.evaluate(next_);
		
		if ( evaluateCondition() == true ) {
			interpreterContext_.gotoState(state);
		}
	}
	
}
