/*
 * (c)2004 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 *  $Id: Vector3D.java,v 1.1 2006/11/17 02:31:20 nishi Exp $
 */

package galatea.agent;

//import galatea.main.*;
//import java.util.*;

public class Vector3D
{
	public double x, y, z;
	
	private double xMin_, yMin_, zMin_;
	private double xMax_, yMax_, zMax_;
	
	private static double SMALL_VALUE = 0.02;
	
	public Vector3D(double d1, double d2, double d3)
	{
		x = d1;
		y = d2;
		z = d3;
	}
	
	public Vector3D set(double d1, double d2, double d3)
	{
		x = d1;
		y = d2;
		z = d3;
		return this;
	}
	
	public Vector3D set(Vector3D v)
	{
		x = v.x;
		y = v.y;
		z = v.z;
		return this;
	}
	
	public Vector3D add(Vector3D v)
	{
		x += v.x;
		y += v.y;
		z += v.z;
		return this;
	}
	
	public Vector3D setLimitter(double d1, double d2, double d3)
	{
		xMin_ = -d1;
		yMin_ = -d2;
		zMin_ = -d3;
		
		xMax_ = d1;
		yMax_ = d2;
		zMax_ = d3;
		return this;
	}
	
	public Vector3D applyLimitter()
	{
		if (x < xMin_) { x = xMin_; }
		if (y < yMin_) { y = yMin_; }
		if (z < zMin_) { z = zMin_; }
		if (x > xMax_) { x = xMax_; }
		if (y > yMax_) { y = yMax_; }
		if (z > zMax_) { z = zMax_; }
		return this;
	}
	
	public boolean equals(Vector3D v)
	{
		if (v == null) {
			return false;
		}
		if ( (Math.abs(x - v.x) < SMALL_VALUE)
				&& (Math.abs(y - v.y) < SMALL_VALUE)
				&& (Math.abs(z - v.z) < SMALL_VALUE) ) {
			return true;
		}
		return false;
	}
	
}
