/*
 * Decompiled with CFR 0.152.
 */
package galatea.util;

import galatea.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;

public class Property {
    public static boolean getAsBoolean(String name, boolean defval) {
        String s = System.getProperty(name, null);
        if (s == null) {
            return defval;
        }
        return Integer.parseInt(s) != 0;
    }

    public static double getAsDouble(String name, double defval) {
        String s = System.getProperty(name, null);
        if (s == null) {
            return defval;
        }
        return Double.parseDouble(s);
    }

    public static int getAsInt(String name, int defval) {
        String s = System.getProperty(name, null);
        if (s == null) {
            return defval;
        }
        return Integer.parseInt(s);
    }

    public static String getAsStr(String name, String defval) {
        String s = System.getProperty(name, null);
        if (s == null) {
            return defval;
        }
        return s;
    }

    public static String getConfigStrings() {
        ArrayList<String> al = new ArrayList<String>();
        Enumeration<Object> en = System.getProperties().keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String val = System.getProperty(key);
            String s = String.valueOf(key) + "=" + val + "\n";
            al.add(s);
        }
        Object[] oa = al.toArray();
        Arrays.sort(oa, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return ((String)arg0).compareTo((String)arg1);
            }
        });
        String config = "";
        int i = 0;
        while (i < oa.length) {
            config = String.valueOf(config) + oa[i];
            ++i;
        }
        return config;
    }

    public static String getForPlatformAsStr(String name, String defval) {
        if (Util.isWindows()) {
            return Property.getAsStr(String.valueOf(name) + ".Windows", defval);
        }
        return Property.getAsStr(name, defval);
    }

    public static boolean getForPlatformAsBoolean(String name, boolean defval) {
        if (Util.isWindows()) {
            return Property.getAsBoolean(String.valueOf(name) + ".Windows", defval);
        }
        return Property.getAsBoolean(name, defval);
    }

    public static int getForPlatformAsInt(String name, int defval) {
        if (Util.isWindows()) {
            return Property.getAsInt(String.valueOf(name) + ".Windows", defval);
        }
        return Property.getAsInt(name, defval);
    }
}

