/*
 * Decompiled with CFR 0.152.
 */
package galatea.relaxer.pdoc;

import galatea.relaxer.pdoc.IPdocAddChoice;
import galatea.relaxer.pdoc.RStack;
import galatea.relaxer.pdoc.UJAXP;
import galatea.relaxer.pdoc.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PdocBreak
implements Serializable,
Cloneable,
IPdocAddChoice {
    private String content_;
    private Double length_ = new Double(0.0);
    private Boolean bargein_ = Boolean.TRUE;

    public PdocBreak() {
    }

    public PdocBreak(PdocBreak source) {
        this.setup(source);
    }

    public PdocBreak(RStack stack) {
        this.setup(stack);
    }

    public PdocBreak(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public PdocBreak(Element element) {
        this.setup(element);
    }

    public PdocBreak(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PdocBreak(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public PdocBreak(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public PdocBreak(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public PdocBreak(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public PdocBreak(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PdocBreak source) {
        this.content_ = source.content_;
        this.length_ = source.length_;
        this.bargein_ = source.bargein_;
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.content_ = URelaxer.getElementPropertyAsString(element);
        this.length_ = URelaxer.getAttributePropertyAsDoubleObject(element, "length");
        this.bargein_ = URelaxer.getAttributePropertyAsBooleanObject(element, "bargein");
    }

    @Override
    public Object clone() {
        return new PdocBreak(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("break");
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.length_ != null) {
            URelaxer.setAttributePropertyByDouble(element, "length", this.length_);
        }
        if (this.bargein_ != null) {
            URelaxer.setAttributePropertyByBoolean(element, "bargein", this.bargein_);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    @Override
    public String getContent() {
        return this.content_;
    }

    @Override
    public void setContent(String content) {
        this.content_ = content;
    }

    public double getLength() {
        if (this.length_ == null) {
            return 0.0;
        }
        return this.length_;
    }

    public double getLength(double length) {
        if (this.length_ == null) {
            return length;
        }
        return this.length_;
    }

    public Double getLengthAsDouble() {
        return this.length_;
    }

    public boolean checkLength() {
        return this.length_ != null;
    }

    public void setLength(double length) {
        this.length_ = new Double(length);
    }

    public void setLength(Double length) {
        this.length_ = length;
    }

    public boolean getBargein() {
        if (this.bargein_ == null) {
            return true;
        }
        return this.bargein_;
    }

    public boolean getBargein(boolean bargein) {
        if (this.bargein_ == null) {
            return bargein;
        }
        return this.bargein_;
    }

    public Boolean getBargeinAsBoolean() {
        return this.bargein_;
    }

    public boolean checkBargein() {
        return this.bargein_ != null;
    }

    public void setBargein(boolean bargein) {
        this.bargein_ = new Boolean(bargein);
    }

    public void setBargein(Boolean bargein) {
        this.bargein_ = bargein;
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<break");
        if (this.length_ != null) {
            buffer.append(" length=\"");
            buffer.append(URelaxer.getString(this.getLength()));
            buffer.append("\"");
        }
        if (this.bargein_ != null) {
            buffer.append(" bargein=\"");
            buffer.append(URelaxer.getString(this.getBargein()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.append("</break>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<break");
        if (this.length_ != null) {
            buffer.write(" length=\"");
            buffer.write(URelaxer.getString(this.getLength()));
            buffer.write("\"");
        }
        if (this.bargein_ != null) {
            buffer.write(" bargein=\"");
            buffer.write(URelaxer.getString(this.getBargein()));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.write("</break>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<break");
        if (this.length_ != null) {
            buffer.print(" length=\"");
            buffer.print(URelaxer.getString(this.getLength()));
            buffer.print("\"");
        }
        if (this.bargein_ != null) {
            buffer.print(" bargein=\"");
            buffer.print(URelaxer.getString(this.getBargein()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        buffer.print("</break>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    @Override
    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getLengthAsString() {
        return URelaxer.getString(this.getLength());
    }

    public String getBargeinAsString() {
        return URelaxer.getString(this.getBargein());
    }

    @Override
    public void setContentByString(String string) {
        this.setContent(string);
    }

    public void setLengthByString(String string) {
        this.setLength(Double.parseDouble(string));
    }

    public void setBargeinByString(String string) {
        this.setBargein((boolean)new Boolean(string));
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "break")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return PdocBreak.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (PdocBreak.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

