/*
 * Decompiled with CFR 0.152.
 */
package galatea.relaxer.event;

import galatea.relaxer.event.IEventEvChoice;
import galatea.relaxer.event.RStack;
import galatea.relaxer.event.UJAXP;
import galatea.relaxer.event.URelaxer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EventInterpreted
implements Serializable,
Cloneable,
IEventEvChoice {
    private String text_;
    private String script_;

    public EventInterpreted() {
    }

    public EventInterpreted(EventInterpreted source) {
        this.setup(source);
    }

    public EventInterpreted(RStack stack) {
        this.setup(stack);
    }

    public EventInterpreted(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public EventInterpreted(Element element) {
        this.setup(element);
    }

    public EventInterpreted(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public EventInterpreted(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public EventInterpreted(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public EventInterpreted(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public EventInterpreted(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public EventInterpreted(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(EventInterpreted source) {
        this.text_ = source.text_;
        this.script_ = source.script_;
    }

    @Override
    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    @Override
    public void setup(Element element) {
        this.init(element);
    }

    @Override
    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.text_ = URelaxer.getElementPropertyAsStringByStack(stack, "text");
        this.script_ = URelaxer.getElementPropertyAsStringByStack(stack, "script");
    }

    @Override
    public Object clone() {
        return new EventInterpreted(this);
    }

    @Override
    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("interpreted");
        if (this.text_ != null) {
            URelaxer.setElementPropertyByString(element, "text", this.text_);
        }
        if (this.script_ != null) {
            URelaxer.setElementPropertyByString(element, "script", this.script_);
        }
        parent.appendChild(element);
    }

    @Override
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    @Override
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    @Override
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    @Override
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    @Override
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    @Override
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    @Override
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public String getText() {
        return this.text_;
    }

    public void setText(String text) {
        this.text_ = text;
    }

    public String getScript() {
        return this.script_;
    }

    public void setScript(String script) {
        this.script_ = script;
    }

    @Override
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    @Override
    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<interpreted");
        buffer.append(">");
        if (this.text_ != null) {
            buffer.append("<text>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getText())));
            buffer.append("</text>");
        }
        if (this.script_ != null) {
            buffer.append("<script>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getScript())));
            buffer.append("</script>");
        }
        buffer.append("</interpreted>");
    }

    @Override
    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<interpreted");
        buffer.write(">");
        if (this.text_ != null) {
            buffer.write("<text>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getText())));
            buffer.write("</text>");
        }
        if (this.script_ != null) {
            buffer.write("<script>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getScript())));
            buffer.write("</script>");
        }
        buffer.write("</interpreted>");
    }

    @Override
    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<interpreted");
        buffer.print(">");
        if (this.text_ != null) {
            buffer.print("<text>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getText())));
            buffer.print("</text>");
        }
        if (this.script_ != null) {
            buffer.print("<script>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getScript())));
            buffer.print("</script>");
        }
        buffer.print("</interpreted>");
    }

    @Override
    public void makeTextAttribute(StringBuffer buffer) {
    }

    @Override
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    @Override
    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getTextAsString() {
        return URelaxer.getString(this.getText());
    }

    public String getScriptAsString() {
        return URelaxer.getString(this.getScript());
    }

    public void setTextByString(String string) {
        this.setText(string);
    }

    public void setScriptByString(String string) {
        this.setScript(string);
    }

    @Override
    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "interpreted")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child = target.peekElement();
        if (child != null && URelaxer.isTargetElement(child, "text")) {
            target.popElement();
        }
        $match$ = true;
        child = target.peekElement();
        if (child != null && URelaxer.isTargetElement(child, "script")) {
            target.popElement();
        }
        $match$ = true;
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return EventInterpreted.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (EventInterpreted.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

