/*
 * Decompiled with CFR 0.152.
 */
package galatea.logger;

import galatea.logger.ILoggerListener;
import galatea.util.Property;
import java.util.ArrayList;

public class Logger {
    private int debuglevel;
    private static int count_ = 0;
    private String name_ = "DM";
    private static ArrayList<ILoggerListener> listeners = new ArrayList();

    public static void addListener(ILoggerListener ls) {
        listeners.add(ls);
    }

    public Logger(String name, int defaultLevel) {
        this.debuglevel = Property.getAsInt("Logger." + name, defaultLevel);
        this.name_ = name;
    }

    public Logger(String name) {
        this.debuglevel = Property.getAsInt("Logger." + name, 0);
        this.name_ = name;
    }

    public Logger() {
        this.debuglevel = 0;
    }

    public void setLevel(int level) {
        this.debuglevel = level;
    }

    public int getLevel() {
        return this.debuglevel;
    }

    public static void doPrint(String msg, String name) {
        String str = "[" + ++count_ + " " + name + " " + Thread.currentThread().getName() + "] " + msg;
        for (ILoggerListener l : listeners) {
            l.addLoggerEvent(str);
        }
    }

    public void print(String msg) {
        if (this.debuglevel != 0) {
            Logger.doPrint(msg, this.name_);
        }
    }

    public void print(String msg, int level) {
        if (this.debuglevel >= level) {
            Logger.doPrint(msg, this.name_);
        }
    }

    public void err(String msg) {
        if (this.debuglevel != 0) {
            System.err.println(msg);
        }
    }

    public void err(String msg, int level) {
        if (this.debuglevel >= level) {
            System.err.println(msg);
        }
    }

    public void DIE(Exception e) {
        if (this.debuglevel != 0) {
            System.err.println("DIE");
            System.exit(1);
        }
    }

    public void DIE(String msg) {
        if (this.debuglevel != 0) {
            System.err.println("DIE: " + msg);
            System.exit(1);
        }
    }

    public void ASSERT(boolean bool, String msg) {
        if (this.debuglevel != 0 && !bool) {
            System.err.println("ASSERTION FAILED: " + msg);
            System.exit(1);
        }
    }

    public void ASSERT(boolean bool, String msg, int level) {
        if (this.debuglevel >= level && !bool) {
            System.err.println("ASSERTION FAILED: " + msg);
            System.exit(1);
        }
    }

    public static void main(String[] args) throws Exception {
        Logger dbg = new Logger("DM", 5);
        dbg.print("1: this is shown.", 4);
        dbg.print("2: this is shown.", 5);
        dbg.print("3: not shown.", 6);
        int a = 1;
        int b = 2;
        dbg.ASSERT(a == a, "4: not shown.");
        dbg.ASSERT(a == b, "5: this is shown.", 4);
        dbg.ASSERT(a == b, "6: not shown.", 5);
        dbg.ASSERT(a == b, "7: not shown.", 6);
    }
}

