/*
 * Decompiled with CFR 0.152.
 */
package galatea.io.wrapper;

import galatea.dialog.InterpretedEvent;
import galatea.logger.Logger;
import galatea.recogman.RecogInterpreter;
import galatea.recogman.RecogInterpreterListener;
import galatea.submodule.AbstractSubModule;
import galatea.util.Property;
import galatea.util.Util;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SRMSubModule
extends AbstractSubModule
implements RecogInterpreterListener {
    private Logger dbg = new Logger("SRM", 0);
    private RecogInterpreter parser_ = new RecogInterpreter();
    private String xmlContent_ = "";
    private boolean debugMode_ = true;
    private Pattern patSrmTell_ = Pattern.compile("^From @SRM tell (.*)$");
    private boolean insideMultiLine_ = false;
    private boolean useSIM_ = false;
    private boolean useDIM_ = Property.getAsBoolean("DM.UseDIM", true);

    public SRMSubModule() {
        this.useSIM_ = Property.getAsBoolean("DM.UseSIM", false);
        this.debugMode_ = Property.getAsBoolean("Debug.RecogMan", false);
        this.parser_.setListener(this);
    }

    private void _debugPrint(String str) {
        if (this.debugMode_) {
            this.dbg.print(str);
        }
    }

    public void setDialogName(String s) {
        this.parser_.setDialogName(s);
    }

    public void setSlotAlias(String s) {
        if (s.equals("RESET")) {
            this.parser_.resetSlotAlias();
        } else {
            this.parser_.setSlotAlias(s);
        }
    }

    private void _sendRecogState(int s) {
        if (this.useDIM_) {
            this.sender_.send("to @DIM set RecogState = " + s);
        }
    }

    private void _sendUserSpeakState(int s) {
        if (this.useDIM_) {
            this.sender_.send("to @DIM set UserSpeakState = " + s);
        }
    }

    private void _fromSRMtell(String s) {
        this._debugPrint("[" + this.xmlContent_ + "] [" + s + "]");
        if (s.startsWith("<STARTPROC/>") || s.startsWith("<ENDPROC/>") || s.startsWith("<STARTRECOG/>") || s.startsWith("<ENDRECOG/>")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("grammar ")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("ModuleStart")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("ModuleExit")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("<STARTPROC/>")) {
            this.logger_.inputEventReceived(s);
            this.receiver_.receiveRunLevel(2, this);
            return;
        }
        if (s.startsWith("<GMM ")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("<INPUT ")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("<INPUTPARAM ")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("<REJECTED ")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("<GRAMMAR ")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (this.xmlContent_.length() > 0 || s.startsWith("<")) {
            this.xmlContent_ = String.valueOf(this.xmlContent_) + s;
            if (this.xmlContent_.endsWith("</RECOGOUT>") || this.xmlContent_.endsWith("</GRAMINFO>")) {
                try {
                    this.parser_.receiveRecogMessage(this.xmlContent_);
                }
                catch (Exception e) {
                    this._debugPrint(e.toString());
                }
                this.xmlContent_ = "";
            }
        }
    }

    @Override
    public void recogListenStarted() {
        this._sendUserSpeakState(0);
    }

    @Override
    public void recogRecordStarted() {
        this._sendUserSpeakState(1);
    }

    @Override
    public void recogRecordFinished() {
        this._sendUserSpeakState(0);
    }

    @Override
    public void recogPass1Finished() {
    }

    @Override
    public void recogPass2Finished() {
        String script = this.parser_.getScript();
        String text = this.parser_.getText();
        String xmlevent = "<ev src=\"SRM\" type=\"INPUT\"><interpreted><text>" + text + "</text>" + "<script>" + script + "</script></interpreted></ev>";
        InterpretedEvent ev = InterpretedEvent.newInstance(xmlevent);
        this.receiver_.receiveInterpreted(ev);
        this.logger_.inputEventReceived(xmlevent);
    }

    @Override
    public void recogFailed() {
    }

    @Override
    public void recogException(Exception e, String str) {
        this._debugPrint("recogException(" + str + ") " + e.toString());
    }

    @Override
    public boolean receiveFromDevice(String str) {
        Pattern pSIMResult;
        Matcher mSIMResult;
        if (this.useSIM_ && (mSIMResult = (pSIMResult = Pattern.compile("From @SIM tell 300 (.*)$")).matcher(str)).matches()) {
            String xmlevent = mSIMResult.group(1);
            this.dbg.print("tell 300 " + xmlevent);
            InterpretedEvent ev = InterpretedEvent.newInstance(xmlevent);
            this.receiver_.receiveInterpreted(ev);
            this.logger_.inputEventReceived(xmlevent);
            return true;
        }
        if (str.startsWith("From @SRM ")) {
            if (this.insideMultiLine_) {
                if (str.startsWith("From @SRM EOM")) {
                    this.insideMultiLine_ = false;
                    this._debugPrint("multiLine End");
                } else {
                    String s = str.replaceAll("From @SRM ", "");
                    this._fromSRMtell(s);
                }
            } else if (str.startsWith("From @SRM tell << EOM")) {
                this.insideMultiLine_ = true;
                this._debugPrint("multiLine Start ");
            } else {
                this._fromSRMtell(str.replaceAll("From @SRM tell ", ""));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean filterOutputNative(String str) {
        if (!this.useSIM_) {
            String s = Util.getFirstGroup("to @SIM set DialogName = (.*)$", str);
            if (s != null) {
                this.setDialogName(s);
                return true;
            }
            s = Util.getFirstGroup("to @SIM set SlotAlias = (.*)$", str);
            if (s != null) {
                this.setSlotAlias(s);
                return true;
            }
        }
        if (str.startsWith("to @SRM set Grammar =")) {
            String doc = this.getGrammarForDisplay(str);
            this.logger_.grammarFileUpdated(doc);
        }
        return false;
    }

    public String getGrammarForDisplay(String str) {
        String s = Util.getFirstGroup("to @SRM set Grammar = (.*)$", str);
        if (s != null) {
            String file = s.replaceAll(".dfa", "");
            Charset charset_ = Util.getSystemDefaultCharset();
            String XML_ENCODING = "EUC-JP";
            Charset xmlCharset_ = Charset.forName(XML_ENCODING);
            try {
                String s1 = Util.loadFromFile(String.valueOf(file) + ".voca", charset_);
                String s2 = Util.loadFromFile(String.valueOf(file) + ".grammar", charset_);
                String s3 = Util.loadFromFile(String.valueOf(file) + ".xml", xmlCharset_);
                return String.valueOf(str) + "\n\n[voca]\n" + s1 + "\n\n[grammar]\n" + s2 + (s3 != null ? "\n\n[xml]\n" + s3 : "");
            }
            catch (Exception e) {
                return String.valueOf(str) + "\n" + file + "\n" + e.toString();
            }
        }
        return "";
    }

    @Override
    public void setTargetRunLevel(int level) {
        if (level == 2) {
            this.sender_.send("to @SRM set Run = INIT");
            this.sender_.send("to @SRM set Run = START");
        }
        this.receiver_.receiveRunLevel(level, this);
    }
}

