/*
 * Decompiled with CFR 0.152.
 */
package galatea.io.plugins;

import galatea.dialog.InterpretedEvent;
import galatea.io.plugins.KeypadWindow;
import galatea.logger.Logger;
import galatea.submodule.AbstractSubModule;
import galatea.util.HashArray;
import galatea.util.Util;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KeypadSubModule
extends AbstractSubModule
implements KeyListener {
    private Logger dbg = new Logger("KBD");
    private KeypadWindow keypadWindow_;
    private int acceptableLength_ = 3;
    private String slot_ = "dummy";
    private long lastInputWhen_;
    private String dialogName_;
    private HashArray slotAliases_ = new HashArray();
    private Pattern pattern4_ = Pattern.compile("(\\S+) (.*)");

    public KeypadSubModule() {
        this.keypadWindow_ = new KeypadWindow(this);
    }

    @Override
    public boolean filterOutputNative(String str) {
        String s = Util.getFirstGroup("to @KBD set FieldName = (.*)$", str);
        if (s != null) {
            this.setFieldName(s);
            return true;
        }
        s = Util.getFirstGroup("to @KBD set FieldType = (.*)$", str);
        if (s != null) {
            this.setFieldType(s);
            return true;
        }
        s = Util.getFirstGroup("to @SIM set DialogName = (.*)$", str);
        if (s != null) {
            this.setDialogName(s);
            return true;
        }
        s = Util.getFirstGroup("to @SIM set SlotAlias = (.*)$", str);
        if (s != null) {
            this.setSlotAlias(s);
            return true;
        }
        return false;
    }

    private void setSlotAlias(String s) {
        if (s.equals("RESET")) {
            this.slotAliases_ = new HashArray();
        } else {
            Matcher m = this.pattern4_.matcher(s);
            if (m.matches()) {
                this.slotAliases_.put(m.group(1), m.group(2));
            }
        }
    }

    private void setDialogName(String s) {
        this.dialogName_ = s;
    }

    public void setFieldName(String s) {
        this.slot_ = s;
    }

    public void setFieldType(String s) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.dbg.print("keyTyped:" + e.paramString());
        if (!e.isActionKey()) {
            if (e.getKeyChar() == '\n') {
                this._checkInput();
            } else if (e.getKeyChar() == '\u001b') {
                this.keypadWindow_.clearInputText();
            } else {
                this.keypadWindow_.addChar(e.getKeyChar());
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.lastInputWhen_ = Util.getCurrentTimeInMillis();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void _checkInput() {
        if (this.keypadWindow_.getInputLength() == this.acceptableLength_) {
            String src = "KBD";
            String val = this.keypadWindow_.getInputText();
            String script = "$utterance='" + val + "';" + this.slot_ + "='" + val + "';" + this.slot_ + "$.justfilled=true;";
            String xmlevent = "<ev src=\"" + src + "\" type=\"INPUT\"><interpreted>" + "<script>" + script + "</script></interpreted></ev>";
            InterpretedEvent ev = InterpretedEvent.newInstance(xmlevent);
            this.receiver_.receiveInterpreted(ev);
        }
        this.keypadWindow_.clearInputText();
    }

    @Override
    public void doTimerTask() {
        long curr = Util.getCurrentTimeInMillis();
        if (curr - this.lastInputWhen_ > 1000L) {
            this._checkInput();
        }
    }
}

