/*
 * Decompiled with CFR 0.152.
 */
package galatea.io.plugins;

import galatea.dialog.InterpretedEvent;
import galatea.logger.Logger;
import galatea.recogman.JulianServerRunner;
import galatea.recogman.JuliusClient;
import galatea.recogman.RecogInterpreter;
import galatea.recogman.RecogInterpreterListener;
import galatea.submodule.AbstractSubModule;
import galatea.util.Util;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class JulianSubModule
extends AbstractSubModule
implements RecogInterpreterListener {
    private Logger dbg = new Logger("SRM");
    private RecogInterpreter parser_ = new RecogInterpreter();
    private String xmlContent_ = "";
    private boolean debugMode_ = true;
    private Pattern patSrmTell_ = Pattern.compile("^From @SRM tell (.*)$");
    private boolean insideMultiLine_ = false;
    private JulianServerRunner server_;
    private JuliusClient client_;

    public JulianSubModule() {
        this.parser_.setListener(this);
        this.server_ = new JulianServerRunner();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                JulianSubModule.this.dbg.print("Shutting down");
                JulianSubModule.this.server_.setRunning(false);
            }
        });
    }

    @Override
    public void setTargetRunLevel(int level) {
        if (level == 2) {
            this.server_.run();
            this.client_ = new JuliusClient("localhost", 10500);
            try {
                Thread.sleep(3000L);
                this.client_.open();
                this.dbg.print("JulianSubModule setup done");
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.receiver_.receiveRunLevel(2, this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doTimerTask() {
        String er;
        if (!this.server_.isRunning()) {
            return;
        }
        while ((er = this.server_.getErrors()).length() != 0) {
            this.dbg.print("SE: " + er);
            this.server_.clearErrors();
        }
        while (true) {
            String str;
            if ((str = this.server_.getOutputs()).length() == 0) {
                try {
                    this.client_.receive();
                    break;
                }
                catch (Exception e) {
                    this.dbg.print("CX: " + e.toString());
                    this.server_.setRunning(false);
                    return;
                }
            }
            this.dbg.print("SO: " + Util.removeNewLines(str));
            this.server_.clearOutputs();
        }
        String msg;
        while ((msg = this.client_.getMessage()).length() > 0) {
            this.dbg.print("CO: " + msg);
            this._fromSRMtell(msg);
        }
        return;
    }

    private void _debugPrint(String str) {
        if (this.debugMode_) {
            this.dbg.print(str);
        }
    }

    public void setDialogName(String s) {
        this.parser_.setDialogName(s);
    }

    public void setSlotAlias(String s) {
        if (s.equals("RESET")) {
            this.parser_.resetSlotAlias();
        } else {
            this.parser_.setSlotAlias(s);
        }
    }

    private void _fromSRMtell(String s) {
        if (s.startsWith("grammar ")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("ModuleStart")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("ModuleExit")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("<STARTPROC/>") || s.startsWith("<ENDPROC/>") || s.startsWith("<STARTRECOG/>") || s.startsWith("<ENDRECOG/>")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("<GMM ")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("<INPUT ")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("<INPUTPARAM ")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("<REJECTED ")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (s.startsWith("<GRAMMAR ")) {
            this.logger_.inputEventReceived(s);
            return;
        }
        if (this.xmlContent_.length() > 0 || s.startsWith("<")) {
            this.xmlContent_ = String.valueOf(this.xmlContent_) + s;
            if (this.xmlContent_.endsWith("</RECOGOUT>") || this.xmlContent_.endsWith("</GRAMINFO>")) {
                try {
                    this.parser_.receiveRecogMessage(this.xmlContent_);
                }
                catch (Exception e) {
                    this._debugPrint(e.toString());
                }
                this.xmlContent_ = "";
            }
        }
    }

    @Override
    public void recogListenStarted() {
    }

    @Override
    public void recogRecordStarted() {
    }

    @Override
    public void recogRecordFinished() {
    }

    @Override
    public void recogPass1Finished() {
    }

    @Override
    public void recogPass2Finished() {
        String script = this.parser_.getScript();
        String text = this.parser_.getText();
        String xmlevent = "<ev src=\"SRM\" type=\"INPUT\"><interpreted><text>" + text + "</text>" + "<script>" + script + "</script></interpreted></ev>";
        InterpretedEvent ev = InterpretedEvent.newInstance(xmlevent);
        this.receiver_.receiveInterpreted(ev);
        this.logger_.inputEventReceived(xmlevent);
    }

    @Override
    public void recogFailed() {
    }

    @Override
    public void recogException(Exception e, String str) {
        this._debugPrint("recogException(" + str + ") " + e.toString());
    }

    @Override
    public boolean filterOutputNative(String str) {
        String s = Util.getFirstGroup("to @SIM set DialogName = (.*)$", str);
        if (s != null) {
            this.setDialogName(s);
            return true;
        }
        s = Util.getFirstGroup("to @SIM set SlotAlias = (.*)$", str);
        if (s != null) {
            this.setSlotAlias(s);
            return true;
        }
        s = Util.getFirstGroup("to @SRM set Grammar = (.*)$", str);
        if (s != null) {
            try {
                this.sendGrammar(s);
            }
            catch (Exception e) {
                this.logger_.grammarFileUpdated(e.toString());
                return true;
            }
            this.logger_.grammarFileUpdated(this.getGrammarForDisplay(s));
            return true;
        }
        return str.startsWith("to @SRM set Dic =");
    }

    public void sendGrammar(String s) throws Exception {
        String file = s.replaceAll(".dfa", "");
        Charset charset_ = Util.getSystemDefaultCharset();
        String dfa = Util.loadFromFile(String.valueOf(file) + ".dfa", charset_);
        String dict = Util.loadFromFile(String.valueOf(file) + ".dict", charset_);
        this.client_.send("CHANGEGRAM " + file + "\n");
        this.client_.send(dfa);
        this.client_.send("DFAEND\n");
        this.client_.send(dict);
        this.client_.send("DICEND\n");
        this.client_.send("RESUME\n");
    }

    public String getGrammarForDisplay(String s) {
        String file = s.replaceAll(".dfa", "");
        Charset charset_ = Util.getSystemDefaultCharset();
        String XML_ENCODING = "EUC-JP";
        Charset xmlCharset_ = Charset.forName(XML_ENCODING);
        try {
            String s1 = Util.loadFromFile(String.valueOf(file) + ".voca", charset_);
            String s2 = Util.loadFromFile(String.valueOf(file) + ".grammar", charset_);
            return String.valueOf(s) + "\n\n[voca]\n" + s1 + "\n\n[grammar]\n" + s2;
        }
        catch (Exception e) {
            return String.valueOf(s) + "\n" + file + "\n" + e.toString();
        }
    }
}

