/*
 * Decompiled with CFR 0.152.
 */
package galatea.io;

import galatea.dialog.ISystemEventLogger;
import galatea.io.ISenderToDevice;
import galatea.logger.Logger;
import galatea.submodule.IReceiverFromSubModule;
import galatea.submodule.ISubModule;
import galatea.util.AMBuffer;
import galatea.util.Util;
import java.util.ArrayList;

public class AMThread
extends Thread
implements ISenderToDevice {
    private int runLevel_ = 0;
    private Logger dbg = new Logger("AMThread", 0);
    private AMBuffer ambuf_;
    private ArrayList<ISubModule> subModules_ = new ArrayList();

    public AMThread() {
        this.setName("AMThread");
        this.ambuf_ = new AMBuffer(Util.getSystemDefaultCharset());
        this.outputNative("rep Run = POWEROFF");
        this.dbg.print("rep Run = POWEROFF");
    }

    public void addSubModule(ISubModule s, IReceiverFromSubModule r, ISystemEventLogger l) {
        this.subModules_.add(s);
        s.setSender(this);
        s.setReceiver(r);
        s.setLogger(l);
    }

    public void outputNative(String str) {
        int i = 0;
        int n = this.subModules_.size();
        while (i < n) {
            ISubModule s = this.subModules_.get(i);
            if (s != null && s.filterOutputNative(str)) {
                return;
            }
            ++i;
        }
        this.ambuf_.send(str);
    }

    private synchronized boolean _iteration() {
        String str = this.ambuf_.receive();
        this.dbg.ASSERT(str != null, "AMT str != null");
        if (str.length() == 0) {
            return true;
        }
        this.dbg.print(str);
        int i = 0;
        while (i < this.subModules_.size()) {
            ISubModule s = this.subModules_.get(i);
            if (s != null && s.receiveFromDevice(str)) {
                return true;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void send(String msg) {
        this.ambuf_.send(msg);
    }

    @Override
    public void run() {
        while (this._iteration()) {
            try {
                Thread.sleep(1L, 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

