/*
 * Decompiled with CFR 0.152.
 */
package galatea.httpclient;

import galatea.document.DocError;
import galatea.httpclient.INetUtilListener;
import galatea.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NetUtil {
    private static CookieManager cookieManager;
    private static ArrayList<INetUtilListener> listeners;

    static {
        listeners = new ArrayList();
    }

    private NetUtil() {
    }

    public static void createCookieManager() {
        for (INetUtilListener l : listeners) {
            l.addNetUtilEvent("createCookieManager");
        }
        cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
    }

    public static void addListener(INetUtilListener ls) {
        listeners.add(ls);
    }

    public static String getTopName(Element elem) {
        String topName = elem.getNodeType() == 1 ? elem.getNodeName() : "";
        return topName;
    }

    public static Element loadXMLFile(String filename, boolean isPost, String postdata) throws Exception {
        Document root;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (filename.startsWith("http:")) {
            int n;
            URL url = new URL(filename);
            HttpURLConnection uc = (HttpURLConnection)url.openConnection();
            if (isPost && postdata != null) {
                uc.setDoOutput(true);
                DataOutputStream outStream = new DataOutputStream(uc.getOutputStream());
                byte[] bytBuff = postdata.getBytes("UTF-8");
                outStream.write(bytBuff, 0, bytBuff.length);
                uc.connect();
            } else {
                uc.setRequestMethod("GET");
            }
            InputStream is = uc.getInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int SIZE = 8196;
            byte[] buf = new byte[8196];
            while ((n = is.read(buf, 0, 8196)) != -1) {
                os.write(buf, 0, n);
            }
            byte[] bytes = os.toByteArray();
            os.close();
            is.close();
            uc.disconnect();
            CookieStore store = cookieManager.getCookieStore();
            List<HttpCookie> cookies = store.getCookies();
            int i = 0;
            while (i < cookies.size()) {
                HttpCookie cookie = cookies.get(i);
                for (INetUtilListener l : listeners) {
                    l.addNetUtilEvent("Cookie[" + i + "]: " + cookie);
                }
                ++i;
            }
            String encoding = "UTF-8";
            int pos = 0;
            int i2 = 0;
            while (i2 < bytes.length) {
                if (bytes[i2] == 62 && i2 > 0 && bytes[i2 - 1] == 63) {
                    String s;
                    String e;
                    String line = new String(bytes, 0, i2 + 1);
                    if (line.startsWith("<?xml ") && (e = Util.getFirstGroup(".*encoding[\\s]*=[\\s]*'([^']+)'.*", s = line.replaceAll("\"", "'"))) != null) {
                        encoding = e;
                    }
                    pos = i2 + 1;
                    break;
                }
                ++i2;
            }
            int len = bytes.length - pos;
            String content = new String(bytes, pos, len, encoding);
            ByteArrayInputStream is2 = new ByteArrayInputStream(content.getBytes("UTF-8"));
            root = builder.parse(is2);
            for (INetUtilListener l : listeners) {
                l.addNetUtilEvent("fetched and parsed " + filename + (isPost && postdata != null ? " [POST]" : " [GET]"));
            }
        } else {
            root = builder.parse(filename);
            for (INetUtilListener l : listeners) {
                l.addNetUtilEvent("parsed " + filename);
            }
        }
        Element elem = root.getDocumentElement();
        return elem;
    }

    public static Element loadXMLFile(String filename) throws Exception {
        return NetUtil.loadXMLFile(filename, false, null);
    }

    public static String loadTextFile(String filename) throws Exception {
        String doc = Util.readURL(filename);
        if (Util.getError().equals("")) {
            return doc;
        }
        throw new DocError(Util.getError());
    }

    public static String makeString(Element element) {
        Transformer transformer;
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            transformer = factory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            return e.toString();
        }
        DOMSource src = new DOMSource(element);
        StringWriter writer = new StringWriter();
        StreamResult target = new StreamResult(writer);
        try {
            transformer.transform(src, target);
        }
        catch (Exception e) {
            return e.toString();
        }
        String ws = new String(writer.getBuffer());
        return ws;
    }

    public static void main(String[] args) throws Exception {
        String s = NetUtil.loadXMLFile("http://localhost/bento/vxml/vxml-begin.php").toString();
        System.err.println(s);
    }
}

