/*
 * Decompiled with CFR 0.152.
 */
package galatea.grammar;

import galatea.grammar.GrammarUtil;
import galatea.logger.Logger;
import galatea.relaxer.vxml20.VxmlGrammar;
import galatea.relaxer.vxml20.VxmlItem;
import galatea.relaxer.vxml20.VxmlOneOf;
import galatea.relaxer.vxml20.VxmlRule;
import galatea.relaxer.vxml20.VxmlRuleref;
import galatea.relaxer.vxml20.VxmlToken;
import galatea.util.Util;

public class GrammarMaker {
    private Logger dbg = new Logger("GrammarMaker", 0);
    private int unique_ = 0;

    private String _getUniqueId() {
        ++this.unique_;
        StringBuffer id = new StringBuffer("grm").append(this.unique_);
        return id.toString();
    }

    private boolean _isRulerefOnly(VxmlItem item) {
        int ntoken = 0;
        int nruleref = 0;
        int i = 0;
        while (i < item.sizeContent()) {
            if (item.getContent(i) instanceof VxmlToken) {
                ++ntoken;
            } else if (item.getContent(i) instanceof VxmlRuleref) {
                ++nruleref;
            }
            ++i;
        }
        return ntoken == 0;
    }

    private boolean _isToken(VxmlItem item) {
        int ntoken = 0;
        int nruleref = 0;
        int i = 0;
        while (i < item.sizeContent()) {
            if (item.getContent(i) instanceof VxmlToken) {
                ++ntoken;
            } else if (item.getContent(i) instanceof VxmlRuleref) {
                ++nruleref;
            }
            ++i;
        }
        return ntoken == 1 && nruleref == 0;
    }

    private void _addRuleOfToken(VxmlGrammar ipasrg, String ruleid, VxmlToken token) {
        VxmlRule rule = new VxmlRule();
        rule.setId(ruleid);
        rule.addContent(token);
        ipasrg.addContent(rule);
    }

    private void _addRuleOfToken(VxmlGrammar ipasrg, String ruleid, VxmlItem item) {
        VxmlRule rule = new VxmlRule();
        rule.setId(ruleid);
        int i = 0;
        while (i < item.sizeContent()) {
            if (item.getContent(i) instanceof VxmlToken) {
                VxmlToken token = (VxmlToken)item.getContent(i);
                token.setContent(Util.removeSpaces(token.getContent()));
                rule.addContent(token);
                break;
            }
            ++i;
        }
        ipasrg.addContent(rule);
    }

    private void _addRuleOfRuleref(VxmlGrammar ipasrg, String ruleid, VxmlItem item) {
        VxmlRule rule = new VxmlRule();
        rule.setId(ruleid);
        int i = 0;
        while (i < item.sizeContent()) {
            if (item.getContent(i) instanceof VxmlRuleref) {
                VxmlRuleref ref = (VxmlRuleref)item.getContent(i);
                String uri = ref.getUri().replaceAll("#", "");
                ref.setUri(uri);
                rule.addContent(ref);
            }
            ++i;
        }
        ipasrg.addContent(rule);
    }

    private void _makeIpaXmlFromRule(VxmlGrammar ipasrg, VxmlRule rule) {
        String ruleid = rule.getId();
        if (ruleid == null) {
            ruleid = this._getUniqueId();
        }
        int i = 0;
        while (i < rule.sizeContent()) {
            if (rule.getContent(i) instanceof VxmlToken) {
                VxmlToken token = (VxmlToken)rule.getContent(i);
                this._addRuleOfToken(ipasrg, ruleid, token);
                break;
            }
            if (rule.getContent(i) instanceof VxmlOneOf) {
                VxmlOneOf oneof = (VxmlOneOf)rule.getContent(i);
                int j = 0;
                while (j < oneof.sizeItem()) {
                    VxmlItem item = oneof.getItem(j);
                    if (this._isRulerefOnly(item)) {
                        this._addRuleOfRuleref(ipasrg, ruleid, item);
                    } else if (this._isToken(item)) {
                        String newid = String.valueOf(this._getUniqueId()) + "_" + ruleid;
                        VxmlRuleref nref = new VxmlRuleref();
                        nref.setUri(newid);
                        VxmlRule nrule = new VxmlRule();
                        nrule.setId(ruleid);
                        nrule.addContent(nref);
                        ipasrg.addContent(nrule);
                        this._addRuleOfToken(ipasrg, newid, item);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    public VxmlGrammar makeIpaXml(VxmlGrammar gram) {
        VxmlGrammar ipasrg = new VxmlGrammar();
        int i = 0;
        while (i < gram.sizeContent()) {
            if (gram.getContent(i) instanceof VxmlRule) {
                VxmlRule rule = (VxmlRule)gram.getContent(i);
                this._makeIpaXmlFromRule(ipasrg, rule);
            }
            ++i;
        }
        return ipasrg;
    }

    private VxmlRule _getRuleByUri(String uri) throws Exception {
        this.dbg.print("_getRuleByUri() " + uri);
        String subfile = Util.getUriWithoutFragment(uri);
        String fragment = Util.getUriFragment(uri);
        this.dbg.print("new VxmlGrammar(" + subfile + ")");
        VxmlGrammar src = new VxmlGrammar(subfile);
        VxmlRule newrule = new VxmlRule();
        int i = 0;
        while (i < src.sizeContent()) {
            VxmlRule rule;
            if (src.getContent(i) instanceof VxmlRule && (rule = (VxmlRule)src.getContent(i)).getId().equals(fragment)) {
                this.dbg.print("_getRuleByUri() " + fragment + " found");
                newrule.setup(rule);
            }
            ++i;
        }
        newrule.setId(fragment);
        return newrule;
    }

    public void resolveExtRuleRef(VxmlGrammar dest, VxmlRule rule, String adrs, String org) throws Exception {
        this.dbg.print("resolveExtRuleRef() adrs=" + adrs + " org=" + org);
        VxmlRule newrule = new VxmlRule();
        newrule.setId(rule.getId());
        int j = 0;
        while (j < rule.sizeContent()) {
            if (rule.getContent(j) instanceof VxmlOneOf) {
                VxmlOneOf oneof = (VxmlOneOf)rule.getContent(j);
                VxmlOneOf newoneof = new VxmlOneOf();
                newoneof.setup(oneof);
                int k = 0;
                while (k < oneof.sizeItem()) {
                    VxmlItem item = oneof.getItem(k);
                    int m = 0;
                    while (m < item.sizeContent()) {
                        VxmlRuleref ref;
                        String uri;
                        if (item.getContent(m) instanceof VxmlRuleref && (uri = (ref = (VxmlRuleref)item.getContent(m)).getUri()) != null) {
                            this.dbg.print("adrs=" + adrs + " uri=" + uri);
                            uri = Util.resolveAdrs(adrs, uri);
                            this.dbg.print("org=" + org + " resolved=" + uri);
                            if (!Util.isSameFile(org, uri)) {
                                VxmlRule subrule = this._getRuleByUri(uri);
                                this.resolveExtRuleRef(dest, subrule, uri, org);
                                VxmlRuleref r = (VxmlRuleref)newoneof.getItem(k).getContent(m);
                                r.setUri("#" + Util.getUriFragment(uri));
                            }
                        }
                        ++m;
                    }
                    ++k;
                }
                newrule.addContent(newoneof);
            } else if (rule.getContent(j) instanceof VxmlRuleref) {
                VxmlRuleref ref = (VxmlRuleref)rule.getContent(j);
                String uri = ref.getUri();
                this.dbg.print("adrs=" + adrs);
                this.dbg.print("uri=" + uri);
                if (uri != null) {
                    uri = Util.resolveAdrs(adrs, uri);
                    this.dbg.print("uri org:" + org + " resolved:" + uri);
                    VxmlOneOf newoneof = new VxmlOneOf();
                    VxmlItem newitem = new VxmlItem();
                    newoneof.addItem(newitem);
                    VxmlRuleref newruleref = new VxmlRuleref();
                    newitem.addContent(newruleref);
                    if (!Util.isSameFile(org, uri)) {
                        VxmlRule subrule = this._getRuleByUri(uri);
                        this.resolveExtRuleRef(dest, subrule, uri, org);
                    }
                    newruleref.setUri("#" + Util.getUriFragment(uri));
                    newrule.addContent(newoneof);
                }
            } else {
                newrule.addContent(rule.getContent(j));
            }
            ++j;
        }
        dest.addContent(newrule);
    }

    public void resolveExtRuleRef(VxmlGrammar dest, VxmlGrammar src, String adrs, String org) throws Exception {
        int i = 0;
        while (i < src.sizeContent()) {
            if (src.getContent(i) instanceof VxmlRule) {
                VxmlRule rule = (VxmlRule)src.getContent(i);
                this.resolveExtRuleRef(dest, rule, adrs, org);
            } else {
                dest.addContent(src.getContent(i));
            }
            ++i;
        }
    }

    public VxmlGrammar makeIpaXml(VxmlGrammar gramXml, String file) throws Exception {
        VxmlGrammar src = new VxmlGrammar();
        this.resolveExtRuleRef(src, gramXml, file, file);
        VxmlGrammar ipasrg = this.makeIpaXml(src);
        GrammarUtil.convertToken(ipasrg);
        ipasrg.setVersion("IPA-XML-1.0");
        ipasrg.setRoot(gramXml.getRoot());
        return ipasrg;
    }
}

