/*
 * Decompiled with CFR 0.152.
 */
package galatea.document;

import galatea.command.AddOutItemCommand;
import galatea.command.Command;
import galatea.command.CompositeCommand;
import galatea.command.EvaluateCommand;
import galatea.command.SetNextCommand;
import galatea.dialog.Tstamp;
import galatea.document.ContentState;
import galatea.grammar.GrammarRuleSet;
import galatea.logger.Logger;
import galatea.outitem.NativeOutItem;
import galatea.util.Util;
import java.util.ArrayList;
import java.util.HashMap;

public class StateMap {
    private Logger dbg = new Logger("StateMap");
    private float pdocVersion_ = 0.0f;
    private HashMap<String, ContentState> hashMap_ = new HashMap();
    private String firstStateName_ = null;
    private ArrayList<String> states_ = new ArrayList();
    private GrammarRuleSet grammarSet_ = null;

    public void setPdocVersion(float f) {
        this.pdocVersion_ = f;
    }

    public StateMap() {
        this.setPdocVersion(Tstamp.STATEMAP_PDOC_VERSION);
    }

    public ContentState put(String key, ContentState value) {
        this.states_.add(key);
        ContentState ret = this.hashMap_.put(key, value);
        this.dbg.ASSERT(ret == null, "put with no override");
        return ret;
    }

    public ContentState get(String key) {
        this.dbg.print("using StateMap.get(" + key + ")");
        ContentState cs = this.hashMap_.get(key);
        return cs;
    }

    public boolean has(String key) {
        ContentState cs = this.hashMap_.get(key);
        return cs != null;
    }

    public String newState(String newID) {
        this.dbg.ASSERT(newID != null && newID.length() > 0, "newID empty");
        ContentState state = this.hashMap_.get(newID);
        if (state != null) {
            this.dbg.print("overwriting " + newID);
            return newID;
        }
        this.dbg.ASSERT(state == null, "newState()");
        state = new ContentState();
        state.setName(newID);
        this.dbg.print("newState:" + newID);
        this.put(newID, state);
        return newID;
    }

    public void addCommand(String id, Command c) {
        ContentState state = this.get(id);
        if (state == null) {
            String newID = this.newState(id);
            state = this.get(newID);
            this.dbg.ASSERT(id.equals(newID), "addCommand() failed 1");
        }
        this.dbg.ASSERT(state != null, "addCommand() failed 2");
        if (c != null) {
            if (c instanceof CompositeCommand && !c.hasCondition()) {
                ArrayList<Command> commands = ((CompositeCommand)c).getCommands();
                int i = 0;
                while (i < commands.size()) {
                    state.addCommand(commands.get(i));
                    ++i;
                }
            } else {
                state.addCommand(c);
            }
        }
    }

    public void addCommand(String id, ArrayList<Command> commands) {
        ContentState state = this.get(id);
        if (state == null) {
            String newID = this.newState(id);
            state = this.get(newID);
            this.dbg.ASSERT(id.equals(newID), "addCommand() failed 3");
        }
        this.dbg.ASSERT(state != null, "addCommand() failed 4");
        if (commands != null) {
            int i = 0;
            while (i < commands.size()) {
                this.addCommand(id, commands.get(i));
                ++i;
            }
        }
    }

    public void addCommandOnTop(String id, Command c) {
        ContentState state = this.get(id);
        this.dbg.ASSERT(state != null, "addCommandOnTop()");
        state.addCommandOnTop(c);
    }

    public void addScriptCommand(String id, String script) {
        this.addCommand(id, new EvaluateCommand(script));
    }

    public void addScriptCommand(String id, String script, String with) {
        this.addCommand(id, new EvaluateCommand(script, with));
    }

    public void addTrans(String src, String dst, String input) {
        this.dbg.print("addTrans: " + src + ", " + dst + ", " + input);
        ContentState state = this.get(src);
        this.dbg.ASSERT(state != null, "addTrans()");
        state.putEventHandler(input, dst);
    }

    public void addDefaultTrans(String src, String dst) {
        this.addTrans(src, dst, ".*");
    }

    public void addSetNextCommand(String id, String dst) {
        this.addCommand(id, new SetNextCommand("'" + dst + "'"));
    }

    public void addOutputNativeCommand(String id, String msg) {
        this.addCommand(id, new AddOutItemCommand(new NativeOutItem(msg)));
    }

    public void setFirstStateName(String name) {
        this.firstStateName_ = name;
    }

    public String getFirstStateName() {
        return this.firstStateName_;
    }

    public ContentState getFirstState() {
        return this.hashMap_.get(this.firstStateName_);
    }

    public void add(ContentState state) {
        this.put(state.getName(), state);
    }

    public GrammarRuleSet getGrammarSet() {
        return this.grammarSet_;
    }

    public void setGrammarSet(GrammarRuleSet g) {
        this.grammarSet_ = g;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("<?xml version=\"1.0\" encoding=\"");
        s.append(Util.getSystemDefaultCharset());
        s.append("\" ?>\n");
        s.append("<pdoc version=\"");
        s.append(this.pdocVersion_);
        s.append("\">\n");
        if (this.grammarSet_ != null) {
            s.append("<head>\n");
            s.append(this.grammarSet_.getRulesAsString());
            s.append("\n");
            s.append("</head>\n\n");
        }
        s.append("<body start=\"");
        s.append(this.firstStateName_);
        s.append("\">\n\n");
        int i = 0;
        while (i < this.states_.size()) {
            String keyname = this.states_.get(i);
            ContentState state = this.hashMap_.get(keyname);
            s.append(state.toString());
            s.append("\n");
            ++i;
        }
        s.append("</body>\n");
        s.append("</pdoc>\n");
        return s.toString();
    }
}

