/*
 * Decompiled with CFR 0.152.
 */
package galatea.document;

import galatea.document.DocError;
import galatea.document.GrammarDoc;
import galatea.document.IAbstractDoc;
import galatea.document.PDoc;
import galatea.document.StateMap;
import galatea.document.VXMLDoc;
import galatea.httpclient.NetUtil;
import galatea.util.Util;
import java.io.FileNotFoundException;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public class DocLoader {
    private Element element_;
    private IAbstractDoc doc_;
    private StateMap stateMap_;
    private String warnings_;

    public DocLoader(String filename, String path, String fragment, String poststring) throws Exception {
        block5: {
            this.doc_ = null;
            this.warnings_ = "";
            try {
                this.element_ = poststring != null && poststring.length() > 0 ? NetUtil.loadXMLFile(filename, true, poststring) : NetUtil.loadXMLFile(filename);
                String topName = NetUtil.getTopName(this.element_);
                if (topName.equals("vxml")) {
                    this.doc_ = new VXMLDoc(this.element_, path, fragment);
                    break block5;
                }
                if (topName.equals("pdoc")) {
                    this.doc_ = new PDoc(this.element_, path, fragment);
                    break block5;
                }
                if (topName.equals("grammar")) {
                    this.doc_ = new GrammarDoc(this.element_, path, fragment);
                    break block5;
                }
                throw new DocError("Not a valid document:" + filename);
            }
            catch (Exception e) {
                throw new DocError("Not a valid document:" + filename + "\n" + e.toString());
            }
        }
        this.warnings_ = this.doc_.getDocWarnings();
        this.stateMap_ = this.doc_.getStateMap();
    }

    public StateMap getStateMap() {
        return this.stateMap_;
    }

    public String getWarnings() {
        return this.warnings_;
    }

    public String getSrcAsString() {
        if (this.element_ == null) {
            return "";
        }
        return NetUtil.makeString(this.element_);
    }

    public String getTranslatedAsString() {
        if (this.stateMap_ == null) {
            return "";
        }
        return this.stateMap_.toString();
    }

    public static String convert(String uri) {
        String ret = "";
        try {
            String path = Util.getUriWithoutFragment(uri);
            String dialog = Util.getUriFragment(uri);
            DocLoader loader = new DocLoader(uri, path, dialog, "");
            StateMap stateMap = loader.getStateMap();
            if (stateMap == null) {
                System.err.println("DocLoader stopped: stateMap null.");
                return ret;
            }
            ret = String.valueOf(loader.getWarnings()) + "\n" + stateMap.toString();
        }
        catch (DocError e) {
            e.printStackTrace(System.err);
            System.err.println("DocLoader stopped.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
            System.err.println("DocLoader stopped.");
        }
        catch (SAXParseException e) {
            e.printStackTrace(System.err);
            System.err.println("Source:" + uri);
            System.err.println("Line:" + e.getLineNumber() + " Column:" + e.getColumnNumber());
            System.err.println("DocLoader stopped.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("DocLoader stopped.");
        }
        return ret;
    }
}

