/*
 * Decompiled with CFR 0.152.
 */
package galatea.dialog.window;

import galatea.dialog.ISystemEventLogger;
import galatea.dialog.window.IDMWindowActionListener;
import galatea.document.DocLoader;
import galatea.httpclient.INetUtilListener;
import galatea.logger.ILoggerListener;
import galatea.util.Property;
import galatea.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DialogManagerWindow
implements ISystemEventLogger,
INetUtilListener,
ILoggerListener {
    private JEditorPane applogPane_ = null;
    private StringBuffer applogContent_ = new StringBuffer();
    private JEditorPane recogPane_ = null;
    private StringBuffer recogContent_ = new StringBuffer();
    private JEditorPane statePane_ = null;
    private StringBuffer stateContent_ = new StringBuffer();
    private IDMWindowActionListener eventListener_ = null;
    private JLabel labelPauseMode_ = null;
    private JTextField textFieldLocation_ = null;
    private JTextArea textFieldSpeaking_ = null;
    private String currLocalDirPath_ = "";
    private String test1Label_;
    private String test1Command_;
    private String test2Label_;
    private String test2Command_;
    private String test3Label_;
    private String test3Command_;
    private String demo1Label_;
    private String demo1File_;
    private String demo2Label_;
    private String demo2File_;
    private String demo3Label_;
    private String demo3File_;
    private String demo4Label_;
    private String demo4File_;
    private JTextField textFieldDebuggerEval_;
    private JTextArea textFieldDebuggerResult_;
    private StringBuffer debugEvalResultContent_ = new StringBuffer();
    private JTextArea textFieldHttpLog_;
    private String httpLogText_ = "";
    private JTextArea textFieldViewSrc_;
    private JTextArea textFieldViewGram_;
    private JTextArea textFieldViewTrans_;
    private JTextArea textFieldLogger_;
    private String loggerText_ = "";
    private JTextArea textFieldConfig_;

    private void _send(String str) {
        System.out.println(str);
        System.out.flush();
    }

    private void _makeWindow(int width, int height) throws Exception {
        JFrame frame = new JFrame("Galatea Dialog Studio 2.2.2.2 (080817)");
        frame.setDefaultCloseOperation(3);
        JMenuBar menuBar = this._makeMenuBar();
        frame.setJMenuBar(menuBar);
        JTabbedPane tab = new JTabbedPane();
        tab.addTab("Main", this._makeMainPanel());
        tab.addTab("Config", this._makeConfigPanel());
        tab.addTab("Script", this._makeDebuggerPanel());
        tab.addTab("Logger", this._makeLoggerPanel());
        tab.addTab("Http", this._makeHttpPanel());
        tab.addTab("Source", this._makeViewSrcPanel());
        tab.addTab("Translated", this._makeViewTransPanel());
        tab.addTab("Grammar", this._makeViewGramPanel());
        tab.setTabLayoutPolicy(1);
        tab.setTabPlacement(1);
        frame.getContentPane().add(tab);
        frame.setSize(width, height);
        frame.setVisible(true);
    }

    private JMenuBar _makeMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        menuBar.add(menuFile);
        JMenuItem itemOpen = new JMenuItem("Open Local File...");
        menuFile.add(itemOpen);
        itemOpen.addActionListener(new MenuOpenActionListener());
        JMenuItem itemQuit = new JMenuItem("Quit Current Dialog");
        menuFile.add(itemQuit);
        itemQuit.addActionListener(new MenuQuitActionListener());
        JMenuItem itemExit = new JMenuItem("Exit");
        menuFile.add(itemExit);
        itemExit.addActionListener(new MenuExitActionListener());
        JMenu menuFace = new JMenu("Face");
        menuBar.add(menuFace);
        JMenuItem itemAgentEnable = new JMenuItem("AgentEnable");
        menuFace.add(itemAgentEnable);
        itemAgentEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set AgentEnable = ENABLE");
            }
        });
        JMenuItem itemAgentDisable = new JMenuItem("AgentDisable");
        menuFace.add(itemAgentDisable);
        itemAgentDisable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set AgentEnable = DISABLE");
            }
        });
        JMenuItem itemAgentAlpha10 = new JMenuItem("Alpha 1.0");
        menuFace.add(itemAgentAlpha10);
        itemAgentAlpha10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set AgentAlpha = 1.0");
            }
        });
        JMenuItem itemAgentAlpha08 = new JMenuItem("Alpha 0.8");
        menuFace.add(itemAgentAlpha08);
        itemAgentAlpha08.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set AgentAlpha = 0.8");
            }
        });
        JMenuItem itemAgentAlpha05 = new JMenuItem("Alpha 0.5");
        menuFace.add(itemAgentAlpha05);
        itemAgentAlpha05.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set AgentAlpha = 0.5");
            }
        });
        JMenuItem itemAgentAlpha03 = new JMenuItem("Alpha 0.3");
        menuFace.add(itemAgentAlpha03);
        itemAgentAlpha03.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set AgentAlpha = 0.3");
            }
        });
        JMenuItem itemViewMode1 = new JMenuItem("Texture");
        menuFace.add(itemViewMode1);
        itemViewMode1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set ViewMode = TEXTURE");
            }
        });
        JMenuItem itemViewMode2 = new JMenuItem("Texture with Wireframe");
        menuFace.add(itemViewMode2);
        itemViewMode2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set ViewMode = TEXTURE_WITH_WIREFRAME");
            }
        });
        JMenuItem itemViewMode3 = new JMenuItem("Wireframe");
        menuFace.add(itemViewMode3);
        itemViewMode3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FSM set ViewMode = WIREFRAME");
            }
        });
        JMenu menuMask = new JMenu("Mask");
        menuBar.add(menuMask);
        JMenuItem itemMask1 = new JMenuItem("man01");
        menuMask.add(itemMask1);
        itemMask1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set Mask = man01");
            }
        });
        JMenuItem itemMask2 = new JMenuItem("man02");
        menuMask.add(itemMask2);
        itemMask2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set Mask = man02");
            }
        });
        JMenuItem itemMask3 = new JMenuItem("woman01");
        menuMask.add(itemMask3);
        itemMask3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set Mask = woman01");
            }
        });
        JMenu menuAuto = new JMenu("Auto");
        menuBar.add(menuAuto);
        JMenuItem itemAutoMoveOn = new JMenuItem("AutoMove ON");
        menuAuto.add(itemAutoMoveOn);
        itemAutoMoveOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set AutoMove = 1");
            }
        });
        JMenuItem itemAutoMoveOff = new JMenuItem("AutoMove OFF");
        menuAuto.add(itemAutoMoveOff);
        itemAutoMoveOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set AutoMove = 0");
            }
        });
        JMenuItem itemAutoGazeOn = new JMenuItem("AutoGaze ON");
        menuAuto.add(itemAutoGazeOn);
        itemAutoGazeOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set AutoGaze = 1");
            }
        });
        JMenuItem itemAutoGazeOff = new JMenuItem("AutoGaze OFF");
        menuAuto.add(itemAutoGazeOff);
        itemAutoGazeOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set AutoGaze = 0");
            }
        });
        JMenuItem itemEmotionSpeakOn = new JMenuItem("EmotionSpeak ON");
        menuAuto.add(itemEmotionSpeakOn);
        itemEmotionSpeakOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set AutoEmotionSpeak = 1");
            }
        });
        JMenuItem itemEmotionSpeakOff = new JMenuItem("EmotionSpeak OFF");
        menuAuto.add(itemEmotionSpeakOff);
        itemEmotionSpeakOff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @AM-MCL set AutoEmotionSpeak = 0");
            }
        });
        JMenu menuExp = new JMenu("Expression");
        menuBar.add(menuExp);
        JMenuItem itemEmo1 = new JMenuItem("Neutral");
        menuExp.add(itemEmo1);
        itemEmo1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = NEUTRAL");
            }
        });
        JMenuItem itemEmo2 = new JMenuItem("Happy");
        menuExp.add(itemEmo2);
        itemEmo2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = HAPPY 90");
            }
        });
        JMenuItem itemEmo3 = new JMenuItem("Disgusted");
        menuExp.add(itemEmo3);
        itemEmo3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = DISGUSTED 90");
            }
        });
        JMenuItem itemEmo4 = new JMenuItem("Sad");
        menuExp.add(itemEmo4);
        itemEmo4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = SAD 90");
            }
        });
        JMenuItem itemEmo5 = new JMenuItem("Angry");
        menuExp.add(itemEmo5);
        itemEmo5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = ANGRY 90");
            }
        });
        JMenuItem itemEmo6 = new JMenuItem("Surprised");
        menuExp.add(itemEmo6);
        itemEmo6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = SURPRISED 30");
            }
        });
        JMenuItem itemEmo7 = new JMenuItem("Feared");
        menuExp.add(itemEmo7);
        itemEmo7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManagerWindow.this._send("to @FS-MCL set Emotion = FEARED 90");
            }
        });
        JMenu menuDemo = new JMenu("Demo");
        menuBar.add(menuDemo);
        this.test1Label_ = Property.getAsStr("DM.Window.Test.1.Label", null);
        this.test1Command_ = Property.getAsStr("DM.Window.Test.1.Command", null);
        if (this.test1Label_ != null && this.test1Command_ != null) {
            JMenuItem itemTest1 = new JMenuItem(this.test1Label_);
            menuDemo.add(itemTest1);
            itemTest1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogManagerWindow.this._send(DialogManagerWindow.this.test1Command_);
                }
            });
        }
        this.test2Label_ = Property.getAsStr("DM.Window.Test.2.Label", null);
        this.test2Command_ = Property.getAsStr("DM.Window.Test.2.Command", null);
        if (this.test2Label_ != null && this.test2Command_ != null) {
            JMenuItem itemTest2 = new JMenuItem(this.test2Label_);
            menuDemo.add(itemTest2);
            itemTest2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogManagerWindow.this._send(DialogManagerWindow.this.test2Command_);
                }
            });
        }
        this.test3Label_ = Property.getAsStr("DM.Window.Test.3.Label", null);
        this.test3Command_ = Property.getAsStr("DM.Window.Test.3.Command", null);
        if (this.test3Label_ != null && this.test3Command_ != null) {
            JMenuItem itemTest3 = new JMenuItem(this.test3Label_);
            menuDemo.add(itemTest3);
            itemTest3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogManagerWindow.this._send(DialogManagerWindow.this.test3Command_);
                }
            });
        }
        this.demo1Label_ = Property.getAsStr("DM.Window.Demo.1.Label", null);
        this.demo1File_ = Property.getAsStr("DM.Window.Demo.1.File", null);
        if (this.demo1Label_ != null && this.demo1File_ != null) {
            JMenuItem itemDemo1 = new JMenuItem(this.demo1Label_);
            menuDemo.add(itemDemo1);
            itemDemo1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String adrs = Util.resolveAdrs(DialogManagerWindow.this.currLocalDirPath_, DialogManagerWindow.this.demo1File_);
                    if (DialogManagerWindow.this.eventListener_ != null) {
                        DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
                        DialogManagerWindow.this.eventListener_.setPauseModeAction(false);
                        DialogManagerWindow.this.eventListener_.setNextDocumentAction(adrs);
                        DialogManagerWindow.this.eventListener_.terminateDialogAction();
                    } else {
                        System.err.println("adrs:" + adrs);
                    }
                }
            });
        }
        this.demo2Label_ = Property.getAsStr("DM.Window.Demo.2.Label", null);
        this.demo2File_ = Property.getAsStr("DM.Window.Demo.2.File", null);
        if (this.demo2Label_ != null && this.demo2File_ != null) {
            JMenuItem itemDemo2 = new JMenuItem(this.demo2Label_);
            menuDemo.add(itemDemo2);
            itemDemo2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String adrs = Util.resolveAdrs(DialogManagerWindow.this.currLocalDirPath_, DialogManagerWindow.this.demo2File_);
                    if (DialogManagerWindow.this.eventListener_ != null) {
                        DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
                        DialogManagerWindow.this.eventListener_.setPauseModeAction(false);
                        DialogManagerWindow.this.eventListener_.setNextDocumentAction(adrs);
                        DialogManagerWindow.this.eventListener_.terminateDialogAction();
                    } else {
                        System.err.println("adrs:" + adrs);
                    }
                }
            });
        }
        this.demo3Label_ = Property.getAsStr("DM.Window.Demo.3.Label", null);
        this.demo3File_ = Property.getAsStr("DM.Window.Demo.3.File", null);
        if (this.demo3Label_ != null && this.demo3File_ != null) {
            JMenuItem itemDemo3 = new JMenuItem(this.demo3Label_);
            menuDemo.add(itemDemo3);
            itemDemo3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String adrs = Util.resolveAdrs(DialogManagerWindow.this.currLocalDirPath_, DialogManagerWindow.this.demo3File_);
                    if (DialogManagerWindow.this.eventListener_ != null) {
                        DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
                        DialogManagerWindow.this.eventListener_.setPauseModeAction(false);
                        DialogManagerWindow.this.eventListener_.setNextDocumentAction(adrs);
                        DialogManagerWindow.this.eventListener_.terminateDialogAction();
                    } else {
                        System.err.println("adrs:" + adrs);
                    }
                }
            });
        }
        this.demo4Label_ = Property.getAsStr("DM.Window.Demo.4.Label", null);
        this.demo4File_ = Property.getAsStr("DM.Window.Demo.4.File", null);
        if (this.demo4Label_ != null && this.demo4File_ != null) {
            JMenuItem itemDemo4 = new JMenuItem(this.demo4Label_);
            menuDemo.add(itemDemo4);
            itemDemo4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String adrs = Util.resolveAdrs(DialogManagerWindow.this.currLocalDirPath_, DialogManagerWindow.this.demo4File_);
                    if (DialogManagerWindow.this.eventListener_ != null) {
                        DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
                        DialogManagerWindow.this.eventListener_.setPauseModeAction(false);
                        DialogManagerWindow.this.eventListener_.setNextDocumentAction(adrs);
                        DialogManagerWindow.this.eventListener_.terminateDialogAction();
                    } else {
                        System.err.println("adrs:" + adrs);
                    }
                }
            });
        }
        return menuBar;
    }

    private GridBagConstraints _initPos() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 11;
        constraints.fill = 1;
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.gridy = 0;
        constraints.gridheight = 1;
        return constraints;
    }

    private void _setPos(GridBagConstraints c, int x, int width) {
        this._setPos(c, x, width, 0, 0);
    }

    private void _setPos(GridBagConstraints c, int x, int width, int wx) {
        this._setPos(c, x, width, wx, 0);
    }

    private void _setPos(GridBagConstraints c, int x, int width, int wx, int wy) {
        c.gridx = x;
        c.gridwidth = width;
        c.weightx = wx;
        c.weighty = wy;
    }

    private void _nextRow(GridBagConstraints c) {
        ++c.gridy;
    }

    private JPanel _makeMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = this._initPos();
        this._setPos(c, 0, 2, 1);
        this.textFieldLocation_ = new JTextField();
        panel.add((Component)this.textFieldLocation_, c);
        this._setPos(c, 2, 1);
        JButton buttonGo = new JButton("Go");
        panel.add((Component)buttonGo, c);
        buttonGo.addActionListener(new MainPanelGoActionListener());
        this._setPos(c, 3, 1);
        JButton buttonValidate = new JButton("Validate");
        panel.add((Component)buttonValidate, c);
        buttonValidate.addActionListener(new MainPanelValidateActionListener());
        this._nextRow(c);
        this._setPos(c, 0, 1, 1);
        JButton buttonStart = new JButton("Run");
        panel.add((Component)buttonStart, c);
        buttonStart.addActionListener(new MainPanelButtonStartActionListener());
        this._setPos(c, 1, 1, 1);
        JButton buttonStop = new JButton("Pause");
        panel.add((Component)buttonStop, c);
        buttonStop.addActionListener(new MainPanelButtonStopActionListener());
        this._setPos(c, 2, 2);
        this.labelPauseMode_ = new JLabel("Mode: Run");
        panel.add((Component)this.labelPauseMode_, c);
        this._nextRow(c);
        this._setPos(c, 0, 4);
        panel.add((Component)new JLabel("Speak"), c);
        this._nextRow(c);
        this._setPos(c, 0, 4, 1, 1);
        this.textFieldSpeaking_ = new JTextArea();
        this.textFieldSpeaking_.setEditable(false);
        this.textFieldSpeaking_.setRows(3);
        this.textFieldSpeaking_.setLineWrap(true);
        panel.add((Component)new JScrollPane(this.textFieldSpeaking_, 22, 31), c);
        this._nextRow(c);
        this._setPos(c, 0, 4);
        panel.add((Component)new JLabel("Log"), c);
        this._nextRow(c);
        this._setPos(c, 0, 4, 1, 1);
        this.applogPane_ = new JEditorPane("text/plain", "");
        this.applogPane_.setEditable(false);
        panel.add((Component)new JScrollPane(this.applogPane_, 22, 31), c);
        this._nextRow(c);
        this._setPos(c, 0, 4);
        panel.add((Component)new JLabel("Input"), c);
        this._nextRow(c);
        this._setPos(c, 0, 4, 1, 1);
        this.recogPane_ = new JEditorPane("text/plain", "");
        this.recogPane_.setEditable(false);
        panel.add((Component)new JScrollPane(this.recogPane_, 22, 31), c);
        this._nextRow(c);
        this._setPos(c, 0, 4);
        panel.add((Component)new JLabel("State"), c);
        this._nextRow(c);
        this._setPos(c, 0, 4, 1, 1);
        this.statePane_ = new JEditorPane("text/plain", "");
        this.statePane_.setEditable(false);
        panel.add((Component)new JScrollPane(this.statePane_, 22, 31), c);
        return panel;
    }

    private JPanel _makeDebuggerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = this._initPos();
        this._setPos(c, 0, 3, 1);
        this.textFieldDebuggerEval_ = new JTextField();
        panel.add((Component)this.textFieldDebuggerEval_, c);
        this._setPos(c, 3, 1);
        JButton buttonGo = new JButton("Eval");
        panel.add((Component)buttonGo, c);
        buttonGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str = DialogManagerWindow.this.textFieldDebuggerEval_.getText();
                if (DialogManagerWindow.this.eventListener_ != null) {
                    DialogManagerWindow.this.debugEvalResultContent_.append(">" + str + "\n");
                    DialogManagerWindow.this.textFieldDebuggerResult_.setText(DialogManagerWindow.this.debugEvalResultContent_.toString());
                    DialogManagerWindow.this.eventListener_.setDebuggerEvalAction(str);
                } else {
                    System.out.println(e);
                    System.out.println(str);
                }
            }
        });
        this._setPos(c, 4, 1);
        JButton buttonSrc = new JButton("To Source");
        panel.add((Component)buttonSrc, c);
        buttonSrc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String str = DialogManagerWindow.this.textFieldDebuggerEval_.getText();
                str = String.valueOf(str) + ".toSource()";
                if (DialogManagerWindow.this.eventListener_ != null) {
                    DialogManagerWindow.this.debugEvalResultContent_.append(">" + str + "\n");
                    DialogManagerWindow.this.textFieldDebuggerResult_.setText(DialogManagerWindow.this.debugEvalResultContent_.toString());
                    DialogManagerWindow.this.eventListener_.setDebuggerEvalAction(str);
                } else {
                    System.out.println(e);
                    System.out.println(str);
                }
            }
        });
        this._nextRow(c);
        this._setPos(c, 0, 5);
        panel.add((Component)new JLabel("Result"), c);
        this._nextRow(c);
        this._setPos(c, 0, 5, 1, 1);
        this.textFieldDebuggerResult_ = new JTextArea();
        this.textFieldDebuggerResult_.setEditable(false);
        this.textFieldDebuggerResult_.setRows(3);
        this.textFieldDebuggerResult_.setLineWrap(true);
        panel.add((Component)new JScrollPane(this.textFieldDebuggerResult_, 22, 31), c);
        return panel;
    }

    public void dispDebuggerEvalResult(String result) {
        this.debugEvalResultContent_.append(String.valueOf(result) + "\n");
        if (this.textFieldDebuggerResult_ != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogManagerWindow.this.textFieldDebuggerResult_.setText(DialogManagerWindow.this.debugEvalResultContent_.toString());
                }
            });
        }
    }

    private JPanel _makeLoggerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = this._initPos();
        this._setPos(c, 0, 0, 1, 1);
        this.textFieldLogger_ = new JTextArea();
        this.textFieldLogger_.setEditable(false);
        this.textFieldLogger_.setRows(1);
        this.textFieldLogger_.setLineWrap(true);
        panel.add((Component)new JScrollPane(this.textFieldLogger_, 22, 31), c);
        return panel;
    }

    private JPanel _makeHttpPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = this._initPos();
        this._setPos(c, 0, 0, 1, 1);
        this.textFieldHttpLog_ = new JTextArea();
        this.textFieldHttpLog_.setEditable(false);
        this.textFieldHttpLog_.setRows(1);
        this.textFieldHttpLog_.setLineWrap(true);
        panel.add((Component)new JScrollPane(this.textFieldHttpLog_, 22, 31), c);
        return panel;
    }

    private JPanel _makeViewSrcPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = this._initPos();
        this._setPos(c, 0, 0, 1, 1);
        this.textFieldViewSrc_ = new JTextArea();
        this.textFieldViewSrc_.setEditable(false);
        this.textFieldViewSrc_.setRows(1);
        this.textFieldViewSrc_.setLineWrap(true);
        panel.add((Component)new JScrollPane(this.textFieldViewSrc_, 22, 31), c);
        return panel;
    }

    private JPanel _makeViewGramPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = this._initPos();
        this._setPos(c, 0, 0, 1, 1);
        this.textFieldViewGram_ = new JTextArea();
        this.textFieldViewGram_.setEditable(false);
        this.textFieldViewGram_.setRows(1);
        this.textFieldViewGram_.setLineWrap(true);
        panel.add((Component)new JScrollPane(this.textFieldViewGram_, 22, 31), c);
        return panel;
    }

    private JPanel _makeViewTransPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = this._initPos();
        this._setPos(c, 0, 0, 1, 1);
        this.textFieldViewTrans_ = new JTextArea();
        this.textFieldViewTrans_.setEditable(false);
        this.textFieldViewTrans_.setRows(1);
        this.textFieldViewTrans_.setLineWrap(true);
        panel.add((Component)new JScrollPane(this.textFieldViewTrans_, 22, 31), c);
        return panel;
    }

    private JPanel _makeConfigPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = this._initPos();
        this._setPos(c, 0, 0, 1, 1);
        this.textFieldConfig_ = new JTextArea();
        this.textFieldConfig_.setEditable(false);
        this.textFieldConfig_.setRows(1);
        this.textFieldConfig_.setLineWrap(true);
        panel.add((Component)new JScrollPane(this.textFieldConfig_, 22, 31), c);
        String config = Property.getConfigStrings();
        this.textFieldConfig_.setText(config);
        return panel;
    }

    public DialogManagerWindow() {
        this.currLocalDirPath_ = Property.getAsStr("user.dir", "/");
        this.currLocalDirPath_ = String.valueOf(this.currLocalDirPath_) + Property.getAsStr("user.dir.suffix", "/files/");
        this.currLocalDirPath_ = "file:" + Util.replaceAll(this.currLocalDirPath_, "\\", "/");
        if (Property.getAsBoolean("ShowWindow", true)) {
            try {
                this._setLookAndFeel();
                int w = Property.getAsInt("DM.WindowWidth", 640);
                int h = Property.getAsInt("DM.WindowHeight", 480);
                this._makeWindow(w, h);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    private void _setLookAndFeel() {
        String metal = "javax.swing.plaf.metal.MetalLookAndFeel";
        String mac = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
        String motif = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        String windows = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        String gtk = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
        String lafname = "javax.swing.plaf.metal.MetalLookAndFeel";
        if (Util.isWindows()) {
            lafname = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        }
        try {
            Class<?> lnfClass = Class.forName("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            LookAndFeel newLAF = (LookAndFeel)lnfClass.newInstance();
            if (newLAF.isSupportedLookAndFeel()) {
                try {
                    UIManager.setLookAndFeel(newLAF);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void documentLocationChanged(String text) {
        if (this.textFieldLocation_ != null) {
            this.textFieldLocation_.setText(text);
        }
    }

    @Override
    public void outputVoiceStarted(String text) {
        if (this.textFieldSpeaking_ != null) {
            this.textFieldSpeaking_.setText(Util.removeTags(text));
        }
    }

    public void dispApplog(String text) {
        if (this.applogContent_ != null) {
            this.applogContent_.insert(0, String.valueOf(text) + "\n");
        }
        if (this.applogPane_ != null) {
            this.applogPane_.setText(this.applogContent_.toString());
        }
    }

    @Override
    public void inputEventReceived(String text) {
        if (this.recogContent_ != null) {
            this.recogContent_.insert(0, String.valueOf(text) + "\n");
        }
        if (this.recogPane_ != null) {
            this.recogPane_.setText(this.recogContent_.toString());
        }
    }

    @Override
    public void dialogStateChanged(String text) {
        if (this.stateContent_ != null) {
            this.stateContent_.insert(0, String.valueOf(text) + "\n");
        }
        if (this.statePane_ != null) {
            this.statePane_.setText(this.stateContent_.toString());
        }
    }

    @Override
    public void fatalError(String error) {
        if (this.stateContent_ != null) {
            this.stateContent_.insert(0, String.valueOf(error) + "\n");
        }
        if (this.statePane_ != null) {
            this.statePane_.setText(this.stateContent_.toString());
        }
    }

    public void setDialogManagerWindowActionListener(IDMWindowActionListener listener) {
        this.eventListener_ = listener;
    }

    @Override
    public void srcFileUpdated(String text) {
        if (this.textFieldViewSrc_ != null) {
            this.textFieldViewSrc_.setText(text);
        }
    }

    @Override
    public void translatedFileUpdated(String text) {
        if (this.textFieldViewTrans_ != null) {
            this.textFieldViewTrans_.setText(text);
        }
    }

    @Override
    public void grammarFileUpdated(String text) {
        if (this.textFieldViewGram_ != null) {
            this.textFieldViewGram_.setText(text);
        }
    }

    @Override
    public void addNetUtilEvent(String msg) {
        if (this.textFieldHttpLog_ != null) {
            this.httpLogText_ = String.valueOf(this.httpLogText_) + msg + "\n";
            this.textFieldHttpLog_.setText(this.httpLogText_);
        }
    }

    @Override
    public void addLoggerEvent(String msg) {
        if (this.textFieldLogger_ != null) {
            this.loggerText_ = String.valueOf(msg) + "\n" + this.loggerText_;
            this.textFieldLogger_.setText(this.loggerText_);
        }
    }

    public static void main(String[] args) throws Exception {
        DialogManagerWindow w = new DialogManagerWindow();
        w.dispApplog("abc\u65e5\u672c\u8a9e\u3067\u3059\u3002");
        w.dispApplog("java.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
        w.dispApplog("os.arch=" + System.getProperty("os.arch"));
        w.dispApplog("os.name=" + System.getProperty("os.name"));
        w.dispApplog("user.dir=" + System.getProperty("user.dir"));
        int i = 0;
        while (true) {
            String s = "test" + i;
            w.dispApplog(s);
            try {
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private final class MainPanelButtonStartActionListener
    implements ActionListener {
        private MainPanelButtonStartActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
            if (DialogManagerWindow.this.eventListener_ != null) {
                DialogManagerWindow.this.eventListener_.setPauseModeAction(false);
            } else {
                System.out.println(e);
            }
        }
    }

    private final class MainPanelButtonStopActionListener
    implements ActionListener {
        private MainPanelButtonStopActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogManagerWindow.this.labelPauseMode_.setText("Mode: Pause");
            if (DialogManagerWindow.this.eventListener_ != null) {
                DialogManagerWindow.this.eventListener_.setPauseModeAction(true);
            } else {
                System.out.println(e);
            }
        }
    }

    private final class MainPanelGoActionListener
    implements ActionListener {
        private MainPanelGoActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String uri = DialogManagerWindow.this.textFieldLocation_.getText();
            if (DialogManagerWindow.this.eventListener_ != null) {
                DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
                DialogManagerWindow.this.eventListener_.setPauseModeAction(false);
                DialogManagerWindow.this.eventListener_.setNextDocumentAction(uri);
                DialogManagerWindow.this.eventListener_.terminateDialogAction();
            } else {
                System.out.println(e);
                System.out.println(uri);
            }
        }
    }

    private final class MainPanelValidateActionListener
    implements ActionListener {
        private MainPanelValidateActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String uri = DialogManagerWindow.this.textFieldLocation_.getText();
            if (uri != null && uri.length() > 0) {
                String doc = DocLoader.convert(uri);
                if (doc != "") {
                    System.err.println("[DM Validate OK] " + uri);
                } else {
                    System.err.println("[DM Validate ERROR] " + uri);
                }
            }
        }
    }

    private final class MenuExitActionListener
    implements ActionListener {
        private MenuExitActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    private final class MenuOpenActionListener
    implements ActionListener {
        private MenuOpenActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String org = DialogManagerWindow.this.currLocalDirPath_.replaceFirst("file:", "");
            JFileChooser chooser = new JFileChooser(org);
            chooser.showOpenDialog(null);
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String uri = file.getAbsolutePath();
            uri = Util.replaceAll(uri, "\\", "/");
            uri = "file:" + uri;
            if (DialogManagerWindow.this.eventListener_ != null) {
                DialogManagerWindow.this.labelPauseMode_.setText("Mode: Run");
                DialogManagerWindow.this.eventListener_.setPauseModeAction(false);
                DialogManagerWindow.this.eventListener_.setNextDocumentAction(uri);
                DialogManagerWindow.this.eventListener_.terminateDialogAction();
            } else {
                System.out.println(e);
                System.out.println(uri);
            }
            DialogManagerWindow.this.currLocalDirPath_ = Util.getUriDirectory(uri);
        }
    }

    private final class MenuQuitActionListener
    implements ActionListener {
        private MenuQuitActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DialogManagerWindow.this.eventListener_ != null) {
                DialogManagerWindow.this.eventListener_.quitAction();
            } else {
                System.out.println(e);
            }
        }
    }
}

