/*
 * Decompiled with CFR 0.152.
 */
package galatea.dialog;

import galatea.dialog.IC;
import galatea.dialog.IControllerModeManager;
import galatea.dialog.IInteractionController;
import galatea.document.DocError;
import galatea.document.DocLoader;
import galatea.document.StateMap;
import galatea.httpclient.NetUtil;
import galatea.logger.Logger;
import galatea.util.Getopt;
import galatea.util.Messages;
import galatea.util.Property;
import galatea.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Properties;

public class DialogManager {
    private static final String propertiesPath = "/res/config/dialog.properties";
    private static final String messagesPath = "res.messages.messages";
    private Logger dbg = new Logger("DM");
    private IC theIC_;
    private IInteractionController interactionController_;
    private IControllerModeManager modeManager_;
    private String filename;
    private String poststring = "";

    public static String getResourceAsString(String res) {
        InputStream is = DialogManager.class.getResourceAsStream(res);
        String str = Util.readInputStream(is, Charset.forName("UTF-8"));
        return str;
    }

    public static void main(String[] argv) {
        DialogManager dm = new DialogManager();
        dm._setup(argv);
        dm._waitDevicesForReady();
        dm._execute();
        Util.halt("Galatea Dialog Manager terminated.");
    }

    private void _setup(String[] argv) {
        int c;
        Messages.setup(messagesPath);
        boolean isPrintOnly = false;
        ArrayList<String> confFileNames = new ArrayList<String>();
        ArrayList<String> overrideParams = new ArrayList<String>();
        Getopt g = new Getopt("", argv, "c:vpD:");
        g.setOpterr(false);
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 99: {
                    confFileNames.add(g.getOptarg());
                    break;
                }
                case 118: {
                    this.showVersion();
                    this.showUsage();
                    System.exit(1);
                    break;
                }
                case 112: {
                    isPrintOnly = true;
                    break;
                }
                case 68: {
                    overrideParams.add(g.getOptarg());
                }
            }
        }
        Properties props = new Properties(System.getProperties());
        InputStream is = DialogManager.class.getResourceAsStream(propertiesPath);
        try {
            props.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        for (String conf : confFileNames) {
            File conffile = new File(conf);
            if (!conffile.canRead()) continue;
            try {
                props.load(new FileInputStream(conffile));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String s : overrideParams) {
            ArrayList<String> v = Util.makeTokenizedList(s, "=");
            if (v.size() != 2) continue;
            props.setProperty(v.get(0), v.get(1));
        }
        System.setProperties(props);
        if (isPrintOnly) {
            System.out.print(DocLoader.convert(argv[g.getOptind()]));
            System.exit(0);
        }
        if (argv.length - g.getOptind() != 1) {
            this.filename = null;
        } else {
            this.filename = argv[g.getOptind()];
            this.filename = Util.getNormalizedFileName(this.filename);
        }
        String workdir = Property.getForPlatformAsStr("Grammar.WorkDir", "/tmp");
        File file = new File(workdir);
        if (!file.exists()) {
            file.mkdir();
        }
        this.theIC_ = new IC();
        this.theIC_.start();
        if (Property.getAsBoolean("ShowVersion", true)) {
            this.showVersion();
            System.err.println(this.theIC_.getScriptVersionAndCopyright());
        }
        this.interactionController_ = this.theIC_;
        this.modeManager_ = this.theIC_;
    }

    public void showVersion() {
        System.err.println("Galatea Dialog Studio 2.2.2.2 (080817)");
        System.err.println("(c)2003-2008 Takuya NISHIMOTO (nishimoto@m.ieice.org)");
    }

    public void showUsage() {
        System.err.println("Usage:\tgalatea [options] [document.vxml]");
        System.err.println("\t -c file : config file");
        System.err.println("\t -v      : show version");
        System.err.println("\t -p      : print translation results");
        System.err.println();
    }

    private void _waitDevicesForReady() {
        this.interactionController_.waitDevicesForReady();
    }

    private void _execute() {
        NetUtil.createCookieManager();
        while (true) {
            try {
                while (true) {
                    if (this.filename != null && this.filename.length() > 0) {
                        this.dbg.print("filename:" + this.filename);
                        this.modeManager_.setStatelessMode(false);
                        String path = Util.getUriWithoutFragment(this.filename);
                        String dialog = Util.getUriFragment(this.filename);
                        DocLoader loader = new DocLoader(this.filename, path, dialog, this.poststring);
                        StateMap stateMap = loader.getStateMap();
                        if (stateMap == null) {
                            throw new DocError("Document not found: " + this.filename);
                        }
                        this.interactionController_.setStateMap(stateMap);
                        String state = "[Load] " + this.filename + " [post] " + this.poststring;
                        String src = loader.getSrcAsString();
                        String trans = loader.getTranslatedAsString();
                        this.interactionController_.dispDocInfo(this.filename, state, src, trans);
                    } else {
                        this.dbg.print("StatelessMode=true");
                        this.interactionController_.dispDocInfo("", "(no dialog)", "", "");
                        this.modeManager_.setStatelessMode(true);
                    }
                    this.interactionController_.mainLoop();
                    this.filename = this.interactionController_.getNextDocFile();
                    this.poststring = this.interactionController_.getPostString();
                    this.interactionController_.resetNextDocFile();
                }
            }
            catch (Exception e) {
                System.err.println("caught " + e.toString());
                this.modeManager_.setStatelessMode(true);
                this.modeManager_.setPauseMode(true);
                this.interactionController_.dispDocInfo("", e.toString(), "", "");
                this.interactionController_.resetNextDocFile();
                this.filename = "";
                continue;
            }
            break;
        }
    }
}

