/*
 * Decompiled with CFR 0.152.
 */
package galatea.command;

import galatea.command.Command;
import galatea.command.EvaluateCommand;
import galatea.dialog.RuntimeError;
import galatea.logger.Logger;
import java.util.ArrayList;

public class CompositeCommand
extends Command {
    private Logger dbg = new Logger("CC");
    private ArrayList<Command> commands_ = null;

    public CompositeCommand(ArrayList<Command> v) {
        this.commands_ = v;
    }

    public CompositeCommand(ArrayList<Command> v, String cond) {
        this.commands_ = v;
        this.setCondition(cond);
    }

    public void setCommands(ArrayList<Command> v) {
        this.commands_ = v;
    }

    public ArrayList<Command> getCommands() {
        return this.commands_;
    }

    public void addCommand(Command c) {
        this.commands_.add(c);
    }

    public void addScriptCommand(String script) {
        this.commands_.add(new EvaluateCommand(script));
    }

    public void addScriptCommand(String script, String with) {
        this.commands_.add(new EvaluateCommand(script, with));
    }

    @Override
    public String toString() {
        String s = "  <cmd";
        if (this.hasCondition()) {
            s = String.valueOf(s) + " cond=\"" + this.getConditionAsEncodedString() + "\"";
        }
        s = String.valueOf(s) + ">\n";
        int n = this.commands_.size();
        int i = 0;
        while (i < n) {
            Command cmd = this.commands_.get(i);
            s = String.valueOf(s) + " " + cmd.toString();
            s = String.valueOf(s) + "\n";
            ++i;
        }
        s = String.valueOf(s) + "  </cmd>";
        return s;
    }

    @Override
    public void execute() throws RuntimeError {
        if (this.evaluateCondition()) {
            this.dbg.print("CC:adding " + this.commands_.size() + " command(s).");
            this.interpreterContext_.insertCommandsTop(this.commands_);
        }
    }
}

