/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: Util.java,v 1.5 2003/07/25 09:56:37 nishi Exp $
 */
package util;

import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import java.util.*;
import java.net.*;

public class Util 
{
    public Util() 
    {
    }

    public static void halt()
    {
	System.err.println("Dialog Manager Halted. Press Ctrl-C to quit.");
	while (true) 
	    ;
    }

    public static void halt(String msg)
    {
	System.err.println(msg);
	halt();
    }

    public static String removeSpaces(String str)
    {
	StringBuffer retStr = new StringBuffer("");

	if(str == null)
	    return "";

 	StringTokenizer st = new StringTokenizer(str, " \t\n\r");
	while (st.hasMoreTokens()) {
	    retStr.append(st.nextToken());
	}

	if(retStr.length() == 0)
	    return "";

	return retStr.toString();

    }


    /**
     * äȤ䤷뤴ꤺࡣ
     */
    public static String xmlSafeRemoveSpaces(String str)
    {
	if (str == null)
	    return "";

	StringBuffer retStr = new StringBuffer("");
	String token;
	boolean inTag = false;
	
 	StringTokenizer st = new StringTokenizer(str, " \t\n\r");
	while (st.hasMoreTokens()) {
	    token = st.nextToken();
	    // ǽʸ < Ǥ inTag = true
	    // Ǹʸ > Ǥ inTag = false
	    if (token.startsWith("<") ) {
		if (!token.equals("<")) {
		    inTag = true;
		}
	    }
	    if (token.endsWith(">") ) {
		inTag = false;
	    }
	    retStr.append(token);
	    if ( inTag ) {
		retStr.append(" ");
	    }
	}

	if(retStr.length() == 0)
	    return "";
	
	return retStr.toString();
    }


    public static String removeNewLines(String str)
    {
	StringBuffer retStr = new StringBuffer("");

	if(str == null)
	    return "";

 	StringTokenizer st = new StringTokenizer(str, "\n\r");
	while (st.hasMoreTokens()) {
	    retStr.append(st.nextToken());
	}

	if(retStr.length() == 0)
	    return "";

	return retStr.toString();

    }


    /**
     * < >  &lt; &gt; Ѵ롥
     */
    public static String encodeXmlChars(String s)
    {
	if (s==null) return "";
	StringBuffer t = new StringBuffer("");
	for ( int i = 0; i < s.length(); i++ ) {
	    char ch = s.charAt(i);
	    if ( ch == '<' ) {
		t.append("&lt;");
	    } else if ( ch == '>' ) {
		t.append("&gt;");
	    } else if ( ch == '&' ) {
		t.append("&amp;");
	    } else {
		t.append(ch);
	    }
	}
	return t.toString();
    }

    
    public static String decodeXmlChars(String s)
    {
	if ( s == null ) return "";
	String ret = s;
	ret = ret.replaceAll("&lt;", "<");
	ret = ret.replaceAll("&gt;", ">");
	ret = ret.replaceAll("&amp;", "&");
	return ret;
    }


    /**
     * base   : http://aaa.bbb.com/index.vxml
     * rel    : sub/next.vxml
     * return : http://aaa.bbb.com/sub/next.vxml
     */
    public static String resolveAdrs(String base, String rel)
    {
	String s;
	if ( base == null || rel == null ) {
	    return "";
	}
	try {
	    URI u1 = new URI(base);
	    URI u2 = new URI(rel);
	    URI u3 = u1.resolve(u2);
	    s = u3.toString(); 
	} catch ( URISyntaxException e ) {
	    s = "_error_resolveAdrs_";
	}
	return s;
    }


    /**
     * f1: sub/file.vxml#a f2: sub/file.vxml#b -> true
     */
    public static boolean isSameFile(String f1, String f2)
    {
	boolean b = false;
	try {
	    URI u1 = new URI(f1);
	    URI u2 = new URI(f2);

	    // f1  path  f2  fragment  URI 
	    URI u3 = new URI
		(u1.getScheme(), 
		 u1.getUserInfo(),
		 u1.getHost(),
		 u1.getPort(),
		 u1.getPath(),
		 u1.getQuery(),
		 u2.getFragment());
	    if ( u2.equals(u3) )
		b = true;
	} catch ( URISyntaxException e ) {}
	return b;
    }


    /**
     * make Util.run
     */
    public static void main(String args[]) throws Exception
    {
	String src, s, s1, s2;
	/*
	src = "a\nb c < hoge > <br/><hr/> <audio href=xxx src=\"wav\"/> def <div class=\"ggg\">title</div>";
	//s1 = Util.removeSpaces(src);
	//System.out.println(s1);
	s2 = Util.xmlSafeRemoveSpaces(src);
	System.out.println(s2);
	*/

	/*
	s = Util.resolveAdrs("http://aaa.bbb.com/index.vxml", "sub/next.vxml");
	System.out.println(s); // http://aaa.bbb.com/sub/next.vxml

	s = Util.resolveAdrs("/lab/common/src/nishi/galatea/gdm-current/phoenix/", 
			     "../tests/audio/hoge.wav");
	System.out.println(s);

	s = Util.resolveAdrs("/lab/common/src/nishi/galatea/gdm-current/phoenix", 
			     "../tests/audio/hoge.wav");
	System.out.println(s);
	*/

	s = "if (1<=num && 2>nantoka) {infiniteLoop}";
	System.out.println(s);
	s = Util.encodeXmlChars(s);
	System.out.println(s);
	s = Util.decodeXmlChars(s);
	System.out.println(s);
    }

}
