/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: SubProcess.java,v 1.3 2003/07/25 09:56:37 nishi Exp $
 */
package util;

import main.Debug;
import java.io.*;

public class SubProcess
{

    /************************ private: */

    private Debug dbg = new Debug(8);               // ǥХ٥

    private String module_command;   // ֥⥸塼Υޥ
    private Runtime rt;              // ץꥱ Runtime ֥
    private Process child;           // ֥⥸塼 Process ֥
    private InputStream out;         // ֥⥸塼ɸ
    private InputStream err;         // ֥⥸塼ɸ२顼
    private OutputStream in;         // ֥⥸塼ɸ
    private PrintStream stdin;
    private BufferedReader stdout;
    private BufferedReader stderr;
    private boolean running = false;


    /************************ public: */

    public SubProcess()
    {

    }

    public SubProcess(String com)
    {

	this();
	module_command = com;

    }

    public void SetCommand(String com)
    {
	
	module_command = com;

    }

    public boolean Run()
    {
	
	String[] com = new String[3];

	if(module_command.length() == 0){
	    
	    dbg.err("SubProcess.Run(): 'module_command' is undefined.");
	    return false;

	}

	com[0] = "/bin/sh";
	com[1] = "-c";
	com[2] = module_command;

	rt = Runtime.getRuntime();

	try{
	    child = rt.exec(com);
	}
	catch(IOException e){
	    dbg.err("SubProcess.Run(): Runtime.exec() failed.");
	    return false;
	}

	in = child.getOutputStream();
	out = child.getInputStream();
	err = child.getErrorStream();
	stdin = new PrintStream(in);
	stdout = new BufferedReader(new InputStreamReader(out));
	stderr = new BufferedReader(new InputStreamReader(err));

	running = true;

	return true;

    }

    public boolean IsRunning()
    {

	return running;

    }

    public void ToStdin(String str)
    {

      dbg.print("ToStdin: "+str, 9);
      stdin.println(str);
      stdin.flush();

    }

    public String FromStdout()
    {

      String s;

      try{
	  s = stdout.readLine(); // ȥ꡼νãƤ null
	  dbg.print("FromStdout: "+s, 9);
      }
      catch(IOException e){
	dbg.err("SubProcess.FromStdout(): BufferedReader.readLine() failed.", 8);
	return null;
      }

      return s;

    }

    public String FromStdoutNB()
    {
	
	String s;

	try{
	    if(stdout.ready()) {
		s = stdout.readLine();
		dbg.print("FromStdoutNB: "+s, 9);
	    } else {
		s = "";
	    }
	}
	catch(IOException e){
	    dbg.err("SubProcess.FromStdout(): BufferedReader.readLine() failed.");
	    return null;
	}
	
	return s;

    }

    public String FromStderr()
    {

      String s;

      try{
	s = stderr.readLine();
      }
      catch(IOException e){
	dbg.err("SubProcess.FromStderr(): BufferedReader.readLine() failed.");
	return null;
      }

      return s;

    }

    public String FromStderrNB()
    {
	
	String s;

	try{
	    if(stderr.ready())
		s = stderr.readLine();
	    else
		s = "";
	}
	catch(IOException e){
	    dbg.err("SubProcess.FromStderr(): BufferedReader.readLine() failed.");
	    return null;
	}
	
	return s;

    }

    public InputStream GetStdout()
    {

	if(running)
	    return out;
	else
	    return null;
    }

    public InputStream GetStderr()
    {

	if(running)
	    return err;
	else
	    return null;
    }

    public OutputStream GetStdin()
    {

	if(running)
	    return in;
	else
	    return null;

    }

    public void waitFor() throws InterruptedException
    {

	child.waitFor();

    }

    public void destroy()
    {
	child.destroy();
    }

    public int exitValue() throws IllegalThreadStateException
    {
	return child.exitValue();
    }

}
