package relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlTransfer</b> is generated from vxml20.rxg by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="transfer">
 *   <mixed>
 *     <choice occurs="*">
 *       <ref label="audio"/>
 *       <ref label="enumerate"/>
 *       <ref label="value"/>
 *       <ref label="catch"/>
 *       <ref label="help"/>
 *       <ref label="noinput"/>
 *       <ref label="nomatch"/>
 *       <ref label="error"/>
 *       <ref label="filled"/>
 *       <hedgeRef label="grammarExtension"/>
 *       <ref label="prompt"/>
 *       <ref label="property"/>
 *     </choice>
 *   </mixed>
 * </elementRule>
 * 
 * <tag name="transfer">
 *   <attribute name="name" type="NMTOKEN"/>
 *   <attribute name="cond" type="string"/>
 *   <attribute name="expr" type="string"/>
 *   <attribute name="dest" type="string"/>
 *   <attribute name="destexpr" type="string"/>
 *   <attribute name="bridge" type="NMTOKEN">
 *     <enumeration value="true"/>
 *     <enumeration value="false"/>
 *   </attribute>
 *   <attribute name="connecttimeout" type="string"/>
 *   <attribute name="maxtime" type="string"/>
 *   <attribute name="transferaudio" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="transfer"&gt;
 *   &lt;mixed&gt;
 *     &lt;choice occurs="*"&gt;
 *       &lt;ref label="audio"/&gt;
 *       &lt;ref label="enumerate"/&gt;
 *       &lt;ref label="value"/&gt;
 *       &lt;ref label="catch"/&gt;
 *       &lt;ref label="help"/&gt;
 *       &lt;ref label="noinput"/&gt;
 *       &lt;ref label="nomatch"/&gt;
 *       &lt;ref label="error"/&gt;
 *       &lt;ref label="filled"/&gt;
 *       &lt;hedgeRef label="grammarExtension"/&gt;
 *       &lt;ref label="prompt"/&gt;
 *       &lt;ref label="property"/&gt;
 *     &lt;/choice&gt;
 *   &lt;/mixed&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="transfer"&gt;
 *   &lt;attribute name="name" type="NMTOKEN"/&gt;
 *   &lt;attribute name="cond" type="string"/&gt;
 *   &lt;attribute name="expr" type="string"/&gt;
 *   &lt;attribute name="dest" type="string"/&gt;
 *   &lt;attribute name="destexpr" type="string"/&gt;
 *   &lt;attribute name="bridge" type="NMTOKEN"&gt;
 *     &lt;enumeration value="true"/&gt;
 *     &lt;enumeration value="false"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="connecttimeout" type="string"/&gt;
 *   &lt;attribute name="maxtime" type="string"/&gt;
 *   &lt;attribute name="transferaudio" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version vxml20.rxg (Thu Aug 14 17:30:02 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class VxmlTransfer implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlFormChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String name_;
    private String cond_;
    private String expr_;
    private String dest_;
    private String destexpr_;
    private String bridge_;
    private String connecttimeout_;
    private String maxtime_;
    private String transferaudio_;
    // List<IVxmlTransferMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlTransfer</code>.
     *
     */
    public VxmlTransfer() {
    }

    /**
     * Creates a <code>VxmlTransfer</code>.
     *
     * @param source
     */
    public VxmlTransfer(VxmlTransfer source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlTransfer(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlTransfer(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlTransfer(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlTransfer(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlTransfer</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlTransfer(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlTransfer(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlTransfer(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlTransfer(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlTransfer</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlTransfer(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the VxmlTransfer <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlTransfer source) {
        int size;
        setName(source.getName());
        setCond(source.getCond());
        setExpr(source.getExpr());
        setDest(source.getDest());
        setDestexpr(source.getDestexpr());
        setBridge(source.getBridge());
        setConnecttimeout(source.getConnecttimeout());
        setMaxtime(source.getMaxtime());
        setTransferaudio(source.getTransferaudio());
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlTransferMixed)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        cond_ = URelaxer.getAttributePropertyAsString(element, "cond");
        expr_ = URelaxer.getAttributePropertyAsString(element, "expr");
        dest_ = URelaxer.getAttributePropertyAsString(element, "dest");
        destexpr_ = URelaxer.getAttributePropertyAsString(element, "destexpr");
        bridge_ = URelaxer.getAttributePropertyAsString(element, "bridge");
        connecttimeout_ = URelaxer.getAttributePropertyAsString(element, "connecttimeout");
        maxtime_ = URelaxer.getAttributePropertyAsString(element, "maxtime");
        transferaudio_ = URelaxer.getAttributePropertyAsString(element, "transferaudio");
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (GramGrammar.isMatch(stack)) {
                addContent(new GramGrammar(stack));
            } else if (VxmlAudio.isMatch(stack)) {
                addContent(new VxmlAudio(stack));
            } else if (VxmlPrompt.isMatch(stack)) {
                addContent(new VxmlPrompt(stack));
            } else if (VxmlCatch.isMatch(stack)) {
                addContent(new VxmlCatch(stack));
            } else if (VxmlHelp.isMatch(stack)) {
                addContent(new VxmlHelp(stack));
            } else if (VxmlNoinput.isMatch(stack)) {
                addContent(new VxmlNoinput(stack));
            } else if (VxmlNomatch.isMatch(stack)) {
                addContent(new VxmlNomatch(stack));
            } else if (VxmlError.isMatch(stack)) {
                addContent(new VxmlError(stack));
            } else if (VxmlFilled.isMatch(stack)) {
                addContent(new VxmlFilled(stack));
            } else if (VxmlProperty.isMatch(stack)) {
                addContent(new VxmlProperty(stack));
            } else if (VxmlEnumerate.isMatch(stack)) {
                addContent(new VxmlEnumerate(stack));
            } else if (VxmlValue.isMatch(stack)) {
                addContent(new VxmlValue(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlTransfer(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "transfer");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.cond_ != null) {
            URelaxer.setAttributePropertyByString(element, "cond", this.cond_);
        }
        if (this.expr_ != null) {
            URelaxer.setAttributePropertyByString(element, "expr", this.expr_);
        }
        if (this.dest_ != null) {
            URelaxer.setAttributePropertyByString(element, "dest", this.dest_);
        }
        if (this.destexpr_ != null) {
            URelaxer.setAttributePropertyByString(element, "destexpr", this.destexpr_);
        }
        if (this.bridge_ != null) {
            URelaxer.setAttributePropertyByString(element, "bridge", this.bridge_);
        }
        if (this.connecttimeout_ != null) {
            URelaxer.setAttributePropertyByString(element, "connecttimeout", this.connecttimeout_);
        }
        if (this.maxtime_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxtime", this.maxtime_);
        }
        if (this.transferaudio_ != null) {
            URelaxer.setAttributePropertyByString(element, "transferaudio", this.transferaudio_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlTransfer</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlTransfer</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param text
     */
    public void setContent(String text) {
        setContent(new RString(text));
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param text
     */
    public void setContentByString(String text) {
        setContent(new RString(text));
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>cond</b>.
     *
     * @return String
     */
    public final String getCond() {
        return (cond_);
    }

    /**
     * Sets the String property <b>cond</b>.
     *
     * @param cond
     */
    public final void setCond(String cond) {
        this.cond_ = cond;
    }

    /**
     * Gets the String property <b>expr</b>.
     *
     * @return String
     */
    public final String getExpr() {
        return (expr_);
    }

    /**
     * Sets the String property <b>expr</b>.
     *
     * @param expr
     */
    public final void setExpr(String expr) {
        this.expr_ = expr;
    }

    /**
     * Gets the String property <b>dest</b>.
     *
     * @return String
     */
    public final String getDest() {
        return (dest_);
    }

    /**
     * Sets the String property <b>dest</b>.
     *
     * @param dest
     */
    public final void setDest(String dest) {
        this.dest_ = dest;
    }

    /**
     * Gets the String property <b>destexpr</b>.
     *
     * @return String
     */
    public final String getDestexpr() {
        return (destexpr_);
    }

    /**
     * Sets the String property <b>destexpr</b>.
     *
     * @param destexpr
     */
    public final void setDestexpr(String destexpr) {
        this.destexpr_ = destexpr;
    }

    /**
     * Gets the String property <b>bridge</b>.
     *
     * @return String
     */
    public final String getBridge() {
        return (bridge_);
    }

    /**
     * Sets the String property <b>bridge</b>.
     *
     * @param bridge
     */
    public final void setBridge(String bridge) {
        this.bridge_ = bridge;
    }

    /**
     * Gets the String property <b>connecttimeout</b>.
     *
     * @return String
     */
    public final String getConnecttimeout() {
        return (connecttimeout_);
    }

    /**
     * Sets the String property <b>connecttimeout</b>.
     *
     * @param connecttimeout
     */
    public final void setConnecttimeout(String connecttimeout) {
        this.connecttimeout_ = connecttimeout;
    }

    /**
     * Gets the String property <b>maxtime</b>.
     *
     * @return String
     */
    public final String getMaxtime() {
        return (maxtime_);
    }

    /**
     * Sets the String property <b>maxtime</b>.
     *
     * @param maxtime
     */
    public final void setMaxtime(String maxtime) {
        this.maxtime_ = maxtime;
    }

    /**
     * Gets the String property <b>transferaudio</b>.
     *
     * @return String
     */
    public final String getTransferaudio() {
        return (transferaudio_);
    }

    /**
     * Sets the String property <b>transferaudio</b>.
     *
     * @param transferaudio
     */
    public final void setTransferaudio(String transferaudio) {
        this.transferaudio_ = transferaudio;
    }

    /**
     * Gets the IVxmlTransferMixed property <b>content</b>.
     *
     * @return IVxmlTransferMixed[]
     */
    public final IVxmlTransferMixed[] getContent() {
        IVxmlTransferMixed[] array = new IVxmlTransferMixed[content_.size()];
        return ((IVxmlTransferMixed[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlTransferMixed property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IVxmlTransferMixed[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlTransferMixed property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IVxmlTransferMixed content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlTransferMixed property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IVxmlTransferMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlTransferMixed property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IVxmlTransferMixed[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlTransferMixed property <b>content</b>.
     *
     * @return int
     */
    public final int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlTransferMixed property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlTransferMixed
     */
    public final IVxmlTransferMixed getContent(int index) {
        return ((IVxmlTransferMixed)content_.get(index));
    }

    /**
     * Sets the IVxmlTransferMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void setContent(int index, IVxmlTransferMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlTransferMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void addContent(int index, IVxmlTransferMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlTransferMixed property <b>content</b> by index.
     *
     * @param index
     */
    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlTransferMixed property <b>content</b> by object.
     *
     * @param content
     */
    public final void removeContent(IVxmlTransferMixed content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlTransferMixed property <b>content</b>.
     *
     */
    public final void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "transfer", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.append(" ");
            buffer.append("name");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.append("\"");
        }
        if (cond_ != null) {
            buffer.append(" ");
            buffer.append("cond");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.append("\"");
        }
        if (expr_ != null) {
            buffer.append(" ");
            buffer.append("expr");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.append("\"");
        }
        if (dest_ != null) {
            buffer.append(" ");
            buffer.append("dest");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDest())));
            buffer.append("\"");
        }
        if (destexpr_ != null) {
            buffer.append(" ");
            buffer.append("destexpr");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDestexpr())));
            buffer.append("\"");
        }
        if (bridge_ != null) {
            buffer.append(" ");
            buffer.append("bridge");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getBridge())));
            buffer.append("\"");
        }
        if (connecttimeout_ != null) {
            buffer.append(" ");
            buffer.append("connecttimeout");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getConnecttimeout())));
            buffer.append("\"");
        }
        if (maxtime_ != null) {
            buffer.append(" ");
            buffer.append("maxtime");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxtime())));
            buffer.append("\"");
        }
        if (transferaudio_ != null) {
            buffer.append(" ");
            buffer.append("transferaudio");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getTransferaudio())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "transfer", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "transfer", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.write(" ");
            buffer.write("name");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.write("\"");
        }
        if (cond_ != null) {
            buffer.write(" ");
            buffer.write("cond");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.write("\"");
        }
        if (expr_ != null) {
            buffer.write(" ");
            buffer.write("expr");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.write("\"");
        }
        if (dest_ != null) {
            buffer.write(" ");
            buffer.write("dest");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getDest())));
            buffer.write("\"");
        }
        if (destexpr_ != null) {
            buffer.write(" ");
            buffer.write("destexpr");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getDestexpr())));
            buffer.write("\"");
        }
        if (bridge_ != null) {
            buffer.write(" ");
            buffer.write("bridge");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getBridge())));
            buffer.write("\"");
        }
        if (connecttimeout_ != null) {
            buffer.write(" ");
            buffer.write("connecttimeout");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getConnecttimeout())));
            buffer.write("\"");
        }
        if (maxtime_ != null) {
            buffer.write(" ");
            buffer.write("maxtime");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxtime())));
            buffer.write("\"");
        }
        if (transferaudio_ != null) {
            buffer.write(" ");
            buffer.write("transferaudio");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getTransferaudio())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "transfer", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "transfer", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (name_ != null) {
            buffer.print(" ");
            buffer.print("name");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.print("\"");
        }
        if (cond_ != null) {
            buffer.print(" ");
            buffer.print("cond");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.print("\"");
        }
        if (expr_ != null) {
            buffer.print(" ");
            buffer.print("expr");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.print("\"");
        }
        if (dest_ != null) {
            buffer.print(" ");
            buffer.print("dest");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDest())));
            buffer.print("\"");
        }
        if (destexpr_ != null) {
            buffer.print(" ");
            buffer.print("destexpr");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDestexpr())));
            buffer.print("\"");
        }
        if (bridge_ != null) {
            buffer.print(" ");
            buffer.print("bridge");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getBridge())));
            buffer.print("\"");
        }
        if (connecttimeout_ != null) {
            buffer.print(" ");
            buffer.print("connecttimeout");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getConnecttimeout())));
            buffer.print("\"");
        }
        if (maxtime_ != null) {
            buffer.print(" ");
            buffer.print("maxtime");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxtime())));
            buffer.print("\"");
        }
        if (transferaudio_ != null) {
            buffer.print(" ");
            buffer.print("transferaudio");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getTransferaudio())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlTransferMixed value = (IVxmlTransferMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "transfer", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCondAsString() {
        return (URelaxer.getString(getCond()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getExprAsString() {
        return (URelaxer.getString(getExpr()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDestAsString() {
        return (URelaxer.getString(getDest()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDestexprAsString() {
        return (URelaxer.getString(getDestexpr()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getBridgeAsString() {
        return (URelaxer.getString(getBridge()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getConnecttimeoutAsString() {
        return (URelaxer.getString(getConnecttimeout()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaxtimeAsString() {
        return (URelaxer.getString(getMaxtime()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTransferaudioAsString() {
        return (URelaxer.getString(getTransferaudio()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCondByString(String string) {
        setCond(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setExprByString(String string) {
        setExpr(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDestByString(String string) {
        setDest(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDestexprByString(String string) {
        setDestexpr(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setBridgeByString(String string) {
        setBridge(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setConnecttimeoutByString(String string) {
        setConnecttimeout(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaxtimeByString(String string) {
        setMaxtime(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTransferaudioByString(String string) {
        setTransferaudio(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlTransfer</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "transfer")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (GramGrammar.isMatchHungry(target)) {
                $match$ = true;
                while (GramGrammar.isMatchHungry(target)) {
                }
            } else if (VxmlAudio.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPrompt.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlCatch.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlHelp.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNoinput.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlNomatch.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlError.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlFilled.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlProperty.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEnumerate.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlValue.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlTransfer</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlTransfer</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
